(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[   4813390,      84354]
NotebookOptionsPosition[   4806313,      84251]
NotebookOutlinePosition[   4806747,      84268]
CellTagsIndexPosition[   4806704,      84265]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Sample playground", "Title",
 CellChangeTimes->{{3.8601397412505856`*^9, 
  3.860139755017807*^9}},ExpressionUUID->"d0e8ddea-97d3-4359-93ee-\
9734776dce2c"],

Cell[TextData[{
 "This notebook is used for the processing and fitting of one sample. It \
requires the functions in ",
 StyleBox["Polydisp fitting functions all data.nb",
  FontSlant->"Italic"],
 ".\nIntensity units are arbitrary as the patterns are rescaled for merging."
}], "Text",
 CellChangeTimes->{{3.8601397453382463`*^9, 3.8601397964528313`*^9}, {
  3.8617669288125243`*^9, 3.861766945139561*^9}, {3.8617673062268524`*^9, 
  3.8617673066939745`*^9}, {3.861942912912383*^9, 
  3.861942913146066*^9}},ExpressionUUID->"7c1a7862-4493-4bbd-ad86-\
2d905071e2e2"],

Cell[CellGroupData[{

Cell["Select and plot the data to be analyzed", "Subsubsection",
 CellChangeTimes->{{3.854421099868669*^9, 3.854421101948415*^9}, {
  3.8601398442554398`*^9, 
  3.8601398549474306`*^9}},ExpressionUUID->"44c23e06-c6ba-4d87-ae3e-\
52595994b93e"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Join", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Cases", "[", 
    RowBox[{
     RowBox[{"Keys", "[", "sampleFiles", "]"}], ",", 
     RowBox[{"s_String", "/;", 
      RowBox[{"StringMatchQ", "[", 
       RowBox[{"s", ",", "\"\<C22_*\>\""}], "]"}]}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Cases", "[", 
    RowBox[{
     RowBox[{"Keys", "[", "sampleFiles", "]"}], ",", 
     RowBox[{"s_String", "/;", 
      RowBox[{"StringMatchQ", "[", 
       RowBox[{"s", ",", "\"\<BG25_*\>\""}], "]"}]}]}], "]"}]}], 
  "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"testsamples", "=", "%"}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"testsamples", "=", 
     RowBox[{"{", 
      RowBox[{
      "\"\<171_1.4002\>\"", ",", "\"\<171_30.9999\>\"", ",", 
       "\"\<171_9.99982\>\"", ",", "\"\<171_9.99999\>\""}], "}"}]}], ";"}], 
   "*)"}]}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.843296948142498*^9, 3.843296958212912*^9}, {
   3.8432972784145517`*^9, 3.8432973057271643`*^9}, {3.8432977131560783`*^9, 
   3.843297716018899*^9}, {3.843298309901671*^9, 3.84329834918407*^9}, 
   3.843298997733918*^9, {3.8432990321174*^9, 3.843299072004407*^9}, {
   3.843299122424327*^9, 3.843299133661518*^9}, {3.843299265884342*^9, 
   3.84329926858108*^9}, {3.843300103749148*^9, 3.843300112466827*^9}, {
   3.8527849855621357`*^9, 3.852784994200242*^9}, {3.852787417047249*^9, 
   3.852787424091958*^9}, {3.8527874789702*^9, 3.8527874801375923`*^9}, {
   3.852787728214538*^9, 3.852787778738393*^9}, {3.8527968489630823`*^9, 
   3.8527968515622187`*^9}, {3.8527969362639837`*^9, 3.852796936383173*^9}, {
   3.8527970088774014`*^9, 3.8527970089163847`*^9}, {3.853836617160633*^9, 
   3.853836617592147*^9}, {3.854421141973649*^9, 3.854421142035899*^9}, {
   3.8544211928939333`*^9, 3.854421193010366*^9}, {3.860120705408345*^9, 
   3.860120705446088*^9}, {3.8617632879814606`*^9, 3.861763304765732*^9}, {
   3.8617673092767124`*^9, 3.8617673185406885`*^9}, {3.8859734491964083`*^9, 
   3.885973455500765*^9}, {3.8859747794365234`*^9, 3.8859748137649736`*^9}, {
   3.8859750181935196`*^9, 3.885975018432844*^9}, {3.8859763176629515`*^9, 
   3.8859763198468237`*^9}, {3.8859770271978893`*^9, 
   3.8859770297569485`*^9}, {3.8859774963407874`*^9, 3.885977500029621*^9}, {
   3.8859790256696296`*^9, 3.8859790880678005`*^9}, {3.8859792862203617`*^9, 
   3.885979303353922*^9}, {3.885979636059869*^9, 3.885979636325242*^9}, {
   3.8859798673963566`*^9, 3.885979867979951*^9}, {3.8859802087472224`*^9, 
   3.8859802091063414`*^9}, 3.8859802670443172`*^9, {3.8859805336112413`*^9, 
   3.8859805370509305`*^9}, {3.885980676883481*^9, 3.8859806770585265`*^9}, {
   3.8860615694895253`*^9, 3.8860615965610476`*^9}, {3.8902035063775234`*^9, 
   3.8902035070815973`*^9}, {3.8914972133528996`*^9, 
   3.8914972138838634`*^9}, {3.8914991163760495`*^9, 3.89149911657799*^9}, {
   3.891500277727111*^9, 3.8915002779989977`*^9}},
 CellLabel->
  "In[2766]:=",ExpressionUUID->"288b6ba3-0e36-41d8-949e-a2c664f880eb"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"C22_30.7138\"\>", ",", "\<\"C22_10.0042\"\>", 
   ",", "\<\"C22_1.504\"\>", ",", "\<\"BG25_30.7138\"\>", 
   ",", "\<\"BG25_10.0042\"\>", ",", "\<\"BG25_1.504\"\>"}], "}"}]], "Output",
 CellChangeTimes->{{3.85278774182577*^9, 3.8527877823161783`*^9}, 
   3.852796852362589*^9, 3.852796937189692*^9, 3.852797010008708*^9, 
   3.8528624946560097`*^9, 3.853381366643115*^9, 3.853381473062273*^9, 
   3.8534022376061707`*^9, 3.85346909236896*^9, 3.8534962759553757`*^9, 
   3.8534996218158073`*^9, 3.853817842919454*^9, 3.853818242802884*^9, 
   3.853824682294836*^9, 3.853824869851644*^9, 3.853833074084684*^9, 
   3.853836452539434*^9, 3.8538366226871643`*^9, 3.8538385385329847`*^9, 
   3.854072553810278*^9, 3.85409167434895*^9, 3.854098459654634*^9, 
   3.854420757546021*^9, 3.854421148417843*^9, 3.8544211935109262`*^9, 
   3.8544236425084476`*^9, 3.860120714271991*^9, {3.8601208146323557`*^9, 
   3.860120817823097*^9}, 3.8601209904370317`*^9, {3.8601401966367846`*^9, 
   3.8601402016808*^9}, {3.8601411929801598`*^9, 3.860141197066132*^9}, 
   3.8617633119613857`*^9, 3.8617673196071157`*^9, 3.861941017862147*^9, 
   3.8619433170388165`*^9, 3.861950007077615*^9, 3.861950097594084*^9, 
   3.861950313053934*^9, 3.8859734561647086`*^9, 3.8859735723144336`*^9, {
   3.8859747343360167`*^9, 3.8859747430702314`*^9}, 3.8859747970713787`*^9, 
   3.8859750198706293`*^9, 3.885976323503401*^9, 3.8859770304553003`*^9, 
   3.885977536755321*^9, {3.885979057328891*^9, 3.885979092434539*^9}, {
   3.8859792905705223`*^9, 3.885979306593282*^9}, 3.8859796400840683`*^9, 
   3.885979871667265*^9, 3.8859802113912177`*^9, 3.8859802706713324`*^9, 
   3.885980540538966*^9, 3.8859806802452884`*^9, 3.886061601230296*^9, 
   3.8861522211573744`*^9, 3.8883109765610237`*^9, 3.8890022652170677`*^9, 
   3.8890603226490602`*^9, 3.88906456673145*^9, 3.889081912662714*^9, 
   3.88908274923429*^9, 3.889084479032218*^9, {3.8895035587135143`*^9, 
   3.8895035763897266`*^9}, 3.8895042359682283`*^9, 3.889668723612721*^9, 
   3.890203509837488*^9, 3.89020358352724*^9, 3.8909804837292213`*^9, 
   3.89098153769302*^9, 3.890982738443742*^9, 3.8914160072605443`*^9, 
   3.8914972154035673`*^9, 3.8914975432719035`*^9, 3.891498587225662*^9, 
   3.891499117841081*^9, 3.8914994453271046`*^9, 3.8915002794350853`*^9, 
   3.8915004339538713`*^9, 3.891696273508443*^9},
 CellLabel->
  "Out[2766]=",ExpressionUUID->"c1f4d2f7-5c99-4f21-b423-cfb3484c9704"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"dataToPlot", "=", 
   RowBox[{"scatteringDataSampleAveraged", "/@", "testsamples"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"plotDataRaw", " ", "=", " ", 
  RowBox[{"ListLogLogPlot", "[", "\[IndentingNewLine]", 
   RowBox[{"dataToPlot", ",", "\[IndentingNewLine]", 
    RowBox[{"Frame", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
    RowBox[{"PlotLegends", "\[Rule]", "testsamples"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
    RowBox[{"FrameTicks", "->", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
         RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
         RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",", 
    " ", 
    RowBox[{"(*", " ", 
     RowBox[{
     "only", " ", "works", " ", "with", " ", "PowerTicks", " ", "function", 
      " ", "defined", " ", "in", " ", "polydisp", " ", "fitting", " ", 
      "functions", " ", "file"}], " ", "*)"}], "\[IndentingNewLine]", 
    RowBox[{"LabelStyle", "\[Rule]", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
      "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"(*", 
     RowBox[{
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
        "}"}]}], ","}], "*)"}], "\[IndentingNewLine]", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Automatic", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"5", " ", 
          RowBox[{"10", "^", 
           RowBox[{"-", "3"}]}]}], ",", 
         RowBox[{"10", "^", "5"}]}], "}"}]}], "}"}]}], ",", " ", 
    RowBox[{"(*", " ", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0.01", ",", " ", "0.1", ",", " ", "1"}], "}"}], ",", 
        RowBox[{"{", "Automatic", "}"}], ",", " ", "None", ",", " ", "None"}],
        "}"}], ",", " ", 
      RowBox[{"FrameTicks", " ", "->", " ", 
       RowBox[{"{", 
        RowBox[{
        "LogTicks", ",", "LinTicks", ",", " ", "None", ",", " ", "None"}], 
        "}"}]}]}], " ", " ", "*)"}], "\[IndentingNewLine]", 
    RowBox[{"FrameLabel", " ", "->", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\"\<Intensity [a.u.]\>\"", ",", " ", "None"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
      "}"}]}]}], "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Export", "[", 
  RowBox[{
   RowBox[{"FileNameJoin", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
      "\"\<DataRaw.pdf\>\""}], "}"}], "]"}], ",", "plotDataRaw"}], " ", 
  "]"}]}], "Input",
 CellChangeTimes->{{3.84329809635746*^9, 3.843298105573452*^9}, {
   3.84329815837682*^9, 3.843298163080853*^9}, {3.843298211914578*^9, 
   3.8432982378108053`*^9}, {3.843298288845417*^9, 3.843298291452414*^9}, 
   3.843298361191868*^9, {3.84329871517915*^9, 3.843298719649724*^9}, {
   3.843299850907208*^9, 3.843299962957724*^9}, {3.843300008752656*^9, 
   3.8433000099440603`*^9}, {3.8433000666678867`*^9, 3.843300081842258*^9}, 
   3.8433001270605783`*^9, 3.852785029476323*^9, {3.8527875156086903`*^9, 
   3.852787529623748*^9}, {3.852787908039447*^9, 3.852787908637274*^9}, {
   3.88951548143122*^9, 3.88951548156557*^9}, {3.8896687353498526`*^9, 
   3.8896687417207317`*^9}, {3.8896725688232393`*^9, 3.889672590126113*^9}, {
   3.889672623190502*^9, 3.8896726983115826`*^9}, {3.889672740640524*^9, 
   3.889672758876796*^9}, {3.8896729834503565`*^9, 3.889673069010479*^9}, {
   3.889673142722207*^9, 3.8896731964734883`*^9}, {3.889676349237294*^9, 
   3.8896763709122796`*^9}, {3.889692253576544*^9, 3.889692254563936*^9}},
 CellLabel->
  "In[2768]:=",ExpressionUUID->"6ebf2b6c-fd73-4115-90fc-264fde664a3f"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{}, {{{}, {}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         PointSize[
          NCache[
           Rational[1, 360], 0.002777777777777778]], 
         RGBColor[0.368417, 0.506779, 0.709798], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJwUWHk4lV8XvaN5niNDhigqKYrwXkKESFIKkZTKUOqHotJEUklJSpGUCIVk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         "]], 
        LineBox[CompressedData["
1:eJwBIQLe/SFib1JlAgAAACEAAAACAAAA6ho3HU5I979TnJQbejEVwI7TNbBM
Rve/Ok0E55QuC8DPUhAupkP3v9c3pLF/0QrAr7pZLQBB979HAUooCIAIwGW5
sYtaPve/r/EBY9OqCMDYtyhrtTv3vyUECwuaNgXAj9ppqRA5979vMziZRvgE
wGdhemhsNve/6KEqpiL+BsCL3xCGyDP3vykDszKisgnAFXMnJCUx97/vlO7D
vFQMwDAWgCCCLve/zDnS/b79CMBzzAmd3yv3v8RDPHkyzgjAcO+Rdz0p97/R
cq0/0iQEwG5v/NGbJve/anQ069wRC8DV/SGK+iP3v2G1p7cujAjAzX7bwVkh
978AlF95yTsFwAf0DFe5Hve/9qjDrreADMC3PIRrGRz3v1LD+qfbsAXAUqMw
3XkZ97/CEWetjcwIwDsJ1c3aFve/kM5Vr1WZB8Au+msbPBT3v7sV3WKJkAbA
2WCt550R979GjZe56jsMwMoCnxAAD/e/b273Al6zCsAO2+23Ygz3v8+reNgu
3AXAmOGqu8UJ9789UhS7p6ULwOIoeD0pB/e/TTxudmfnCcDe03EbjQT3v8do
Ypu4rQ3AeRMvd/EB978TABMFaEMUwEcu1y5W//a/P64SqAROCMCoevZju/z2
vxiu3ducSwbAeVu/9CD69r/9VwQAiJwMwIhTswKH9/a/0IgIRMY7CsBjjRPK
WPX2v1OclBt6MRXAiiEOJA==
         "]], 
        LineBox[{{-1.4346884080875741`, -5.298317366548036}, \
{-1.434162446467272, -3.412741187711168}, {-1.433528496639963, \
-2.3020138170624973`}, {-1.4329065292064849`, -5.298317366548036}}], 
        LineBox[CompressedData["
1:eJwBUQGu/iFib1JlAgAAABQAAAACAAAA7FQhhQft9r9TnJQbejEVwEEqhWqL
6va/FuO/NEkdEMDFPKz/8+f2v3szUJjg3gXAT1N671zl9r9xOIf0+ZoFwKXn
RVvG4va/ysQeuvrCEMDmfHghMOD2v0iQeVhTGRDAwttdY5rd9r80AYUl/hsK
wC14av8E2/a/dxPNNP0yCsCTcN8WcNj2v+emlFXsGwbAkyI8iNvV9r+pmrRZ
tj0OwDamDmRH0/a/vBTeDNxgE8B1ZNq6s9D2v2Tj3llplAnAMAwvayDO9r9Q
/FuZhfAHwMUvM5aNy/a/4xYrR3gvBsAEVoEa+8j2v0zTE7ZqygrAtX41GWnG
9r90B+zsXToMwIcB9XDXw/a/e3doxkC9A8BjUtFCRsH2v1w2uXT/mAPA0pJ6
bbW+9r92A4y9DG8LwD+6DGKMvfa/U5yUG3oxFcBNh60p
         "]], 
        LineBox[{{-1.4205976143391656`, -5.298317366548036}, \
{-1.4203081690295074`, -3.3516943795781664`}, {-1.4196830004606906`, \
-4.1574875916607965`}, {-1.419058160893575, -3.260669791234503}, \
{-1.418433773058574, -4.210473377801377}, {-1.4178097133274605`, \
-2.934530381877768}, {-1.4171861042786886`, -3.1555695513832447`}, \
{-1.4165628224394424`, -3.1067485543644215`}, {-1.4159399902365912`, \
-3.7984411976202703`}, {-1.4153174843523386`, -3.152983937516187}, \
{-1.4146954270623417`, -5.223472590637625}}], 
        LineBox[{{-1.412804212678167, -5.298317366548036}, \
{-1.4122109379097125`, -3.76492257096917}, {-1.4115907483412689`, \
-3.9731649762341066`}, {-1.410971004263323, -4.620832159888041}}], 
        LineBox[{{-1.4091139512378517`, -4.232146032488344}, \
{-1.4084957397671074`, -3.1870485740993026`}, {-1.407877849340566, \
-3.098834211982481}, {-1.4072604013343666`, -2.863828414244563}, \
{-1.406643273505007, -3.3409213043952284`}, {-1.4060265870799868`, \
-3.152104863778285}, {-1.4054102199677423`, -2.7867453138636673`}, \
{-1.4047942932474957`, -4.716388535333572}, {-1.4041786849792435`, \
-2.939808689264678}, {-1.4035635160942912`, -4.416465076874393}, \
{-1.4029486648038185`, -4.410947495548647}, {-1.4023342518915736`, \
-3.477933564932164}, {-1.4017201557195431`, -2.2474890942650374`}, \
{-1.4011064969242768`, -2.3360681693814818`}, {-1.4004931540181937`, \
-3.241557324995797}, {-1.4000272707244727`, -5.298317366548036}}], 
        LineBox[{{-1.399729792637609, -5.298317366548036}, \
{-1.3992676560051798`, -3.3046318561829624`}, {-1.398655499903949, \
-3.670607068640004}, {-1.398043657999477, -3.429216621569056}, \
{-1.3974322504888532`, -3.7874487157368204`}, {-1.3968211563335622`, \
-2.534056873885405}}], 
        LineBox[{{-1.3952315625303846`, -5.298317366548036}, \
{-1.394990231544737, -2.999382918620256}, {-1.3943806274181056`, \
-4.801197700347035}}], 
        LineBox[{{-1.3925541015537621`, -3.593759726147382}, \
{-1.3919460401861279`, -3.206585513690058}}], 
        LineBox[{{-1.3885917406603996`, -5.298317366548036}, \
{-1.3883052369189728`, -2.5010918324039397`}, {-1.387699693172116, \
-4.265613567150395}}], 
        LineBox[{{-1.3858853185074895`, -3.0189632709585426`}, \
{-1.3852813570020988`, -2.4596988723843523`}}], 
        LineBox[{{-1.3840742893096247`, -4.779423461611647}, \
{-1.3834713014037296`, -1.7834177100947999`}, {-1.382868795674771, \
-1.9672036516216034`}, {-1.382266534010283, -2.369313840195167}}]}, {
        Hue[0.9060679774997897, 0.6, 0.6], 
        Directive[
         PointSize[
          NCache[
           Rational[1, 360], 0.002777777777777778]], 
         RGBColor[0.880722, 0.611041, 0.142051], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJwUV3c81e8Xv/bmXnukUigRKSpFV0hpEEp2yJaKSKWSmZXIKIQSoRSKr4qc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         "]], 
        LineBox[{{-0.26610850759027554`, -5.298317366548036}, \
{-0.26558113396476035`, -4.630491235081332}, {-0.26497629994481253`, \
-4.343862462742444}, {-0.2643719091696942, -4.485823434948399}, \
{-0.26376780586728016`, -4.2950169545919445`}, {-0.26316406728534836`, \
-4.4178890239187805`}, {-0.262560770485036, -4.7716449481098415`}, \
{-0.26195775997776694`, -4.768563299371018}, {-0.2615665976897511, \
-5.298317366548036}}], 
        LineBox[{{-0.26121238248045253`, -5.298317366548036}, \
{-0.26075290609440566`, -4.376291189350737}, {-0.26015098443578805`, \
-3.6695576825384317`}, {-0.25959857742150516`, -5.298317366548036}}]}, {
        Hue[0.1421359549995791, 0.6, 0.6], 
        Directive[
         PointSize[
          NCache[
           Rational[1, 360], 0.002777777777777778]], 
         RGBColor[0.560181, 0.691569, 0.194885], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJwUm3c4l30Uxu2Z+QuFNAilVHpVok5DUWZRQqGlMpIoSYSmKJWWiMzsHYV6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         "]]}, {
        Hue[0.37820393249936934`, 0.6, 0.6], 
        Directive[
         PointSize[
          NCache[
           Rational[1, 360], 0.002777777777777778]], 
         RGBColor[0.922526, 0.385626, 0.209179], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJwUV3c8lf8Xv3svW1RERkhIZd9LZSYkZURJSkmkIqlERltJKErFFylFiSie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         "]], 
        LineBox[CompressedData["
1:eJw9VXs81HkXJol1mfn9ZohqSYnaVjFha9uwNC7pjVxKF0XETrFZUVFEW2Fd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         "]], 
        LineBox[CompressedData["
1:eJwBMQLO/SFib1JlAgAAACIAAAACAAAAA1e6lA9s+L9TnJQbejEVwP7vBVJt
afi/KwexYvqTEMBuhDfZlGb4v4G41IfQEhHANWY/9Lxj+L+sTbaTXd0TwCiY
L37lYPi/6QwJmIU6EcDHspObDl74v9Oj2P5p8Q7AF/WKJzhb+L8tWq4rcxIR
wK8hlEZiWPi/VLcPJobEEMBCqtvTjFX4v/kp0z8iGhLAcYTT87dS+L9ro26C
/n4QwCJLtYHjT/i/xdbTyN3dDcDwL+ahD034v/XH368rDhDAgu2sLzxK+L9s
8ilfsAoTwE36YU9pR/i/kG1RpE0FFcBXJ1nclkT4v47sEZ/pjRLAyDje+sRB
+L/tYxK54HkQwKgMUobzPvi/orxxmXVxEcCjvfOiIjz4v/dhaL/Fuw/Aci0x
LFI5+L8dJs2vqwYOwAvWPEaCNvi/yn5AxbdUDsCRk5HMsjP4v9Ah3vg3ShHA
BEhV4+Mw+L8BEwbWHIATwK/AD2YVLvi/NlmOEQlEE8BVUNp4Ryv4vwJeC/x4
sxHAN6xJ93ko+L9O+LCJR7QQwIGgagWtJfi/lFwCVvRFEsBEwd5+4CL4v99e
iR6cixHAulymhxQg+L84SH4K5x0RwKDcb/tIHfi/ggzFBxPVD8DaGS/+fRr4
v7E38w/zPBDAvEqfa7MX+L9MRfarZx0VwGTbp2fpFPi/W0ml1bVpFMCvxRDO
HxL4v7pfJnm8MRHAS515al4P+L9TnJQbejEVwMkMGbo=
         "]], 
        LineBox[{{-1.5037373115477313`, -5.298317366548036}, \
{-1.5030652337220112`, -4.331103292784053}, {-1.5023861452440905`, \
-5.176982644281236}, {-1.5017074507178931`, -5.233671505510157}, \
{-1.501029283356703, -4.187777142744001}, {-1.500351508788963, \
-5.122999128780635}, {-1.49967426004908, -3.9248989701165513`}, \
{-1.4989974029491981`, -4.94981402959598}, {-1.4983210703453254`, \
-3.970192279352568}, {-1.4976451282328034`, -4.509504977213211}, \
{-1.497282419903845, -5.298317366548036}}], 
        LineBox[CompressedData["
1:eJwBUQGu/iFib1JlAgAAABQAAAACAAAApneL4K/y979TnJQbejEVwHlwp7DS
8Pe/oCqk+TMhD8Dl+dtqD+73v0LfRKfBaxDAq/xFjUzr97+wKLB5IB4QwCSv
ajuK6Pe/iztDK8POEMAu5nZRyOX3v6NI1Xw7PxTA/88W4Qbj97/taga8RD0U
wBZq6vtF4Pe/1HrsTwxPE8DKMzF+hd33v3fKU7yUUg7A2R9Si8Xa97/4atrb
9LMPwFwUmf8F2Pe/arFhx2pfFMBr92D+RtX3v0BwMCS87hTAPA0CZIjS979q
SzeSOZEPwGg3y1PKz/e/hxvGkWfoDMCsDyGqDM33v8dW61hyCRXAQHtGik/K
978Vo+tpvI0RwNlgrNCSx/e/Z/RZdD4eEcBksYmg1sT3v6Zq+TaG0w3ACJhb
1hrC97/p9UiKYJYQwO8768mUwPe/U5yUG3oxFcBLt7NN
         "]], 
        LineBox[{{-1.483886653499008, -5.298317366548036}, \
{-1.4835555326370005`, -4.39705131516282}, {-1.4828895602005607`, \
-4.401750227067394}, {-1.482223965382512, -4.374087933670677}, \
{-1.4815588788483816`, -3.9384168175040464`}, {-1.4812637138944458`, \
-5.298317366548036}}], 
        LineBox[{{-1.4803310403373955`, -5.298317366548036}, \
{-1.4802299658562001`, -4.992724114168252}, {-1.480130607317852, \
-5.298317366548036}}], 
        LineBox[{{-1.4790167876091118`, -5.298317366548036}, \
{-1.4789028165302598`, -4.938134008965426}, {-1.478239869107999, \
-5.0622434804610075`}, {-1.4775774261954666`, -3.3915402251370703`}, \
{-1.4769153565646709`, -4.558825204390678}, {-1.4762537901952915`, \
-5.058448137319012}, {-1.4755925960345126`, -4.0385819735202935`}, \
{-1.4749775546448352`, -5.298317366548036}}], 
        LineBox[{{-1.4746371640347773`, -5.298317366548036}, \
{-1.4742715828886581`, -5.1823414383079065`}, {-1.4736117626649108`, \
-4.982317778518238}, {-1.4729523125165611`, -3.931031150665172}, \
{-1.4722933619135883`, -3.726149987245192}, {-1.4716347803258993`, \
-3.82044712941299}, {-1.4709766970544564`, -4.794451356971668}, \
{-1.470569512613433, -5.298317366548036}}], 
        LineBox[{{-1.4699900741939378`, -5.298317366548036}, \
{-1.4696617635223481`, -4.988863228633127}, {-1.4690049122101352`, \
-4.9862082416072315`}, {-1.4683990314453386`, -5.298317366548036}}], 
        LineBox[{{-1.4683340010489607`, -5.298317366548036}, \
{-1.467692567190646, -4.152511638544663}, {-1.467037072268365, \
-4.16446176460503}, {-1.4663819421636302`, -4.217548623597961}, \
{-1.4657273055057047`, -4.7324541834001455`}, {-1.465073032626457, \
-3.4151974642051353`}, {-1.4647478434084786`, -5.298317366548036}}], 
        LineBox[{{-1.4639294832167207`, -5.298317366548036}, \
{-1.4637658340941535`, -4.6625171875140605`}, {-1.4635861917095527`, \
-5.298317366548036}}], 
        LineBox[{{-1.4626413805310627`, -5.298317366548036}, \
{-1.4624603420993125`, -4.655187661493137}, {-1.4622737460920365`, \
-5.298317366548036}}], 
        LineBox[{{-1.4603921544184328`, -5.298317366548036}, \
{-1.4598544599396643`, -3.3016071198731365`}, {-1.459204016997299, \
-4.681394983523469}, {-1.458630550877732, -5.298317366548036}}], 
        LineBox[{{-1.4573737786764684`, -5.298317366548036}, \
{-1.4572553507560915`, -4.6081576337074575`}, {-1.4570061472398073`, \
-5.298317366548036}}], 
        LineBox[{{-1.4562430340056267`, -5.298317366548036}, \
{-1.455958325045854, -4.431771799698098}, {-1.4553104105673174`, \
-3.6884219517704806`}, {-1.4546629794324164`, -3.7875887872405443`}, \
{-1.454015903412415, -4.424856977366221}, {-1.4533693095687956`, \
-4.779929861161433}, {-1.4527230698400555`, -4.210198452513272}, \
{-1.4520773111248584`, -4.726138237648436}, {-1.4514319055284977`, \
-3.809659189144794}, {-1.4507869797872333`, -3.6576939636188914`}}], 
        LineBox[{{-1.4494595020042143`, -5.298317366548036}, \
{-1.4488545674843287`, -4.88190758788891}, {-1.4482113012607243`, \
-4.991634932671452}, {-1.4475683851914845`, -4.404280576219742}, \
{-1.446925945528132, -5.058222512174203}, {-1.4465574513315533`, \
-5.298317366548036}}], 
        LineBox[{{-1.4462147731221693`, -5.298317366548036}, \
{-1.445642239814265, -3.820915009826304}, {-1.4450009727872855`, \
-4.487892130493094}, {-1.4443601798882761`, -3.689620948818113}, \
{-1.4437197342142167`, -4.1859897494254525`}, {-1.4430797615355704`, \
-4.521661853962425}, {-1.4424401351130984`, -3.4512697536520935`}, \
{-1.4418009805577212`, -4.25023259330421}, {-1.4416042175553077`, \
-5.298317366548036}}], 
        LineBox[{{-1.4406928177346845`, -5.298317366548036}, \
{-1.4405238327723882`, -4.450565730070384}, {-1.4401712215799982`, \
-5.298317366548036}}], 
        LineBox[{{-1.4396163915314673`, -5.298317366548036}, \
{-1.4392483140132346`, -4.3610435177695415`}, {-1.438611132817861, \
-4.873463190028933}, {-1.4379744201298463`, -3.9908319487200803`}, \
{-1.437387973634555, -5.298317366548036}}], 
        LineBox[{{-1.4347967358750486`, -4.651005338914097}, \
{-1.434162446467272, -5.125227008565867}}], 
        LineBox[{{-1.4328950108984277`, -4.356067813256831}, \
{-1.4322618637985587`, -4.393001183791281}, {-1.4316291796892966`, \
-4.893982783803193}, {-1.4313152749202462`, -5.298317366548036}}], 
        LineBox[{{-1.429102314139286, -3.7975380561614918`}, \
{-1.428471563070626, -3.5806928834518836`}, {-1.428054099927964, \
-5.298317366548036}}], 
        LineBox[{{-1.427063380108268, -5.298317366548036}, \
{-1.4265817554936695`, -3.3967932259575795`}, {-1.42595265378466, \
-5.001251158093977}, {-1.4253238856188197`, -3.9803091493548735`}, \
{-1.424695574492021, -2.7125261171725916`}, {-1.4240675959930522`, \
-4.565336714721569}, {-1.423440073463934, -3.5096303820731847`}, \
{-1.4230640573350464`, -5.298317366548036}}], 
        LineBox[{{-1.4205899318224064`, -5.298317366548036}, \
{-1.4203081690295074`, -3.935636994726556}, {-1.4196830004606906`, \
-3.9113641821774228`}, {-1.4193428567564446`, -5.298317366548036}}], 
        LineBox[{{-1.4178097133274605`, -4.0750369361463985`}, \
{-1.4171861042786886`, -3.1460246966053}, {-1.4165628224394424`, \
-3.514548710088936}, {-1.4159399902365912`, -3.9104830761884}, \
{-1.4153650725124158`, -5.298317366548036}}], 
        LineBox[{{-1.4143543716746851`, -5.298317366548036}, \
{-1.414073695203434, -3.778047679104936}, {-1.4137264541023669`, \
-5.298317366548036}}], 
        LineBox[{{-1.4096183420134631`, -5.298317366548036}, \
{-1.4091139512378517`, -3.6865429357371795`}, {-1.408759986598989, \
-5.298317366548036}}], 
        LineBox[{{-1.4082412080315263`, -5.298317366548036}, \
{-1.407877849340566, -3.580615504897623}, {-1.40746819022165, \
-5.298317366548036}}], 
        LineBox[{{-1.4070536129033233`, -5.298317366548036}, \
{-1.406643273505007, -3.569438934928174}, {-1.4060265870799868`, \
-3.9277720571367136`}, {-1.4054102199677423`, -4.234246477078686}}], 
        LineBox[{{-1.403562249878592, -5.298317366548036}, \
{-1.4029486648038185`, -3.50232074803919}, {-1.4027706951203969`, \
-5.298317366548036}}], 
        LineBox[{{-1.400840577054237, -5.298317366548036}, \
{-1.4004931540181937`, -3.1121560601199656`}, {-1.3998802474910017`, \
-3.325239376225763}}], 
        LineBox[{{-1.398655499903949, -4.120282342546367}, \
{-1.398043657999477, -3.557972110479627}}], 
        LineBox[{{-1.3931625929004259`, -5.250416840132505}, \
{-1.3925541015537621`, -2.861298478622127}, {-1.3919460401861279`, \
-3.31801981184503}, {-1.391338288426397, -3.493553549565278}}], 
        LineBox[{{-1.3895173657767712`, -3.6246956952954177`}, \
{-1.3889110878104278`, -2.8870540138682053`}}], 
        LineBox[{{-1.4308119554125818`, -5.298317366548036}, \
{-1.4303649487833152`, -4.306568202162434}}]}, {
        Hue[0.6142719099991583, 0.6, 0.6], 
        Directive[
         PointSize[
          NCache[
           Rational[1, 360], 0.002777777777777778]], 
         RGBColor[0.528488, 0.470624, 0.701351], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJwUWnc81e8Xt/e891pJkpE9olBkJBIZaZDxLRSJRImyQnZJWkhUFIpQRBnn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         "]], 
        LineBox[{{-0.274677743164378, -5.298317366548036}, \
{-0.27408705585431015`, -4.969485974757601}, {-0.273598930718067, \
-5.298317366548036}}], 
        LineBox[{{-0.2721308661865039, -5.298317366548036}, \
{-0.27164944546190495`, -5.099040171584874}, {-0.2710409310817236, \
-4.827102489230139}, {-0.27043278676611493`, -5.190183761590067}, \
{-0.27011722996158055`, -5.298317366548036}}], 
        LineBox[{{-0.2692932393090027, -5.298317366548036}, \
{-0.2692176845490116, -5.284095850375458}, {-0.268610647684061, \
-4.678386890519318}, {-0.26800405701359853`, -4.410781081388414}, \
{-0.2673977561952779, -4.831118370141682}, {-0.2671970924629547, \
-5.298317366548036}}], 
        LineBox[{{-0.2656315760385054, -5.298317366548036}, \
{-0.26558113396476035`, -5.285816629941033}, {-0.26497629994481253`, \
-4.720271339889647}, {-0.2643719091696942, -5.228139952607627}, \
{-0.26376780586728016`, -5.03739343249013}, {-0.26316406728534836`, \
-5.08188885025199}, {-0.262560770485036, -5.087528578106296}, \
{-0.26195775997776694`, -4.836499833344438}, {-0.26135511287304525`, \
-4.633771593023157}, {-0.26075290609440566`, -4.760675184375608}, \
{-0.26015098443578805`, -4.607324334564698}, {-0.2595494248689136, \
-4.364465508880019}, {-0.25894830418020226`, -3.4429375320786066`}}]}, {
        Hue[0.8503398874989481, 0.6, 0.6], 
        Directive[
         PointSize[
          NCache[
           Rational[1, 360], 0.002777777777777778]], 
         RGBColor[0.772079, 0.431554, 0.102387], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJwcW3c8Vf8bt0cq4mqhpZCVFGU+9KVFEcrILKVsESmpNFFRRlZKIrOEklHn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         "]]}}}, {{}, {}}}, {
    DisplayFunction -> Identity, GridLines -> {None, None}, DisplayFunction -> 
     Identity, DisplayFunction -> Identity, DisplayFunction -> Identity, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, 
     AxesOrigin -> {-6.487195066484062, -5.298317366548025}, DisplayFunction :> 
     Identity, Frame -> {{True, True}, {True, True}}, FrameLabel -> {{
        FormBox[
         TagBox["\"Intensity [a.u.]\"", HoldForm], TraditionalForm], None}, {
        FormBox[
         TagBox[
         "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) [\\!\\(\
\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], TraditionalForm], 
        None}}, FrameTicks -> {{{{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {0, 
          FormBox[
           
           TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           
           TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           
           TemplateBox[{"10", "2"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           
           TemplateBox[{"10", "3"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           
           TemplateBox[{"10", "4"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[100000], 11.512925464970229`], 
          FormBox[
           
           TemplateBox[{"10", "5"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200], 5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300], 5.703782474656201], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400], 5.991464547107982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500], 6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600], 6.396929655216146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700], 6.551080335043404], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800], 6.684611727667927], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900], 6.802394763324311], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2000], 7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3000], 8.006367567650246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4000], 8.294049640102028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5000], 8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6000], 8.699514748210191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7000], 8.85366542803745], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8000], 8.987196820661973], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9000], 9.104979856318357], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20000], 9.903487552536127], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30000], 10.308952660644293`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40000], 10.596634733096073`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50000], 10.819778284410283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60000], 11.002099841204238`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70000], 11.156250521031495`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80000], 11.289781913656018`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90000], 11.407564949312402`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100000], 11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200000], 12.206072645530174`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300000], 12.611537753638338`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400000], 12.89921982609012], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500000], 13.122363377404328`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600000], 13.304684934198283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700000], 13.458835614025542`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800000], 13.592367006650065`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900000], 13.710150042306449`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}, {{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100000], 11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200], 5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300], 5.703782474656201], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400], 5.991464547107982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500], 6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600], 6.396929655216146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700], 6.551080335043404], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800], 6.684611727667927], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900], 6.802394763324311], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2000], 7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3000], 8.006367567650246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4000], 8.294049640102028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5000], 8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6000], 8.699514748210191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7000], 8.85366542803745], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8000], 8.987196820661973], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9000], 9.104979856318357], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20000], 9.903487552536127], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30000], 10.308952660644293`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40000], 10.596634733096073`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50000], 10.819778284410283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60000], 11.002099841204238`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70000], 11.156250521031495`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80000], 11.289781913656018`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90000], 11.407564949312402`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100000], 11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200000], 12.206072645530174`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300000], 12.611537753638338`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400000], 12.89921982609012], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500000], 13.122363377404328`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600000], 13.304684934198283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700000], 13.458835614025542`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800000], 13.592367006650065`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900000], 13.710150042306449`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}}, {{{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {0, 
          FormBox[
           
           TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           
           TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}, {{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}}}, GridLines -> {None, None}, GridLinesStyle -> 
     Directive[
       GrayLevel[0.5, 0.4]], LabelStyle -> {FontSize -> 14, 
       GrayLevel[0]}, 
     Method -> {
      "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
       "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           Exp[
            Part[#, 1]], 
           Exp[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           Exp[
            Part[#, 1]], 
           Exp[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{-6.487195066484062, 
      1.6310721412512184`}, {-5.298317366548036, 11.512925464970229`}}, 
     PlotRangeClipping -> True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {0, 0}}, Ticks -> {
       Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
        15.954589770191003`, RotateLabel -> 0], 
       Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
        15.954589770191003`, RotateLabel -> 0]}}], 
   FormBox[
    FormBox[
     TemplateBox[{
      "\"C22_30.7138\"", "\"C22_10.0042\"", "\"C22_1.504\"", 
       "\"BG25_30.7138\"", "\"BG25_10.0042\"", "\"BG25_1.504\""}, 
      "PointLegend", DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #3}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #4}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.528488, 0.470624, 0.701351], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.528488, 0.470624, 0.701351], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #5}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.772079, 0.431554, 0.102387], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.772079, 0.431554, 0.102387], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #6}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontSize -> 14, 
          GrayLevel[0], FontFamily -> "Arial"}, Background -> Automatic, 
         StripOnInput -> False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"PointLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "360"], "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.368417, 0.506779, 0.709798]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "360"], "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.880722, 0.611041, 0.142051]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "360"], "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.560181, 0.691569, 0.194885]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "360"], "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.922526, 0.385626, 0.209179]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "360"], "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.528488, 0.470624, 0.701351]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "360"], "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.772079, 0.431554, 0.102387]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}]}],
              "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3, ",", #4, ",", #5, ",", #6}], "}"}], 
           ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               
               RowBox[{
                "True", ",", "True", ",", "True", ",", "True", ",", "True", 
                 ",", "True"}], "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"FontSize", "\[Rule]", "14"}], ",", 
                 
                 TemplateBox[<|"color" -> GrayLevel[0]|>, 
                  "GrayLevelColorSwatchTemplate"]}], "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{
  3.843298149991452*^9, 3.843298203872168*^9, 3.8432982736696587`*^9, {
   3.843298384765218*^9, 3.843298404726954*^9}, 3.84329873022256*^9, {
   3.8432988004009867`*^9, 3.843298803824133*^9}, {3.843298872108584*^9, 
   3.843298895599083*^9}, {3.8432990149186*^9, 3.8432990770538588`*^9}, {
   3.843299137189081*^9, 3.8432991407725573`*^9}, {3.843299840648491*^9, 
   3.843299921480537*^9}, {3.843299960469057*^9, 3.843299972052854*^9}, 
   3.843300012041739*^9, 3.843300096769802*^9, {3.8433001291250687`*^9, 
   3.843300174678563*^9}, {3.852785009054036*^9, 3.852785030774148*^9}, {
   3.852787502594598*^9, 3.852787530539609*^9}, 3.852787791379717*^9, 
   3.852787910287105*^9, 3.852796869163835*^9, 3.8527969417886457`*^9, {
   3.852797012104776*^9, 3.852797018397952*^9}, 3.852862497566475*^9, 
   3.853381366813589*^9, 3.8533814753005857`*^9, 3.853402239868787*^9, 
   3.853469094796208*^9, 3.853496279768393*^9, 3.853499624685063*^9, 
   3.853817846160879*^9, 3.853818247955379*^9, 3.8538246853293123`*^9, 
   3.8538248725516987`*^9, 3.853833076731237*^9, 3.853836454739139*^9, 
   3.853836627576047*^9, 3.8538385410146437`*^9, 3.8540725564096527`*^9, 
   3.854091676757815*^9, 3.854098462801889*^9, 3.8544207604946127`*^9, 
   3.854421164446437*^9, 3.8544212040376797`*^9, 3.8544236563123503`*^9, 
   3.860120820146564*^9, 3.860120992755413*^9, 3.8601402097736197`*^9, 
   3.860141203197979*^9, 3.8617633271887465`*^9, 3.8617673254490795`*^9, 
   3.861941023959653*^9, 3.8619503178258157`*^9, 3.885973462316798*^9, {
   3.8859735791689806`*^9, 3.8859735863327785`*^9}, 3.8859747465859413`*^9, 
   3.8859747986681952`*^9, {3.885975027787902*^9, 3.8859750393330336`*^9}, 
   3.885976328509342*^9, 3.885977032989354*^9, 3.8859775404716673`*^9, 
   3.885979060483423*^9, 3.8859790972689905`*^9, {3.885979294595189*^9, 
   3.885979310657553*^9}, 3.885979644422537*^9, 3.8859798767472997`*^9, 
   3.8859802200758305`*^9, 3.885980276257719*^9, 3.885980545153112*^9, 
   3.885980685497188*^9, 3.8860616074751854`*^9, 3.886152225682108*^9, 
   3.888310978040262*^9, 3.889002269915166*^9, 3.8890603306392736`*^9, 
   3.889064568176372*^9, 3.889081913918378*^9, 3.8890827504249163`*^9, 
   3.889084480239011*^9, {3.8895035588509493`*^9, 3.8895035673865147`*^9}, {
   3.8895042405971904`*^9, 3.889504241091606*^9}, 3.88951548578316*^9, {
   3.8896687291557455`*^9, 3.889668742820923*^9}, 3.8896725906682463`*^9, 
   3.889672649616415*^9, 3.8896726992702703`*^9, {3.889672743456319*^9, 
   3.8896727596135435`*^9}, {3.889672989005809*^9, 3.889673014473555*^9}, 
   3.889673069643585*^9, {3.88967314352767*^9, 3.8896731597222066`*^9}, 
   3.8896731975865993`*^9, 3.8896763716560993`*^9, 3.890203528371027*^9, 
   3.8902035960444994`*^9, 3.8909804917392635`*^9, 3.8909815443374186`*^9, 
   3.8909827436668806`*^9, 3.8914160422882376`*^9, 3.8914972309806986`*^9, 
   3.891497552617916*^9, 3.8914985996710963`*^9, 3.891499128090147*^9, 
   3.8914994582819223`*^9, 3.8915002914464154`*^9, 3.8915004458203573`*^9, 
   3.8916962811957335`*^9},
 CellLabel->
  "Out[2769]=",ExpressionUUID->"2a5b133f-2132-40ee-bb12-dc8b3cb29480"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\ESRF\\\\Analysis\\\\2022-08_\
new_data\\\\Analysis\\\\Full form factor \
fit\\\\LH-ESRF-C22\\\\DataRaw.pdf\"\>"], "Output",
 CellChangeTimes->{
  3.843298149991452*^9, 3.843298203872168*^9, 3.8432982736696587`*^9, {
   3.843298384765218*^9, 3.843298404726954*^9}, 3.84329873022256*^9, {
   3.8432988004009867`*^9, 3.843298803824133*^9}, {3.843298872108584*^9, 
   3.843298895599083*^9}, {3.8432990149186*^9, 3.8432990770538588`*^9}, {
   3.843299137189081*^9, 3.8432991407725573`*^9}, {3.843299840648491*^9, 
   3.843299921480537*^9}, {3.843299960469057*^9, 3.843299972052854*^9}, 
   3.843300012041739*^9, 3.843300096769802*^9, {3.8433001291250687`*^9, 
   3.843300174678563*^9}, {3.852785009054036*^9, 3.852785030774148*^9}, {
   3.852787502594598*^9, 3.852787530539609*^9}, 3.852787791379717*^9, 
   3.852787910287105*^9, 3.852796869163835*^9, 3.8527969417886457`*^9, {
   3.852797012104776*^9, 3.852797018397952*^9}, 3.852862497566475*^9, 
   3.853381366813589*^9, 3.8533814753005857`*^9, 3.853402239868787*^9, 
   3.853469094796208*^9, 3.853496279768393*^9, 3.853499624685063*^9, 
   3.853817846160879*^9, 3.853818247955379*^9, 3.8538246853293123`*^9, 
   3.8538248725516987`*^9, 3.853833076731237*^9, 3.853836454739139*^9, 
   3.853836627576047*^9, 3.8538385410146437`*^9, 3.8540725564096527`*^9, 
   3.854091676757815*^9, 3.854098462801889*^9, 3.8544207604946127`*^9, 
   3.854421164446437*^9, 3.8544212040376797`*^9, 3.8544236563123503`*^9, 
   3.860120820146564*^9, 3.860120992755413*^9, 3.8601402097736197`*^9, 
   3.860141203197979*^9, 3.8617633271887465`*^9, 3.8617673254490795`*^9, 
   3.861941023959653*^9, 3.8619503178258157`*^9, 3.885973462316798*^9, {
   3.8859735791689806`*^9, 3.8859735863327785`*^9}, 3.8859747465859413`*^9, 
   3.8859747986681952`*^9, {3.885975027787902*^9, 3.8859750393330336`*^9}, 
   3.885976328509342*^9, 3.885977032989354*^9, 3.8859775404716673`*^9, 
   3.885979060483423*^9, 3.8859790972689905`*^9, {3.885979294595189*^9, 
   3.885979310657553*^9}, 3.885979644422537*^9, 3.8859798767472997`*^9, 
   3.8859802200758305`*^9, 3.885980276257719*^9, 3.885980545153112*^9, 
   3.885980685497188*^9, 3.8860616074751854`*^9, 3.886152225682108*^9, 
   3.888310978040262*^9, 3.889002269915166*^9, 3.8890603306392736`*^9, 
   3.889064568176372*^9, 3.889081913918378*^9, 3.8890827504249163`*^9, 
   3.889084480239011*^9, {3.8895035588509493`*^9, 3.8895035673865147`*^9}, {
   3.8895042405971904`*^9, 3.889504241091606*^9}, 3.88951548578316*^9, {
   3.8896687291557455`*^9, 3.889668742820923*^9}, 3.8896725906682463`*^9, 
   3.889672649616415*^9, 3.8896726992702703`*^9, {3.889672743456319*^9, 
   3.8896727596135435`*^9}, {3.889672989005809*^9, 3.889673014473555*^9}, 
   3.889673069643585*^9, {3.88967314352767*^9, 3.8896731597222066`*^9}, 
   3.8896731975865993`*^9, 3.8896763716560993`*^9, 3.890203528371027*^9, 
   3.8902035960444994`*^9, 3.8909804917392635`*^9, 3.8909815443374186`*^9, 
   3.8909827436668806`*^9, 3.8914160422882376`*^9, 3.8914972309806986`*^9, 
   3.891497552617916*^9, 3.8914985996710963`*^9, 3.891499128090147*^9, 
   3.8914994582819223`*^9, 3.8915002914464154`*^9, 3.8915004458203573`*^9, 
   3.8916962838413134`*^9},
 CellLabel->
  "Out[2770]=",ExpressionUUID->"2ae39677-6c1e-451a-8907-5c392a2cc466"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Process data", "Subsubsection",
 CellChangeTimes->{{3.8601399392765074`*^9, 3.8601399407209606`*^9}, {
   3.8859798317515917`*^9, 3.885979836205883*^9}, 
   3.8896895105228753`*^9},ExpressionUUID->"c68dbf72-8a8c-4c44-a3ef-\
9c60b7918969"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Subtract", " ", "backgrounds"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"dataToAnalyze", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"scatteringDataSampleAveragedSubtracted", "[", 
        RowBox[{
        "\"\<C22_30.7138\>\"", ",", "\"\<BG25_30.7138\>\"", ",", "1.05"}], 
        "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"scatteringDataSampleAveragedSubtracted", "[", 
         RowBox[{
         "\"\<C22_10.0042\>\"", ",", "\"\<BG25_10.0042\>\"", ",", "1.05"}], 
         "]"}], ".", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"1", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"(*", " ", 
        RowBox[{
         RowBox[{"wat", " ", "doen", " ", "de", " ", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"1", ",", "0"}], "}"}], ",", " ", 
             RowBox[{"{", 
              RowBox[{"0", ",", "4"}], "}"}]}], "}"}], "?", " ", "--"}]}], 
         ">", " ", 
         RowBox[{
         "vermenigvuldig", " ", "alle", " ", "intensity", " ", "waardes", " ",
           "met", " ", "4"}]}], "*)"}], "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"scatteringDataSampleAveragedSubtracted", "[", 
         RowBox[{
         "\"\<C22_1.504\>\"", ",", "\"\<BG25_1.504\>\"", ",", "1.05"}], "]"}],
         ".", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"1", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"plotDataSubtracted", " ", "=", " ", 
    RowBox[{"ListLogLogPlot", "[", "\[IndentingNewLine]", 
     RowBox[{"dataToAnalyze", ",", "\[IndentingNewLine]", 
      RowBox[{"Frame", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameTicks", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",",
       " ", 
      RowBox[{"(*", " ", 
       RowBox[{
       "only", " ", "works", " ", "with", " ", "PowerTicks", " ", "function", 
        " ", "defined", " ", "in", " ", "polydisp", " ", "fitting", " ", 
        "functions", " ", "file"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotLegends", "->", 
       RowBox[{"{", 
        RowBox[{
        "\"\<31 m\>\"", ",", " ", "\"\<10 m\>\"", ",", " ", "\"\<1.5 m\>\""}],
         "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Automatic", ",", 
         RowBox[{"{", " ", 
          RowBox[{
           RowBox[{"10", "^", 
            RowBox[{"-", "5"}]}], ",", 
           RowBox[{"10", "^", "5"}]}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", " ", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\"\<Intensity [a.u.]\>\"", ",", " ", "None"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
        "}"}]}]}], "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
        "\"\<DataSubtracted.pdf\>\""}], "}"}], "]"}], ",", 
     "plotDataSubtracted"}], " ", "]"}]}]}]], "Input",
 CellChangeTimes->{{3.852787913735702*^9, 3.852788081126293*^9}, {
   3.852788124237091*^9, 3.852788221803185*^9}, {3.85278830511749*^9, 
   3.852788314820683*^9}, 3.852788353883409*^9, {3.8527951901832237`*^9, 
   3.852795266554426*^9}, {3.852795790301991*^9, 3.852795801188776*^9}, {
   3.8534052664208517`*^9, 3.853405359776355*^9}, 3.853405404221602*^9, {
   3.853409748113482*^9, 3.8534097682258587`*^9}, 3.853410243789892*^9, {
   3.853410568646674*^9, 3.853410593142272*^9}, {3.8538366552098618`*^9, 
   3.853836688425962*^9}, {3.8544213058580093`*^9, 3.8544213392155523`*^9}, {
   3.854421399974036*^9, 3.854421487835609*^9}, {3.860120980130918*^9, 
   3.8601209825914593`*^9}, {3.8601399447486825`*^9, 3.860139952932967*^9}, {
   3.861763386455724*^9, 3.8617634066433244`*^9}, {3.8617636721585855`*^9, 
   3.8617636911551275`*^9}, 3.861763753820904*^9, {3.861763829259494*^9, 
   3.8617638295877748`*^9}, {3.8617640171756115`*^9, 
   3.8617640685814066`*^9}, {3.861764108969255*^9, 3.8617641095314784`*^9}, {
   3.8617641469152203`*^9, 3.8617641470504246`*^9}, {3.8617642667147017`*^9, 
   3.861764269211673*^9}, {3.861764301965845*^9, 3.8617643679072943`*^9}, {
   3.861764616394006*^9, 3.861764629873103*^9}, {3.8617647074999027`*^9, 
   3.861764707889408*^9}, {3.861767331688716*^9, 3.8617674531915107`*^9}, {
   3.8619430250008717`*^9, 3.8619430252780623`*^9}, 3.885975125250722*^9, {
   3.885975162956421*^9, 3.8859751687928877`*^9}, {3.885975253564953*^9, 
   3.885975292171652*^9}, {3.8859753684038987`*^9, 3.8859753944654756`*^9}, {
   3.8859764080472107`*^9, 3.885976444462107*^9}, {3.8859766205505714`*^9, 
   3.885976701234559*^9}, {3.885977061431158*^9, 3.885977105613533*^9}, {
   3.8859775666625447`*^9, 3.8859775972455435`*^9}, {3.8859793109661627`*^9, 
   3.8859793451759176`*^9}, {3.8859793845178595`*^9, 
   3.8859794119426813`*^9}, {3.8859794524741387`*^9, 3.885979469919469*^9}, {
   3.8859796644128475`*^9, 3.8859797943053474`*^9}, {3.885979909660304*^9, 
   3.885979925707234*^9}, {3.885980058912956*^9, 3.8859800719340887`*^9}, {
   3.8859802956113253`*^9, 3.885980299515154*^9}, {3.8859803946280155`*^9, 
   3.8859804083447933`*^9}, {3.8859805548112154`*^9, 3.885980558763019*^9}, {
   3.8859806884189878`*^9, 3.8859807559686003`*^9}, {3.886061779883998*^9, 
   3.8860618911826696`*^9}, {3.886062270796764*^9, 3.8860623299442167`*^9}, {
   3.88606290416301*^9, 3.88606290438365*^9}, {3.886152279651626*^9, 
   3.8861523073398314`*^9}, {3.8861523706298904`*^9, 
   3.8861523714286704`*^9}, {3.888311253563958*^9, 3.8883112815379667`*^9}, {
   3.8895154757176466`*^9, 3.889515521326418*^9}, 3.889668778999714*^9, {
   3.8896725208785334`*^9, 3.889672555662263*^9}, {3.8896761687511916`*^9, 
   3.8896761875813046`*^9}, {3.8896762430656424`*^9, 3.8896763228575*^9}, {
   3.890203680281665*^9, 3.8902036879233007`*^9}, {3.890203721626855*^9, 
   3.8902037336503353`*^9}, {3.890203765562109*^9, 3.890203784550714*^9}, {
   3.890216653073305*^9, 3.89021672873991*^9}, {3.8902167682576685`*^9, 
   3.890216804044831*^9}, {3.89021744880861*^9, 3.890217482686234*^9}, {
   3.8902177558058324`*^9, 3.890217761492506*^9}, {3.8909816465407667`*^9, 
   3.890981653810565*^9}, {3.8909826260035453`*^9, 3.89098264917115*^9}, {
   3.890982718701262*^9, 3.890982720715917*^9}, {3.8914972861846867`*^9, 
   3.8914972916516743`*^9}, {3.89149732190543*^9, 3.891497325080738*^9}, {
   3.8914973608592787`*^9, 3.891497387301942*^9}, {3.8914981362303147`*^9, 
   3.8914982511085134`*^9}, {3.891498313222266*^9, 3.8914983218384113`*^9}, {
   3.891498500855095*^9, 3.891498501109005*^9}, {3.8914991502841578`*^9, 
   3.891499209059951*^9}, {3.8914992518783436`*^9, 3.891499304841953*^9}, {
   3.8915003267627788`*^9, 3.891500390785962*^9}, {3.8915011039236207`*^9, 
   3.891501169881201*^9}, {3.891696257967516*^9, 3.8916962624557104`*^9}, {
   3.8916964408634305`*^9, 3.8916964443815727`*^9}},
 CellLabel->
  "In[2828]:=",ExpressionUUID->"5cc1674a-6b09-4f41-a48c-1487561a3f0f"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{}, {{{}, {}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         PointSize[0.003666666666666667], 
         RGBColor[0.368417, 0.506779, 0.709798], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJwUWXc8lu8XfqfX3tKXlBSJkooi8rwkWYWsJCINiYzKSIUkJZKojCINlChb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         "]]}, {
        Hue[0.9060679774997897, 0.6, 0.6], 
        Directive[
         PointSize[0.003666666666666667], 
         RGBColor[0.880722, 0.611041, 0.142051], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJwUV3k4lW8TPo59PysSSeKXiEqFxBFaqCyhZEsSpayRFAqVQiKRiEpEi6Ui
FZmhQkpCqSRb9vUc++57v7/ONdczz8x93zPPvHPknb32HyOTSKT1fCTS/3+n
sqweVqow0PuKRvlFe0F9i8HBO2866Wh0v8dVu1xAv2jl7Z270+m40ev5sUQr
QX0Fv41P/h2lo7h0nOX5i4L6Wc6zjxnKdExKkrTMZgjqX3+dGxzAoeHpMHqb
Y7eA/mejXT1FJTS0KvXTyzoloP/heCvneiQNmUodU12SAvq8qwfrim1pGFi/
d4NACr8+ma1CFllHQ3HOqSe/Fvn03/s/rjLjouEs7+ktJqf49D/7Suo7/qSi
r7Wvfcs0r765zX4Deh4VO6/e05qK4NV38KJ9N71KxfpVy31UBXj1u/conRt3
pmJgPk+E1g0e/U3Ce3L69aho7ldstWEnj75/vVm8tAwVS3QCW6JauPXj40JD
vWYpKKLqb2zswq3fYX+hofE3BY1P7G2Jnibre9y+mcZ6S8FjEucC1ZPI+k+r
//olp1Bwf9R3wxOaZP01Uiq6v4MpqBF+jvtMJZe+0Y4qpREnCp7z1VLfYsGl
X9AmeOibEQXbP7yu950h6Wv9zhn2UaagkcDx0fZ4kv4F9nbOJzEKjmEHu8uC
pO9a+EE9rU8cY8mr/DY0L7FOLqbc4rwSx92uYkefblhi2Vps2RlyWRzZ1z9e
nr+1yOIvDfDZbC2Oqc6HhSbSFlh3pGUPCCqJY5rRYUtP6QXWlrfPmUNTYlh1
zGGs03OeZVP29+v3ajHc3jZdqvFojvXPaHB7YZoYrip/ZlcxMMvaEnG/K/y0
GF7Xf/PW+PAsS1dl7cwWYzGkHn6WfWRwhvVtNmjjRzkxrPjv2ny6ygyrSc3k
h+KUKPL43oBfqdOsSIVllea1oiiwLlr3ZsMUa9MZ3R162aI4sJZKm9ebYskp
N8x3h4pi/qH0D6+qJ1nh3ONyRvaiuFO9yKxZdpJ1sPaDvJmmKJode1qzP2CC
tVdp2y8uuihea0AXp8lx1irls84HRkQw9/k55RmrcZbsl8Ddu76IoOGZR6ll
/8ZYdaGPdWsfi6DNQnxcjNUYq+jOuFZfhAgq2X5Y5G8ZZfUlhUbGuorgI8WA
mGryKGvnobXpuIM4D/eohSsclvBT9f/8FUVwNfv1inPbOSwH1VzRJ7wi2HrQ
VcQmj81avTvYya5bGC+UTW+rZ4+wJEJcnS5XCmO2Wx3vqNYI6/qvMe/Vj4Xx
q9N+Azn9YZYOdXbd5ijCP+b3grjWEIuUctKpwEMYw9aWy7/aPMh6NhVUkWZO
+H+MZrWpDbDshT8FczSEUfJ+gLSPVz8rR3r6ymNJYdx9s6Rid1wfK2i7htqH
OSGslUu7Pa/Ry1q/3PqPXpsQLrMNVRPZ18PK8W/ukvgohMmZfrSklG7Wtf3H
+42fCKEX/ZJ5zYUuloSCdOqPG0IoUXPhzRmXTlZj0cl7Rf5C+Je2W8Oj6h/r
qFZM/ZCdEF4Py3toMdLB2hBWqXLGQAjbAsvWGf5qZ82dWowyVRbC9vCCdQVi
7Sz/SHVxf4oQHn0lZlt7qI2l5n27o2dKEBli+cdUt7eynCVqZTNbBfFR0kjp
tqJm1toTl8WfVgripeqO0e/Jf1g2jabM6TxBfDjsfChfuoll07b+TGSSIH4a
oXuVmv5iXen9/MwpVBBlPKfFpxwaWT6Pc/QD3QVxQNGFYyj5gzXppp5ebymI
S66bHHcNNrA2jmn6ntQVxGsmtYa9V+pZvqJj9gb/CaIFSyv92fVvLC31vklr
qiDW6+QFtXypYb29/1s0c04A41ydsnOPVrPGhSb2qHULYNjWFJNgniqW/Zms
CPY3Acz49qjzC+cDS+XMifv9xQK47nPa041+yBq498JheZYA0mcZmZ+3vmN9
TlzID70pgK4JZuoea96ykFUaLxMigHZaOmXurwpYC1I2Pf0nBPBJrd3rft1H
rNhfGoUD1gJo0DPVI2GfxsrfXym6wkAAhbic9HIvXmPRrC/0XVQTQJv5iYpS
p+vgJEd2oy8XQPmkTTE1X5LAPlnz6Xd+AbzHf+icIukBcE9Kvn8/zo/3g0yu
NU/nw0vVTW2t7fyoXd8QXBBXBIpNudpravmxbWTwqIJ4CcTpdQynlPBjqUbo
gYpL72BJcqfB1if86Crwc+9F1zJwbTU5T07ix7urGhO6v38ENYHPn8Yu86Pz
4W93z9+shPWdH66K+vGj120vpyPc1fAyW3HU1JkfC3LJYXf3fAFB5QqnInN+
9JUNf2Ae9hU+ajzU2MniRzfWIeOKD1/h7sFrL2bX8aP6780CeTx1cOAG947v
Mvz4qWiTGJlSD7eGrQ/UC/MjM8QuJOFDA5wV+b11fJYP16YIuvL0f4eAuuvH
tPv5sCePWUc2b4RgrW97H/zmQ9fMsqlrXY2w7Mohc5VPfKhTP5VfL/oLruRd
G2p8zYfX7FNSLn38BbofqzIeZvOhepDM1s0nfoPR5//aYpP4MHQf9/LcR39A
m+allHaVD7eOtzYtbmyGk8mKXJ/PEv7D5O18a/5CxELVP4kTfFioGGzvuvAX
fETyHEIP8eGLLn9mWEwL5Kx8ShIy4cNLZ3Kkk/e0wXl64+78rXwoa1SG071t
4BluXnNahQ+9uH9/Ee9pg6J7If9ZyfCh05lWV6pwB9hOa/0zF+VDt6M/1WMS
OiDVTi7ixCIvJkydZa9W+AeRdrKfU0d40XfQz+ru+3/wXW3r1qE2XjSQTO00
ifwHPiuWOR+s50UTnaGdgwGdkF4UQGp+z4v2EtEt38W6IFKFnHWukBdvd+eK
6H3rAsk7X/s2ZvEi/hzQGZPrhj3xA1E8d3gx9KWM6Z713XBtu4LiSCQvaux1
/XhnVQ+0ngoyGw3ixb1nG7Rz/HpAltNRL+rFi1t5RoQPXOkBka0f924/wosb
Rs4V5Zn1QqVFpn20JS9aeKx5IiHeB8+NOr8O7+DF5cVcIUeX98PNH0o7j2vx
YpPWLrEKsX64pUZym15L4OW+Qj73qw+0S3q57snyYmXzx932C/1QImFTakfh
RZfS9UvGSgMg6HZzhxo3Lwreby779mkAXpbXn5SY5EGdUt/AQNYgsA4I/qX3
8SAXZXWPi+ogmAp936nUzIMvt0TudUsahKXpfxf31fLg3Sp2/jP/IUj4a6Zz
rZwHPf13mVdlD0G8EP73u5AHV1o/XHB/NQyZ/0nI6z7mQdK3wZlk/RHgqTP6
U3CXB3k6JVatcx6BuqBXwvqxPNi08saYn9UIFJvqxbaE86C24DrnFUdGwOqR
68rYAB78+G/jETEtNvT/J+1vdZIHhaz6ed5dY8N7yU5PlcPE/bNOzIP2bNho
n13FsORBxx/yP3c/Z8O0+cY9lF08+E2qKu1yDxskUt6+lNXhwZ5nl0ZF9nHg
6kaZ7m3qPPgg+U31Bm8OOCbaPvBQ4MHdXWIfqA84cPDN48w8SR60SFuxPaOD
A9io/JsswoNxm1NPq3GPQobN2wVXEg+uWozadn7DKIzsOtT4Z5wbzyjqLRS6
jYLD3+17jvRx45LmIV7vh6MwWUeSn/rLjfuDupSE7o9CquAG2dR6buTd+/ju
RO8ocAuQ11pWcuMQLZA2LTUGFuNhYstKCHuyiOd5zBiYDpbdHM7nxj3FdzPC
347Box2Q3pDJjc37Ta9Vx4/BPKOLvyqZG4+NZvwQahmDJMuY6M83uDHs58rg
i3rj0Hvn5IqWS9x4M2vXylXR4xB3VvbaUiA3Ssl9ZpdcHod/tmvuqHtxY4rU
3n8uV8fhmnqtrqcLN7Z7GD8QrRuHbJtKo+JDBP6KeMHnyyYgdCY1SMKMG7O2
uBlPbJqAkRqRxgtG3LjvWvHOhugJ8OgqXTmlzY3Zgp5+X05OgE+9yrogdW7c
KOdy5G3aBNSC+5CYIjeOh61pMxiYgIabSxvzpLlxV2fUirHlk8Cvt/6bPYUb
Z//RttxVnQSHiUOvJfm4if7cE8L1ehKUCktLW+fI2LvjU0ni1CQkV9kUFXDI
GDgxpBf5axJG6woTE3vIeD15svnt+0noFH+34fJfMlIuDqz1J09BzQyP48UG
Mn5fzedsHDYF97M0qVc/kXFjc/9g4I0pWHOlWv4ukJGdfjSGXTMFn0p/u5YU
khGuK6VMvpyC4y7LfvY+JWO7ooPVf7NTwEwKMJFPJ2OC7pMqO6lpWGEceudY
Ehl/vtH+98JuGk64/SsujCHjqxqtmtHr09BZwY6kXibjRX7xPaqcaWC5Z/Wf
PU/GbReOq3x/Ow1rmo4UDviQ8dnwAq9u/jQI2JE6Txwno8nkS3/FAzMQGn3L
YsyRjN2C2lxtQTNwyqj0d4Q1GW3GeAXDbWeg0FHjzH97yahatyHzZeYMrI3V
5643IKPAhv2rtF/MQNmRtw4R2mQUHnt9e/u3Gfg9uOLirvVk/O/51GcB3Vkg
07p30f4jo8ODktZbp2bhZoRgfI8sGSPzdfJGn89CtPZ7+0oGGXNjzy03a5+F
ZRZZ4c+FyVh8Oush7e8szK2t6M4kk1F92bEgkJ8DrinBsIwZLlxPWXbdwGUO
GjYzN+ewudB72ZTr+Ytz8MeUqw16uLC+SejnsyNzYMtxuNDcwoWnftu1qBTM
Aeff1zFyIxfO0dNCi0XmwazxxAqNGi5UDjQ5vr5jDuyGDs2f+sCF++P6TqrN
z8HkqKZXfjGRzzHGJMJxHr52CR5aeMGFqYViL/rM5iGXfL3I8gkXNh9LC/Bx
mAf/eEOPlw+4UHgyuCrn0jx8eSTlIHOHC3+Uxi+S/s2DX/3+yzGxXKiR9vDw
Gu0FCBKz/CR4lQtrj1tWO4ktgGJPi0jMBS6kneZ8+blxAfjkSk2XB3BhyMkz
e5LTFuA/daXTzz25UIm/vqb86wLoq+c4mrty4b+OY6zkFYtwwP0WZdqBCz2z
+awCfy4Ac2ezR7Y1F+7xfvFSdtUiHBTosDuyjwsfmG/qKlq2CM0Oh5pW7eBC
04m1SUp+i/D4Jk/t4DYutF4aaWotWITqXUtysIkLY9LLo87GLILf7+M1d1QJ
viX9b70jF2FgquRd0Gou3JueGS9ftQi6+2p+uslwoapUYOiM8hJ8SVshY8fg
wq9sQxeL/5ZAYvavzwERLpzp/B3kWrUEfLojVYd4CH3FFRZMby9BcYaQ4LF5
Ev4y2hJuMLIECxIaGmfHScht3Nq2u3QJBo+dUY8fJOHZWpOgrokleLRhQ3dh
JwmVD97zuClBwty0Upu2ZhKyytflbp9eAvn6L160HyQUqc65YaNEwrXD1oy9
NSS0FGtd0W5MwuWGAruvfyThF7+RVS2BJHR9qDL+4x0JXwuOSL50ImHcBguy
0isSHo2WuduUSkL3TH+/4FwSpv9IUXCJIqH1Jr9NzY9IuEp1q31kCAmDfnmq
GtwjYZpVkZRfIglPbCg6kHebhI+9T1/RekHEZ98qVIglYbSh2MPQDyRs4G5c
fu8qCaubTyfceE1CZMhGy4eScKpapr19joSaeZMCTwlcb+846PGJcqHt2plj
Or4kZC7xmzuTudB8c3JhvTsJU3okummErnK8o5+9j5Jwy5fn6KnAhS9GRZ8x
7Um4kb99ZFaPC/NLOm3KrEhYq86bq2HJhe9592ad3kfCJon5Y0cdubDDOjpZ
dSehT0XKqSlv4r7Dz82DeiS8+HzlgWyir/csvTF9oUnC3efXGYi95sL++ILe
kPUk5HOT4w1P4sKlE+v59yuTcKfX0zVcj7kw6t3JiyqrSDhyRKUt5T0XlkQv
txFeTkIfVdGvNe+4UP3+3zgOndD1Qk6BQB3RV4MpPC0iJGS8SjfR+8aFbyV1
C77xEvXs2dGEOmScbVppHL+wBNvazt3P20zGMwF7beOIPimaOMM0VCNj/uR/
GSntSzD74dWlVjkyahzNU3vRsARGkNxkYEHMzfIdT75/XILC5NlLjb5kXG3r
Kcf9egk+xl90TA8m46RDcKLukyVQ1UpUL8wk46C7WFn43SVIZkzY10SQcS9l
OutHzBJ8Xngil55PRtn8dkuN0CVgrUv/9DGZjP6SiQF3TxN9f0vaP/I9GU84
bpWhui5BPyhI/ekg40HHDyZxNkuQFWoS5tBJxjaGYpHMniXYwbDmfkp8Z5Qz
Pru/1F0Cd9W5PR9J3JjYO+VpvZ7gx3s+VHmBjL98Xp8lKyxBdW7y9Q3buXG1
anncWybBL3XyVyXx3TyOye+DBZYAXqaoB+/iRrqY64c9c4ugRxcOG9jNjQcq
pNNWDxPv9IDm1ghjbjR2vmgr0L4ICalvtrw3J/yVqvInGxbhyGh5/II/Nyq9
VXo6UrEIT2WN++mEzZ/+wHLszSJ8H4w1DP1G3B/2cubKWYR2sytRH95z40wG
qWPZ/UVo/Ep6o97MjU/L4pu3xS/CTUOpCsuC/+8RjsLuVxYhbCxu+vtNbgxq
5w98ELgIJ/dt2p5QxY3aHN71/04tAggVntXv50Ye2Sv9ak6L8DnCRvE2gwe1
pJ1fXrJchGVf77jpLeNB7majhM6di/DzZ+bjp9o8KGu4d4/p1kX4eqj2lqYc
D0rmh7WVrVuEW7d3NtoYE3vf8PvDLPlFKNr6p6TyAA9e2Sh1uYKxCF6mhbYW
5jwo/rDI7qDAImzu6NkqT+yNp7meDXPmFiD8uP2jvcS5eXr7bMLIApztllbm
DeNBt/ziKMN/hH3Y+OJHYk+VVfZ6Ntu4AEn5yec1c4g9NaJCurh6AbYzK8rO
FvNgmeO+jkulC+BgF1+FFTy4bP8RMZsXC6DAd2I17TuxtxpkOmx6tEDwoS19
KuPBOwXVf5YlL0AA51KeyF8eZJ6zviUQQ8z1bD5pbVFeFNtfvJMUtgDfS283
LhvmQTnbukXSmQUo3pNxuF+SF0e2saqE3BfA484puxZ5XuQz2n1U1nEB4Pxr
j/U6vMg70PFHa/8CbAq8pmFjyov7LvzSddi5AJ+3zXxysiX2/hebTCK3EvFW
fu6hRPPiE31RUVRbgMej20WMMnmxbMnk5uKqBUjuHy3afJcXIyXepeyQXIDj
cpdCrkXwovrFxM0JwguwbuK6iKgdL9JS/p4cWpqHdDK/6f1EXlTRW8llOj4P
O3pPyWok86Jh8TOuot554A+m39Ip4sVL9MzANX/n4ekX+ZEfobxI2mShml43
DxYe3fYt33jRZkJKaXXFPJzsNMoS+sOLz9Zpnc59Ow+UwUa9yA+8eMHr2U/9
vHnYcHupPPIdL946MnH4z8N5kPZQCkz7y4uUaVepkKR52B/XedOb+B+XL5//
cc31eegeKBoS0eLDi/mufn9C5+FXu1nont18aM2cWJ94Zh4+Pa2yXLaJDx8H
FKHNyXmoE9r7Q3kfH04N9+5ScJoH2zUcvcu6fDjXcSB6wmoeoEyr/6wPH3rm
vE6uNZ4HQ3eH5vupfOhel3zhud48jIeRb77y58NuGx+uFI15OLxF+pZvHh+u
/sq7LnrNPDQYnqAfjONDe+0pscuyxDnT8K0KcX/4gr3nZRqxZ9gk+O0M4kM/
EsXmOv88qD34PGJwnQ/nB8t+3SX2mM5k78K4D3wYcXjN65ecOZCQFdPY2cGH
9ax13PXdc4AHpFbH/+VDi3uxFVN/5sDQNl7ChYsfw4wyqlfXzUGgJ5eB6Dgf
rj/mJHOoYg7MbVfPvFLjx9dF8VW3iufg10Ef05vTBD6jNUk/8+dgOrN8Mp7O
jzJHFZLkH80BrSI8dmiWD0cNj/zwTZmDys/bkgPM+HFHh9Oyz7FzoJ+lxxbx
4EdSiobP2itzsDLuSQ5HlR/LZsv6Ys/PgYHkyWdzKvwYXCKzb9F7DpoMDthX
3ODHMxudsn1d58DaMNBvRSA/PttyUWDYbg62NDa0Ol7mxzZlGS1vizlQOdp/
4+45flSzsDWa2UngqfapdH/Aj0/rtLZe2zYHP74mc7IT+HEqv6NTbuMckHLu
6jFi+XFifYTFu/+IPfPCf2afI/mx/vO660dk50Bo38axA5XEuUHkURH6HCTF
HZwrauLHd/0N7e8E5iDjsB13zAI/rsuWZp5ZnCXe144bpeX8qKGU9GnT+CzU
CHQY+/zlx+TBSJHZvllgNL5fzZAVQOYpoYGPrbPQqXRztaW1AP4MatiQ9GMW
3k1wy4toC2A2r8qw9+dZeBp7+pG2qgAeUVNfZ142C0nLi+0CbQXQxFq2ZHPR
LFiIO2Q5+Ahg+wQrWz5nFjiV5lfnAwXw8eriRfrDWbDt2hYivUsApTRMrovc
mYXV+yua9poJ4DvvbUeEb8zCesceusw5AWyVLY6gXJ4FpoXzJb5MAXy7NP91
+flZOC99fvBCugB6h1kbrfOZhZlh8vkHVwRwl+3ouJEbwedbqIddqgAmWIbn
OTsQeFaG5O75KYBmuw+HXrGcBcunp61khAQx43lRQL7xLFy8fyU1mk8Q7QRe
HmljzULtviYmRVUQ64ae7JXYMgtyay4wFJYEcPtMw479qrOw5dwOU+HlgviA
75PMrVWzcCIulXR4QQDXtnW1/JGaBdcDoXxDioKofvfIHWXxWRi/Kec6biOI
etuNZYJ5Z0HZyUGRQtieKrN+jXMzME5/EJl9RBDzbXLyN4/OwLEaF7cgXUHM
qWu9l9w7A7tDD+c1BQvi1fERM97WGXhzirfidoogBklIffX/MQP6hdSGW06C
aKFsODDweQZiVR1MdpwSxM083wrcymcg3LZoTvG6IKpWz2j2vZ4BZm7O4yof
QRTYK7nTO28GrBUj5Q1jBTHmYMTgPPE/K/+v2rm6vYIYbntZ68bdGUjjSGk4
pQsiU7B+Til+BvKe1xg8OSqIR55+NvxwbQbqhbKLtsYIIi04R9bt4gyEBf19
c+a+IHb/d99OPIC4nxR5vLpHEBemSMLvPGbgDpPz53uFIM5eENL2dpmBZ5ma
RisbBLEkZM/rNXYz8DJHwr+rRBBfN8gldlvMQGn8xJNH3YKoOYWtj3fPgN3X
OtkrTCF82yd/3Jc1A6d13tSarRbC0hd3t+lvmQFL5uVtHWuFUN/ohDt93Qxc
yl67+vpmIdy/7O+HAYUZUHC77euuK4RWc2aHPknPwMGbDTqD4kK4ZmRq0zPq
DPSKTWTsOCuErupRKrcEiHzqvnwmp4WQHnnaIXRpGswyV/CVEzbXp0dppyen
4ftAbOSWPULYv+rsvPvQNBh3TxY8PSOEkTeWXXLrnAZeVyjt0BZCn9oWwRN/
pmH1sfUbigOFcFOHZIpX/TSI/k54PG4uhLd+jhmd/0T8766+GtVhL4QDn1Y1
R+E0HEibiEu7K4QeqhyPB0XTgG6ZnyQLhZDzLZK/JHcaHi57kdv9TQj17swG
/8mchpVufLH22sJIWX6tZenuNPzn4rpVXUgYLyY5blG+NQ2Z+pWVa8aE8OHG
VtuDUdOwjdvFJI0ujIlWZociw6ZhVFI8cWarMDY5N+iVB05DcNJxrk1rhDGW
9V/7ovc01IZPCLEEhfF3e+Q+/ePTsBSROLPHThgvXVkRd+XwNAyvMv9zwFUY
qfbjoXUHpoHnQ4/hC+L+v3u71smbToOmg3KXM5EvYeWm+/47pmFv/xfn+yeF
MWVo5fOv26ahPqltS5yuMO7cbeShumkaeiXiLknvEEbOvsL2GJVpKKx+lei7
XhivRat1Tayahmxd1brwx8K4S6j90hHpaeA6IGXdGUPwHWupqaNOw6agl6Mi
BsJYPbvp9k7Bafj1YXbHf4eE0S1PbBhI0yDwuH684ZEwclMCW3WnpyD41qHg
E57C6JteZ4AjU7BXrW0kK0IY5XbqKe7qmYLNRXsebksTRs+bFfH1LVMgOrN8
82Y/YVS4Lenq3DgFO9WW3T38Wxi/7bN4PFkzBfudfNdfyBPGn3n+7jc+TsFk
TbhdXYkwBjAvhqq+mwLdaN6NG9qEce3hyLmagil4WFBr61QojGYFsV2nn01B
/q5vLJlWYaw9/0dyRcYUvF2xlfxmlQie2hty70vKFESfahPCfSKoZOJ17UL8
FPwq0ft6+z8RXPbaIHdL1BTU6d8kHecVwS2FvMtHw6bgnuB7v5+rRXCHRnbz
83NTYOy/cEdsuwjuVhL84u87BTq8qcv2u4tgjqD6pK77FGQJrpcx6xLGG97c
x4WcifPXL4cf7BDBc39yZ5sOTUFvQ3X3vLMIcqbXF+dZTMEuydtrX50XQcOG
U6+uGk9B+g/NeAgQwT+HGj4e2z4FZYMTPl01Irhyl8PkTu0p2Nf5ZPMhCxHM
HO+2Ut0wBT6z3zUUtEUw/vGaYqbyFGxnnHo7+lIEZfkZW7jlp8BkbIb0rUIE
d8aG1I9LEfW43bXbX0oU1zS4uvdTpqD2s6Ru5mcRfLapSKhTYAoezXRaD74Q
wQBdPWwnTYH3QSvf0rci2FXEOvZvehK27clcKe8qgj5P0/j62JMwbGybVPxc
BMMvrXo+2jsJ5WteS0+vEMVFI0sWqX0SdifUcqeqieKDAJFS6u9JOBj457jK
f6IYu1ds6391k8AKvMhjsEDou6gQo/9pEnjeHb62rkEEtYLlKx3KJuHd0HLx
7/KiKHAPOCFvJqHRzEu464Yoev4V7nv4fBJy42Z03+0UxQ++9W++PJ6E7H3R
+xx2i2LSuw/eMw8mif2slN/TQxSnwzb0KSdPguMnGZVcQ1HsVf2r7nhzEi5m
n3DxdRTFiQgfi8TISXAvuJTRnySKfYXByvVhk2CXePXWvJ0ovtcs/UA9Pwka
L2oob/JFMVfth7r16UkIb99LSswRxbfqcTvvnpyER8k3piTziPPiR8yeo5PQ
k1brKm0uir7r8x9vtp+EQSerk21eovj3+duWCKtJSChtcplzF8XiJ75lf/dO
Qgzp9ZfmWlHUuefuqLljEnbuObQr7bMoHnIeirulOwn+UbO7pB6K4ufeR2cn
Nk/Cmr/s3ukxUeR/KjRySG0S5NRfPGUqi+E6jyKucqVJ0IrXvvWKLIZZXhvf
rZObBKUI72mx76JYy2swfFdyEizN32e8bBDFFb1adeKUSVh+K8CI770okoR+
GVwRmIT+OnOvtEVR3Mcvv5LENQmuMm7v9cZF8dukdGbwzARcVty/pqROFDVH
y3IXORMQRnrlrXpQDEkzFtLh/RNg0M7fUO1A2OsiFIT/TcDZxZV+H8zEcI6U
lJX4ZwLCf2tWLbmIoZvYbLji9wmojX60R2qLGDapyo0XfZkA+1Ue73xOiKHO
4YAf+z5OwNAKwWf1hmLoQn/O2/NuAjzu75qLDxHDMxfGIfzVBEjebuWveySG
KT797Qp5E4CkimO1wWIY7B5oXJk1ASEP7KIvs8QwM/PiBs/7ExBJquFhB4ph
4lxbgNSdCXC0Or3+xEsxlDd4PfsxbgIuHOI6VW4thkqHU8fPRE5A8SqDyehC
It7ZbEOV8AmQ5Ql3T/krhtpL6yo6zk+AjtC9QKkWMXygFPwq1W8CPmur4/Ef
Yngvu3PUzmMC1FW1fR8kiKHNn+FDsq6EPgNLPRc6xfBx20PFDscJWLniU+7m
KTEcN7+66cnBCUjmfftq1ypx/FNgd8zffALWv5N0n+EWxzUlrRxD4wl44KWX
ofNYDJ+qfH3NNJiADon6hOJeMfQSX36nf+sE5Jabqm5kieNTA4Mv5RoTkHSe
Qtp3WBwlBDZuSFOdgG7WQW9vN3H0NqRlBSlOgLWl5w4xU3Fk3F7m5riC0O+1
4qo4mjiekXI3N5ScgAFGw2gZRRyfNzkaqFAmgKQwGPljsziqtff5SwhOgP62
sgumn8Rx+ymnah7yBFiyldzpeeJotMxcbnJ2HDbEluuzcsWxrtM1p39sHKit
iRyKszieTVC16hgch02+H1uzU8Ux82of5W/XOIgHUSt1MsVR/b3H+6aWcfga
UvzC66Q4lgSIZvz5OQ5FM7kFqykUfFV782brt3HIAYkE82pxFO9a9Oz+NA6J
fiPDq93FsZV11IddPg4uFtq8NSQKPl9eHLhQPA4NBiUHTswS+US0josWjgNU
pxQ+qiL4hT32W5k7DslrcnlmTonj0nqdC1uyxiFrVkwuPloc/143PW52fxwy
ftu7v74rjj9DfdxO3hkHx4Nj2z6hOErfX7KPvDkOP8s9NucQ/DlPryk/iyL4
cfKOT/JT8EaCPU/dpXHwYkj8dGgQx4M63F+ng8ch9uP7oSluCsot13VTCBiH
y54ymUPiFNz8VoLfwpvwf3b9ovo2CsrkG8eEniD0sd5k1EH4n8t8/7fAeRxC
ySobdIh4V/UtVAfsxqFRQXyrogkFQw2abFdbj4OmwiHNLCI/cgJNnEzHwe17
t7qXIQXv3nu34d6ucSjuktVnSlLQ6MlbTpv+OBw3Srf8vJWCG06+Oam4dRy6
n1lRy8bFMcxNoPGUBlE/eu7GtasoKEnppxapEv4xQcNK6wk8xg0kHqVxmLwl
tidaiYIZlt9/WcqNw/Vytz+Hd1DQZa39+UdS4yD448ishDFRvyLh6jnqOEgO
+smbb6Hg+PnCWUthgp9snOgRawpGnh0fzuUZh72uQtaTpyn4YFnCVZHFMTiu
eEZZT5uCXBmqC6emxsDqZEx7cDoFC1JC1b6xxyDCCs4y4yio5Bm1uLl/DLwO
MF4J5VOQkpWenvZvDC5FsGKUL1LQ78vrecG/Y7AVM7ungilo83VkOKBxDFip
0n2KvhT0Irnk9taOgec369z5kxTcd2qDrP2nMdhTYJLj4k3BlQIZsvXlYxAz
9HSuIpWCyl53O01KxuB8uXMW4ywR74WTVUXhGKi6BWX/JvCVWrqaGeWNgYHc
+KsPERTcW7Bf6GP2GOyQOb4uiohn5Jvgtjt9DFLHd0zr76bgCYUa468pY9BV
KJBhH0VBiZMuXQcSxoBf5MjFzV4UHJgfk+mIGYMqX53GLYQ+u0QMG7yujsHi
xFNvSSK/5mzoNlLYGDATGmQ2Z1DwxzJfnfjzYxDKfMLVR9h8VeSXa/zHwH9C
bJXWeQr6p679iZ5jkOHV58XeS8HvUg2RdsfH4KA6s2kVgd/blP58+gih771M
+1/VFFwWkR2cZDcGrZNiv3f/IPpl7mHDVusx+LzsTRhPDwW1+YwSW03HQDO1
qdjlPQXtpERnruweA2r1+mcbOij48KVm63qDMZho+VKa+4WCQSLKqn91xuAc
BnjKFFBw+/p19OjNY3BqUuDv+0oKXg16GKCrPgY3XS4clRykoPpNSV3OGqK+
CzUREykUNI5NTcxaNQZvXG7sP9lKwRzDYjcnmTEIcl1svPeUgoumq24tlxgD
HgWfjx1DFNx5IM/0t/gYOH5po0YJUlFSRez8HcExyMu8cDiEScVpAYkFO+4x
sJmqsc3mo+KPyFP88gujsGddP/cPUSrqr/gX3Ds5Co8M24r+Laeiz/ozRi/Y
o3BD6euHHxQq9r6/dT2kfxTcDdKblEWoqHx+s+6+zlGgfbxKuzdA9PONQM0V
LaNg5E82ejdCwS9Nd3I5P0dhSW82dt9/VPz09fmVyrpRkIxRiv5nREVbUf6M
e59HIaOvxOWELxXVCu9qnfs4CoEHw+4OGFDRMOPFmoMwCqIPjP1EdajoF/bC
ZsubUVAUV3dmraJi0kr3WcmXo6Df/k00XICK3q66o3PPRkGbe/dtEsF314M3
qzsejYKGYPwbkZVUbIeA99X3R+GNccDZ9QTfLZZLLwqTR+F8Lqt1hxwV24ZJ
v9JvjYLc+WQ//jkKKgq1H70ZMwr2pyZft5ymosZFE51LV0fBTjTrpZgFFQ/W
UAzPho1CkMJ6oyweKoKtyzPPoFEw05pxkJCnohmbZu92ZhTeSSfKnzpIxc5E
mqaz9yhIU4OMTIn7jVQnz8PuoyDcLPNJ9iQVC98MdDu6EHqDsXSnMxVZn2ou
OzmOQulSENdzJyrSPtaed7EZBf7VA8JeJlSs1+HJdd8/CuVtf95ti6Rik34m
1+m9o9As1DBqtZWK/BeNs4J3jsLxgJ/ePoT+3S6KlyL1R8H61YFj9LVUvBZ+
K/jOVoLf8cTNJ9KoOEKfe/9k0yh0ujkcEU8g+PDlbStVG4VLPDLkvngq6kqv
q2lYQ+jj5/XaO4qK+85kZQ6sGoVPyVGyr45RcfvWhKe8sqMQ0q7y7oQNFe1n
4j/IS45CevW7GOtEKkqpZazUp45Crin3m4UsKu6vc8h0Eh6Frdd0E3cUUtFt
KkQrnHcUmGpHt6RlUlGgtlEwe4kDtp7L4lY/oGJ1o+zS1xkOJGak9eUR8a5Y
bFycGuPApoOPTjA/UPFl2IstCsMcyD3kmF89SEWGTECMeS8HlnnXiTVXUjFN
N2TgQgcHLpW4aT6PI87vbQ5+3swBbk0Bt4u/qCj9PUG5q5EDT/wEVu58RcW7
10oapes48Nukqwaiqahi0vNy/2cO8IhfyBHNJ/pBRy0r+iMH1qy2DnhSS8Ws
XV8Tq4ADmo32Odk/qOi09sdzvrcc4OzAtaoEvxd7zrXsLOBA7xax7M/1VKy7
soz7Wi4HKEnDDm41VLRRiDOtyebAdb+A6n19VKwN0cyiP+RA1c/xyavVVBSW
ihizS+WAYLnHAVYzFftXqDs/us0BywgvuvcBGt66k/F7NI4D0nLOJW8Each7
+KL+9mgODBXAsXYyDTvaDT7GXeFAwGseORSm4aXLF0w7L3IgDE5FpL+h4hO1
oXKt8xyYGrBa1jZN1Gfwr/kNf4KPaPxJI00a5m/ibu3x4kD+v3sxLitoOJO/
wcrAnQNFA9PBtA00XHnsekuaCwc+tJ90OCBOw9HYLpcFRw6cHsh+09VOxX+H
VL86HOJAw5rTn+4T8cMpNrvRkgNp759U2avTUOiM9dvVphxw3V/fxlxJw9lO
DeGo3RwoFKD/OCVEQ5ZFyfExAw64h0ncFCXyWb+afuOgywEFubtlz8VomO7A
7P6kyYEt6SWKZr40NNqUK621kQNWhq1/czVo2KTcr5etygET7+vKOYR9aQNt
q/R/RPwX55xIOjQMu5KgHSPPAbm6po/nZGnoV1m0mkeGA5f1WENO62jIv6+l
47wEBzpYx5gGujTMGt/zYILCgUmD761JVjT8Vum0y0eYAyWmiiZ3dtHw6va0
kmFeDih51uumytAwdtNyNU8SBxzc18fr0mhIrbcMH5llA8VvC8ttHw0V/bse
+k6wYfDFxNEywlbTKi6ZGmFD/P7SWLEbNKza4FEY0k+cS2puvxJAw2q7An/+
Ljbs4LE7vesoDbNPmK+92cqGqYzJsOxlNJSTmHi7ookNTIHF+ycdaGj75ox4
znc2eEd1iG4yoOFZ9gkr3Vo2zFs8u5fkSUP271Sf2k9sqInWOVcSTcO1R+uP
Hf3ABov7/g+DHWnosLQkNVPKhmfKBWxFwj/WKqwo9g0bTiQLhcsm0DD04V7l
tQVsOPd8j8LVCBr+Xet74GMuG95m9u9TDqShssbqk86P2bBlvUfePSK+yFdv
M64MIt75gCsHLWj4X9XlgQdpbGCf1g8+6ENDO1v3k0Z32EBaIfkm34+Gb5V3
FfXGs2HzrWu7TJ1puM7KpSgmhg0sFff6uis05Da/d3vLNTaMfCn6bhNMQ/Fl
Ovpt4WxICI3Llj1Cwxcdd+5EhbDB60t1JP0BDXueedVqBbJBTtKDb6iEhmdi
llX3nGbDm4tPJ1tiCP4JdN8kTzbQpaV/PG+hoXpi76jJCTb4jx3YNvmZhluu
im9eOsqGSBFhta/pNNRbtkK+0JENEaH9f53SaGivd6bj1CE2pHM7XJivoeFY
fPYRJSs22H5eED/8k4ao5hLRbsqGMsEp37vDNCzy6AhJM2bDDSf79QYVNAw+
VLPewYgN1YEJTtMTNGzdNHRZlsUGLrmFs8FvCfxUy8et2gR/I4X7pqU0/Kpa
Hv5wExumG847R/TRMLx0+eJxdTasWE8/4vOChve/7zZcv5YNVSpFolPPiPmQ
pbhtZjUb/HpFfKrqaRi37lndezlC7z/LC2V20lH9TaparDQbKrkzvNYJ0XHz
zhEdRyYb3FruJHz4TcMFq5cd6yhsWA7/bs8Y0bEKw/ctCbHhm1Ju5FoGHQfo
nsfqedmgcS1wqqyJ4COfSs8iscHXwS4qpJiGFWv5eecmR6C592gGleBzIiNm
y9NBwn6Aj4IF6egRdyDGsWME5txVflGk6LjyzKQT89cIlChTfMmVNFzm2H+x
tmYEzKMKTO5vouPVhR6Mfj8CISOlz9bspaPEDW3/fW9GIJHy9KudAh0F5iO9
qXkj8KdF4qfJGA0bj5Zd/pUxAsmVHjnf+Og4z2oSeJg8At4eK5KaF2kozM7/
4h07AmN7Pw58rqVhadKhjO1XRiD+g1VTuTkdgwIv/2MGjUBHa4PN20N0lCWz
HIZ8RqCuS+LrFwc6tk9VdVa6jcDJYnezG8qE3XW1JtNhBKi1nkcsg+gY3FPU
f8VyBK4dTjaUo9NRdKlC/KTxCAxLWsnOb6NjTcS3G/tZI3Df4u+TKmk6anTp
6OluHoEfqy4oKWjR8eJ41vBalREonDWLlXah41aXzrHl8iPA63ng+idTOpYE
X5GnSI4AnS66VYqw9ZJs9/CLjkBgt1/3WQKfl2b3ey7uEUihG5lpd9AwWXnQ
cWl6GC6rtM+dnqahdtsx9tLwMDystn9gIE7H15tuVHN3DUNVYGztsBkdb0vb
lAn9GYYmu/vyuvvoKA7d2Yy6YeBLy+zRWaDhvW/rGuQrh8FONZRn0ZmOvoIm
jI3vhqErW/DkWsJfeeK6/o6XwyB5ParXhNDPK+HhY7vHwyBwtvb3Nyc6lop+
V/C/Nwz6WfwZtIt0HBtIDY9LGAZd0XTVo9p0LOc6Kv08ahjcH0en7iDq/f5C
UklD6DCMuH2j7N9NR56UXr2ZgGGI9dsYFE3oPeTtMSrvOQy5vnKB6/zpKN9Z
+XSfyzBs+ZP0oi+UjjNnalhBtsOgWLXzkJs3HblFLZZyzIchO8A41ngXHcnt
K6Bj5zAM8z58K1VA9PsJTStp3WE40LrhZ1wcHS2qlcStNYah/+pYo3gKHZ9s
6/xwU3kYrBJjpi8H0vHI92STBjkif9mAnslzAt+pWLaExDBM8OtY+QAdV3d1
RzmIDENhSto11zN0dLszxnlEHoZVawpS30TRsTXule/Y9BBwzeJ+NUKfcVLQ
P4ORIUicjoj7cZ2OFevfL0voGoJq1e7e70T88q87j/X/GSK+b3LHdhP5LwgE
pxjUD4HRd/lM/UTiPXwQu5laNQRmE4+fdHynY0OlT9Jc6RBoOWhf9YmhI613
xyX7wiFo5k1VbXhJ4LN0UMGnQ+BMkrxn20NHJfu+ZqX0IXAfOdU60ExH47Uv
PWOThoA+Tn3n7E7H5+2Fr+ZjhiDfN0Nd5AId07+3cJ+6PASbpUzztl6m48u1
K1Vbzg/BI6U/DdfvE/37LJXX0ncI3vVljIe8pqOwDFdr9fEh+Jut/1arkY6X
zY/F7Dg8BGd9XRTJVXRMPCbRX249BJ6qKy4WvqPj9OI5fcO9Q+AQbjSxbjkD
11k0ulUYEPZqF69fFXSkBt3dsld7CO4UqMqdHqTjjdOc2e/qQ3AixeNVARE/
+Zx+lJPSEPg9bwixVWGgoati6bDMEJiKpm4QVWdgR29o+wX6ENiM7MkiV9Jx
OW/fZ7rQELAChNd559Px+JSs1RPSEPDG/byz4xsdMRUrDacGITvsyX6dFQx8
eCpqoXVoEKrveNCrc+koVnz8S0jnIGgm/tJzYzHwy+Kr0JV/BsGqpML/jioD
d9cdHP9QN0jMs4a8zHY6ctnYz52sGgRD1epHuV/o+FG44x8TBuH1bR29SgoD
2x05l8oLB4HpksU/pMdArdmyQp9ng1Dg3PDCZRkDq9+vf6/wcBBY7Jx5VU0G
phafuvTrziDMn57Y8KqNjkXvG77diB2Ei00aJTK9xHxKIk8YRwzCnJ+n3FI/
HZ2DTav4Qgah/a5mxgNTBqoY6ayq8CPwLjVHJVxk4J8eRbOrJwdBQCpqKUaH
0CvzmtI+50FIlPmc/2MVAzdMiV9kHBqElKSRjhVEvBdBjVktZoMQ+au4RXgt
Azcphvg/3TkINZddNIuoDJT+9APP6Q5CZfboGQ0eBoYzS37s3UTowfZ89leA
gU3OU1HyKoPw9dmSSTRRb/7088XT8oNgO2+ztvoIA0s5vXn1UoPQGcCd6GPG
QGrN2u154oNg/dRM2UeYgSZTh3bF8A3CcKxKWhERT/XYL1HvhQFQShtWbyT4
6Xu+OmU1PgD5R0/zehD16XTesE1nYADe6dbXaxH6nvLxqFzdMQCNGa2bOiIZ
GHL1Xjfl9wDUGRiFTr1j4LS+su9S7QD4xTeEXVvDQLdjnAJ2xQDYKp2pWO7E
QM4Wi4jOdwNwzyzja9FGQk/Lr2VNBQOw2VEvxp3IfzuMltfwdADk975uFkxl
IB8z5b/a9AF4ZszovU7YJSeoPDV3BuDHIc+5U1EMFMjuiKmJHYDsvsrWFk8G
7h/Iu/8tYgCCY3kP9vkw0IC2k9YYMgAM2rHm/g8MHCE3rmvxH4D4xP9Wsl4z
kOy8+kvvqQH4xPo6zTrKwKk98hUTRwdg6VOSasYZBn76UHaM124AWuKfPqQQ
9ap8PRQuuX8AWFc5NMUIBrpvfz2jYkzwTVKN+ZbHwIaWJoqh/gD0nVZvSshl
oMQlp3R7zQGwOyPytjGWgVf4L0ScVRuAwz/HKr5/ZGBjeYHgbcUBuPztyr/t
VxiY66VOfi0zAB83rjvkfo2B347sMvlDJ/is9dv8OJ6BNGV9FS7hARgQKgkS
BQZu43MPUSYPwG61kJNt1gwsjmLJWs30g+fGK7r1Jxlo9ueTeSi7H6yWF75W
v0r0Q8j50fyefggL7DtjRfTrHqlF0r+WfrD/1BZrupKJvy/NWEs29sOjdMOT
xW0E30jlraY1/dDhNOGulsnAIwJqEREf+sFow8nBaYLfiYhvEu+L++EYz0m/
D40M/KgRv4HrZT+U0wfIVQYM3Jih+Xz7k3449Pn1k8MpBN/v2V6XHvRDX/jM
yoEKBoblqRd+SuoH877tUarPCP125tlRY/uBmaY6GzjKwIAaDV27iH5Qa+F+
Xp7EQG/DmgdZIf3QoDvCdYLQ/8DchaOT/v2QPqxMC7Rn4EqFQPtdHv1Qpm2S
G5bFwKtrYr8nu/SDw+mmflWiPt+d+zPZdv1w8XvW6Eqif3Lwx5Pdlv0gRbpp
AV1Ev/hx1j406Ye9VVbupUT8rrRwEsmgH9glfv02GQxkF87yHtbuh4Nkr2+y
wwwU5CsNw/X98B/71qA20V8X9DdZrF7TDyGH1p99RejBt2ZwT6RcP3C3dc6L
JRD3zzLfjkr0g1dLjbbsEAMVdTTPOIj1A88CV9GLMQZ27yDZVfMS+Or3vat4
xMCCZSfytBf6YHqHeHJOLwP1mqVMn473QZRw6tv7yECl7S1UucE+SBnuTDYn
+qu17dz2hH99cI39lTPwioHpFYVFon/64I+ltlzSXwa2mQSbXa3vA6aRTWTI
USaSfezNeKv74ICChOYdov6qo9o3L5X1QU7U0e0iZCYm3lIY433TB4VzszvJ
1QyckPJ8fS2/D8R+v9e2k2Dirjy5d+LZffBvxfPycBMmSlgfa759rw8a7tdH
nnvCQO4mB/tVt4l4hS/ElQYZeCxXTSovpg+OLSnkP21moE6dwoDulT74KHtD
eZh4D+M+Sstrg/ugaHKFxZIsEw8Knw939u+D3bsPdm8bZ2Dw8eilqVN90E6B
X3KbmNh+XOzHDZc+kBzPFvW3ZaKlvUursn0f9G0VkBbvYKBRpuTsR8s+0A3X
ylPYwMTSVVnuLnv6YOyq/d7in0R/f7glwmvYB9K/KbWedCZ2m18tztpKnM88
udbHw8TY8c8lezf2wZJ1ud2eJgYWCZMGx5QJvodZh1vYDGRF9a9Ole+DmeoR
5fviTNyi++DZ7mVE/mTVYwUEnqLCDsdJSh+4SH4elrVmYn3XTclHAgQfWdcQ
zl0mvgyNX25D6oPS3DoFNqGf86qynSLTveD2zKFMaYKBJ8Nk/ctHeuHJvmMF
w0R/TkcfGDjX0wtvZ0nZd1uIeZ3jenlzay9sNbRdtUDgX73ZQ260sRfWQHPW
Jl2ivvGdC/lfe+EujV/y0lsmCtZ3zvtU9IK+5gyrIY2JlY+fTG8q7QXXK9lT
3RpMtD8YvHm2sBdGB04uM9nNRD2rmzfKcnphl9mZ8NECJgZEG/6LzOyFp0dM
v8BlJrYeyPQ7kNoLlCfRS/k+TJw5IbRydUIvrPeQ3/crgomphX1lY9G9wOfD
qeT1Z+LT8dVpHy/1wvnf43EfDzBxsk8l7k5QLzi2FI4NH2HilM3NAC+/Xljx
IDI9meC3/Ql/wq5TvRBTOrj1EvFeSoOkKuRdeuHyrukDoWZMrNb071mw64XV
d1l8eY5MLN+asq3ZshckozedfkLg7/imkV6ypxe6U6aP915golKj8ESaYS9A
ubT7pDsT1/d5ng3X6YWFhfrYCqJeevWrBN01CH3Mj75ibmPimpeUS/tVekFa
79CdeaLfcp7vV9VV6AXds3Z/acT3Q6ezukV5eS/cus1mKhL81S+FnJWi9wLj
k59IXA3hf/nANkHhXrgSfuy1Zy4TR1dY8M+Te6Gq64mhxwkmzvveeMWe7YEm
VkS7E8FHMOpTdM9oD6CTnUBsIBM33ljm1tbfAz9GJrgsHzDxmWPJqj8dPbCG
QdLlD2Jip4M2+VdTD0zcJVNFCf1sAys6Gut74N5BXpkoIt9ZuZIHP6sJ/5zg
mvMSxPy29gltKu8B43s5WzSI989J0zzc+rYHCiqXKrwLmahdEybV/aIHwu8v
KHaYEng+B44MP+kB14ARtVxNAu+Va2Uz6T1QfEK5cSiViVkC20/xpfQAd/2N
RLa+BA663N7AjO+BxXtlearXiX6oYowoRvWA7GjW3+h2Jm7YdTRMK7wHltYE
pqcQ952cTdbtO98D3z2Vd4ggE8NtPWqOnu4BaprSVxlzJobJx+kHnewBsdic
qqY2JtoM7KtKPNoDwzqiZyL+MDG09YjBS7seePNho3wYEe9SxrPoOsse6M60
vhZI8NnnfLuXs6cHdnBcjLKmCL3mZzUYRj2w76PWi4w8Js5m1O3V2kbgzX42
mN/CxLTX1n6Om3qAdp+sXPKZmC85565eUe0B+3vZEWUvmXiVae2Wv7oHTgSo
mHW/Z6LvR7ZFs0wPmAz+MQ5IYWJKip2SELMHYv5LTa+Wl8D1hz+Ua4v2QMDR
4yLpWUzkuidw/CRvD1T6vb5VS+DfFmA+nrbQDR6sN3oJZ5moVtK54/tEN8jX
5ZmbEO9zy6RfqvBwNxTaZIf/2CeBRw4Y/jbq7gYDUiAfLYeJmxNe/LzQ0g3v
d754a51IzBs/o98ljd3AXxrzptmKif+o1iVzX7thUNLcttiZieNtToe3VXaD
qkTp/rtfiXkvW0K+AN1wy2iVmlAfE7seNV96X9QNc2Yq5/del8D+yzYfBPO7
IfXh48j4JiZ+zTnAtT+7G765/tO+rimBy5Ndpe/e74ZPH7SO7k5i4olSzeGe
pG7witV4Ky4ogeq8/6u4yuOpfJ8o0SItUt73vdcSKluyK2UpJUXKkqUsRUq7
9iTSgoRKC7JEKaISJQqlGaUoKsV1cV3uRipfWiiS/J7fn8/nXZ6ZOWfOmal6
an6xC5JCSmSW6FPo6Ve8OTq2C25/3qV3aEAJeREfqppOdkHR1ABbRSD9E9ut
one0C4T5nsCQ+uo8frLq+P4uqIp+njRRisKZ7fpGTTu6gCNVO/X+X+I3F9rk
DAO74LDm/fMwjcZy/VuPY326wGba8o+5NhTOOBHFdK3tAuWwv7pBgRS+q/26
086pC/oVdvzdXq+Ej3bXX8i26wLBH03/tf7k/jH2QeOsu8Bdgf/50CtSn8eJ
c3eYd4HO+p8abiQ+6+ev4f28LjD/PnTx0A8lnLNj2pgFWl2gYGq6/WqTEq4P
OuJ6Xa0L7BYuNL+4hcKvR9fOk6e74Ip1dqqlO4UpyaWNIVO7ICe8b9c1wk/z
tydPd43vAgPDFzeO2lPYssn/uadUFywyc98rq0shPLCprhnshJjbBl7apF6s
c7UNVt87Yesv/YXFKyk8bzpjW9HnTnhbHlC2nuAne4v7XFfUCV+XN+eomlN4
/EGq5s3WTngwOFfuZCnBc+KL8WoNnYA5CwKcj1N4OvHT/bTaTtj4RuqMwXQK
zZ39fVlVnWAVsTBqwwXSz6JvcalPO0FwZd6uVW8oPLt6TJhySSesbPgkTiD4
B44833HtXics1O5e3X2ewg3yrrzZtzohwTpre9BBCqvefJmYn9kJaSY5TzcG
U3jQJXGB+ZVO8P1yKmxIgUKXnJciSOgEHTN/gx+rKPS/e8nR6UwnGPYUmvUm
UvjCk5PfeqITzO6ltaYzFG5T3xi/I5TE01nSrkjqM/yANfvvvk5Ynjcj899m
wg+6pDhhRyd43tKT0ttK4c8yH5gd2AmJO+J11WdSuNTu7cknPiT+WTf7Iwif
ZKZdWOjuTuo1fdfN2LsUPhnR2t7r1Ak3W+JyFlym0KdHe03c8k7otysdXZFF
4eVnfXN0bDqhSuT2qO8KhRdXrj9QPb8Tbr9r9KQPk/+11R/YZtgJBSX7bb08
KXRi4jbL63SCzKMUQZsVhXFOj2sK1TtB7XI9bzrhh9e+dL4HqxNYYyfMfUvq
5cm2FYxM64Sy8UmB9YQvncnG7rkTO8Hr51vtwX4ldKg4fdhNphMs27QfxBlS
GLtKM2p0WAK2K38ts4ykMImWSBX0S2DipqgqvgOFD+UrdDf8J4H1oimXUtdQ
OME+yFKhi7wfoOptgaSed5TKX7RLoGGD4h8nHoXjdl8WHeFKwFllFdNpRGGI
7d7vhvUSGOtaxRVq0Pg8a8HO7hry/n86Jk3jaYy3jT17o1IC57xrpKhK4r+Z
by9uKJfAb/crt852K+AXt85R5YcSmLzGI9JYrIBmr1ZM592VwJF39vpXiV4H
HzKfcDVbAkbXy78aadLYdlMcuCFDAqtDjm/sJ/H13cjapJksgT7ZbXuFKRQe
1jyzpPu8BLRVWXu0TGi8laYeWRgjgc8Gm3JL51IYefRS0JETEkiE8KQnSRRe
aX6ntSxUAgeenOe99yP87i1ymLpfAo2Wv59s/kb0J8xGnr9DAmc6E6ndaynU
MbHMzQ+UwAKuSGovn8LslJabx3wloHijOY9eQ+OH/u9WLh4SiK9f8WaaAo1e
VVoFs9dI4EZw54TrBK+hHcPH/tiT+hsygZGTiF53qXd/WCwB9+ctiS0yFDY9
VNS5ayEBj9MlXYkmFK64casq2lgClSljPohlabRPCxoK0JPA5XV+CicX0PjT
MVd6ySxSj0XFM/fI0WgVcWHzTBUJ3KIkPcUkvzGLov2klCSQflQzST2dxskX
H2qLJ0vAN6D6ed8EGqe0JDpWj5NAd/XmxanbaDTdukX63qgYrngd4bEI37eL
9WMSB8VwYtTeUO8v0RssCTz2XQzVu23mzckm/OQofdz6RQx7yxwqNMoo9E4w
mOwuFsNi61OmzaQ/S6cpZ9i2iUEy1q7wDnleJ3nz1Igjhgvf+td3+FBYvnvo
lsY7MdyYnmBW0UNhkaKiZHq1GAasN5zb40H8cXF7wXgUg1Ohq0vMSwqLj/+0
HSkVQ8C1+FcCoic90yZr9T8Qg4HjiHdDNYWjB98l9dwRw0ONwPFmBI+PZ3Nr
u26KoSX8v5kNlRTelLnpIroqhgipYAvXdRQevWqzsSNJDB9kuJSxEoWOz6uM
28+Lwaw2QHnhbgrrNRJc22PEwKVwrAzhW833gcGOE2K4WFIyp11E9G6t2iZx
qBgenOrOlN1GIXXuPtW9Xwz3pix2PUHi9zjS4dK7UwwW9Lf6igjSPyp3HX9t
FkNd1S7VdcY09vfKnR/1I/mhVM77WgqDMuQ8JnqJYUaicPC8FY1qS6NbKBcx
XI9V0JK3pVFDtTJntoMY1rbrjhtzhkYuL+en6VLyvr2VEYxQuI73+a+dpRg6
+g512+dROP2ZmpOXmRhm1e5MueNA46SACco754nBxTfD80k9hTkXLW6e0BKD
19Dpi92kv8p6z+25MlMMKwN4D28Tfsg+zC0rZAjeCUYPB3dSyHP4Wf56mhh2
Si95/ZroiePn9H+SiWJoq+V0fCf+cdlL5Zm0LMH3fuXWEPK/VbUVJuojIvh0
f0pmBcFr2b3fnxb/EoEx34UeeEHho3B1OqBPBHU3s0tDSb4h2/yGIrtFkNWp
fri8ncaDefvYeUIRWMsZPX6lTKPMjYSHb1tFUPqvoWmQprE9r3Skv0EEMzWd
5dMYGvUChqNU34rA7+iYPQ1jaNRfFnRqxSsR5F+hFKllNLb8bDI4ACLYvuPg
j7+kX/Zo5FLXS0UwrfWDhsJkGlMjK/e/eyCC99t/v/pE5oXLVoKwf3dE4Hl4
T5Ugj8Y1N3OfGWaLwPuIckTILBon8toPbMoQgenC8rxlpL/+Fag0JieLwP9H
kt8jT3L/M+dddQkisN9pN1xI+LD0hfIhmVgRlHvfk65vp5Dv169ldUoEss3u
ETXjaJytpDj1cJgIItze7SxcRiEGDWx5cFAE81bXPJ6rwGDt997A3t0i0PjU
F3f+BI2bX51I1t8qAtHzh1tcyb60y2XC/F3+Igi+rD2YMobBZesfHr23nuRv
pvfRp4DBs8qrf/S5iWB8+sHQaesZXK2iwDF1EsHkg9TntYtpvB063id0uQh8
uqpSBhczON5yhSLaiODsvp5UDaI/prqfTCZYiODO2HRnFum3ZcL3/a7GIhib
vC41P530f6tf11U9EWjb6G0ZO0Dj+lWnF3+eJYKha9z0w0RfTI5OtVigKoKn
yqVqv1op3Po9Y8NpSgR7Qqdt+vCD+PVx2a9NU0Ug3LiCdaGOQjebTzN05UQQ
O/7D7hLin3nBJjvDx4hAZ+K1lA0yBM+s5DkfhoVgtu2Ox3EWjVN7ksK0B4Qg
NpF/fSeUQvuewL8RvULInbyrZ2sE8QO1hA7uJyGAcvndgW8Uaj4N8TURCiHu
g7BsVJrgFZQy5nyrEHaljH3ruovGjff85L42CGEaf0theDfJnxmX5/BWCNJu
IYU9hN8/vrkF334lhJ5txdF1v2g8Mzbh8kQUQvhp/l/9ZIKPG3fN7jIhfP7V
lfpWh8GSfaZGH4qEMNplMGz7m0HHK3XB8/OFsPvj5655N0g/+GXaZuQIwWOw
YuuYFOKnnr8sxl4TwgZ7rrq7GY277Nrig1OE0Nzgbvb0Lo1uMXr7Wi4KIegb
jXmhJH7Xg6HL44VQuvpc2vtYGg3Z13lFUUIQGs4evbCaxiyjre80IoTg0qyz
1rKFwnlTb4guhghB+fga0yUyDA7KU84y+0i+KjKL9poyuCrOx/HwDiGskIrP
XVFA8vmdsOVLoBCmhNkWvv9CY2OBF3ejnxCm2z5I7XKkcdBZr6nJUwgqz5w8
t2XQ2C3Z/nONixDSryZJ93vQWD+QuqXGQQjDa/SeNRB+/IiaFrhsmRDuqsef
df9K4SzJ4WNgJYR7vvQrm380svr0v1rNF8Jhb2+dzCwao413iJ4YCsHUT+V0
7R4GI74xA5a6Qqg1nP7DdyoLe06Gra/QFMIN72eu3bcZtNDIW75ERQgpjqUq
N94w2FpUt6pKidTnaWWcnDuDrvPkbzhMFUJkZvTD3Jc0VmWtj6ifIAR9t3bV
OaSm1Ut0D6wbI4RFhv8dX7+fwaTqsEfCYQHk5UcLn6gy2LBUO2LXgADMbBcX
PSb+FtvW4TvYKwD3hPdzD5yj8ZxNzJnobgE4Lhmycb5KY1Ryw/wZIgEkYrF/
hTWDLSVP/tzkCSDY4JJqcjiNaeukJ5pzBPAsJH/TllYa7/5YlFb9TgA3FIK+
L4qncdPdLBufGgHoBx+5/ILwL+AwV/9bpQDOmV0LUqIZfGuyNu30EwGo8wr2
pGmwUHryBbZaiQBWNa74WVfLoIuHgvhRgQCMjOCTD4mHf3SurmueAAbVrNuO
TSX6vyHzRE+WAKbLNWXo+1L48mOtWmy6AA6UR+zyn8PC7D9fLbSTBCB9ccr0
SILHRpWRTa/OC0DB0S/X4CSDo4VLPwadEUDC5RW9t57R2POA82TCKQHsjww7
XPmAxqFjAw/vhgngye+yRausWPjY81Wf8yEBREs1jIlLYNDNfGn2QLAANlsy
tVoE/w9Wn7dc3SaAmufV/wYJ/7Zn4na7TQJwnXPp7EpdGhsO3JT85yOAW7E7
Y01W0mix3m1niocAbucaxu24xaD7pYcmds7kPs2pxg7FNP4Oj9zzfaUAtg/X
bb2sxcL/BM8fXVtK4tNatU/rPIOqFgutna0E0P4+7ErcRxpLV0QtkJovAIw3
vpOxjkbLR5JFRYYC+JCeZbiU9NdML5nwLboCmLNDalnXWxrHH91oyJ4lgHEf
U8zODNL42Cv0y3sVAYS4el9v49O4ZQlPeJoSwMd/ss6l5PzHqMthsYIAdlhO
uN8hpjE7b33poJwAHro7Xn1xn0HbK1kBD2UEUDY4XUuB6LfVZen+9j8dION4
dEO/Agv7D3w1WN/bATZUpGUc4edM86ttHGEHKNf1F8saMMh399viwemAVurM
yYA/NOro3B5oqumA7/iOHXyTQR1++4D30w544TXKfp/LYDV70jthYQcoeoTt
2WbFYI+0zt0dNzvAvK3JU0VE4+d3HgMDyR1QFlz05SHRC5ekrTOi4jrgv9aa
tGn1RB8K6s1nRHSA26xT8RFLaczPO1J5a18HdLY9m2e8lsaaFb/UrLZ0gL7g
/rljlQy+j7MIb1jXAapj9uSfDaSRSv66ZLdTB1jb6yoaEj4vVd/ZKLekAy71
to3XlmdhmZXGljzTDvA6HtadXULjy+4IbwftDhizS40tm8TgZYUc5f/YHXDb
IvHYB8n//ecI99KUDtjZvpSzwo/4dZHBwKIxHXAuJqEm0peF+/MKeJ0D7RAV
a8yyt1HGGeWe5Zc+t4NjwpHpOR3K+NFPc9CW3w7DJ7c1HcpkYeX9iuGf9e1Q
UKVmpL2ZhTrZUgO5Ve1w8dIt/+NLGHy4Jt9xQ2k7mEhfU2VUGPxTbRJI57fD
ibcPdvqWsDC8RRL88Vo7pOe8LnVfw0I6zKEx4XI7OM8+O9odQ/gymjLkHNMO
t31cmZQvLDwefnWqYlg7hOreLpZ4MXhMPiu8Kbgdcpee686ez6BnWM6tjE0k
ftafSysjGTTO+vIsyLMdRAcfO76qZ2H7UORcE0fyfVv309gzLHw0dYGblE07
jNzf5/aNQ+P8/55srjduh+3bX51qPkyjclFPzY057dC3JCbq3nbSz2IPSQir
HVQOe//zdSZnC63Paya3Q79Zo8dX0s/HH/6z0pFuB/OcXbPOknpETjddLjvA
h20Czvb5pF9HjLeZibr5cJ89tmOQ+Kez6bi9z9v4UBC/TD6N8DXbRccvp54P
+xw3XppP8Ps00m0QV8WHj05l4/1XM+iPIY77SvnwOKws1M2GwednHs/wyefD
qoD+ZEXiT0PtCyrtr/Mh9/E0G9NTLHzyqa/YLJEPd7P0w6S2stEkNs59zhk+
fPvwqOwl8YdlLfKNdDgfIs4YpZoaMWjSapIyaS8fZkJg6hgnBg1z9o+V3Uzi
Sbur6GXHxv51y1xGvPjg2FtzYPJuGueeXrt0aBUfFO4mBPP6iP77blP4vZgP
39WiTx5XZDCzRaz225QPhT7HhKJqFm7IaPswpM2HMPY3/e3RyvhPNn7DP2U+
7MyoXxutqIwHzrN0xyrwobFvf0Imme9bCrcmTZHlg7A/qCCFzJOL9qq3sAbb
oKAkeq0COUfKL1in3dMGkak9bwuOMDhfzv3wAgF5rjRn/3WKhSkpidsdGtvg
Qf1u9rZJxF/6ipP8atqguXTpWVqLjblirQ0Hn7aBcVlJeMJrBg86hg6dvd8G
0XJvHxb20Zh5wbg2N7sNqtbJvz8ax+DG6fHzX6a0wb2quZHBB1ioVx+9X3K2
DUK9V8Sfc2DhjJy9orEn2+CFk9ydYi0GJUUun3UPtUHy5qEq1xgGyzKTnzlv
bwOfKk74QAqDMT+9X4b4tUGR9bTxW/0ZdKjf5X/DtQ36PZZXmn9kob3Mvep3
y9tgn9ZGq+32DGqMjviNLGyDd/szQs+0MuikPBRtYNAG9VN/rza3ZuO5D70h
AZpt8Kh57ZnoCgazHsUnJ1NtoL5E/ch5Ml/4JJravZvYBpYJlyTrCT7a02+V
jR/lwRb7P9o1RN+/zfJev+wnDybJa78fIP64zyoi+uQnHlz4nZIeOIeNFY+X
hFTyeOD1YF/cjFQGU1TEF2TqebD/4M7Wi0EsbH25wWxlFQ/KKx6YK1SxcJy9
S/r5Uh5cP2WXrDCJxmk/X2hz83nwOQkXmlQQvVoeYamZxYOYgAOHrnxhMP9c
rMKeJB5kT3/mwjJn8KtOxYRnsTz478dtG/XnNBZ35UVPjeDBmt3yHrW7GZT2
rqrctJ8HGcUm1070sfClRpFaaRAPmgb+dfwm/gbpb0em+vDgC5P8yjqLwug5
w6nbnXkQu9fV7wzZ/zS4ee4vl/Gg7wrfMFyPjbcaR87PsuAB25zPLT5I/Oad
Y1SkPg82rt5badBE9pmzr5M61XnQ/TtYybSN6JPJ7tmOSqQ+K7W4GSLin44/
dt6X48HKFrnUdXtoXB6z4S3zrxWiD20pr+HSeMRm3+3IH62wP99nqOgngwJ/
N6tvXa3gsuBFyC82g8PQ0LWB1wolb3jKUmKCt9pJufr3rdDvf8nXaTUL673/
EyytaoUFi/fufsBj4dLMR28fl7ZCyMaxF3zPsZHvZG5keK8VVu659oFN+Lka
g5bnZbVCz50Y68+BDNIFJbtnJbdCL87aZ0WR/clthVxWXCusuaP3uoLcP35K
pIf68VYIWv56v8wog23rrhdlHWiF4Tm8PKEx0ZtjF0/M2dYKfqlFeqtfMtgU
rD1yx7cVfH9tmW9F5r0rmUFnTFxbYWjvwZ8lPAqb06acerq8Fe6VWtf8eKOM
oYfW66xc1Ao7lq5tn8hj4/B7hscxaIVqvkIq34CFOfdbhrbMagUHbBwZ/49B
Fa7Ni980iWfCb8e5xG81HT4lx09qhc+nnpdt02TQsnxeo4Z0K4w6240+2cXC
81qq5WUDLfBEdMioUY7kM08zb+2XFtC3P2g/hfSTcNOWkb72Fqj8mR4YSfY5
swvrh841tMDCkQuuYlKfYo2Fw/NqWiDEeuD8YlkGQ57/Cah/2gK9Bpv+3iD7
d1Hykd0HH7SA8bYpS+oIH+ZMfhLOvtUCs6ztA7/1MpjOjul9ntYCHXZqE2Lm
Eb+uV5XZndACVpVn4BnZRzo+erBYUS1wbMrjfFcSf0ji84TqIy0QvFUUEEjm
mefZ8rkhu1ugPCo1MNtTDU0Umyp0N7WA9p7cqY9PstBmNNKk3bMFRiPujJ1N
5p2dk2bZJ65qgXn7Kp2febPQqFPLy2lJC9TGWyqEjzDom4Avxpm3QKjzo7Xp
djQudA58+1yX3K97MnsolUKH664fT6i1gENu3PanRN9cMuONbKe3wAPNKQnX
HJVxuOqzrsyEFnhbHl12uHMmXrl0TKX6bzMoV+4UeB+ZiXN2UkHnvjfD6vXH
A3u/Mjgp+ftKj65mYM2MH7aoY/DNqz7Nmbxm2JPM6p7yjsGbvELXr++bIWJd
2viPF5WxMLyBLqtqBp2kJadl/Vn4vGpiw5myZhhryL+wmezrM2yqBN4FzZBp
zbU2ZhH+xoyNMrjZDId6p3/jl7Lw1do1bNmUZrial5iS853Cx/J8qbazzXC0
5OLdO6EsHN/KDis52Qy+svdczcn+42/t1XXhcDNUV6bVdbux8MPd69eCdzZD
x6/6Vn0h8fuDL76s9m+GP95RembXWNig0DHb0KMZ3v5s+6s9QQW9Fny8o+jY
DIWGUafYAQzmfa/F3zbNsG6eSGN0KYMLPz150W7aDEtcdvYVjVBoY+2qUKPT
DOm3nW0m6DK42FX1a5FqM4ybn/bXgui/iY7g/jXFZmj45Wqha8TGgBjWs/Pj
m+HWaSW+I5+FL0qfeh3/y4W9f8z2n3Rh0MjZu3Xfdy5YiaNtZQ6xUEqw9EZQ
FxeMJtTs0wtnobplbb8vjwvn+I/qHjkpo/8DdwOPei6M++2/vHkGjRyu1F3n
l1woSeWU+BB9TMiMvr+qnAtf1N7Te11ZqGGnlO5QyIWY03buiSNET8/eeOWQ
zYW6GcYHxAUUhsyyC12VyoWZS2T++U6jUWnzyBTn81yY/OW0ZLo0jSr7Lond
I7nwJ27OVyDzQ8eqo9a+R7gQqna2LOkRg5VXY49s2c0F8y6riqneBI/pnt/2
buLCD96MRgfifztuPvp6zIsLdmE6p7J7yXy51/XVWScu/DQbnfHtohLR/3O8
DFsuTFuZYzTNmMbvMTf235/PhfdiLz0dfQZPa47/VDWXC6byMnWUggq+kh+4
zFPnglmL4gV0I/vkD+nKn0pcyCgxcDSRYjD3WMjryfJc+FVzR5nTz0JndsAE
PSly37HL5XGpszHW9uHLFQNN0HH4zcZf2ar45Hqs79YvTXDmqfOXy5UaSH+t
1I7taIL8hu91/hQbZ4wp3JPf2AQ3/xm8i09lYWm1TcKH101QkpKnFxhMY+wm
DeHgsyZwWug83f6xMp58Mr5Ao7gJal8V1lqdVEEJVeTidLsJ0i5fK1FisbHW
8uas0ExyFnXKd1eo4uryz3tyLzfB4cXqDdVKbFwexFzgnmmCLFWtXVbEz3wb
o9rlIpqgQr1Otvj/+xAvLdv6QBPIDGcdC3GgMGUyWh3Y1gSpvENvCr+yceGg
ivRdvyaoM+dKR5mzcLnPUUuJWxNsrVN5uDRfCevuK9jPXNkEt65WNqn60Hii
gHfU17oJ2p9v8+M6qqJhhtTsdJMmyFjrs8bASQWlJsen87SbIITJmxBF9CB9
nKOlmmoTeLrsuBRE+EH/e7Z6k2ITBLZ3P/AeVsJ/L2v088Y3QeOfeyGteizs
7pQz+faXA3DNwa1Tjo051zbmLfzBgTTOOPPbNiy0MAv/HPWJAwFUTOBADwtb
OJw1H9s4MHnBAbYqmTeYBTmzND5y4HqGeJVIVQ0Xm+6t3FfNgQijBPrYbhZm
fDxxsuopB4blBotVyPyv2LajkCnigLNNbNGv1TQ+/RaTHZzLgaNFbJNBDzZa
sn+VvbrKgTcuAUMzrFWxhXvTUv0SB3RFn3Qv6ysj78mzU2ExHDi8I9Xr3SWy
//y16G4O54D+3oHMsdJkfz7kU7pgPwde9EcmGRM+LOBoO6Vs5UC61MZ9TedY
6Ht7898/vhx4GvreQF2ghIb1xUob3TgwO/Pqr8ed5P3Fvd+qVnBggZbHME9C
/FY2v0vfmgP1vfyjS6XZWJj7ZVmyCQcmlbw3ndbKwk/n3QOkdcjzDrsSmS0U
ph5cfyVYlQOLA+LL79+ksWCesylfkQPLsiO/1VEquLii+NzqCRwwHVeUMFSj
ghoP3/2DkUZIbLYpHbakcVXLqkbTn43whvHozsxgsHPweNDt7kbYFbqIShMx
uCwrarJGeyO8rtA6kt7NwnKLADqtoRE2hPSdVCgj+R2xaZvxuhHe2j6QnVJO
42lGvvjis0Y4caRIO4P4O77Q+m9qcSMYP7Tqacsh87hTQkfC7UYQc47PihWz
sKdignjatUZIkq833ETmj6wCR/ukxEaYcJN/5pgXjZ5mOgHsuEbYcWrDkape
Ms9xFsVnHSf/c3i/a+4BJTxacXG63qFGUPxTtrtypwrOnnEoY4l/IwTp9je+
nKGOsgx3+TuPRmgurv1ep81Gn4uhN/xWNcKquace5JD50zMka2LfkkYYmvvz
b7WPGlqsn2xH6TeC9Ffkh/xSwX4lfJGv0QgthkGff56kUbDIIsOOboQfG1XX
Vbxg8Nqpa9rtkxrhkL7y1kSKzI+/uspCxzSCU9nvITlbCh88PZJNDTaA8/kr
E6PeK+HHq+42Jf81QKxsh3tkLIWRXbbtHuIGGA6uC+9KYOO9XCnO7+YGyGPk
Bg9mETw6gkLT3zWA99fb+zqOkXqvUtS0rWqAbtZTtR1E/8ecY9S7yxpA4Wt+
kHAdjeVjtN5cKGwAuwSzo9dnsXHJSMFhy5wGqMoYZVv50yj0Vwv5lNYAkzZ0
Gw6+Y6P/tN8aSRca4LHtSk/2fwyuUY56a3e6ATR75idbhJF9QaTI+G1tgLIo
96i1VWq44ipnynS/BsjtV0teM8RGe05d/hu3Bvipmg+aXWR+i/m+ImplA0jN
FU/4ZMzG3m35JottGkA1I8/v0loWJmY80Tk6swHOe7ACXh1WwfNqJbcslUg8
Uq4Tv01Sxlelr0UvpBqgSy+6VHqXBjoWn8xz6/kIw6mVX2aPsjGj/H31dfFH
8LlzQy9znDb+D9MkvTE=
         "]], 
        LineBox[CompressedData["
1:eJwBQQO+/CFib1JlAgAAADMAAAACAAAANdP9ep7g0r9bqqIqngYnwD0MyJ3n
19K/SKEVUYWfGsBwfBvftM3Sv5lmw7NL3hrA5qhiaoPD0r9KAu2csI4XwMNg
ApVTudK/V2gVstaqFcBDDSm0Ja/SvyeKcYXArRzA7hHgG/mk0r/UqC1yOo4Y
wL34YyHOmtK/ygZor64cF8BUGbsZpZDSv+HP/CSxehbAojxBWX2G0r/Uf3vb
zf0bwCHNCjVXfNK/2tFwXRHYF8A/NvYBM3LSvzIzismdABrATFexFBBo0r+S
flRxXnYWwLagKMLuXdK/omjv4XsoGsD5QG9AsUnSvxwM7tQxZB3AkNoCu5Q/
0r+/PXJnDNcjwBCGXCN6NdK/vF6iVTbHG8AsZM3OYCvSv1uOAWWW9xjA2GDy
EUkh0r90HF+fCv8YwDkBM0EzF9K/VwLivExsGMDlkTGyHg3Sv6JmcePtJhvA
9dMIq/r40b8QNBHMMS0cwAbdFN3q7tG/zzzzWkZIG8AhitWj3OTRvzXNr7K0
4RfAetNjU9Da0b9WVK4kGWUYwAd2A0LF0NG/Y3QKLxrnFMCU2twstLzRvwzk
9OfkKhXAAoec062y0b+8iuXOTA4ZwBrMGQypqNG/rO2L8PhFGsDqpR8qpp7R
v/3MSoSj7RzAFhCShKSU0b9E/BOxVWkXwA6tSW+kitG/2MhUw5rsF8CXsOo9
poDRv+b/r2ZFnRPAHMSoR6l20b9vYQ4kEaYUwJG0NeCtbNG/n9pevWwgFcAU
EQ9btGLRv33QQes6OBbAq+W3D7xY0b8BtE+BpecUwIBNu1HFTtG/0FgFhroV
GsB3VnB00ETRv6oKbeSzuRTAciSpz9w60b/TBgnuocsgwOF6eHoLHdG/5gsv
B6A2HcDipGQCHhPRvyCaEAXC8BPAIgw0A0j/0L9xI1JEg6wVwHqYnidf9dC/
2JxVi/d5FsDWWvcneOvQvyXuebbgthTAYQL8XJLh0L/cT8M7bvMTwDxEnhmu
19C/8iwwR0LIFMDah5ywy83Qv9PnCPW24xjAZG0Ce+rD0L8/sbDUr3chwK3L
APUssNC/AZjmVGeGFsBrIYtQUKbQv2uMS+3KyxDAOlGu/w==
         "]]}, {
        Hue[0.1421359549995791, 0.6, 0.6], 
        Directive[
         PointSize[0.003666666666666667], 
         RGBColor[0.560181, 0.691569, 0.194885], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJwUWHc81W8UNrJl73uvkkoqClEip0Epldkgq6UyComMrESiEBkpQsneIdT3
RVZ29t57XVdKRv3e318+53O/7/ue85znPOccEtfu6d1koKOjs2Wmo/v/70+W
4YGs06yIYN03134ol2jnpH7/+p0FHRDJKHx6oopQLxQiK+mzoILBnLACqRZi
R5SvqcYwM7oa5aEmdr+beL8iR1F1YkbT7OsMIfmDxAW3/Xw+vMzonUcxU5nM
KOHBEn/3TRYTQg9OBz2/PkFcNVeqEDRgQp/uT2UPeE4T++ZqtgetbULcXNXk
18FzxN6IM29zEzchiZpF1jA1KkE+keh/6MImZHHX/eTu2EWiMv15dg/zJuRa
9f3i8BqNGG/oUrlWzIi6G1mbrpz5SWjwUZ9F2DOiwTclWa/8l4meC1PPz+5l
RIfjKoqFC38Rpmli5RcnGZBvuutoyfBvojZKvS4okQFJRFrQ3aP8IfJvmra3
WjAgJSMfyxzVVcJGhlWfWZoB+bf9Y866sEb8PXvUhGWOHslm9nbs0FsnrFh3
hnzJoUczqkfX9t3cIOxetxXzuNAjKvdTjdzbf4mB1zrh08fp0cJUXcEh43/E
gEZDrtJmenTcLn5jy2469HbLpS3DnXSI+vKi6kgCHbrN9+dizwc61HSE1kgW
o0fDC13CfA506KFs+JJfKD1iyU0wdTpBh+yXuQoGGRjQK8Eo8gY/HWL+87im
+B4Dil+Wd99b+4+Qz36Xsb+bAe2fXpa0sf1HhChYMaZqMCLNXI/LH4T/EeFC
oS9ykhjRUW/DeAL9JW4UFQr8Zt+EBh1f7Uuy+kt4eL1M7763CUlfOStwVuQv
kRhm4c7csgnt6Cx4F1W5QZwJZqQ2KTIhd+PPsp6OG4TO75o8g1AmFP7NaTNV
aoPQlTvWkL3EhG6IT97t7l4n0hQi1apOM6NHIhyX5ILWCS+m3vrkRGZ041Vm
4IT6OrG8x6WVg54FdU2FOFDX1gjTsK0yXsYs6PhHvqtH89aILzVipreTWNBA
8P21Wps1ortswr7oLwuSMb8f/nTXGsHUV7JVWIcV2d2V2Ww9ukpEX7ZlivvA
iqafyBRZx60Sl0V2JVFWWNHAE5V7XmarhGxCTGCcJhsaM6+3iRNfJU5mZwY4
RbGhnlFu82/9f4go0YK4ByNs6FDBO7Xh2D/EcIHEzzU5dpTieur10tU/hNhR
FWk/N3bkdcRTfHH7H8Lq2eDzfZXsiN00pbdlcoUwQ7K9sps50McQKYVX6SuE
XlR+hocBB5Jy/F0te3+F0PHX7Ot8y4F+ysf7v1ZeIVb2Hvk6OM6BZoKs4n7Q
rRCX3RQrn+zmRHFFIrebq38TiVVMPRounCicJfZ9SMhvYtnkxHJPESdS1zu0
hevKb+LM9+8Dpn85Udmd1bFjO34Tjn+9LhxV3Yzy3A8e2kX9RRjt61UN8t2M
NHtWHpcU/yKu9QW+0KzcjDZfjb++6veLWHpc6HGThQv9+Voc3Wfwi4jS1GfP
PsGFKPaTrNe2/SKeVb9jY/HmQq/Vf/U9pi4TqcfznriXcqHvrz4fA2KZWGLa
oGdm5EZNbMXPg18sE1q7M8ddT3Cj7u12qg6my0RKkXHFmDc3Wm0snBiXXSbO
Ht88fu4rtg1unBr795M45i13ffgvN0o6PbDPuvknwatWfTlDjAfV0Y8HP0z4
SRhJKsuJH+RBzCraDiyOP4mIPopRkAEPutk4vi54+idxj6UybesDHtSvd/lm
HBl//2HEpPEZDxJ8tetfInWJiBDgSbRM40GuAl/ktlcsEQzzVHP+Gh70ZVHB
VOj1EhHoanAjYIIHzYoQWq73loghPb090Sy8SPlAgLeOxhLhs2uQVZ7Mi1ws
vxWGkpaIja8p9kdUeVGotm7+cRqNGBmRT4rW50WUKIrBlRoaMXHz39uAu7wo
tsbGtecdjfhmYcEp/4wXBWip7Ch9SCPUE42pM294kaF7pCG7Lo1gFPQMZ/zC
iwKPkvd9kqYRMpVV4ZZdvOiYv8F3goFGsJ26IiS4wIuYUsFkV+8ioZUbpHmP
hQ8FDNbunPu0SMxoS/cOSfOhvhpje87gRSKkMLNeWY0P3fW9GOFjuUjwxxLz
ty/xoVZKxoq+xiKh7a+7cNSaDxFz7pucty4SSVFjcgF+fOhDrA+ZtkYlzA/z
V+2L5UNXWu7SvnRQCZ9Jj9B3n/lQydMd6925VGLC5KCpVgsfui4R1HQqmEoE
NMiV+Y5ifxbHuBlt8O8SrvV/6PmRVZ7FdY4zVGJql+G3t7z8SNKB4ZGZFJVQ
KDt87IscP/pUyC/8dxOVyE/88DNKnR9BksxkbcUC4R/cyc1hwY9uan4v2eO9
QHw7dmEntws/en56XFsUFohF1ZGDM4H8KMN0m8HL9Xmi+ET/xrV3/Cjsucmz
sKJ54gTto+CBAn50+93RUorzPFGXlnDdopwfzSs2tO45NE/YC6edlRjlR+2H
fqeX/J4jnvh0HzX6xY8O+iscbyiYI/ZtUCrkuAXQ+ui8penDOWKSalU+sUMA
Hdl10NdKeY4gi8jALyUBtGZn4LO0OktofzJ3ljkvgCzvivv/LJklhKz9Q3WM
BdA5P6lya49ZoiNz24sbdgKItGZpZXR8lvCyMiv+80IAza9tfCtmmiUeGT10
DvsogHbklZODamaIummP96HZAkiJZ3vNj+czRMHgfEVjlQCakK2QfqI3Q9Tk
1PFy9QmgT0anPr4XniEChaL926kCyN+WMXdf3zTRMksXH/tPAN2Iqq3cnjBN
zNCZzDrxCaLRIxk3vO9MEzeu5Sw/FBFESaRioVP7pwnued7Qr4cE0d+b3+/a
/Z4iKAPVqgpnBZFwrwYzHTFFnNgkPLliKIiOoKVHi75ThNaNpIqm+4KIus3F
SF17inC/UTCT5SWInLiCQ34LTxFPss/NmMUIItZck09sQ5PE1ODC8efvBdEy
415v55RJAihmuU7Jgkh7JqtIw2GSOMDTEKZZLYgW2UalbNQmCUtGMb4jQ4Jo
dbA1cp51khjax/f57bggqrzoPVzdMkGIekq+ffxHEPX65w6sxkwQMS7XdmoI
CCHesWbbx5YThLOZ1WnqfiH07PY316tKE0T22wi6FyCEqKS6mVCGCcLHYj5y
y1kh9C7marZo4zgh/IHa12oohIRq+csWo8eJI/PxXVschZD19VsipDvjxN40
0a4Hj4TQcklBbpjSONHwIqSR2V8Ide85/tBk0zhRNPX9UclLIcQ4/TLD4ccY
wegxf/LEayF0aHfDia53Y4TY/cyCd9lCiPmX9+ln98aIUM7e5U+1+P0NvzZf
tTGi513AekW1EGLwG6Jv2DxG9D/bnzMxKYQMtyXNmvaNEhWSCvtYFoVQHpla
cCh9lDil+2eX7oYQMkvJ9jd6NEr0utav/hEVRo5l2QHl50aJI+d41XZICKMX
H6xm7MVHCc7Lqes7dgijV2xrXbcWRohDHadVfFSE0aEx5sA4NEL4scl32V4S
Rtfb0pS3vBwhkr44Bm+7IIxShW3EB6+PEMolacOBt4WRn4Cw84jiCHFC/3V8
3WNhlOiQH7CLdYSgPj9d2fdEGH0s8YzO6B4mnFU03axChFGVZTnVIX2Y2HHk
s2l8sjA6+fJHu4vnMMFpfHqVLksYGVB/RxP6w4Ryx645vWJhFOt4LeS41DDh
q/fSLLhKGKWdEuJgXBsiblx8a26F7TMSfWZ0jUPE8viC9ew8fk/u4JRywhCR
wL3XPxnbL/TPMmY6DRGPDrIFPJ4QRhEZfZxmZ4cIttSmJPvfwihlJmj/aYkh
4mzeP/fLoiLIsLoCbH4NEm3HDrxmlxRBfYer73yvHSTSP4sMTe0QQaChKGwe
N0jQyZSphxwTQSFV9LkyToOE2o/TKVRtEaSlbJMif26Q2Ea1KE66IoJqcpat
70oOEh8zr9kMWomgyaeRnWhpgBiN4A9pviOCXORDD/HEDRDK24e9xh+JoHPf
KsZqzg8QB3pSDQIeiCADXrWm2fV+ghTqWeTxUASVa4nMOqX2E4T4N0pDjAgi
HlrKWRr1E/5+dB+JLBH06ub+N2Vs+PfEG2e8v4qgCLFDez0/9xGWK1rksgoR
9KuKayzuTh+BNsIK1EpFkKD0fP1OsT7ijONS9MlvIqjNKGVxc20vIeFx9MzK
iAh6J/HO9KJbL2G/MFdfsoD9j07Y+U+mlxhK/dBzcF0E8ZoumLIM9hAcVUzv
HRlFUelP/q13X/YQz9Tuq/ALiKK07xNP5DV6iJCN34nXxUTRlntOmfor3cTh
S4Mik9tE0aPDv742pXYTm22uUiekRZHk+cyuJLNugvJ1drppvyjaOvdLqoe/
m7CX0pQ4ckQUae8ht1lUdxFfSMUqieqiyJZqxK31qIuIVHu7Un5CFK2cbWDx
k+8iztEV+fmcE0VXxK/TRCc7iZQJvcBcbCfR1TIxxnQShGkll8NFUWQWcM/1
mEEnYRcyxRBuK4o8O24GtbJ3Es1b+yp5XUQR984YyeLSDkJP/Drdqaei6EW9
rsLyww7in8KXtBpsR69KfPDa30GY5WiafY4QRUWeRoTZZDvBdqempTtdFFUY
FX5/8a6dMJ80r5fNF0XSpaZ8XIbthHfPh/MixaKozq1upJe3nZg5r+PNg38X
ftD8YvV7G8ElYqY5XiqK3jj53LTwaSPsbZP62upEUdNB5ZItam1E8pPJcrlZ
UeT8xHFqx0orcYeh5iUrts0KZzUe5rQSwsnB2+V+iSKqtvVeIZtW4tf7OD2O
36LoYUXvn79S2Hb7bPn0nyj6FKSwWX6khTC3iLtSRS+Gnly0qsqIaSFidqjp
8HKJIYcLrgEORi0EZfwsGz2PGOKcPf/VW6iFCNPmIp0UFUOFRl8qO3/8IPYk
7Jjbf1AMSad6bXYM+kF00/iLJGXEkFS5/Ibh2R9EY7midIyyGKp+p8Lgw/aD
8Fg9fHXLLjHERLQ8W6psJpqCXw06K4qh/LjfzEk+zUR4c7x13FExtOnp1cl3
x5uJffukewfPiqEr6t7xfXTNRPorlWSx82Jo45BLignRRMyWFxXOaIkhw4d8
Tlvdm4jkN9Zth6+KIVXWfM8dR5oIe4nJgzU2YujYi3bvzpVGItRZ5lK2pRi6
O/b6zqRTIzG6zuHEFCyGht5yZjn/biDulG6d3hYjhly7gvQDnBqIYbJOS7qX
GHq15bkBeaWeuPR5UvzBe/z+jZv5e5zrie7CK2f3JoihzsTB/oLVOuJOf9Gt
G/i+4px2kVK3OkKpReeKXoEYYimQatT4V0sI/7EXeFcshiZUEng0vGsJ1iWu
YZ1SMTRf1Dn/hamWEHS5ayX1RQyx/+J0z/T/TlCMlOmimsTQb699bSJc3wkt
jhT5oA4xtObdtPnPyxpiKtlG8BW+v/61kLq2SA3B5OHJNFMnhl4yfwoXi6km
tqmqxVeviKGemaGdRturCavfvyra58VQWMtZkc2pVYSKq6HvdTYSmtMVDJGX
ryIymvVV/v9+V3fp55rPlcS7KwE99FNiyPGL0pfmY5UEaR8hKTcphur006tP
f68gdik/5eTlIqHxc6kccvoVBKNjlmUGVQx571st8O39Rkzd0S2WYCShZWoM
/RmLb8TCsvAavyAJna5qFnehlhOSpoH/PHhJiInv1ykh13LiYaB40Ao/CXXa
vCygMJcTm2rlLTdvJyHzGc2UoJAyIjm0iyjjIyGVO42mVpQyQnk/ywlbbGfz
TApmJZcSI+/NJL8cJiHln4Z8JkqlxJEgpehoaRISa5yKtCtHRKwY9XiPAgm5
jelRZ3UQcSP/sa6dIgkFsnqWvflCEBemTHn81Uho81F/693dXwmiQNnIxJyE
CranOXn9/kII+O43D75IQvrT/p7vBL8QcmLOGmqHSIhTyUbK90AJsV0j/f0h
GxLy1TzCI2dQTBBcNzZvwbbT3ZeVMQ5FxFjJPb+310ioaBNZtunVZ0LIbRMR
fIeE2hkfdJYVFBLpj3ZKuXuS0Al+V6cH3QVEYu8OAS0HErJ3sULjG/nE3l0t
XIfuk1DEsw4rwW35hH7d34iP+Pd55ShFulOfiE9ftvM4eJBQ+kJV7wfrPCJ/
QHxLuC0J+XmkSzKF5hJRm+l/+7mQ0JB+cSO5KIcIzjw0y/aChCoqPJJnhrKJ
g/cS7vx0JaHcuGg3W/ZsQugBd+G2MBKy6CwQTlHIIqLuxValBuF8fPoVKVuc
QTgfn1Qvwee1gGHAhiedIDs8PPwwgoSuJL3J4r6VSuwz4g3YhW1bi5AyXiKZ
iHvnYsCXR0IfOYwa7USSCNZbBuTdpSQUE8YRIXM/kSh0+f4gIJWEbBjVB443
vidkS/29ugpIqFZD5H7m3gSiaMeUid0XzKcbDJJ2AXHEUX8ZGbs6HM9arD9H
RyxxPOxKbwG+L4B+2632qDfE5/idXhFdJFRiuTlWzSyK8DGVCA/MJyFrtp3r
IBVOpNy/OcBfREJ72XX02xdfEiqa53NfDpOQ7tYB5rVHQQS57PGWgX4SCnsf
Mn2N4k8ETeTs5hgjIY67pUq9pd6EjdTcQsg/EhLNcar60v6QgMX6fyLTJCTR
ob8UcOs2MRGePHdokoTO9shNZ+KNRSXo5p2OPhJ6oHuSGU3eAavUwoOWCyTE
+q7kTLqzM2Tb0w2yr5IQ0Sr66/WqN4xf6K14skRCySeIQB8Ff+Daq7Vqz05G
R7a8pb6+FQRSg7Eaivj7l38qau1rX4IuY62N/yIJfRLgW/o0+AoeU918jzGS
kfXTPxGvlyKBQUlrq/pmMhII7LiyfdMbMNrCXnVehIzG333quMgXC/cv8usI
YHvWQb5BjDsOjnNUBR9kJaOUEC3R4dB40C+0uia8i4xkY1w3PxZ+DyR2z5By
Chndq9l661/UB0g6zXpQfjcZ2U6n918mfQRHDhYhynUyWjuRvyskOgn2VbTr
0p0mo1vkP8vJYilwpNB+JA/ISGi3zdL7yFSIcb96eOIkGbm1aX1/LJgOOuS3
qdIqZKT8rXxUKyQDlNEFcSUdMpqsPp+2xpQFVW4S5jc1yGibbnVFRVkWBMhs
3at8nIyCVKU4mTyyQc211Oq4OhlxR9FpFR3OgQ/n15VP4fPJU7vPji/ngHkc
V/R1RTJCquUd/lm5UH/5TfQjTTJq3Sef98EyD4TttRaizpLR5qH9iYe3f4IM
5eyzZ1UxPg31tqf7PoFTXApnpC0Z3U20a/vxKh/kvicI5OqS0ei/kdCOcwXQ
dLLwURe+r5ldx/IyUyFMKE7rxp0nI5L0acGLJYUAnVECqjZkVOvcqN1s/xle
2RY47btJRmn6Bi3fdxVB1mLNaoIxGbFnfb10or8Irn7Inztgje97ci9UJbQY
6AOU/COcyOiC4EmVvFMlgIQ8fxUZktG/7e8ZMtZKQMjc+/hHEzLaus8+Wjrz
CxwqXDuwRY+MtntJ5ktd+wrTcsrrTz2x/2eL6JMFCEgd1fX57U1GbMm1ezIq
CdhztCIjzZ6MVCqOUUmqCPz41v1iwsjohr7BzYQwBLv6NvP6ppLRrl1NNXOz
CE5pX52N+UBG9BKf7dbUS2EhltMgGX9vs88iq+5NKdzsJ7vVFJORkvzjzqs/
S0Emh+fTrndkdLuaT7VYqwwUrwTR0iLJiCxuu7crvgwg5edXjxQyEs7VWS3+
UwaUacJdLpSMHpAql6/rlEMdW2EV4O+vF8Hd5sRyOOliE/Mojow2OQXmbNoo
B90/Jw5fwb/HWfXy/NX7BjYHVUr2hJPRnqCy9i9J34BEnp2PyicjNUMlXfW/
32Cb3+7L2vFk9Mb8VV2IfgXIfCw1yssgI/2f78MSkyrg8LeTe17mkNHLzNCf
3hsV4KRWntmXRUbqrGtKUnqVMKgX8aqwAPOvc/BDaGIlTDdXlJgk4vtHCp9V
r1bC6bFXTufTyeigvoVs5fkqKOgOfdeK32dUOtIVGF8F4n+ZLRcRGT1bZGwh
/6qCqODFS67fcT4+/bzmeLoarj4YOK2Afzcc+9oY9aYavm6Ue5c34Ph8npr5
LVSDCVnG9kgFGd1/tXAJjtdAogoTeRXj98iZ429pWA3whclln2whoyqtu+Hc
EzVAfQ5sm2rIKFZp581dyt/hsibztg58n0bF13TOgO9Q8UQmSaKJjC7JHc8t
6f0OkZbGETk4vi1phwsPydbCqNdRDr1xMqpLyP3r6VELLLo3q/LnMH6bVKpf
NdXCU4qshw1+j+I4fMFJog7Y60op7Y1k5Bx2dHKHfR3cjx37kfSNjGg77Im4
sjrw83z6s2qUjILPkkgzfPWQsYK23B8mI96824cZrtfDlm6SOOKnoH0lPMYT
OfVQnu8I61NkdCzW4OtrhgZwvbdLNhq/d/YVfSxZrwH+apK2RPWR0fMlOxWb
uAZwWzr3cKObjFgvhkc9pzbATvt7nwd/k5FjltF1N2iEJq6vNWVjWF9KtWIO
v2iEzANV6ZfWMf/OMPpW9zbCm7kdj4LmyUirun13qGATNC3GROiyUJDEIabt
KapNwNE9nHyUj4LK9xVoJV9vgr6tzKR1bBcXDX0NftYEdY9FLh6ikdGSosZr
8+wmqF3KZuXA+O1qtFkV6WyCHvfKhlN/MR4MeWuf/zaBy+dnvKZLmD+iR4pO
7GgGEZejkTcxHubv1nTztZrhtTTbkce8FJQ4ntnPa98M5F1VNX3sFBRqP+l6
MbIZ6k68Ghqio6BoZwYNn6/NELmJu+r8GhmFX9h9IXq0GVKcB8qiuCno28qV
qmj2H/BedDu7GbZ9zK/nP9n/A/y2KifKUCgom7lP1fDiD8CLOPkSGwUV6io9
EHL7AfIZg6+1VsnImDHD+UvcD7Abb5LdLU5BkGhw43zVD7D9VDWUy0RBlFVO
7ZrZH5Ak1zibIEdB3aaB+rJ8LfCGVTrYWYCCzqpdCXh0sAVyHJsE6/ZSULtD
G3eBcQs86a7kUNxDQW2Fu1e7vVqAPGJwo49EQX10ZtenElug98f+Mz1iFNQy
eebGcG0L8IuPMTFIU9Co4BvBSmoLVMw/yhTA/l6MagsKE2wFs2cD+y/i+07p
6cycO9wKTWmn9iIcr9Z5laM001YwHZx/3IX9+bvrTaLX41a43UC/YYfxfWSp
rbT+sRUeNNjzrHBR0MAoK8u1ulao8nWM4RGmoFc8Bvtzqa3QbvV1MAfj9eNW
WM2CQBtMPxIndDB/JhHTtLByG9TW6O74skJG6R9LkvaYtIHgIZ5nm7F//Z8S
yXu82qDrxt7ilAMUFDz9zFjoQxvwZV9OYFGmoI907B5z1W3wj7uUmoNts28x
r7Nm2+CB5+HHvxUoaOJWTIUZTzsMIdGwFUYK4ug4JLSm0A764y1zAudxPGzO
8d6X2sFWna6Qy4SCDl7S8Pzl0g4uD/MVAvF7Dt/MKi7GtIPCO9YIi53Y/4sW
fgml7cB+OkFiGeMheK2lp3e0HWx6DYRVZCmIu2Ojg4G1A9KyftucP0dB8iGi
IYJ7OsAMpUeP78f5TDhIFjzfAblfI8piDlKQY8LJF/R2HRDEu/fmbuzv/l98
692hHeCbEK2hp0dB+SKnXOLyO8CJzfxXozkFeU5bUS50dUBnVx572xEK4vo1
+Wd5rQMehlfn6XzA+S/ctN1HvBOudzY9dNagoITp0cx/RzvBaDcxrKpGQY3l
L7JvX+8EjcigMTbMh6MnJlSJJ52gMBjMNaVCQdr3c28yJnVCkrjtlm36FCSS
EQmK3zvhycDXe4on8XtD5H6D2U6wODNHZ4352NeYaHCNqwuexO7vnpOhoNcX
3fNN9ncBv0neDmMDCp7H/1if0usCzb2noswvU9Dnleh+cYcuqNNLk27ZSkHb
h9IcRl91gfnio0yfbRQUxLZ2LLKgC+DqjXuj+H5a8EHDw11dcGB+nRfh9/Nk
ftV9X+0CViPbkuem2H+r9MzT5G64XU7cYLiDvx/P5y840g2GBhKHPM5Q0O1A
bQ5+s264+uWMVAw+f7g5IsnEsxuyjjeIvLWnIF5q6EZ4XDc8SXr4zN6QgnZK
7iUTZd2Q3lmr99GMgmT79wq1j3QDBzH7QOIKBaWznNro2dQDi3IRa7PXKShX
jmekaUcPKLU8zezE3/P+YOjKO9kDF24i1nhjClpwdqf63eoB2Qv1d1fuU9Aw
Z/XhM097QH8w8kLZDQqy+c1Ws5bUA9M68Qou+PzKDYO0NzU98OqlvwtjAAWp
P3i7vHe6B1jnXC9y2OF6tCv9lMbeC2Yp87vPYH4l/vPeIO3pBXP/2Lw8Fwqy
vBzQ56LVC68b5qR5rDFfHlpa1Fj1ghJDeG6VDwW5G0QksQT2gqbX2uly/P4/
dts8xbReSFCfCa/2xt8LHX6tX9cLq6Xazs6eWJ/dt1lene2FSAaK40VnCnrG
pnbAjLMPuEdYnyxjPLSt/FnP7e0D5hnu/iwHrC+OU792n+2DYs5Y04sYH8Fz
e7j/WPWBxnXZn0L4fEzApqsFAX3gq3Z5s8oDCkKu/Os3U/sg3/Dk6blXFHT5
6MDCpto+qH+U+jMNx/+MsVMrbLoPDiZPyq/eo6B1yUtbBNj7QdXxweY4dwp6
czXW2Ue6H0TDgs6KhlAQI3vfnTHNfijc2bxpDufXbPvOf0q3+2FuzTSP+xkF
rb1x0XT2w+d79TqnvSjIyPabQVpiP0jfshL5P99jbR3yTRX94CIsMmx3i4JU
Le8vjo72w8vq5xwuZymIx/Bo7DTjAHCJfmK+9IiCUn1/nBnaNgDWnsvPTPD9
mz4nMdQcGwD2PwFtDy0o6CHa2xZnPgCBEn+d7+L8Ud7lNll5DID6vR37fHC8
Xz49YpSKGYDyE00fPlylIPOhfNeWkgGQVT7/+3wUBQWkOZ6y6xkA1dWf3T3+
FCRghxzoVgdAxp2DtfUarmei9OlRzkH49Vgmdh/2vz++/pUzaRC+/TF9T2RR
UMfnW7dTdw/CO3ljj1NPKGiex5KlXXkQ7ipeeUnF/Jhbfe/8R3MQXvnfDSoL
paBwyYEKwcuDkHwp+5JuBgV1xrXRdt8ahJcbSndDYyioiU2VRdlxEL5v+Cmf
iKSgDPcStqNPBqHb1ubYV5zfG99+0x0NG4SzLiXK7HFY/3SfLB1KGASTzNvH
8/woiNVsaWJ3ziAU1K1tuYL5+GW9clSwdBCSSOx9zjjfW7e4Uf80DkL+sy5G
J+z/aPYT3o7+QRC/GD9rhe97M8TgkD6H/fck++RnU1BlR+cPt/VB2PVX2ED/
Jf7da6eRBscQeLkapFlivPTPqvCwiA2BX1CeS/VtrL/zJmulu4bg6e8dB+5j
fog41Uk4HhyCNUEm/fxSCjI0K/GXPDkEkRuWV0lhFOQcaaT83WAIcnPtyK9x
Pk69qVWyvD4EgpG9PmZvKeiW256njPZDcFfZlLwzmYLiF58rhHsOQeGNGnc2
V8x/q79q24KGQPl7ouJbjJcqxTPr49shKL+3TvaLpaBeHq4XO9OGILb0RU9E
JgVVyUX3xRQNwVmlgN/5vhTkZ8L3gadmCEY5c9kZPuH82l2cdu0Ygjsp9feC
PuJ578rx3MGxITgw4ZS26yEFfd2WzAQ/h+Bt/eWXc19x/tcvTIQzDMM175Ca
Ivxe80VO00meYTB99nyn82MKWh71u6ewZRiEXnKdDU/BeprlJvFQZhiSeE5X
mtRivd8e4ZyvMgxTt0I+/8iloA8kt0fzp4fBLTxltwqON3qhWn7r5WF4Tl04
yv6OgqQe88dqWQzDTaL5lgnOj47udJWtwzCUyqxcLS/DeuPcmhPkPQzPLJ7I
7MF4rDTo3kwKHgYfqFe3w/nIHuweLYoZhmSl6YuuON+8HENKVWnDMG/l8u0x
fo/Hu8G8vmgYxg78+tcRREFHTJlv11cPA9fVTY/XXlPQnuRR3ar2YYgjGTY9
w3ihO18li0eHoXp78C6ZQszPrKHhJNowvPjj9dYa378j4VVYMN0I9Eq/mDIr
wvruL6ZmzzUCFWm6D35/piC5ruTRc+QR+PORfCkiiYIOHHV8Lrl7BKqG/4ZZ
YX1Uz0k9snRwBNKovm1KGH//+/dWSzRG4FW/YLcVfu/c9sFqT/0RKB3v8VHP
w+/XCWaoXR2BmFa+eI8qPF+MS2T+ujsCXcdVP75NoCAlK+7mJLcRUIhS2PYW
8zeod1jkwrMRPN8NCPrGU1CkzuuAtYgRkIpNv7iB9eOlm4zsmw8jEMH6W+Qg
/r2IeM50MHcEjrpr5sZ/wfmTTRSqQyPg8b25fjyVgn6/vmJxpWEEDtRGM3tg
vvcnBP4Z7RmBjjyWniPpFJRUxNt2e2oE9jQqEB2YD5L7v2yM/8L4fI0NJudQ
kK7alYdmm0ZB7ePI2JtyCkrhyzn9g3cU1h2IN+nLFHS808sRtmD7n7vzOJ04
6ij1Yfy4dxQEN5i65/H7bfz3llkPj0JpwP22xx4YT9kFnZunsH2+R2gD428Q
ni5WYjAKAlo3jvan4fmH7tylzddGoWytxammHr9nZMlheG8UxF9ZSd/+jvWh
5Y1KrNso2N7yupPUg/V94sHsgP8oJKxHnniFKGjoltc2UsQotA7X537E/FB4
rDGs834UNFnfWJ6pwHoUXK3rlT0KHVcUX7m1UVCprrV82tdR0BAwDPTB+Uvt
U05prh2Fu0aRxh+acb0djvuy2DkK5a7825faMR9XOe04x0eBiY7fxxR/b6gx
XC2xNAo59lvLxDGeB4Y9a+ToxmAt9HXJ6XAKyjxywkl18xiE2WyOfInzZ+/g
3n5MbAzeoJDJVnz+2hXvmWNSYxCaYKK2jO+XexpVpHpgDBpE3RrkGMXRgCGb
pvyxMTg+iSQqOnG90fNFbjs/BnRKGfe2t+B8Pp3P2HxlDCx2eYk3NuB67m8N
Xro1BhJTsWcuYHz3di0fa3UYA7aIQ/WR1VgP1R9VZnqNQcqVgFF3rD+HxkK2
+b4Yg4icBPsWrKcPfS4YXYoeA3JYSt53rHc+y6N2kkljoJAoW7UD8zlL/LLN
dN4YxK8FPyjA9cRIX6aTVjoGvpGPlW42Yhvt33qnYQxqje4YGXdRkFNy+sDW
njGwk7tjk/YCz+NHjoS2TIyBKFflifJEClpSGFDz+jkGt9PGT1aO4/efvhiX
ph8H533fyd4Yf6dHx17Ubx6HT5KGBo2YD60fppStxcbBtWadbz/2v2Pm/hyT
1DhQxdoN/xZg/xbqA18rjMPyo5QHopjvQ0a1rruPjkPOscb0r1jf/uU4q306
Ow4e/KMMG5ivVCb9yyqG48Anf1fGsAbzr5U4V3JzHBbVnl+WHsPzgU193CH7
cSATI4V/MP+8vsSIZLmPw/AZ5XdX5/E8pvLJcVvAOCQbXLi8vwOfv+umFhwx
Dmn3c0fu4/res0VteSVhHPx871gd+IPz0bNKNskah5d1XI3MVDxvpl5QKSkZ
B08Rx/kaXF8bHaPNQjXjsK2nzSEF8+G5zHsL67ZxMD1IBwuVFHTVHLl8GRqH
qMve4lnYHwuf52Fs8+OwX3a3SwLmx947jQd0V8fBaC7tQuII5jtVbjiUeQI4
B+UftmG+yGbzUH7wTcAD+pb6BMyPkqG71hxbJuBfptZ72z4KsntxVOfongmI
sjOs3o7ff1w1oG17cALK5+hSVHG93Svsmo4+MQF/yL6CCt1Yb1v7k8q0J+C3
V5zIGKc4OsotxDZ2ZQICw0b7DZYo6FfVk1CG2xNwKpC0MFOH52GzhUqSwwRw
SYfcf4j9fZWesWe/5wQYpEbKf8L5D96x9ejRwAkQPe6ILuD3p2N/BmpFTsDr
Vq+Vg5jfuprbg/XeT0Cu0TnJ23j/OeKT98MgawIYeQOKxH7g+u1U/qFXMgET
Z6xTH07ieqrYLHK2egI8HRJdCrH/H6uvShxrnYBtCtr01j9x/bGPOMkNToDm
+8KRVqwPYvHmkZTZCRjPcj6yjvXLbK6bk2kFx2vRq396ENfPYUJ3knESxiSf
3z85hee/NPPFSu5JoFrKhRcOUBDz9dpbcaRJGKRxivycwP2/8z04SU2Cskyr
0acZvC9GRf7UVJgElwgdj0wWcXSYKYZXCCbhqYa2tjmu951ZdHwDZybB0Ja7
9ekqjs+ezSvh4iRUrBuPkTB//Nzed12/Ngm+Uxp3UwXFUWuO1cctdydB2jZV
qWGDguhcZm90OE+C8ZhN/zTme5UBb8yzJ5Nw7IGz5hnMtw+2bPXKIZMQ5WnM
OYb9i3rM7T76ZhIuxqzsNMB83iO8vDsgaRLmc0J/jmF/viarm8vkTUJe5ESh
FLM4+pljH1FLTIKgu09+Ps7fE25Dk5u1k9C/puZvj/Ht/cS9Z619EjTpFOeH
eimo3Il4Hjg8CUl/io+8x/VUZbj9r+j8JNyFcOtLWB9OFn1iS/iD/Ttc7v29
FdencuuuXUxT0KQonMo3TUG7jDWmknimoJGR11YK89d6mqt8B3kKKG2sDWTM
r7kd6uoxUlOwdP8X4+9+vC8GBo/yKUzBGP18aw2OL7rAQP6x2hSU9d/KS8H8
O3x9+P3C6SlotfLl48d6mCc28f3ShSk4H5tdOYrnJ9K1K6QS8ylgnDGoOYDP
y+gp7yBbT0Gx8wJVdZM4kvq61eyh0xQoWZcMvPmN/Zm8dLnJewq8+ZavP8V2
t/NOv+0vpqD+YcvyBuavhqu4q0PUFNhJy27ahOOxpu5LQe+nQEC+e6pzgYJc
Y0L7WLOm4ID8oR0Be8TRtGlT/9niKfgsEoea+cVRZJ6+5PPKKXh7/ZKIJpc4
creyUqlpngL5fbuvhQ1R0Olk2Tf0fVPA8HkXiwvOb12KYrvi5BRoe9se9OMR
R0mfj5laLOHv+XIFuraKo0BJxYqXf6dAp/R5uTrOD2O7q0cx2zRcEHss74v5
e7bpmPigwDT8uBVQl4Lj/bwtRpB+6zRw8J+mvf2H/d3C/JuyZxo+Jfp9P4nr
zcJJVemg0jT0aipIOOD4Muz+3Th7bBrcHH6tfp/D+2Lvl18mZ6dha097jxS2
VcLdH1ldmoaT264ZRmB+bmE2sX5wbRpE+q/p5GF/ySeTLrjaTIPv5ckQV+zv
v8ZdaY8eTkNWyAMJAuOx7+0DBrfH02B78W7kS5wfhrxNtY4vpmHT7KDFNVzv
gyF5kTZR0xB3USw4Fudj7Vhyn/n7aVjLsGjJIeH6smKV0cmcBlKSrWz8Cta/
sPcrKkXT8Is39dFNXM8MitMtkhU4nrMFRZcXKaiswmg/a9M0vFcavZSM9e2m
QnLcZPc0SFHznvUKiaOrZsxRFWPTMLaYETuI+1OovlVKDHUahn2TPhbOYv2o
LzzpsDYNgYY5A6+xvnK8kWE4yTwD6Wzk5psYf8k6o3MCvDOQGnyVehP7P/v6
W0k/aQZsvS7KhmF8zNvT0IedM6D5b83gPO5ntB+9c7flZuDS3iP+B7H/l0JO
5e1SnYG6ellnWzFxtLFzLWn05Azs6227lcyA83/wjcpb3RkIfXI7qxbjtU/9
Eb2e8Qx8LI6+dRHXexXD8h3GWzNQItZ1IGmUgnLYX7Nn282A08zHT4643zCH
PtC74jYDQzubM0SGKYhv+WoHvd8MxKizzJSuYT2+SGL9EDIDU7e1H4kpiaPz
7oSL+psZMBzoXk0jiyO/uS9vBxNnYI6txv4Azn+QrxOLc/YM2Gc0P7HH74UG
c+/kKpmB2n4zc6fN4igoXzo4tnIGgp9/tGTB8cjavc2VaZ6BE5KfJ+5i/asY
0pEq7JkBvhHJO0+xfZ3cdBnGZ+BWVrZ+MM6f2q0TA2XUGfDv39+iySuOmrtn
pE6szYBAqsX1NglxdCpE4TvBNAuXFFnFf7GKo2xuXgVlnlmwqu1Op1vH8+rS
vtUMsVnIVq54Jo/5/jFcNVBixywocMvt3sB6XFQj6RW8bxYCFzOSXLB+mWzV
1FhXnsX76p1yO6yX2TodtjfUZ4FpYr+oAdb71efT92rOz8KQqMrWu7ieDmyn
du82nIVbyGfH//ppoVVI8b8+C89SZjzscL9WiVhsGrGZBd/YcxfITOLILknS
XOXhLIRY1j2N+T9fnEduBHnPQlbtH3Yyjrd7/yPNwcBZkGdx/eRIEUekkw7d
MhGz0Mts3rgkit9j/DnhFDcLijtbd69gft1Qa+r5mjoLLUWTg2dw/yvdGa7N
kD8LDzJ/7vyF42/Q+5F+HM2CZsVVTV+sL7sHdYI9vs/C9sSRk9dwfAy+l65+
bp0FGSeN4oO4Pg8yLRYt9M/CPIpanMf9TO0VmUVyahaCvkm4DmO9dtSWHNRb
mgVXPiOJYuz//TNfMz02ZqHkithWKuZje7oDTzLLHDBKm0UXYD28Vf/ZqpF3
Dg4b+weIYL6ceaVnTCPNwfG4e+HvduB+t2StxbdzDh4u+u7yExBHt3U4WmX3
z4EY5zePA+zi6EmwkJnm4Tnw33Tt4xEcD/v5Bj9T9Tk40g9Nf/C8517anm93
fg7kLXo/Z3KIo7W7aX5el+eAy1L3w+lfeH4/knntxbU52ChjXKnD+pGjFzkS
YT0H+e/lzZJxPipiHtvHOM6BkcVdrgy8zwknWKTGec5Bz4rui/N4Xz6fLfor
7tkcOEcoI06M1zWzhvmYsDkgWW9yu79XHOkWiW5ExszBenjVLBnXC9vOO1+C
kuagfyb6YBTWP8VyrojHOXPwtH/bh1+4n7U8yt3pUDIHKgNbcs/gePqHLFqu
Vs7BcFG9+jXM5zXK5sNnm+agjFl/blBSHFl63i9V6Mb3CXz5dlBVHHkpfmYW
GZ0DK81aIx+sV5zv79j+mZuDbYRFdh7OX2h2f3TH7znwup/2hGG3OOJWuLaQ
Qz8PxhIqFmFYP6QfP2UN4JiHobSGmX84/n/KRufMBefhQIQGewf2t3zkwxX5
Lfj3+chAEtZ/xv0KUfTS8+C32+iTG86PfhT7+3r5eVDeGhQdyCaOzA7nDoWr
zsOhCe08KvbnuvI9qvHJedi5wzuKUxjX+70nilt15qFBQCHSEc8zplZ22oOG
8/BjY//aOVlxpCV8OOHt9XkIPGcToIP5Lr47rPGSzTwYGlkkzuHzbgsnlbmd
5kHO6+1JdaxXaZuOepR7zkNnpJQwPeZn1W0W5gfP5sGk95AJA9ZnZdNya8mw
efij+J6Bjl4cCU2WCDe+nYfEqoiQO5gfJul6iU4f54HH6Qfp1F+8XzMFuVGy
56HcVuy7He4PEUWsh1ERjqfe0X0P5pdCdcBx82/zIPYy4lUu5iNz/7jiRv08
0MPD4Bas1xqTH50iOuZBJSM90Qu/91C17aPs0DzU6K4o8uzC8xUzIV0+PQ8f
jmQ3mmF8ihkT3hr8nIdpD7+BHqwfLbOhFiMb8+CZNTyphvvHoUTmHfdYFuBa
p8KANMYr+luTygrPAmxdPsnThvnSJxij5S62ANUVivY/MP4VF1gK6LcvQN0w
S1csnseu/p0X95ZZgJ5ij797MD6Watlj/5QWgCQYzlWA9Suy6XWvy9EFKN1y
ZD4Jz79ee/e30U7j85fvyYfh9/4o35e7rb8A93XMatVwvLZCDS+7jRdgWb75
eDr+vauD+coZiwVISNkX5oj772/7L3sK7i3AwbdTdRN43qh94GYh4bwAzTbW
rcWKGA9b0fSn3tifd6mXLfH3ljkj5nMBC5D9UKpuN/Y/as+4pParBfCID9rN
iPUrS1HxUkbMAig4hLwN+H8eGuN5y560AMCjp+uN9SZhXO/ijewFiBkwSHTA
fN59yHZHcdECPGHwXR+RFkeOW1mtuL8tQPqN2jZb3M8unftWY16/AIrLJCFH
rPeME2zxme0L4MPM03IN96NonoLwtYEF0HhvZmuK+1uO2G8WjakFOKfF0CWJ
/WO+0RsZQFuAhybDhwMxflWpl5Mb1xbA3fNYLi/uV67ShnefMlAhNmPBOBr3
n6BxnRopFiqYBZhwK2O91ojXKajgoMK+7e422nje3ssvcvsaDxUE71SRw5cp
6KuQe/qGABWCWJk+M2M+5THsLIgQpcINlzMv3uH8FJvTXdovToVVyyeZufj+
tlNhJVXbqHCsadxmFdtzzTOfTaSosLFDL1oUxyv7x86dtocKPOYbG5fwPPdb
60zvk/1UWBGWN36A+axRU84gokiFv0/XFePxvnHuMulbkjIVxjIeT4ZhfTsu
7qN9SI0KbKdJ6pvxfITAwKnyOBXuFbBw/9mC60c6wVL/FBV6HeeWxDF+rRKD
a/1aVNAPMa3fgvsR519mozs6VLAxtnHrw/pRzfHuEs2ACocgpicT8305KUDS
xZAK48ctUmVw/iy5rYLpTKlwJ+lx+Rj2/9VJxvon16jgWJMQewXPD7GGXGls
t6hAZ3U3Kw3zMVdUyTjQigqLg3seyMmLoyzNc1mbbalgd4Bq2Ssnjnzjhtuf
O1Ch4PDnJVOc7yveQ/GczhivxoLz4SLiKDXzy/Fnj6gg/a6KtwD7E8Pm6s/s
TYV3JziSJbD+tD6y/+Dli/ExcdFhxu/pG6A7a8+oQK+v6kCP8VEtj9/kEESF
jMOMXavYXw/z86dnQqngtHNIQQPbQzXjN69GUsHzxf7Hkzh+u5pCmfY3VLDi
PO1+byfuZ4/rG07HUaHN/86jS9jfhF5/cskHKhyRctp8HPPLJqZXXSaFCiWm
96TYcb1dzzhOeptBheBQtx/cWL8WooLrOXKpMDsf0zeM3zsse2WfcwEVmAjH
C+zY/tZtfHesmAof8+2uT2E936Ny3FQHUcG6sumqCM4nmUjdW/SNCt8Cjapy
pPA8WWCSvq2GCsf9ZgqOYX48zenf/KyeCgfr5x5NYL03ecu+jdpMBc59hWOa
2N/YY+eFL7RTAf3ZSmrD+0vzxnxHYTcV4ueiJsbFcf3JnDlPGqBC+9aakEDc
f4p2J350G8H36zUo78Tz/rC7aGHvBBV65r8KD2L+SrM1p6nMUmHHcQuJavy9
Z9SqYRSVCkNZi+dNsJ7uzU6eXf5JhQRuoDfC/gedl1TW/UOF8z4POCvxe1XZ
V61TN6hQT+2KOIv9C19ARpsYFkFklNnpL+6nTyW3yRkzL8KcbwDPOO4nLeYr
5Tnsi8D/IPLfJ4xPVxHHUVbuRWDJ2PKoGPPFbc+4szH/IryQ2M7dg/2V6VaK
yRRehMcDDPzL2J/moBgvevIivJ7brvQZzzvUhFwdva2L0B1ZFGl5GvM7XGYw
bvsi/GbZuDuI+5s+5zNj6q5FUKNM+sdifsVuj3h9RGYRjHYl79kvI44Gpz9X
+sstQufWrve5OL9RrB2fWhUXwaX4dKQXzs8Ah0qY+OFFYLO3C17F/YOLZ0jp
ltoilPn91HfG9stjGzUZxxehNo+Pzni/OEoTitu2fHIRmLNlWa9fwnx9MGl9
WGsR/jh4Un248f4pvPbIXXsRlul1ki3HsR4W9nqV6i9C+wmHc8yYr0pqtecY
Ly/Ck6brJ3JxvUTr52xWN8Z49bpt/4L1ovTXWPhj80Vg1Mp44YLzVdetLFh2
YxE0tzxhMMD69vmvsOm/24uwVTN0Lhf303pl1bcqNhh/XdlKbzx/7XywM8nR
bhGGtgbyejXh/bnSJSXrwSJYDN8MqcP7f850g/OU8yIMfnbgYsb1xq+TeUzC
fRF+KuX1zeDzoXZVHZe88fn1ryG9GN/4fYG3nvsuQnLgdaoItrXTv1aWPluE
guCJmC+YL2KXSrYuv1iEH0mZP4JxPi8OX9GSCl0E0st//vx4fttxdcTucsQi
rJPJNRm4/zgygeXT6EVoUViRvIb1+f67t2YFsRjvqv6ILMx3iVq6XWMJi/C2
VED1GdaHWVnPed6kRXCdvCV4APsXmC/vfyRtEfb1rYzpYv/L1kUkb2ctgn5t
r88N3A/Sd5m9DMlbhIPCneoZ+LzuwDx9UeEiUBQHbY2wHnHeY9McKsHvzQdm
bMf6NxrrFcRSiu31AmUbjP/dH+kZeytwvov3Mzni+UKL/UyTTs0iGGsP/xDG
8Zp8KP1+v34RPj295XIYzzc6a5+rXzVjW73gED/W76d6ue/y2xZBOq8nSw/z
n/Ge6qP2LozHuS2G2dj/dcvpA8t9mN89Pzuamilo8oUijW8Y48FPVnxUTUEn
8qoC9o0vgtukKKM81vtlgmGv1vQiVEaHEQO4vs4rfUi+Ob8IWwZtjV/h+nbJ
WpX1oC1C4vcXh2txvzhzuv1lxK9FIO/PFezD9dN90+Zfxio+nxazGbB+US7Z
mlf8XYS+9ytZr/C+t/vM+7huBhqozZ1TOIf9pfemzM0z0+CWHPy6RKWgeOVh
UQYOGrDuLE7wxPg+K6LqCnDTwL8yKfoQ5u+foOvWO/hpQJiPxfw/LwlLSIYq
CtNg7qez3//zRLii6Vt1Eg26ik27FbD+nbkzkae3hQbLu9+7nML7YnwafbaZ
JA1O6Jyx8cd6Qj9xp9hKigYFIVqd+pjfqxSnVMc9NEhXLR8ZxPOASnRTiuc+
Gnzfc338OtYTOouhYH8FGhxbSFFcwr93HVXxCzlIg/rgmM10OF9nJExuRqrQ
QODkncnM//dFw3KDGKBB0JsOrb7/58/PdDIJJ2ig7t1lHI/3w2+H3IQ/nqLB
az65GQ8875237Z1J1qKBiBeDXgbO9yH++y2p2jRoDDVLacXx595d/ZCmTwNu
Q8uIH9vE0SbWzMC0SzQQRXf4CzTEkVKDqVnqFRqMxGyctMXxGcnKnUo2o8HH
E9Iv15Tx/J3IQk68ToOBVw9OXcD4H4n7yRx/iwZOkd28idj/eZG5gTdWOB+h
iQ98cT++ETDfGH6PBoOCwQxvsT6HGdNnBt3H/jt1nhHA9cOmwJXo50SD0KCB
vSpYv5pr9j93d6WBNNOJ6iQaBQUzHXnu4EGDjjjOyTCM/7+xq+53HtOg5eY3
/XUcHznB1N/ED8fTKW1wY5SCft194KsTQAPlM3EpU7ie6Kd1Yo4H0eC9pabj
Jxz/bYuTyQqhNNjn/oBagfkmwjDbKBlBgyOBmic+4PlUkZIyzRdNgy8TI07V
mG//bjFso4+lwaySK5NGA/ZHzfb8fDwNthR+ZKjE/FVeMY/sTqRBRIXrdAbW
O+Gea50VKTSI0eCNXsP1ILvaoJSVQYM4GvXna+xv1f2TgVE5NKi0fu2qgfdR
4T1c9N75NLBX2PnKA+tN96ZumztFNAjfRvRfwftyU3X3qvZXGkhq/wjsw/vO
E54OT8UyGujdquZ+gePxfzMjJVZJg9G8Y9sCcb0lJS9Wb9TQ4Ockw7Q/xvca
Ey1gsB7Hy6fX8RXriZ575+myZhrgoVTKuoeCZhhe705oo0FGiJnJfbz/qQ4f
YHncRYNALd8ye6xXwfCM5VofxvvTfaWD2F/JrpRNR4do8OnQ5u0u2L9BsRs7
KWM0uNfuMueK9ZFFokvjzyQNmM93cIfhfaMmt/xZ6ywNon7STn1TEUeXVQ0b
Mqg0GJN56VSNf/9Eg0NPf9JguDT8lAq+b5MbEWe+QoMPUylvWzAfnoZayh9a
pwHeRI8p/v//Erboci66Jcg7WSGyE/sftq/JbZRxCYxDxr+W4H5hTn1w8DPL
Erz/2hQ7jvXS+tSK2HOOJdj5JRRG8L5ke/KUgDn3Esi5PFOTwfHEnr3JI8+/
BEVv9vidwPj1O8UpMQovwR1nbVPaHAVdSw0zbxFbAo2bDtvu4v5m1O/yKV58
CQLbQ36sYnworX+57LZh+3ZxQwO+b+He6TC1nUvQT3O5Z4nrYUhdeAvH7iW4
rG3y5RD2n0nRvb1dZgnmDisUG2B+tbw8GxYntwQu97eWtOF6+ar7xMNKcQlO
S3zSTsD92fo+q/0B5SW4/Si1oRzzW5678uW66hJMhd5nmcX5L6rILC4/ugTe
f48c/YT59WY0nv+Z+hIUnvHkG8L70sPoeAdtzSU4135fOwHPE7aezkwCZ3E8
khaff2E9Ej+u+q5DewnM+rap8eF+aNQcb/Vafwm2vTEnl+P7WrVajhlfWoLI
4RsJKzje3dz3T1OuLAHnR7ljnXge1Y/8bNxnugS3ytVDbmH/UsqV499cW4I4
TtbUdDy/Zpmo/jSyWIKNE7X5G//v2y3HnEUsl+Bd7/SEMe4vwnLvOdpsliBK
SC7XGu87cr7NzcF2S1D5uftKFK7PW9yKiVoPcPxGy50hWN/5gndnMjkvQXNW
lkA7xrf6pmzVV7clMGRW8bqL738g+kzAyXMJNK04jOdw/UmI1drJ+iyBftHj
la34/rKqXUxjfkvwvMuK9hjvG16hx5JfByyBsL+c5iE8zxVUHPbRDloCv7KP
/4IwH+3Kym0ZQ5eg276+UgHnK7t2ISw/fAlC6Mccv+N6V5b2qL39egnomvpl
xrD+D0jdPywWswRZF8RKv2B9Zh19U/I9bgnWzW9PnMHx2lTOOLl8wHjufdU6
hfd7vuxjp6STlyBHMPypFu5HQcpuOh1pS1B24Af//SoKilh5ftcnawmceKdP
sWP98y49XrU/bwnIrpMHOjCfulrfKvYWLAE/x7EkGXze2cBwwLf4v4qtO56q
PwyLJIRSIdwrFEqkomG9SKJEsmclopBSaCirhND0Q1aiJErLqKiTVXaINGQ0
FDLPveccid/bn/fjnO/3Hc/7vM/zue4EiEWs8RFB//t3SUymxssJIL3SzMqx
Hsdvt6d+qED8a40WL8f8e1z3FYbXTACL1bMkG/OXXlM7o1I3AW6rc5a1oz5t
n9Hxbm6cADX1fhv7f/5bx1A0sGUCvoWFiQUjP+/SYDcuaZ+AuRE/dQqwvl97
TOrKOxF/Q18t3f7pH3p+757PE6Czw/6yKuLDQrp7PV/PBGi94t/hiPXjM5LM
zfk6AcKsC3Oeo79gKoXst/RPwHB5BfUc+Wq6a7XC94EJuK6yvzIP6998q0bt
7PAEdG1LFlyCfDkaZ2urMD4BPit2CPbhfkw5KfziJWcCrF6LBc9DPdvKH7rZ
hZmAEUUrm0b8bEo1CtFTE5CgmX/eAPHs8zdj5AoPCZGlS4Kz8Dy91mkJtdkk
bO809XuM+IpVy3GpESDhmsiERTM+f7Qu9rubMAmKTq8MapFvAuxeZHJFSRDW
12tQxH2dft/pRLw4CULhQjGFqI9k1IySFCVIWP7xVORvxNMmD+v20iUkVLBF
1YZQ7zp17HbYwSJhp+9I+QXkm4Rh26mepSTw1CmLH8T+j+3nfj+6jASN1zej
g5BfUwNhjF+FhNc/3ISi8Lw6mV6jJFUSVCceZGvg3ynzX8XKq0koyXMVulLJ
Ijr2UEdK1pKo/z6vu4f7+takyk6T9SSU5isVtOLnxvfzgt5tImH1uS3W9Tiv
LXpvX+7VI2FRqqXOdqwn6TZmNWxAwlefuSEc7Pf5xffmnjQm4bbeUaH8bhbx
UvLIXH5TEsxT7hbsRD62ex2jdnE7Cbm+c2r4Ea9H/GzSpCxJCOa56WOFeuzr
91VrsnaRIJH9Q40WR/8ts2f+CjsS+hdmiZ9A/B6zd5R44EjCAYMQ8cvIL0Oa
tl7rXUkIrAy6mo949XBp6n6+h4S8mm3KnuWoB1TGsg08SNBlBoi5begHErde
qvIiQT+yoiMR+7mv/vebrT4kmPSr8Hgjnp4JnV5Zd4iEJo+TR99j/647zvqw
PYCEFS9VR4xk2ESVhuLDhkCMLxXOpuP9x8O/dJifIOGKkpjtBYyPd3RAqSGE
hCT3d3nPcf7svTSrt4Vhv7LDjlzBfh28G57wJhLj3X+S1YLzsLng/u0t50kQ
8RNMasP5e2x4eeBVLAnvlwdMiOL97GOc03oJJPDquf4njvEGIARLL5Pg4bXZ
K7OeReT53NuxNhHjb3hk/7sR9++ah7H5ySSIzqvRD8L+XG4KllqWRsKcqY4d
gv/8FO/sd6mZJBx+dPC0HvLnHr/xHvFsEtasrsunkI8e3bORjbmN8ezvUG1q
ZRHej0vypvNIGBdfpuqO810yrLP/6D0SHv+qu+z5hUVkF7gF9j8gIcZyyfs8
5LciRcsnTk9IeFGa1xSG+AkXPmXSWEICKyZPS1CbTZy3WSoIzzG+qKmCucjX
D9TT5R68IGFh4R2hDNw3Szfqey2tIIE8fW+0BOe5SWkX36VqEq7PnJl7A/Fi
oK3ZMv2GhJuZ4HQS+Vy6TJH0bcDzSr2GNuH7i8NjzT42k7A09MPlkg/In8eS
SZM2EpQ9mdmKuH87x6tbH3WQYLaw+EoMvs+ftE6A/ZEE2ZXVS0yRfxx0vP2j
u/D+jzen5bE/qVqB6uM9JKSdcDWSRv4LaxmRd/5GwuyPRgXmWE9r9Y++lf2I
75m/an3/vh+Yej+0cpCEiyWHJ6Tw/pG1n6suD5Pg9TOwbwjxk/wxuZUaw/7F
/3zFg/P8pXFsoyuHhKodz/JScb4q9+W2v6JJ+Nntn/oC+3PJK6F++RTeJz5b
3xbjO5pdKBgzQ8L8RLmEfejvarYrhA7ycuBL3rDUyffoH+7nWOyYw4GtWmWB
dxDPHfel7e4LcuCxjdNvNdzXp++tKxUV4cC03rLglS9Qnz3q3XVoPgfCja8x
JPJNl261aeNCDmw8IcaORjxO+X4JVpXkwDWv9VbauP/Thl7wxkhzwL/u43Qr
5uM8cOz1dxYHln6SkLqG896zNfKnoTwHKtQuV2dhfm5ac4zTl3FAbEYntRPx
G/7hyBSljPfHa9Xrob/MdhodsVLlgLHPjwfKyE9L1vQb5KtzQE1IePk44mnO
oYRGvrUceBJVWh+F+na6X7fUWYsDmzoEI5+hX0y+uLH70UYO9M9b9jHlLotY
fbvWQ1CXA9WfT2yjML8Lo5uVdwPm8315khXmY6zca/rEiANn3E/N5UW8S3Xy
3plrwoEi7yc+SthvY3i338WMAx/mhs744X3Wd6r2FZpz4Po2txAljOd09ygx
aycHTu26buHRziL+9rW7WFtz4KCwnZEF8pW5TIRjjh0HMqVvbi/BepuohyWS
jhxQ+urc74Tz3LXq7VpjVw74XGOtcsV6xToKzb+6hwMzBb3HRRA/X04stezd
xwHxJYlfjyOf/N1b2qTuxYHDQ+qH1Woxv+SiB6cOckC02D9NBufRMbi+7bUf
B+S+MWKBmE/krmbHhUc4sKdJqlUD8RfEEyHvdowDvgYfvTWa0X8X3DW/E8yB
+YNaypM4f72Zks/GTmL+L6KLSHw+41f4Be0zHLgzxyPOt4tFeG6szowI54Du
8MDLGqyHZHycVN1ZDvw9bpW+H/1+/Bjxbn40B1xN0i0e3GMRE+4zHLsLHBgd
SzrDQT/E0tV3TkvgQNORBIcs7K9OxDyl3sscGKq+UbYe5yesw09reSIHQPJY
P43xv7X6etc7mQNna/m3uKFfVWs57ZmfygH2g5QwCu97G/cg6ncGB77feemW
kof66WrKb/WbmM9ec9WkYtz3JhnP/W9x4D+B3XMzsF4Pu341F97hQJh8Q+1f
7F/daNv2kXwO3DBlv/n3fU9ryzVR9UKMx2zludWo/xVcgjb5PuLAereVo12I
F/eJ8vy8Ig5IPDpfaor9XEnkRv0o5UCA4RkrRdz3PWpReQplHDCanFA1wvMf
lZ/XcnvJgSkriUAl3EcRncJCKRUcuLTh5aybJdivfetM26o5oPE38mTDOxbh
+uxg87xaDmzuHi7wQT/2YE01saWBA/x/akVjcN4viJb9Od3MAcN73GBhxIed
nG1WUSsHeE49q3+O+elHS1weaudAltiHRXXI1/PT6UGFDzjPSY+ky3Hftdsl
XHb4jHhoyb/ciPugJaXiZnw3B9xDByQY1C+SbuFiFX0cYNXKnjBFv/AiqvI1
5zsHVi4QGy65wSK2f989pPKLA6W1InauH/79/7Ggq/MQB947WDm+wPPeecZo
x49w4IBdTY4o8ldacqbHi3EOxCqvvlaJ/FOkPHdqmIN/zw63z0I+S7C42MNm
OGDy8EaHF9ZrnPfbWoupf/nb+fLh82fZ3a0hM4j/pvCizchvh/cp9N7l5cKC
wg6JcOxPLVzV6+TnwtPWWOOFqA/bzWvm8gtywcrz99opxNuuyHsKa+Zx4e14
j4vHKxZh6fY230WMC+9qfnsn4r4+a6929rw4FwSrU2b+ff/h1aHf8HAxF7TO
f3gVifw5Uy/m8UmKC4z5/KidOJ/P/xPxnS3LhQO5+XZOuL/tEy2rVslxwXH2
nMI/uH8J5fXxNgpcEDXSFQ/9p4/mf799ajkXhkYfctWHWYR/WeGamypcMCzb
2X51iEWImtaIvFHlAn+f+yEbxDNXy9/5tzoX9L3qAl7H435W+iokvpYLhze4
ft/6BPlC6tCUlhYX4tO2G+kgPy85u/Gw40YumI+JWt/A+Bd/OG8SosOFlXCj
wQz1eN7rlNAMfS5Iff793wmc7w/lrX9eGnLhcda1i82oB1WSVf70GGP8g19s
+BHPpgaM6yxTLriErGlh4T7/0h6+TH47FzbyqFqur2ERp8RgtYEFF0B6NF0U
9fF0KFnuZsWFyco2PWuMX89D6mGIDRdKV/EYCz9EfbOjf+51e6zHkZjYragv
yxZzbxU7caH7yqztwljPC7Ydr1tdufBxK7y+jHhoCZawHN7DhSuXjWtUsD78
4eM6gh5cUH//5yuB/Q/YJumv6MWFr/GNC54h/2wjvinrHeRC7sLOja+xvjN2
s7ba+XFhdfGo2BkVNjEr+k7DocNcqLJdI+aG/OgtkJkSdRTr+X1RqRzmP+a+
8Hd6EBfOz+FVjEL8ryArc5+cQLyscG/MQPwr5A/W1oVwQYMdou2BfPZ+fL9m
TygXas4viieQr0K3rlPiRHCBfCKjfBX5/2mlUphgFNZDazz1rACb6Gs+ZcSK
4ULCj0s3s1APrzuoZKERx4XUtTtaEnJZRJbZRK/RRezf+jldPnj/MqW3X2yu
cKHx8NlrhBHqxz6u8f5ELki/9Wx4i/OwbzCAE5TMhalVG3IHkI9iQnvUz6dy
YcaKSS/D/jm9NW79L4MLP1hJ3LkDyN86H7pvZXHhbjjPx4f//t8shNj4JIcL
/QESzrfx+dVZ+2Uqcrlwq3R+adNLjGftT+/mu1w4dEh/86UO1HPCZ+Q/3+OC
vSQddq8O98kCd6WfD7jQ9vu+ZMuDf/v4bdHEYy44SOwK6ezB+e2aejBdzIUc
BTvnN3he7TM5KcFnXIg5k51h8xz3gd6RQfFyLgQV77ljiPXXXmA6T5bAeU0+
ZGyJ79f155Quq+TC0ZedzYPIXwKWnS2rargQuOjh7BrEx1ceaQfNWoxfN3Lc
CfHmfvb9Kp0GLsiPz3pqi/ow1rwv3rCZC3LTjgk5uK8SG7NctrZyYdj+02t1
9Fthm3ekmLdzIW7D9MhfxFPdqPdyq04upOw/Ed+AembPziR920/IL6UF7Qu1
0B+n2tU4fOGCwKHentX5yGeXu8qce7mwqaEwbhvy8Tax13xu37hQcsjE6Bry
D/ElqnN3P+L/o+nSsSoWcffzQ9m9A1xobRNxKUV/F73jzNu9v7kgwm3acuGf
Po5Kb987yoWLln/t5TLRr/+0ObB3ggtZv2bpduG+a2ix9NvDxfo+k2drIt+d
FqnqdWO4YDuls6Aa5/Gn6Yk7LlNcyH90wiUJ98UVImracQb5Y/H1tFDUQ5c1
71fb8VJgu1v7iCfOxy1q2fQufgq+YPPDsB8nht/EWMyloEn8lOpm5DOL4Mhb
ZsIUbN/0zeAqwSJeXVm1zliUAqdFvGq3sd+1ssxa/QUUrJgxrFNHfCxZ0BW1
YREFXiUjHYcx3yua13w0JCkwcGMu3E9hEYO58ypVpCk4vv2/pS9usojSlpPx
S1kUDD58U5WK/JqZ87NAcikFahohJwNxP/ld+uYqqkiB9Z4V856vw31SFBAx
W4mCG7r/pTgivzkIvJaeVKFAqMK2Vewc1sdiluCIKgXVpzU7i6LQTw9ExHxV
p+B05Es6Bvf/lU+eZ96vwfsN0t7Oxv16Kqurv06Tgs9iBQI82I/mcrk75Rso
EJdZKSaC+Cgi9vwp1KbA9JOY3yys5xGft5VZehTUx3UtUEW+82vImnXVgAJD
KlNeIAnn4a9cUuRmCvyWrRtyw30ixWdNHDWh4NMs072qQmziPwjbvc+MghbX
d0O8WE8Lq4/Hdpnjee3zQ5Tw/VP1r/oMLClIKkgWlUZ9+shb/Lv6LgpK+Nbf
/4J+9bCIspusLQUWNJHne4VFrP21xkLQgQIm2PaVMc5/5687SRwnCi6Fhos9
xfzOvdIJ6nWloPGHh9Y5xBdZ4tTQsIcCsc1brSOycT9c3HC9ZB8FUtF+uz9k
oD467FqRtR/7F6r1+Bf6KR7TnWEXDlDQUaxgchH1xZMbicXHfLH+6nM2lOB+
z33r5unqj3gIVJg8iv1rkjP33xJAQe++kcoafF9vrEhMLZCCsjhn3ouXWUQ1
tX7FouMUFCncfmON+fSzeMomT1IQfPDB8YNYjwv5NXd7TlMgsTVWaRXuB5Gy
Eo2aMArOVyouk/nIIi4KRWrkR1JAdT5cqoR6+YGk492LURTk3lGekx6IeDQ7
mHE0hgJ3Z5OoFxdYxPD0uRG7OMSn9c/ssH+/37qc3bnpIgXXUvfwrkY8ynbF
6cpeoSCQ/ptGI59Vdx+Rmb5GwXu/GDMa+WbwyXqH7iQKAp4I3F5/Efs7latG
XKegq7lA/x7u2zb7nDM30in4o92Ssv4p+jFX5+1hN3CeTh9fl52K/rm2Omh3
NgVnbggXBGA+r16c09G/jXgU8Z/Pg/WzPJ8QIpuH8/YrYCbzFPKDtZj2ZD4F
+3hz902nYf/dF9u/v09B6IZf2xVxnj4lS4k+eUhBhd/aJWHIP6L1S40uPcH5
SDdc8xD3M1PlMuFTgu+/L5Wbuo/9WzU8e+szCup82ecysf5H+hQeypcjnk7v
Ap//WESxquSnPy8pGI00+qSP+vO+PxPRXoH1q+3+Zo/5VKfPXLhfTcEtuQo/
CusZ2rpD4/wbCiydDGsJ9FOG2Yusd9dTMM7eqr3OF/fH4ghyfRMFV+Pllxch
f5zZ0kOJtFAwy7/iLquURdTXrEj61kbBX/KpUz7iU9Yju+hZBwV3fc2VgnHe
aeKk9aUPFDyv6o8S60R/NU/UxvMzBXt/DLnsKsL7YtXHNnVTEBTtxO+GfG8j
pyUq2keB9qJbI28wvyhRy/zebxQsWZd3Ylk06q+Q4fwn/RQsU9eNWYX8dvD6
c7PzAxR8bExMXR2D+Zkpejv+pqCUevYp1B3n8dAuAdVRrM/AQ9PiONSHAs1C
U+MUKLOW/SCxHt99pAoaOBSc4+92akA957ynsCmNpuBpPa/+TdRXZQeIAN8/
FOj8UDvmhnh0Nvl+SmeagsQ/E7f/1Xvo3jFFoVk0bIvSpI/hZ2dVvh2dfDSs
PJblOfqIRZj9KKNvzaFh4NDmZE/0wwMGlkJHBWl4o2GYFor8Phn38xnMo+FH
Y5jJ/mfIdzxrhoXFaGj0dhT/iHjL8LLJeb+ABhc/t50mcvi5YOGrm4tomP+r
JLCjSZYIJo+d9pOkYV7GlXmP8Plhfs3yDdI0iJQJtQ1uYBNdO0PCZrFoyPh1
O/Ye+vNidYX8OjkavpfvuV+CejmhmS/oqgINoQUZvfkRLKLVf7TKeTkNigED
rmssMb5lC5MVVWhYYnPI4C/Gr5tm3TawkobipKwdjciHEmbehQ/VaAjhkQkR
RP4Ur1w3/7gGDXf+cvnrEX96NT0cvXU0HHixiTdmOZsw23TQmG89Db4Z0epK
m1G/Cu3WfLORhpP2MmMXmv/93qwoL06HBvcfCoP5/37/9eS/nJ36NNyzlQk4
gfwSSC0QXGRIg3mKWm1EOovoOJkg9n4zDW6+Vbm6FTgveovTUkxocJqZxzNn
EZsYM39739mMBp5DLTL5GM+SjF9bWeY0GHWD5AN8P2oyavsXCxo+1Z993OqP
/KDWPZZhRcN2kVP2770Qz3wL5Xbb0KB3OKLhKc6DnLR5G9uehnbV0Lt+WL+z
8pXjXY40LBB4mcZvxyYcFkQXpbnQ8E55Z0HUJ9SrN5pmnHbTUFpFm/5G/pGQ
IVqk3GkoWvswNeIxizCazBXr8MD6Sw6/0rZDvZfsP3bFi4bj3848DvJBPRvm
6mx5kIa058VaF9EvTOVe3yHsh/XlX7uuFfm5SvdcQY0/DdoxoXkGWZj/6p7C
8AAaZjePBvmjn+ivnq2rG0jDHkWfvj94n3iWjBU3mIaR/ZZBK1Bfv41ObCs8
SQPNn6Ucgvpxh7bYH+/TiLctc5pkzrOIpOtkvnwY5usRuvCdJvIt4/fjQwQN
K67Kyxfi/jPLnE64fI6Go+/lzNNxXqPNWF2m0TTUKA2Gj6L+ZXmaFs3E0rAp
sW/FSA7iaSRXsjgez5MzKI5Evd55veWnzyUagv+svnnKgkUE2Uvskb9KQ5K5
2ar/zuB8zhJw70ikofWWRUMA+nfW1vrh2GTsv73/m0uXWESNsvCgfiqe5+PP
V4l+0P3vWPx4Og0eEl/rjG6wifxJhbJbN2iIvhDEsw310amQ6kCHbMSfVadm
LOqv5c+vZgrdpsGTZ9x8BPEsmH/1cNkdGs7fW/Mr4zb67fKTjX75GJ9VsG4c
8o/1jH8x+z4+/4Ml6SrDIjbUwvzmBzQ0fA+6WIL65dPnugWhj2l4/TRQYAz3
y+WWzkz1YhrM9AW2muN+Cth/6VlXKfLBN4E+Yw8Wofyn2STuOQ3C0aw2Eezf
aSvrU9ovaIhxmyNToc0iFoiRuj8JGiSjDtcf3MYiHG91XkisxOczlTJm8LzZ
HmPmRjU0ROVkDCYgf2bptxcPv0H+uHIgsLAW+bTF//71ehryOq0fCWD+rwz6
15k00bBReq6iAOpRiSK9VWNvka9OB064IH8sP/e9MbWNhsWvZGbzKbIJoVWf
/27poKFuLWtJFfL97oitZSOdyHexK1uq0A+HHNEZTv6E8/PG5PrEVsz3G3+d
4RecV+nE1l7E1w52seZADw2y5wS6p3EehQuOqF/5SoP+RCLPOg0WIS/vlrbp
Bw0LX/6UsU/A+qndetLzE/lFic+ixI9FQLWXy/lBGsiFZkbP/v3efGX9VbVh
GoTmPO1T+iZLiEbOMWgbpWFMdbUxG/1cXKBc0vEJGn4dmXY6hPPBn2B6hsWl
QdflhdkK1EcF1bc5r2gaCokHcQtwfwu9jOjz/EPDxKYAoduoJwy3vDgpOE1D
+K7oVmNeNiHnlZ5dwMOAcdT1RV9dWETfO2NXSz4GisuNOfNusYjCVR9yx/gZ
2OA+vqAb9dTZhlLvq3MZuK9tcEX/3+8nxpLbNYUZiHVsLIg/yiJcfdva2kUY
mP5pe6ahAPXHtbh9QfMZ0Hh7yvgU+mm+BZoHJRYykLB9O6+/DvLLfWdW8eJ/
7x9MkBTB+BMOudtKMWCiESTmg/vamri0iZRmoPDVh5ajhSxiDXtz9BUWA75O
B+2eIP/kryMjNZYyMPeihGZWIosocV4q3qTAgHbZouNpB9H/uQ2u9VnOwKsq
7/Ubd7MIE83+egEVBmKUIiueYf1X2O4Wz1nJgNIj88d2K1BvQO8gqDEwXi6f
WcPIEomBlxw+rcb7nuRskUP83+SK6QetZSDtY/H+QJxnC7volvlaDNSvnyoZ
2In+US6ZvruBgQjfxYMjN3C+L7k/NtZmoH/48UhPJMaTktrfpcvA2qt9TnF6
LKJSwqwuCBhIPeGyMOw5m5iJlTYUM2LA/fSuOZtRT28eWWuea8xA8CfBqgzU
R91i9i36Wxk4Hau7nx/n5QYc5O8wY0Bz/YjDGUPkz75VTb7mDOTkrF6U0IB4
L3ylymfJgOci4RYeCzZRv36aL8WKgb+bH2fI474Z98++oG7DwL5LI+mLkd8s
LkTcqbRjgP+CzvO7wCJ4/5Q7OTgyUKA77qSG/PyBVzd6yJmBzQ/O+QUW/9P7
qZ5hbgyYxzpJtKJ+XrnoRefCvQzMTma2WWM9+LRqem/vY+CZc1itSLMswZN/
d/+m/QzkuxWL70P/o7rxZ2q9NwO2yySHZtAvffE84uXqw0BKFu9PMfSvyxS8
a4f9MP6n1yuNkE9ftLXlhh7G94MbmUL0h588xDbMP8rAPL876b/2sIi4QZbr
jUAGzCzKk2WQjxsXyUtrHGdgj9TmZl7kk/inGjYvTzLQ/dgnOgr1S4VkFFic
ZsArSyX4twqLsC/XrPgcysCMgNCTYJyXXgm3zwcjGJDf/XSIexj9ltPKY/RZ
Bgz6+Q4vXYB4NHlYfu48A7l/1JSjcL8trpPIFI9lYM2Bz4Pa6Wxi28IQqcw4
BkIOXDgbGMAm9LOWzFe9iOfdb108GcYiFn36/rT4Ms5LvLjm/nsswp9n8ZTh
NQbiXr023CSA/Zx+3dHwHwMVonvv5LBYxOvYrRr2KZif6q97A1ex/t3eur2p
DJR9s3Wr0EU/Eny492AGzldfMP9uWeSvWaFy5A0GDM0Kzm4bkCUoq9+fQ7IZ
EL6orNHOg/4q238H/22s757bHtaoT1STnOzj7zAQfyo5vU+STXSnNU0uymfA
4eq7ow5OuM8SNdlp9xj4fOBv3wjqW5UfchyFBwxM1fUpOmE8NsDxzHvEgGX/
j6CsKVnCpv3d4dVFDGTeemd5bS6L+NHwZXFRCeInzenLC/SPJpMXdbSfMSAh
7LBw4z4WcXRk1+KXZQz09a6YH24hR6x0uBGz+SXmEyZtfg/kiHTZ5OTXrxjg
WqmYJhiyifLRGpXtVXjf9E130Q3oL34H+TXVMKDgeeOSG9bf9abGDqta7Pfg
thSrcjYxVLbwTVs9A9u6Jz5p18sSVWVlVbZNDAgyllcHUD+PHbANev+WgbM5
QcOffNnEfaWgSoc2Bvx75yVKlMsRvfv0Cz60M/CAWtU8cI5NrHFyknTqZIBP
4q/XAtzno3ltGz5+ZIDUCayXwP0BR3eRjl0MyCi2VGnHyhL6QxzzD90McDqP
FFK2LOLr+AkVhz7kJ8agd/COLKGs8uZpxzfkgzkqMy47WESZXXK/TT/W58Ap
r2zk9wsnBR+1/mIgyCpKg5JhE7f5+mcshxigDydE+MfKEa3PJ/kah3H+dMxC
pZD/xfnn3TIbY2DxoY8H6m/JEneyNn2tnmDg5n7287Wo956Hud0y5DLQHu01
rYzznVu2jF1OI16PO7RHoh64p7NPc+MfBtbNbZi9F/vDRG38+egv8iv1mV28
HfHAJCxV45kE2/vku9moJ94ojYnl8k6CwJmAp06tsoS155b0pfyTkDqTrDO5
V5aQmXP3TYrAJOrzUpOm0+ivyqVOiAtNgvfWyaxIE+S7F1M9sfMmwd6p2NuX
lCUiyrf384pNQmSeisiKCTah+k4x7uSCSZDRyCEWS7KInL/xxWMLJ+GzluTt
okppQn5tR7K3xCRojZ2s3N0hTfwPW285Nw==
         "]]}}}, {{}, {}}}, {
    DisplayFunction -> Identity, GridLines -> {None, None}, DisplayFunction -> 
     Identity, DisplayFunction -> Identity, DisplayFunction -> Identity, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, 
     AxesOrigin -> {-5.882554677638043, -11.512925464970204`}, 
     DisplayFunction :> Identity, Frame -> {{True, True}, {True, True}}, 
     FrameLabel -> {{
        FormBox[
         TagBox["\"Intensity [a.u.]\"", HoldForm], TraditionalForm], None}, {
        FormBox[
         TagBox[
         "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) [\\!\\(\
\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], TraditionalForm], 
        None}}, FrameTicks -> {{{{
          NCache[-Log[100000], -11.512925464970229`], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "5"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10000], -9.210340371976184], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "4"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {0, 
          FormBox[
           
           TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           
           TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           
           TemplateBox[{"10", "2"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           
           TemplateBox[{"10", "3"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           
           TemplateBox[{"10", "4"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[100000], 11.512925464970229`], 
          FormBox[
           
           TemplateBox[{"10", "5"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100000], -11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50000], -10.819778284410283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 3]], -10.41431317630212], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25000], -10.126631103850338`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20000], -9.903487552536127], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50000, 3]], -9.721165995742174], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 7]], -9.567015315914915], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[12500], -9.433483923290392], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 9]], -9.315700887634009], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10000], -9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5000], -8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 3]], -8.111728083308073], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2500], -7.824046010856292], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2000], -7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5000, 3]], -7.418580902748128], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 7]], -7.264430222920869], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1250], -7.1308988302963465`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 9]], -7.013115794639964], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200], 5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300], 5.703782474656201], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400], 5.991464547107982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500], 6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600], 6.396929655216146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700], 6.551080335043404], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800], 6.684611727667927], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900], 6.802394763324311], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2000], 7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3000], 8.006367567650246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4000], 8.294049640102028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5000], 8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6000], 8.699514748210191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7000], 8.85366542803745], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8000], 8.987196820661973], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9000], 9.104979856318357], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20000], 9.903487552536127], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30000], 10.308952660644293`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40000], 10.596634733096073`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50000], 10.819778284410283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60000], 11.002099841204238`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70000], 11.156250521031495`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80000], 11.289781913656018`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90000], 11.407564949312402`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100000], 11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200000], 12.206072645530174`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300000], 12.611537753638338`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400000], 12.89921982609012], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500000], 13.122363377404328`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600000], 13.304684934198283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700000], 13.458835614025542`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800000], 13.592367006650065`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900000], 13.710150042306449`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}, {{
          NCache[-Log[100000], -11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10000], -9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100000], 11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000], -11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50000], -10.819778284410283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 3]], -10.41431317630212], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25000], -10.126631103850338`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20000], -9.903487552536127], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50000, 3]], -9.721165995742174], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 7]], -9.567015315914915], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[12500], -9.433483923290392], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 9]], -9.315700887634009], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10000], -9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5000], -8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 3]], -8.111728083308073], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2500], -7.824046010856292], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2000], -7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5000, 3]], -7.418580902748128], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 7]], -7.264430222920869], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1250], -7.1308988302963465`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 9]], -7.013115794639964], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200], 5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300], 5.703782474656201], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400], 5.991464547107982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500], 6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600], 6.396929655216146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700], 6.551080335043404], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800], 6.684611727667927], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900], 6.802394763324311], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2000], 7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3000], 8.006367567650246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4000], 8.294049640102028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5000], 8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6000], 8.699514748210191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7000], 8.85366542803745], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8000], 8.987196820661973], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9000], 9.104979856318357], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20000], 9.903487552536127], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30000], 10.308952660644293`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40000], 10.596634733096073`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50000], 10.819778284410283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60000], 11.002099841204238`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70000], 11.156250521031495`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80000], 11.289781913656018`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90000], 11.407564949312402`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100000], 11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200000], 12.206072645530174`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300000], 12.611537753638338`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400000], 12.89921982609012], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500000], 13.122363377404328`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600000], 13.304684934198283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700000], 13.458835614025542`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800000], 13.592367006650065`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900000], 13.710150042306449`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}}, {{{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {0, 
          FormBox[
           
           TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           
           TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}, {{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}}}, GridLines -> {None, None}, GridLinesStyle -> 
     Directive[
       GrayLevel[0.5, 0.4]], LabelStyle -> {FontSize -> 14, 
       GrayLevel[0]}, 
     Method -> {
      "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
       "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           Exp[
            Part[#, 1]], 
           Exp[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           Exp[
            Part[#, 1]], 
           Exp[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{-5.882554677638043, 
      1.630470845239991}, {-11.512925464970229`, 11.512925464970229`}}, 
     PlotRangeClipping -> True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {0, 0}}, Ticks -> {
       Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
        15.954589770191003`, RotateLabel -> 0], 
       Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
        15.954589770191003`, RotateLabel -> 0]}}], 
   FormBox[
    FormBox[
     TemplateBox[{"\"31 m\"", "\"10 m\"", "\"1.5 m\""}, "PointLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #3}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontSize -> 14, 
          GrayLevel[0], FontFamily -> "Arial"}, Background -> Automatic, 
         StripOnInput -> False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"PointLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.003666666666666667`", "]"}], 
                   ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.368417, 0.506779, 0.709798]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.003666666666666667`", "]"}], 
                   ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.880722, 0.611041, 0.142051]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.003666666666666667`", "]"}], 
                   ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.560181, 0.691569, 0.194885]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}]}],
              "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"True", ",", "True", ",", "True"}], "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"FontSize", "\[Rule]", "14"}], ",", 
                 
                 TemplateBox[<|"color" -> GrayLevel[0]|>, 
                  "GrayLevelColorSwatchTemplate"]}], "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{{3.8527879438310833`*^9, 3.852787964921023*^9}, {
   3.8527880302138367`*^9, 3.8527880537745132`*^9}, 3.852788084697062*^9, {
   3.8527881270170593`*^9, 3.852788224333301*^9}, 3.85278831785238*^9, 
   3.852788361683811*^9, {3.852795206034478*^9, 3.852795268644823*^9}, {
   3.852795796660235*^9, 3.852795803347172*^9}, 3.852862499690114*^9, 
   3.853381367103548*^9, 3.853381477275778*^9, 3.8534022418114157`*^9, 
   3.853402534499599*^9, {3.853405270422613*^9, 3.853405324836055*^9}, 
   3.853405407395211*^9, {3.8534097505906153`*^9, 3.8534097703076878`*^9}, 
   3.853410187279647*^9, 3.8534102457215548`*^9, {3.853410571397106*^9, 
   3.853410595830978*^9}, 3.853469096590513*^9, 3.853469303037784*^9, 
   3.853496283640119*^9, 3.8534996296665163`*^9, 3.853817848440113*^9, 
   3.8538182517655993`*^9, 3.853824687596098*^9, 3.85382487471694*^9, 
   3.8538330798017387`*^9, 3.853836456463883*^9, {3.853836638285132*^9, 
   3.853836690462969*^9}, 3.853838543040962*^9, 3.854072558224156*^9, 
   3.854091678576386*^9, 3.8540984652252827`*^9, 3.8544207625736847`*^9, 
   3.854421344558304*^9, {3.8544214059054337`*^9, 3.854421491046699*^9}, 
   3.854423662477191*^9, 3.8601208220618477`*^9, 3.860120994483048*^9, 
   3.86012125099901*^9, 3.860140222318944*^9, 3.8601412086662254`*^9, 
   3.861763743975759*^9, 3.86176383617095*^9, {3.8617640582820826`*^9, 
   3.861764074747286*^9}, 3.8617641740186996`*^9, 3.861764274902935*^9, {
   3.8617643353175488`*^9, 3.861764372253722*^9}, {3.861764623510527*^9, 
   3.8617646348513403`*^9}, 3.8617647132308836`*^9, {3.861767375375707*^9, 
   3.861767457590822*^9}, 3.861941029316691*^9, 3.861950322744031*^9, 
   3.8636862718685603`*^9, 3.8636872310576773`*^9, 3.885975309403617*^9, {
   3.885975375253332*^9, 3.885975398991347*^9}, 3.885976450290474*^9, {
   3.8859766273930984`*^9, 3.885976705321181*^9}, {3.885977079657692*^9, 
   3.8859771107489624`*^9}, 3.885977602788784*^9, {3.885979327503832*^9, 
   3.885979350000666*^9}, {3.8859793893365097`*^9, 3.8859794164248023`*^9}, {
   3.885979462547427*^9, 3.8859794743961115`*^9}, {3.8859797044283705`*^9, 
   3.8859797993350043`*^9}, {3.885979917813003*^9, 3.885979931062524*^9}, {
   3.8859800636906133`*^9, 3.8859800779593983`*^9}, 3.885980312698554*^9, {
   3.8859804016551037`*^9, 3.8859804126591787`*^9}, 3.8859805640552745`*^9, {
   3.885980715872667*^9, 3.8859807602126627`*^9}, {3.8860618090326586`*^9, 
   3.886061895699357*^9}, {3.8860622756094923`*^9, 3.8860623347401624`*^9}, 
   3.8860629092400513`*^9, {3.886152285047185*^9, 3.8861523259663725`*^9}, 
   3.8861523762490544`*^9, 3.888310979206479*^9, {3.888311255213608*^9, 
   3.888311282957345*^9}, 3.8890022856520777`*^9, 3.889060337400128*^9, 
   3.889064570327097*^9, 3.8890819151049967`*^9, 3.889082751667604*^9, 
   3.889084481475959*^9, 3.889504256968684*^9, 3.8895154808895187`*^9, 
   3.8895155265896363`*^9, {3.8896687737857976`*^9, 3.8896687838826714`*^9}, 
   3.8896725629108257`*^9, {3.8896761751473627`*^9, 3.889676192632434*^9}, 
   3.889676249961451*^9, {3.8896763044816694`*^9, 3.8896763296834364`*^9}, {
   3.890203672586771*^9, 3.8902037015966415`*^9}, 3.8902037493461847`*^9, 
   3.8902037965747986`*^9, {3.890216658915124*^9, 3.8902167333765697`*^9}, {
   3.890216774140562*^9, 3.890216809078682*^9}, {3.8902174567679343`*^9, 
   3.8902174874612885`*^9}, 3.890217766852687*^9, 3.8909816129922285`*^9, 
   3.890981659451852*^9, {3.890982631522698*^9, 3.890982655851638*^9}, {
   3.890982726501892*^9, 3.8909827519660463`*^9}, 3.891416093072353*^9, 
   3.89149730439897*^9, 3.891497334536474*^9, {3.891497375192842*^9, 
   3.8914973992304735`*^9}, 3.8914975640870247`*^9, {3.8914981450974956`*^9, 
   3.8914982596763473`*^9}, 3.8914983355783367`*^9, 3.891498513742013*^9, 
   3.891498617526591*^9, {3.891499166531208*^9, 3.8914992215412855`*^9}, {
   3.8914992677518625`*^9, 3.8914993140044193`*^9}, 3.8914994756905403`*^9, {
   3.891500348790775*^9, 3.891500400517855*^9}, 3.8915004676534395`*^9, {
   3.8915011176485977`*^9, 3.8915011820937757`*^9}, 3.8916962974248304`*^9, 
   3.8916964521350155`*^9},
 CellLabel->
  "Out[2829]=",ExpressionUUID->"cb51d055-bacf-4e15-a0cf-8093ba76c25c"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\ESRF\\\\Analysis\\\\2022-08_\
new_data\\\\Analysis\\\\Full form factor \
fit\\\\LH-ESRF-C22\\\\DataSubtracted.pdf\"\>"], "Output",
 CellChangeTimes->{{3.8527879438310833`*^9, 3.852787964921023*^9}, {
   3.8527880302138367`*^9, 3.8527880537745132`*^9}, 3.852788084697062*^9, {
   3.8527881270170593`*^9, 3.852788224333301*^9}, 3.85278831785238*^9, 
   3.852788361683811*^9, {3.852795206034478*^9, 3.852795268644823*^9}, {
   3.852795796660235*^9, 3.852795803347172*^9}, 3.852862499690114*^9, 
   3.853381367103548*^9, 3.853381477275778*^9, 3.8534022418114157`*^9, 
   3.853402534499599*^9, {3.853405270422613*^9, 3.853405324836055*^9}, 
   3.853405407395211*^9, {3.8534097505906153`*^9, 3.8534097703076878`*^9}, 
   3.853410187279647*^9, 3.8534102457215548`*^9, {3.853410571397106*^9, 
   3.853410595830978*^9}, 3.853469096590513*^9, 3.853469303037784*^9, 
   3.853496283640119*^9, 3.8534996296665163`*^9, 3.853817848440113*^9, 
   3.8538182517655993`*^9, 3.853824687596098*^9, 3.85382487471694*^9, 
   3.8538330798017387`*^9, 3.853836456463883*^9, {3.853836638285132*^9, 
   3.853836690462969*^9}, 3.853838543040962*^9, 3.854072558224156*^9, 
   3.854091678576386*^9, 3.8540984652252827`*^9, 3.8544207625736847`*^9, 
   3.854421344558304*^9, {3.8544214059054337`*^9, 3.854421491046699*^9}, 
   3.854423662477191*^9, 3.8601208220618477`*^9, 3.860120994483048*^9, 
   3.86012125099901*^9, 3.860140222318944*^9, 3.8601412086662254`*^9, 
   3.861763743975759*^9, 3.86176383617095*^9, {3.8617640582820826`*^9, 
   3.861764074747286*^9}, 3.8617641740186996`*^9, 3.861764274902935*^9, {
   3.8617643353175488`*^9, 3.861764372253722*^9}, {3.861764623510527*^9, 
   3.8617646348513403`*^9}, 3.8617647132308836`*^9, {3.861767375375707*^9, 
   3.861767457590822*^9}, 3.861941029316691*^9, 3.861950322744031*^9, 
   3.8636862718685603`*^9, 3.8636872310576773`*^9, 3.885975309403617*^9, {
   3.885975375253332*^9, 3.885975398991347*^9}, 3.885976450290474*^9, {
   3.8859766273930984`*^9, 3.885976705321181*^9}, {3.885977079657692*^9, 
   3.8859771107489624`*^9}, 3.885977602788784*^9, {3.885979327503832*^9, 
   3.885979350000666*^9}, {3.8859793893365097`*^9, 3.8859794164248023`*^9}, {
   3.885979462547427*^9, 3.8859794743961115`*^9}, {3.8859797044283705`*^9, 
   3.8859797993350043`*^9}, {3.885979917813003*^9, 3.885979931062524*^9}, {
   3.8859800636906133`*^9, 3.8859800779593983`*^9}, 3.885980312698554*^9, {
   3.8859804016551037`*^9, 3.8859804126591787`*^9}, 3.8859805640552745`*^9, {
   3.885980715872667*^9, 3.8859807602126627`*^9}, {3.8860618090326586`*^9, 
   3.886061895699357*^9}, {3.8860622756094923`*^9, 3.8860623347401624`*^9}, 
   3.8860629092400513`*^9, {3.886152285047185*^9, 3.8861523259663725`*^9}, 
   3.8861523762490544`*^9, 3.888310979206479*^9, {3.888311255213608*^9, 
   3.888311282957345*^9}, 3.8890022856520777`*^9, 3.889060337400128*^9, 
   3.889064570327097*^9, 3.8890819151049967`*^9, 3.889082751667604*^9, 
   3.889084481475959*^9, 3.889504256968684*^9, 3.8895154808895187`*^9, 
   3.8895155265896363`*^9, {3.8896687737857976`*^9, 3.8896687838826714`*^9}, 
   3.8896725629108257`*^9, {3.8896761751473627`*^9, 3.889676192632434*^9}, 
   3.889676249961451*^9, {3.8896763044816694`*^9, 3.8896763296834364`*^9}, {
   3.890203672586771*^9, 3.8902037015966415`*^9}, 3.8902037493461847`*^9, 
   3.8902037965747986`*^9, {3.890216658915124*^9, 3.8902167333765697`*^9}, {
   3.890216774140562*^9, 3.890216809078682*^9}, {3.8902174567679343`*^9, 
   3.8902174874612885`*^9}, 3.890217766852687*^9, 3.8909816129922285`*^9, 
   3.890981659451852*^9, {3.890982631522698*^9, 3.890982655851638*^9}, {
   3.890982726501892*^9, 3.8909827519660463`*^9}, 3.891416093072353*^9, 
   3.89149730439897*^9, 3.891497334536474*^9, {3.891497375192842*^9, 
   3.8914973992304735`*^9}, 3.8914975640870247`*^9, {3.8914981450974956`*^9, 
   3.8914982596763473`*^9}, 3.8914983355783367`*^9, 3.891498513742013*^9, 
   3.891498617526591*^9, {3.891499166531208*^9, 3.8914992215412855`*^9}, {
   3.8914992677518625`*^9, 3.8914993140044193`*^9}, 3.8914994756905403`*^9, {
   3.891500348790775*^9, 3.891500400517855*^9}, 3.8915004676534395`*^9, {
   3.8915011176485977`*^9, 3.8915011820937757`*^9}, 3.8916962974248304`*^9, 
   3.8916964550335894`*^9},
 CellLabel->
  "Out[2830]=",ExpressionUUID->"ff038d06-751a-472d-b4c2-4bb28f7db318"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Merge", " ", 
    RowBox[{"(", "relevant", ")"}], " ", "patterns"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Usually", " ", "we", " ", "only", " ", "merge", " ", "pattern", " ", "2",
      " ", "and", " ", "3"}], ",", " ", 
    RowBox[{
    "but", " ", "sometimes", " ", "we", " ", "also", " ", "use", " ", "1", 
     " ", "when", " ", "2", " ", "contains", " ", "a", " ", "weird", " ", 
     "kink", " ", "or", " ", "noise", " ", "etc"}]}], " ", "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"only", " ", "pattern", " ", "2", " ", "and", " ", "3"}], " ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"datamerged", "=", 
     RowBox[{"mergeData", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Select", "[", 
        RowBox[{
         RowBox[{"dataToAnalyze", "[", 
          RowBox[{"[", "2", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"0", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "0.1"}], "&"}]}], "]"}], ",",
        " ", 
       RowBox[{"(*", " ", 
        RowBox[{
         RowBox[{"default", ":", " ", 
          RowBox[{"0", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "0.5"}]}], "&"}], " ", 
        "*)"}], "\[IndentingNewLine]", 
       RowBox[{"Select", "[", 
        RowBox[{
         RowBox[{"dataToAnalyze", "[", 
          RowBox[{"[", "3", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"0.06", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "2"}], "&"}]}], "]"}]}], " ", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{"default", ":", " ", 
         RowBox[{"0.2", "<", 
          RowBox[{"#", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "<", "2"}]}], "&"}], " ", "*)"}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"only", " ", "pattern", " ", "1", " ", "and", " ", "3"}], " ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"datamerged", "=", 
     RowBox[{"mergeData", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Select", "[", 
        RowBox[{
         RowBox[{"dataToAnalyze", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"0", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "0.1"}], "&"}]}], "]"}], ",",
        " ", 
       RowBox[{"(*", " ", 
        RowBox[{
         RowBox[{"default", ":", " ", 
          RowBox[{"0", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "0.5"}]}], "&"}], " ", 
        "*)"}], "\[IndentingNewLine]", 
       RowBox[{"Select", "[", 
        RowBox[{
         RowBox[{"dataToAnalyze", "[", 
          RowBox[{"[", "3", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"0.06", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "2"}], "&"}]}], "]"}]}], " ", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{"default", ":", " ", 
         RowBox[{"0.2", "<", 
          RowBox[{"#", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "<", "2"}]}], "&"}], " ", "*)"}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Sequential", " ", "merging", " ", "of", " ", "first", " ", "pattern", 
     " ", "1"}], " ", "+", " ", 
    RowBox[{"2", " ", "and", " ", "then", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "2"}], ")"}]}], " ", "+", " ", "3"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"datamerged1", "=", 
     RowBox[{"mergeData", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Select", "[", 
        RowBox[{
         RowBox[{"dataToAnalyze", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"0.005", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "0.2"}], "&"}]}], "]"}], ",", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"default", ":", 
          RowBox[{"0", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "0.5"}]}], "&"}], "*)"}], 
       " ", 
       RowBox[{"(*", " ", 
        RowBox[{"0.005", "<", 
         RowBox[{"#", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "<", "0.2"}], " ", "*)"}], " ", 
       RowBox[{"(*", " ", 
        RowBox[{"0.02", "<", 
         RowBox[{"#", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "<", "0.2"}], " ", "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"Select", "[", 
        RowBox[{
         RowBox[{"dataToAnalyze", "[", 
          RowBox[{"[", "2", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"0.01", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "0.4"}], "&"}]}], "]"}]}], 
      " ", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"default", ":", 
         RowBox[{"0.2", "<", 
          RowBox[{"#", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "<", "2"}]}], "&"}], "*)"}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"datamerged", "=", 
     RowBox[{"mergeData", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Select", "[", 
        RowBox[{"datamerged1", ",", 
         RowBox[{
          RowBox[{"0", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "0.3"}], "&"}]}], "]"}], ",", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"default", ":", 
          RowBox[{"0", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "0.5"}]}], "&"}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"Select", "[", 
        RowBox[{
         RowBox[{"dataToAnalyze", "[", 
          RowBox[{"[", "3", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"0.05", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "0.4"}], "&"}]}], "]"}]}], 
      " ", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"default", ":", 
         RowBox[{"0.2", "<", 
          RowBox[{"#", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "<", "2"}]}], "&"}], "*)"}], " ", 
      RowBox[{"(*", " ", 
       RowBox[{"0.05", "<", 
        RowBox[{"#", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "<", "1"}], " ", "*)"}], " ", 
      RowBox[{"(*", " ", 
       RowBox[{"0.05", "<", 
        RowBox[{"#", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "<", "0.7"}], " ", "*)"}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"ListLogLogPlot", "[", "\[IndentingNewLine]", 
    RowBox[{"datamerged1", ",", "\[IndentingNewLine]", 
     RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
     RowBox[{"FrameTicks", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
          RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"Automatic", ",", 
          RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",", 
     " ", 
     RowBox[{"(*", " ", 
      RowBox[{
      "only", " ", "works", " ", "with", " ", "PowerTicks", " ", "function", 
       " ", "defined", " ", "in", " ", "polydisp", " ", "fitting", " ", 
       "functions", " ", "file"}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"LabelStyle", "\[Rule]", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
       "}"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"FrameLabel", " ", "->", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\"\<Intensity [a.u.]\>\"", ",", " ", "None"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
         "\"\<\!\(\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
       "}"}]}]}], "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"plotDataMerged", " ", "=", " ", 
    RowBox[{"ListLogLogPlot", "[", "\[IndentingNewLine]", 
     RowBox[{"datamerged", ",", "\[IndentingNewLine]", 
      RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameTicks", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",",
       " ", 
      RowBox[{"(*", " ", 
       RowBox[{
       "only", " ", "works", " ", "with", " ", "PowerTicks", " ", "function", 
        " ", "defined", " ", "in", " ", "polydisp", " ", "fitting", " ", 
        "functions", " ", "file"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", " ", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\"\<Intensity [a.u.]\>\"", ",", " ", "None"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
        "}"}]}]}], "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
        "\"\<DataMerged.pdf\>\""}], "}"}], "]"}], ",", "plotDataMerged"}], 
    " ", "]"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Bin", " ", "data"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"datamergedbinned", "=", 
     RowBox[{"binData", "[", 
      RowBox[{"datamerged", ",", "0.05"}], "]"}]}], ";"}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{"default", ":", " ", "0.05"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"plotDataBinned", " ", "=", " ", 
    RowBox[{"ListLogLogPlot", "[", "\[IndentingNewLine]", 
     RowBox[{"datamergedbinned", ",", "\[IndentingNewLine]", 
      RowBox[{"Joined", "\[Rule]", "False"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameTicks", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",",
       " ", 
      RowBox[{"(*", " ", 
       RowBox[{
       "only", " ", "works", " ", "with", " ", "PowerTicks", " ", "function", 
        " ", "defined", " ", "in", " ", "polydisp", " ", "fitting", " ", 
        "functions", " ", "file"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", " ", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\"\<Intensity [a.u.]\>\"", ",", " ", "None"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
        "}"}]}]}], "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
        "\"\<DataMergedBinned.pdf\>\""}], "}"}], "]"}], ",", 
     "plotDataBinned"}], " ", "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Export", " ", "merged", " ", "and", " ", "binned", " ", "data", " ", 
     RowBox[{"(", 
      RowBox[{
      "for", " ", "plotting", " ", "in", " ", "Python", " ", "or", " ", 
       "other", " ", "software"}], ")"}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"exportlist", " ", "=", " ", 
     RowBox[{"exportData", "[", "datamergedbinned", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Export", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", "\[IndentingNewLine]", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"FileBaseName", "[", 
          RowBox[{"NotebookFileName", "[", "]"}], "]"}], "<>", 
         "\"\< SAXS data merged and binned.csv\>\""}]}], 
       "\[IndentingNewLine]", "}"}], "\[IndentingNewLine]", "]"}], ",", 
     "\[IndentingNewLine]", "exportlist"}], "\[IndentingNewLine]", 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.854423668689094*^9, 3.854423681960602*^9}, {
   3.8601210812169123`*^9, 3.8601211773702602`*^9}, {3.860121220142*^9, 
   3.860121220876803*^9}, {3.860121492525386*^9, 3.8601215079101877`*^9}, {
   3.860121718604267*^9, 3.8601217659879427`*^9}, {3.860121814486486*^9, 
   3.860121940090294*^9}, {3.860121990307417*^9, 3.860122029773138*^9}, {
   3.86012227550008*^9, 3.860122412026474*^9}, {3.860123590194846*^9, 
   3.8601236144362907`*^9}, 3.8601236508219957`*^9, {3.860139958454444*^9, 
   3.8601400142502003`*^9}, {3.8601409041122975`*^9, 
   3.8601409737863803`*^9}, {3.860141247131112*^9, 3.8601412486662936`*^9}, 
   3.860141363728487*^9, {3.861764464753133*^9, 3.8617644999883156`*^9}, {
   3.8617650690038815`*^9, 3.861765107161731*^9}, {3.8617654080879517`*^9, 
   3.8617654464808097`*^9}, {3.8617667857822647`*^9, 3.861766817572381*^9}, {
   3.861767478263466*^9, 3.8617674824174633`*^9}, {3.8617675156782837`*^9, 
   3.8617675385223627`*^9}, {3.861767600750394*^9, 3.8617678801582737`*^9}, {
   3.861768004639906*^9, 3.861768004842128*^9}, {3.8617680471976347`*^9, 
   3.8617680542883253`*^9}, 3.8617682512241673`*^9, {3.8619408859545107`*^9, 
   3.8619408879723635`*^9}, 3.8619500601432023`*^9, {3.8859755937637935`*^9, 
   3.8859756289602833`*^9}, {3.8859767824682684`*^9, 
   3.8859768072202587`*^9}, {3.885976912247283*^9, 3.885976915489427*^9}, {
   3.885977184321333*^9, 3.8859771875417037`*^9}, {3.8859772431391516`*^9, 
   3.8859772459190493`*^9}, {3.8859776946505795`*^9, 3.885977697414628*^9}, {
   3.885977754450777*^9, 3.8859777568929634`*^9}, {3.8859804425147095`*^9, 
   3.8859804438235583`*^9}, 3.8859804753994827`*^9, {3.8859807731997614`*^9, 
   3.885980782688805*^9}, 3.8860629984459877`*^9, {3.886063060466019*^9, 
   3.8860631273919067`*^9}, {3.886071125028043*^9, 3.8860711896934166`*^9}, {
   3.8860714254613867`*^9, 3.8860714550837*^9}, {3.8895154616447597`*^9, 
   3.8895154658794193`*^9}, {3.8896724114246473`*^9, 3.889672412507053*^9}, {
   3.889672471225835*^9, 3.8896725071452694`*^9}, {3.889674589350315*^9, 
   3.889674633174043*^9}, {3.889674670910601*^9, 3.889674765787591*^9}, {
   3.8896748131059356`*^9, 3.889674848516157*^9}, {3.8896748918371353`*^9, 
   3.8896749698660383`*^9}, {3.8896759808235216`*^9, 
   3.8896760211101522`*^9}, {3.8896760618397036`*^9, 3.889676134804789*^9}, {
   3.8896766120107994`*^9, 3.8896766124494815`*^9}, {3.889676755304323*^9, 
   3.889676755581999*^9}, {3.8902038545244083`*^9, 3.890203901273981*^9}, {
   3.890205930477414*^9, 3.8902059314228735`*^9}, {3.8902102550185256`*^9, 
   3.890210255342898*^9}, 3.8902167482021494`*^9, {3.8902168284956217`*^9, 
   3.89021682871568*^9}, {3.890216868216955*^9, 3.8902168763206763`*^9}, {
   3.8902172079856234`*^9, 3.8902172082346754`*^9}, {3.890981726002406*^9, 
   3.890981786213588*^9}, {3.8909822356137176`*^9, 3.8909822357713594`*^9}, {
   3.8914985305692663`*^9, 3.8914985803250184`*^9}, {3.8914993555058784`*^9, 
   3.8914993557443776`*^9}, {3.891501044318815*^9, 3.89150105671945*^9}, {
   3.8915010923443475`*^9, 3.8915010926951523`*^9}, 3.8915012837841167`*^9, {
   3.8916963626347637`*^9, 3.8916963628007703`*^9}, {3.8916963966914325`*^9, 
   3.891696407693929*^9}},
 CellLabel->
  "In[2831]:=",ExpressionUUID->"5b3c3b75-f6f9-43b4-ae93-bf843c1633be"],

Cell[BoxData[
 TemplateBox[{
  "FindMinimum", "lstol", 
   "\"The line search decreased the step size to within the tolerance \
specified by AccuracyGoal and PrecisionGoal but was unable to find a \
sufficient decrease in the function. You may need more than \\!\\(\\*RowBox[{\
\\\"MachinePrecision\\\"}]\\) digits of working precision to meet these \
tolerances.\"", 2, 2831, 304, 18413233985661327353, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{
  3.891499325347288*^9, 3.891499357139942*^9, 3.8914994806722035`*^9, 
   3.8915004125864553`*^9, 3.891500472803057*^9, {3.8915010454855137`*^9, 
   3.891501057628954*^9}, 3.8915012847188373`*^9, 3.891696300822322*^9, 
   3.8916963641046886`*^9, 3.8916964126685753`*^9, 3.8916964655014005`*^9},
 CellLabel->
  "During evaluation of \
In[2831]:=",ExpressionUUID->"0370cf59-8b49-4d9c-aefd-2cf92ede1f81"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
     0.0055000000000000005`], AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJwVWnk41N8XHjOWMWOZJYQokbIrREozSbSiqOxpo1SUtb6hpChKWpQoLUiy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      "]]}}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{-5.45475628582696, -5.551600997958461},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox["\"Intensity [a.u.]\"", HoldForm], TraditionalForm], None}, {
     FormBox[
      TagBox[
      "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) \
[\\!\\(\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], 
      TraditionalForm], None}},
  FrameTicks->FrontEndValueCache[{{{{-6.907755278982137, 
        FormBox[
         TemplateBox[{"10", 
           RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
         TraditionalForm]}, {-4.605170185988092, 
        FormBox[
         TemplateBox[{"10", 
           RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
         TraditionalForm]}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{"10", 
           RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
         TraditionalForm]}, {0, 
        FormBox[
         TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> 
          SuperscriptBox], TraditionalForm]}, {2.302585092994046, 
        FormBox[
         TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> 
          SuperscriptBox], TraditionalForm]}, {4.605170185988092, 
        FormBox[
         TemplateBox[{"10", "2"}, "Superscript", SyntaxForm -> 
          SuperscriptBox], TraditionalForm]}, {-6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.809142990314028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.521460917862246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.115995809754082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.961845129926823, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.8283137373023015`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.710530701645918, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.407945608651872, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.9162907318741551, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.3566749439387324, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.22314355131420976`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.10536051565782635`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.0943445622221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.248495242049359, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.382026634673881, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.499809670330265, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.703782474656201, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.991464547107982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.396929655216146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.551080335043404, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.684611727667927, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.802394763324311, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}}, {{-6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], 
         TraditionalForm]}, {-4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], 
         TraditionalForm]}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], 
         TraditionalForm]}, {-6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.809142990314028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.521460917862246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.115995809754082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.961845129926823, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.8283137373023015`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.710530701645918, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.407945608651872, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.9162907318741551, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.3566749439387324, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.22314355131420976`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.10536051565782635`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.0943445622221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.248495242049359, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.382026634673881, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.499809670330265, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.703782474656201, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.991464547107982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.396929655216146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.551080335043404, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.684611727667927, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.802394763324311, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}}}, {
      Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
       15.954589770191003`, RotateLabel -> 0], {{-6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], 
         TraditionalForm]}, {-4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], 
         TraditionalForm]}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], 
         TraditionalForm]}, {-6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.809142990314028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.521460917862246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.115995809754082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.961845129926823, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.8283137373023015`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.710530701645918, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.407945608651872, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.9162907318741551, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.3566749439387324, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.22314355131420976`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.10536051565782635`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}}}}, {{{{-6.907755278982137, 
        FormBox[
         TemplateBox[{"10", 
           RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
         TraditionalForm]}, {-4.605170185988092, 
        FormBox[
         TemplateBox[{"10", 
           RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
         TraditionalForm]}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{"10", 
           RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
         TraditionalForm]}, {0, 
        FormBox[
         TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> 
          SuperscriptBox], TraditionalForm]}, {2.302585092994046, 
        FormBox[
         TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> 
          SuperscriptBox], TraditionalForm]}, {4.605170185988092, 
        FormBox[
         TemplateBox[{"10", "2"}, "Superscript", SyntaxForm -> 
          SuperscriptBox], TraditionalForm]}, {-6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.809142990314028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.521460917862246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.115995809754082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.961845129926823, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.8283137373023015`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.710530701645918, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.407945608651872, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.9162907318741551, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.3566749439387324, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.22314355131420976`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.10536051565782635`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.0943445622221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.248495242049359, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.382026634673881, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.499809670330265, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.703782474656201, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.991464547107982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.396929655216146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.551080335043404, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.684611727667927, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.802394763324311, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}}, {{-6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], 
         TraditionalForm]}, {-4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], 
         TraditionalForm]}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], 
         TraditionalForm]}, {-6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.809142990314028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.521460917862246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.115995809754082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.961845129926823, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.8283137373023015`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.710530701645918, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.407945608651872, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.9162907318741551, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.3566749439387324, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.22314355131420976`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.10536051565782635`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.0943445622221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.248495242049359, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.382026634673881, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.499809670330265, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.703782474656201, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.991464547107982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.396929655216146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.551080335043404, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.684611727667927, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.802394763324311, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}}}, {{{-5.298317366548036, 
        FormBox[
         TagBox[
          InterpretationBox[
           StyleBox["\"0.005\"", ShowStringCharacters -> False], 
           0.005`15.954589770191003, AutoDelete -> True], NumberForm[#, {
            DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 
        0.}}, {-4.605170185988091, 
        FormBox[
         TagBox[
          InterpretationBox[
           StyleBox["\"0.010\"", ShowStringCharacters -> False], 
           0.01`15.954589770191003, AutoDelete -> True], NumberForm[#, {
            DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 
        0.}}, {-2.995732273553991, 
        FormBox[
         TagBox[
          InterpretationBox[
           StyleBox["\"0.050\"", ShowStringCharacters -> False], 
           0.05`15.954589770191003, AutoDelete -> True], NumberForm[#, {
            DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 
        0.}}, {-2.3025850929940455`, 
        FormBox[
         TagBox[
          InterpretationBox[
           StyleBox["\"0.100\"", ShowStringCharacters -> False], 
           0.1`15.954589770191003, AutoDelete -> True], NumberForm[#, {
            DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 
        0.}}, {-6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.809142990314028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.521460917862246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.115995809754082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.961845129926823, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.8283137373023015`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.710530701645918, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.4079456086518722`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.916290731874155, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.35667494393873245`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.2231435513142097, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.10536051565782628`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {0., 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}}, {{-6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], 
         TraditionalForm]}, {-4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], 
         TraditionalForm]}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], 
         TraditionalForm]}, {-6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.809142990314028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.521460917862246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.115995809754082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.961845129926823, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.8283137373023015`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.710530701645918, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.407945608651872, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.9162907318741551, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.3566749439387324, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.22314355131420976`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.10536051565782635`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}}}}],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  LabelStyle->{FontSize -> 14, 
    GrayLevel[0]},
  Method->{
   "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& )}},
  PlotRange->{{-5.45475628582696, -0.9167189189931146}, {-5.551600997958461, 
   3.6747886958492257`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0], 
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0]}]], "Output",
 CellChangeTimes->{
  3.860121940449121*^9, {3.8601219909814587`*^9, 3.8601219988911247`*^9}, 
   3.8601220305416183`*^9, {3.860122288162386*^9, 3.860122319486766*^9}, {
   3.860122357383444*^9, 3.860122415048162*^9}, 3.8601236448414707`*^9, 
   3.860123678830523*^9, 3.8601409845329585`*^9, 3.8601412163576555`*^9, 
   3.8601413747528563`*^9, 3.86176442550534*^9, 3.861764508178524*^9, 
   3.861764647876793*^9, 3.8617647988763914`*^9, {3.8617650704595146`*^9, 
   3.8617651079871264`*^9}, 3.861765409439147*^9, 3.8617654499851933`*^9, {
   3.861766787669303*^9, 3.8617668184387875`*^9}, {3.861767630673935*^9, 
   3.861767650165983*^9}, 3.861767840576668*^9, {3.8617678717452784`*^9, 
   3.8617678816675997`*^9}, 3.8617680171083403`*^9, {3.8617680479968414`*^9, 
   3.8617680548824015`*^9}, 3.8617682519250493`*^9, 3.861941029901291*^9, 
   3.8619500639728465`*^9, 3.861950323504904*^9, 3.863686272586315*^9, 
   3.8636872317935305`*^9, 3.885975634223706*^9, 3.885976810854197*^9, 
   3.885976922495121*^9, 3.8859771898386564`*^9, 3.885977254405377*^9, 
   3.8859776985071163`*^9, 3.8859777591377735`*^9, 3.8859795032705593`*^9, 
   3.885980141889553*^9, 3.8859804453711944`*^9, 3.8859806226937556`*^9, 
   3.8859807856447215`*^9, {3.8860631041737103`*^9, 3.886063131011697*^9}, {
   3.8860711788656583`*^9, 3.8860711903529096`*^9}, 3.8860714565699263`*^9, {
   3.886152356693725*^9, 3.886152379601023*^9}, 3.888310979615314*^9, 
   3.888311304522476*^9, 3.889002297204956*^9, 3.889060341097105*^9, 
   3.88906457053371*^9, 3.889081915278277*^9, 3.889082751832595*^9, 
   3.8890844816819963`*^9, 3.8895042732162266`*^9, 3.8895154687124505`*^9, 
   3.889668789180977*^9, 3.8896725087091503`*^9, 3.8896746341294947`*^9, {
   3.88967467876441*^9, 3.8896746953717566`*^9}, {3.889674754509908*^9, 
   3.8896747662462883`*^9}, 3.889674833427221*^9, 3.8896749045918837`*^9, {
   3.889676076787506*^9, 3.8896761358772745`*^9}, 3.889676612828989*^9, 
   3.889676756265704*^9, 3.8902038192855253`*^9, {3.890203856897176*^9, 
   3.890203902283286*^9}, 3.8902059339417963`*^9, 3.8902102574150095`*^9, 
   3.8902167504968033`*^9, 3.8902168293738966`*^9, {3.890216870017076*^9, 
   3.890216876660765*^9}, 3.8902172119334965`*^9, 3.8902178180211363`*^9, 
   3.8909817030480986`*^9, 3.8909818035906286`*^9, 3.8909822364544888`*^9, 
   3.890982755046166*^9, 3.891416112682912*^9, 3.891497436223301*^9, 
   3.8914975686949873`*^9, {3.891498532036313*^9, 3.8914985683451767`*^9}, 
   3.891498623092783*^9, 3.891499326018267*^9, 3.891499357538082*^9, 
   3.8914994810548916`*^9, 3.8915004132235947`*^9, 3.89150047307273*^9, {
   3.891501045822155*^9, 3.891501057968319*^9}, 3.8915012850547023`*^9, 
   3.8916963011787567`*^9, 3.891696364294973*^9, 3.8916964128455863`*^9, 
   3.8916964657038717`*^9},
 CellLabel->
  "Out[2833]=",ExpressionUUID->"f05faab0-26e2-4da9-b6d8-8c76589f1dbb"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.007333333333333334], 
     AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJwVl2k41H8bxccw+wxjxpL+lhZLCCXZ9fsRpZSdlCW0CklEi5QWiihK2UIo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      "]]}}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{-5.454578429743322, -5.546216954219008},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox["\"Intensity [a.u.]\"", HoldForm], TraditionalForm], None}, {
     FormBox[
      TagBox[
      "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) \
[\\!\\(\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], 
      TraditionalForm], None}},
  FrameTicks->{{{{
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox[
        TemplateBox[{"10", "2"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500], -6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 3]], -5.809142990314028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250], -5.521460917862246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200], -5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500, 3]], -5.115995809754082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 7]], -4.961845129926823], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125], -4.8283137373023015`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 9]], -4.710530701645918], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[20], 2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[30], 3.4011973816621555`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[40], 3.6888794541139363`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[50], 3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[60], 4.0943445622221], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[70], 4.248495242049359], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[80], 4.382026634673881], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[90], 4.499809670330265], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[200], 5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[300], 5.703782474656201], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[400], 5.991464547107982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[500], 6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[600], 6.396929655216146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[700], 6.551080335043404], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[800], 6.684611727667927], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[900], 6.802394763324311], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}, {{
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500], -6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 3]], -5.809142990314028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250], -5.521460917862246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200], -5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500, 3]], -5.115995809754082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 7]], -4.961845129926823], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125], -4.8283137373023015`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 9]], -4.710530701645918], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[20], 2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[30], 3.4011973816621555`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[40], 3.6888794541139363`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[50], 3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[60], 4.0943445622221], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[70], 4.248495242049359], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[80], 4.382026634673881], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[90], 4.499809670330265], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[200], 5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[300], 5.703782474656201], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[400], 5.991464547107982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[500], 6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[600], 6.396929655216146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[700], 6.551080335043404], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[800], 6.684611727667927], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[900], 6.802394763324311], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}}, {{{
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500], -6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 3]], -5.809142990314028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250], -5.521460917862246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200], -5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500, 3]], -5.115995809754082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 7]], -4.961845129926823], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125], -4.8283137373023015`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 9]], -4.710530701645918], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}, {{
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500], -6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 3]], -5.809142990314028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250], -5.521460917862246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200], -5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500, 3]], -5.115995809754082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 7]], -4.961845129926823], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125], -4.8283137373023015`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 9]], -4.710530701645918], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  LabelStyle->{FontSize -> 14, 
    GrayLevel[0]},
  Method->{
   "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& )}},
  PlotRange->{{-5.454578429743322, -0.920943459371443}, {-5.546216954219008, 
   3.6747886958492257`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0], 
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0]}]], "Output",
 CellChangeTimes->{
  3.860121940449121*^9, {3.8601219909814587`*^9, 3.8601219988911247`*^9}, 
   3.8601220305416183`*^9, {3.860122288162386*^9, 3.860122319486766*^9}, {
   3.860122357383444*^9, 3.860122415048162*^9}, 3.8601236448414707`*^9, 
   3.860123678830523*^9, 3.8601409845329585`*^9, 3.8601412163576555`*^9, 
   3.8601413747528563`*^9, 3.86176442550534*^9, 3.861764508178524*^9, 
   3.861764647876793*^9, 3.8617647988763914`*^9, {3.8617650704595146`*^9, 
   3.8617651079871264`*^9}, 3.861765409439147*^9, 3.8617654499851933`*^9, {
   3.861766787669303*^9, 3.8617668184387875`*^9}, {3.861767630673935*^9, 
   3.861767650165983*^9}, 3.861767840576668*^9, {3.8617678717452784`*^9, 
   3.8617678816675997`*^9}, 3.8617680171083403`*^9, {3.8617680479968414`*^9, 
   3.8617680548824015`*^9}, 3.8617682519250493`*^9, 3.861941029901291*^9, 
   3.8619500639728465`*^9, 3.861950323504904*^9, 3.863686272586315*^9, 
   3.8636872317935305`*^9, 3.885975634223706*^9, 3.885976810854197*^9, 
   3.885976922495121*^9, 3.8859771898386564`*^9, 3.885977254405377*^9, 
   3.8859776985071163`*^9, 3.8859777591377735`*^9, 3.8859795032705593`*^9, 
   3.885980141889553*^9, 3.8859804453711944`*^9, 3.8859806226937556`*^9, 
   3.8859807856447215`*^9, {3.8860631041737103`*^9, 3.886063131011697*^9}, {
   3.8860711788656583`*^9, 3.8860711903529096`*^9}, 3.8860714565699263`*^9, {
   3.886152356693725*^9, 3.886152379601023*^9}, 3.888310979615314*^9, 
   3.888311304522476*^9, 3.889002297204956*^9, 3.889060341097105*^9, 
   3.88906457053371*^9, 3.889081915278277*^9, 3.889082751832595*^9, 
   3.8890844816819963`*^9, 3.8895042732162266`*^9, 3.8895154687124505`*^9, 
   3.889668789180977*^9, 3.8896725087091503`*^9, 3.8896746341294947`*^9, {
   3.88967467876441*^9, 3.8896746953717566`*^9}, {3.889674754509908*^9, 
   3.8896747662462883`*^9}, 3.889674833427221*^9, 3.8896749045918837`*^9, {
   3.889676076787506*^9, 3.8896761358772745`*^9}, 3.889676612828989*^9, 
   3.889676756265704*^9, 3.8902038192855253`*^9, {3.890203856897176*^9, 
   3.890203902283286*^9}, 3.8902059339417963`*^9, 3.8902102574150095`*^9, 
   3.8902167504968033`*^9, 3.8902168293738966`*^9, {3.890216870017076*^9, 
   3.890216876660765*^9}, 3.8902172119334965`*^9, 3.8902178180211363`*^9, 
   3.8909817030480986`*^9, 3.8909818035906286`*^9, 3.8909822364544888`*^9, 
   3.890982755046166*^9, 3.891416112682912*^9, 3.891497436223301*^9, 
   3.8914975686949873`*^9, {3.891498532036313*^9, 3.8914985683451767`*^9}, 
   3.891498623092783*^9, 3.891499326018267*^9, 3.891499357538082*^9, 
   3.8914994810548916`*^9, 3.8915004132235947`*^9, 3.89150047307273*^9, {
   3.891501045822155*^9, 3.891501057968319*^9}, 3.8915012850547023`*^9, 
   3.8916963011787567`*^9, 3.891696364294973*^9, 3.8916964128455863`*^9, 
   3.891696466170102*^9},
 CellLabel->
  "Out[2834]=",ExpressionUUID->"1f9f8555-68d5-47c8-95c9-4f02fda9debb"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\ESRF\\\\Analysis\\\\2022-08_\
new_data\\\\Analysis\\\\Full form factor fit\\\\LH-ESRF-C22\\\\DataMerged.pdf\
\"\>"], "Output",
 CellChangeTimes->{
  3.860121940449121*^9, {3.8601219909814587`*^9, 3.8601219988911247`*^9}, 
   3.8601220305416183`*^9, {3.860122288162386*^9, 3.860122319486766*^9}, {
   3.860122357383444*^9, 3.860122415048162*^9}, 3.8601236448414707`*^9, 
   3.860123678830523*^9, 3.8601409845329585`*^9, 3.8601412163576555`*^9, 
   3.8601413747528563`*^9, 3.86176442550534*^9, 3.861764508178524*^9, 
   3.861764647876793*^9, 3.8617647988763914`*^9, {3.8617650704595146`*^9, 
   3.8617651079871264`*^9}, 3.861765409439147*^9, 3.8617654499851933`*^9, {
   3.861766787669303*^9, 3.8617668184387875`*^9}, {3.861767630673935*^9, 
   3.861767650165983*^9}, 3.861767840576668*^9, {3.8617678717452784`*^9, 
   3.8617678816675997`*^9}, 3.8617680171083403`*^9, {3.8617680479968414`*^9, 
   3.8617680548824015`*^9}, 3.8617682519250493`*^9, 3.861941029901291*^9, 
   3.8619500639728465`*^9, 3.861950323504904*^9, 3.863686272586315*^9, 
   3.8636872317935305`*^9, 3.885975634223706*^9, 3.885976810854197*^9, 
   3.885976922495121*^9, 3.8859771898386564`*^9, 3.885977254405377*^9, 
   3.8859776985071163`*^9, 3.8859777591377735`*^9, 3.8859795032705593`*^9, 
   3.885980141889553*^9, 3.8859804453711944`*^9, 3.8859806226937556`*^9, 
   3.8859807856447215`*^9, {3.8860631041737103`*^9, 3.886063131011697*^9}, {
   3.8860711788656583`*^9, 3.8860711903529096`*^9}, 3.8860714565699263`*^9, {
   3.886152356693725*^9, 3.886152379601023*^9}, 3.888310979615314*^9, 
   3.888311304522476*^9, 3.889002297204956*^9, 3.889060341097105*^9, 
   3.88906457053371*^9, 3.889081915278277*^9, 3.889082751832595*^9, 
   3.8890844816819963`*^9, 3.8895042732162266`*^9, 3.8895154687124505`*^9, 
   3.889668789180977*^9, 3.8896725087091503`*^9, 3.8896746341294947`*^9, {
   3.88967467876441*^9, 3.8896746953717566`*^9}, {3.889674754509908*^9, 
   3.8896747662462883`*^9}, 3.889674833427221*^9, 3.8896749045918837`*^9, {
   3.889676076787506*^9, 3.8896761358772745`*^9}, 3.889676612828989*^9, 
   3.889676756265704*^9, 3.8902038192855253`*^9, {3.890203856897176*^9, 
   3.890203902283286*^9}, 3.8902059339417963`*^9, 3.8902102574150095`*^9, 
   3.8902167504968033`*^9, 3.8902168293738966`*^9, {3.890216870017076*^9, 
   3.890216876660765*^9}, 3.8902172119334965`*^9, 3.8902178180211363`*^9, 
   3.8909817030480986`*^9, 3.8909818035906286`*^9, 3.8909822364544888`*^9, 
   3.890982755046166*^9, 3.891416112682912*^9, 3.891497436223301*^9, 
   3.8914975686949873`*^9, {3.891498532036313*^9, 3.8914985683451767`*^9}, 
   3.891498623092783*^9, 3.891499326018267*^9, 3.891499357538082*^9, 
   3.8914994810548916`*^9, 3.8915004132235947`*^9, 3.89150047307273*^9, {
   3.891501045822155*^9, 3.891501057968319*^9}, 3.8915012850547023`*^9, 
   3.8916963011787567`*^9, 3.891696364294973*^9, 3.8916964128455863`*^9, 
   3.8916964679415107`*^9},
 CellLabel->
  "Out[2835]=",ExpressionUUID->"7321a1de-888b-45e2-92a8-6b5e1ca280ea"],

Cell[BoxData[
 GraphicsBox[{{
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-5.256921585253977, 
         3.5397518956839704`}, {-5.256921585253977, 3.604132094984709}}], 
        LineBox[{{-5.256921585253977, 3.604132094984709}, {-5.256921585253977,
          3.6646170002438314`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-5.2005387488032095`, 
         3.6048786640720745`}, {-5.2005387488032095`, 3.640140914690889}}], 
        LineBox[{{-5.2005387488032095`, 
         3.640140914690889}, {-5.2005387488032095`, 3.6742019754307154`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-5.147166472619123, 3.581781543137103}, {-5.147166472619123,
          3.5893909934635593`}}], 
        LineBox[{{-5.147166472619123, 
         3.5893909934635593`}, {-5.147166472619123, 3.596942977070691}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-5.09649951504208, 3.5120668383168407`}, {-5.09649951504208,
          3.521193737759251}}], 
        LineBox[{{-5.09649951504208, 3.521193737759251}, {-5.09649951504208, 
         3.530238089742752}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-5.048276729473299, 
         3.5573057090810285`}, {-5.048276729473299, 3.5591532930179586`}}], 
        LineBox[{{-5.048276729473299, 
         3.5591532930179586`}, {-5.048276729473299, 3.5609974696827384`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-5.002273086667765, 
         3.4110281599282755`}, {-5.002273086667765, 3.415090054669025}}], 
        LineBox[{{-5.002273086667765, 3.415090054669025}, {-5.002273086667765,
          3.4191355171445204`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.94768844245325, 3.398002942217051}, {-4.94768844245325, 
         3.439562045699913}}], 
        LineBox[{{-4.94768844245325, 3.439562045699913}, {-4.94768844245325, 
         3.4794626852181265`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.895750762859643, 3.373631699395793}, {-4.895750762859643,
          3.379342219894325}}], 
        LineBox[{{-4.895750762859643, 3.379342219894325}, {-4.895750762859643,
          3.3850203154243257`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.846540574896795, 
         3.3059669777760763`}, {-4.846540574896795, 3.347204303535406}}], 
        LineBox[{{-4.846540574896795, 3.347204303535406}, {-4.846540574896795,
          3.386808246324671}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.7904256789098545`, 
         3.224790337620717}, {-4.7904256789098545`, 3.243782630682914}}], 
        LineBox[{{-4.7904256789098545`, 
         3.243782630682914}, {-4.7904256789098545`, 3.262420929273909}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.745892143749627, 3.196364669304279}, {-4.745892143749627,
          3.206201861889019}}], 
        LineBox[{{-4.745892143749627, 3.206201861889019}, {-4.745892143749627,
          3.215943226033385}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.703378855771098, 
         3.1041058541146422`}, {-4.703378855771098, 3.148617869222933}}], 
        LineBox[{{-4.703378855771098, 3.148617869222933}, {-4.703378855771098,
          3.1912327119454016`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.646735106032223, 
         3.0712169779794642`}, {-4.646735106032223, 3.08322421431034}}], 
        LineBox[{{-4.646735106032223, 3.08322421431034}, {-4.646735106032223, 
         3.0950889858341974`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.591895738572719, 3.020347010839881}, {-4.591895738572719,
          3.037808694406261}}], 
        LineBox[{{-4.591895738572719, 3.037808694406261}, {-4.591895738572719,
          3.0549706930981637`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.552199066800568, 2.963656587130923}, {-4.552199066800568,
          2.9653204133323903`}}], 
        LineBox[{{-4.552199066800568, 
         2.9653204133323903`}, {-4.552199066800568, 2.966981475813942}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.402042555761872, 2.72244068066137}, {-4.402042555761872, 
         2.754136987931702}}], 
        LineBox[{{-4.402042555761872, 2.754136987931702}, {-4.402042555761872,
          2.7848594282685513`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.2944436118375116`, 
         2.577286284783282}, {-4.2944436118375116`, 2.602916224742463}}], 
        LineBox[{{-4.2944436118375116`, 
         2.602916224742463}, {-4.2944436118375116`, 2.6279056529714993`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.19730843655865, 2.4179748591073955`}, {-4.19730843655865,
          2.441782594800428}}], 
        LineBox[{{-4.19730843655865, 2.441782594800428}, {-4.19730843655865, 
         2.465036677887166}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.137427702804738, 2.315959332545386}, {-4.137427702804738,
          2.343671380808747}}], 
        LineBox[{{-4.137427702804738, 2.343671380808747}, {-4.137427702804738,
          2.3706361339974746`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.053837356848126, 2.165842421846394}, {-4.053837356848126,
          2.1909513981672397`}}], 
        LineBox[{{-4.053837356848126, 
         2.1909513981672397`}, {-4.053837356848126, 2.2154453255248745`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.001756736202332, 2.084903073568404}, {-4.001756736202332,
          2.1095704565380244`}}], 
        LineBox[{{-4.001756736202332, 
         2.1095704565380244`}, {-4.001756736202332, 2.1336439793150426`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.9522551105228425`, 
         2.005135088937175}, {-3.9522551105228425`, 2.0244467143964133`}}], 
        LineBox[{{-3.9522551105228425`, 
         2.0244467143964133`}, {-3.9522551105228425`, 2.043392455641289}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.9050891681813837`, 
         1.9127673133692735`}, {-3.9050891681813837`, 1.9290771163444962`}}], 
        LineBox[{{-3.9050891681813837`, 
         1.9290771163444962`}, {-3.9050891681813837`, 1.9451251729689751`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.8491968474870055`, 
         1.7955157097387522`}, {-3.8491968474870055`, 1.8231843008970643`}}], 
        LineBox[{{-3.8491968474870055`, 
         1.8231843008970643`}, {-3.8491968474870055`, 1.8501079075449622`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.7960766508869286`, 
         1.7140577458013044`}, {-3.7960766508869286`, 1.7281837247729812`}}], 
        LineBox[{{-3.7960766508869286`, 
         1.7281837247729812`}, {-3.7960766508869286`, 1.7421129367626473`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.745806254138991, 1.60288585829783}, {-3.745806254138991, 
         1.6275611956688882`}}], 
        LineBox[{{-3.745806254138991, 
         1.6275611956688882`}, {-3.745806254138991, 1.6516422943806672`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.697789438310754, 
         1.5183357477190889`}, {-3.697789438310754, 1.5326306367790377`}}], 
        LineBox[{{-3.697789438310754, 
         1.5326306367790377`}, {-3.697789438310754, 1.54672405855588}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.652113025280155, 
         1.4175354154827882`}, {-3.652113025280155, 1.4386375294085572`}}], 
        LineBox[{{-3.652113025280155, 
         1.4386375294085572`}, {-3.652113025280155, 1.4593035311623632`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.5998413776538905`, 
         1.3163326023494604`}, {-3.5998413776538905`, 1.3346113193107039`}}], 
        LineBox[{{-3.5998413776538905`, 
         1.3346113193107039`}, {-3.5998413776538905`, 1.3525619134703617`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.550167336133954, 
         1.2025685185474397`}, {-3.550167336133954, 1.2273754157105985`}}], 
        LineBox[{{-3.550167336133954, 
         1.2273754157105985`}, {-3.550167336133954, 1.25158179759843}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.495239238732143, 
         1.0945094362283978`}, {-3.495239238732143, 1.1177323894276834`}}], 
        LineBox[{{-3.495239238732143, 
         1.1177323894276834`}, {-3.495239238732143, 1.1404282544651851`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.4430427535118717`, 
         0.9886915924450497}, {-3.4430427535118717`, 1.0072725744337234`}}], 
        LineBox[{{-3.4430427535118717`, 
         1.0072725744337234`}, {-3.4430427535118717`, 1.0255145922437388`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.393553721612056, 
         0.8814775491511848}, {-3.393553721612056, 0.9016734345226094}}], 
        LineBox[{{-3.393553721612056, 
         0.9016734345226094}, {-3.393553721612056, 0.9214695073561545}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.3462929219035455`, 
         0.7795802661389616}, {-3.3462929219035455`, 0.7961132157303615}}], 
        LineBox[{{-3.3462929219035455`, 
         0.7961132157303615}, {-3.3462929219035455`, 0.8123772665638503}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.3012624883237294`, 
         0.6777420451567227}, {-3.3012624883237294`, 0.6951574097964703}}], 
        LineBox[{{-3.3012624883237294`, 
         0.6951574097964703}, {-3.3012624883237294`, 0.7122746638104}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.246189753861999, 
         0.5573164232822041}, {-3.246189753861999, 0.576420727612332}}], 
        LineBox[{{-3.246189753861999, 0.576420727612332}, {-3.246189753861999,
          0.595166888884141}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.193891750599751, 
         0.4432901143363579}, {-3.193891750599751, 0.4606255483882618}}], 
        LineBox[{{-3.193891750599751, 
         0.4606255483882618}, {-3.193891750599751, 0.4776655788442987}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.144285378030157, 
         0.33455471793664765`}, {-3.144285378030157, 0.35362856407077714`}}], 
        LineBox[{{-3.144285378030157, 
         0.35362856407077714`}, {-3.144285378030157, 0.3723453975814112}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.0918603937501348`, 
         0.21715802265682782`}, {-3.0918603937501348`, 0.2331807279571788}}], 
        LineBox[{{-3.0918603937501348`, 
         0.2331807279571788}, {-3.0918603937501348`, 0.24895074952873233`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.0420479410377324`, 
         0.10835647877806767`}, {-3.0420479410377324`, 0.1243678383225542}}], 
        LineBox[{{-3.0420479410377324`, 
         0.1243678383225542}, {-3.0420479410377324`, 0.1401268690542818}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-2.9911660280620147`, 
         0.004465355551937933}, {-2.9911660280620147`, 0.02043618558319995}}],
         LineBox[{{-2.9911660280620147`, 
         0.02043618558319995}, {-2.9911660280620147`, 0.03615595263421664}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-2.944918614078745, -0.09427371024669369}, \
{-2.944918614078745, -0.07776176840828024}}], 
        LineBox[{{-2.944918614078745, -0.07776176840828024}, \
{-2.944918614078745, -0.061518047932611016`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-2.8965392040719284`, -0.19088384047981877`}, \
{-2.8965392040719284`, -0.17687431197411782`}}], 
        LineBox[{{-2.8965392040719284`, -0.17687431197411782`}, \
{-2.8965392040719284`, -0.16305834181813994`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-2.8466335915245713`, -0.2955991913719619}, \
{-2.8466335915245713`, -0.28399385998866317`}}], 
        LineBox[{{-2.8466335915245713`, -0.28399385998866317`}, \
{-2.8466335915245713`, -0.272521668664537}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-2.799104911673882, -0.39463232495264555`}, \
{-2.799104911673882, -0.38263824026423976`}}], 
        LineBox[{{-2.799104911673882, -0.38263824026423976`}, \
{-2.799104911673882, -0.37078631031137516`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-2.750482761099594, -0.5066619887394903}, \
{-2.750482761099594, -0.4939606484306892}}], 
        LineBox[{{-2.750482761099594, -0.4939606484306892}, \
{-2.750482761099594, -0.4814186109231737}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-2.698044485612837, -0.6221875631985151}, \
{-2.698044485612837, -0.6105190836144838}}], 
        LineBox[{{-2.698044485612837, -0.6105190836144838}, \
{-2.698044485612837, -0.5989851885588231}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-2.6457065546811838`, -0.7402493497119773}, \
{-2.6457065546811838`, -0.7284007772341169}}], 
        LineBox[{{-2.6457065546811838`, -0.7284007772341169}, \
{-2.6457065546811838`, -0.7166909510842783}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-2.598812388273519, -0.8427042378193516}, \
{-2.598812388273519, -0.8297836400003847}}], 
        LineBox[{{-2.598812388273519, -0.8297836400003847}, \
{-2.598812388273519, -0.8170278567897532}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-2.4487245335749988`, -1.1868442883790267`}, \
{-2.4487245335749988`, -1.1470966873806152`}}], 
        LineBox[{{-2.4487245335749988`, -1.1470966873806152`}, \
{-2.4487245335749988`, -1.108868747684773}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-2.347387847945706, -1.4104179459097763`}, \
{-2.347387847945706, -1.3712456241601982`}}], 
        LineBox[{{-2.347387847945706, -1.3712456241601982`}, \
{-2.347387847945706, -1.3335501051206886`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-2.2553841482219026`, -1.610515174160019}, \
{-2.2553841482219026`, -1.5792124174468585`}}], 
        LineBox[{{-2.2553841482219026`, -1.5792124174468585`}, \
{-2.2553841482219026`, -1.548859854845954}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-2.1984389311930306`, -1.7410489146133443`}, \
{-2.1984389311930306`, -1.708857470597033}}], 
        LineBox[{{-2.1984389311930306`, -1.708857470597033}, \
{-2.1984389311930306`, -1.677670077788973}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-2.144562997373256, -1.8610113360521403`}, \
{-2.144562997373256, -1.8302666228349236`}}], 
        LineBox[{{-2.144562997373256, -1.8302666228349236`}, \
{-2.144562997373256, -1.8004390207716026`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-2.0934424039470523`, -1.978149705351994}, \
{-2.0934424039470523`, -1.9488614583460429`}}], 
        LineBox[{{-2.0934424039470523`, -1.9488614583460429`}, \
{-2.0934424039470523`, -1.9204066603716774`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-2.0448088291688524`, -2.09175619414602}, \
{-2.0448088291688524`, -2.06419560541432}}], 
        LineBox[{{-2.0448088291688524`, -2.06419560541432}, \
{-2.0448088291688524`, -2.037374273906816}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.998431547349378, -2.196856578896347}, \
{-1.998431547349378, -2.1705224741650078`}}], 
        LineBox[{{-1.998431547349378, -2.1705224741650078`}, \
{-1.998431547349378, -2.1448640978500944`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.9434261704597346`, -2.325426564354806}, \
{-1.9434261704597346`, -2.2972225240523065`}}], 
        LineBox[{{-1.9434261704597346`, -2.2972225240523065`}, \
{-1.9434261704597346`, -2.2697921801533427`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.8911076856443865`, -2.4433123454615595`}, \
{-1.8911076856443865`, -2.418802715616315}}], 
        LineBox[{{-1.8911076856443865`, -2.418802715616315}, \
{-1.8911076856443865`, -2.3948794644528713`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.8415558697159746`, -2.564507256997667}, \
{-1.8415558697159746`, -2.5373772979000555`}}], 
        LineBox[{{-1.8415558697159746`, -2.5373772979000555`}, \
{-1.8415558697159746`, -2.5109639739927583`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.794195067044452, -2.671614334748812}, \
{-1.794195067044452, -2.648676255425465}}], 
        LineBox[{{-1.794195067044452, -2.648676255425465}, \
{-1.794195067044452, -2.6262525547736644`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.749112569203864, -2.7815190151207516`}, \
{-1.749112569203864, -2.7576111670841836`}}], 
        LineBox[{{-1.749112569203864, -2.7576111670841836`}, \
{-1.749112569203864, -2.7342615833176724`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.6974896181121244`, -2.903570177197153}, \
{-1.6974896181121244`, -2.8797610949307213`}}], 
        LineBox[{{-1.6974896181121244`, -2.8797610949307213`}, \
{-1.6974896181121244`, -2.8565057271763825`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.6484017660376873`, -3.0234970987971503`}, \
{-1.6484017660376873`, -3.000491274927711}}], 
        LineBox[{{-1.6484017660376873`, -3.000491274927711}, \
{-1.6484017660376873`, -2.9780028383746417`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.594088397426578, -3.156063992896018}, \
{-1.594088397426578, -3.131986098160082}}], 
        LineBox[{{-1.594088397426578, -3.131986098160082}, \
{-1.594088397426578, -3.1084743436810984`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.5424473593467354`, -3.2771672179788895`}, \
{-1.5424473593467354`, -3.2565646895033864`}}], 
        LineBox[{{-1.5424473593467354`, -3.2565646895033864`}, \
{-1.5424473593467354`, -3.2363780708282426`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.493457846130768, -3.4026682872224967`}, \
{-1.493457846130768, -3.379834623390148}}], 
        LineBox[{{-1.493457846130768, -3.379834623390148}, \
{-1.493457846130768, -3.3575107177672}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.4466528065688393`, -3.5158272349088477`}, \
{-1.4466528065688393`, -3.496416983781508}}], 
        LineBox[{{-1.4466528065688393`, -3.496416983781508}, \
{-1.4466528065688393`, -3.477376327948348}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.4020363206488669`, -3.627818212178844}, \
{-1.4020363206488669`, -3.60796773090851}}], 
        LineBox[{{-1.4020363206488669`, -3.60796773090851}, \
{-1.4020363206488669`, -3.5885036337742022`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.3474454533915494`, -3.769242478142074}, \
{-1.3474454533915494`, -3.7471234749399778`}}], 
        LineBox[{{-1.3474454533915494`, -3.7471234749399778`}, \
{-1.3474454533915494`, -3.7254831531776773`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.2955821719692076`, -3.8985074205778676`}, \
{-1.2955821719692076`, -3.880453481101475}}], 
        LineBox[{{-1.2955821719692076`, -3.880453481101475}, \
{-1.2955821719692076`, -3.8627197145158987`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.24636706214148, -4.028475739564562}, {-1.24636706214148, \
-4.008133767414499}}], 
        LineBox[{{-1.24636706214148, -4.008133767414499}, {-1.24636706214148, \
-3.988197354918023}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.1943354736944491`, -4.164891256804122}, \
{-1.1943354736944491`, -4.146653409361832}}], 
        LineBox[{{-1.1943354736944491`, -4.146653409361832}, \
{-1.1943354736944491`, -4.1287422321298095`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.1448783782845262`, -4.292026310051753}, \
{-1.1448783782845262`, -4.273691469009357}}], 
        LineBox[{{-1.1448783782845262`, -4.273691469009357}, \
{-1.1448783782845262`, -4.25568675069659}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.0977528619957602`, -4.417271085963078}, \
{-1.0977528619957602`, -4.399975925491824}}], 
        LineBox[{{-1.0977528619957602`, -4.399975925491824}, \
{-1.0977528619957602`, -4.3829748092588945`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.0483930806633872`, -4.549947375319736}, \
{-1.0483930806633872`, -4.531731564091424}}], 
        LineBox[{{-1.0483930806633872`, -4.531731564091424}, \
{-1.0483930806633872`, -4.513841641171787}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-0.9971493792545362, -4.690243093634208}, \
{-0.9971493792545362, -4.671514106896482}}], 
        LineBox[{{-0.9971493792545362, -4.671514106896482}, \
{-0.9971493792545362, -4.653129455923153}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-0.9484045818214244, -4.815824378984583}, \
{-0.9484045818214244, -4.799067653114208}}], 
        LineBox[{{-0.9484045818214244, -4.799067653114208}, \
{-0.9484045818214244, -4.782587093813652}}]}},
      Antialiasing->False]}}, 
   {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.011000000000000001`], 
    AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJwVxXk4lHkcAPCZMcyMmTEXEmLt5hYhpMP7Fqm2XMW6j3VbRQphF1GbVDZj
mFhPJEUlW+673/epKFcP1lV2IiR6InIfk9394/N81HzDTwSQCASC83/+P92k
7pw8RQ4mfI1NLPsYuMrzPIpbpyz4hOkak1SZOPld++tyoSzIiOi3uTUMnPG0
90WXrywUn3XMD9Jl4H+sx0SGG8rCeMVND/VYBv5ntuXISZIsaAiZjYon6Lhi
akd/WBsPfgV5JfNLdDwnQPUJlsUDz6SxjHEqHf/7kd2VIV8e+NQ2M3gvpfFE
Fz/XAG0exE932VrN0/AZcZhG+zoXjl8I0bYpouFBsyvXDnZxwdIOpXvtpOEJ
Ttb1B4RcmM5ajIx4SMW5WP6nrV5cqOpj3QuzoeKq2rxH50y4sO5XMrlaS8Gf
Rz14ZUfkgmpxpVuZHgVvP7sF9xrgwM2liguH6qTwfj8jelkuB4jLKqsxVCl8
4phG3IIvB/IcrEvy7STx3jCb28k7OKC7OtTU3EPGBfykpPA1Nhh2Vp9+sp2M
a61RzeltbBCPbLdvviKB/xJBflN3nQ3BWlMv+xEJtzr0SuOLDxtu8+JO3uKQ
8KV/hn5QM2NDLaXnMieFiOeoZ1zqILLBMrkhNnCEgI9qhkyb5bFgV160CseI
gNufavPL38+CySzf5UTRN+zXrIQazXYZKP2ib/NcV4ztcQ0I9/SSAUWu6Vph
0TrGCV+0Cllmwj6D+tx46TXsoR21gJvFhGyyqKL49xWsVlxETTFjglO9eet9
8jImGf/uTmwHA/xXZQP5botYof6I2tNABhy2DAxyLJzHgoPOiLElOkS43nXf
OzqHZSe92nS9Rofp3L7B1m2zWIezR8KmOh2EP6pgyW8/Yx3HjM1NmqUh38Tg
1LPYKcznQ7XtRrA0/NWQCfUWE9idzFAnoxUa8HPr39POjmI6JyxUtqTRoPVD
UuZYnAirisjfkqhJA32/oIo3Bf3YwB1nG7VGKngoONSKBjsx0xXlvdt+ooJA
4pB8Rj/CJqPcIyenKRB4ftbIfDoTS+q4HG94gwJKjoYbhpMViMinImU9CrBM
a6y6C1uQvoti38dmKeAX7Mla0OtBLeWl2/j+UtDDpyqqxw+iK7ytSmKCFBg5
Fqgybw2jN+8nXLKzJKHxvqmDd+oYUnOtMwrWkYQcTKDOsvuIgrNxDa82Miz2
80OFaZ+QsmVR6m4nMuzb81krSHUGtZSmlQ1JkWFX9LO7oadmkXDWf2xDKAFy
AW4yyW5f0ZDTVNpxPQmYs2uiFWgtINnCx4fPvSTB9e5gPH92EVUHePX3BpJg
hvpb7d7SZWS6f/ugFJ0EsnMB+yOtVlFYd7xGkJAIGn3uM3HO68j7DOseW4sI
XzMvFDcfESPSVq0GL0SAmETcLVV/E0V2WzS8cCeAQ4jtRsxFAgSml7sLVjdR
jJ7M2B5PIgikD0lbK2yiaxfHjKt9SECemlVbO/ANhfmu7KtylYAm8Z2jEufF
qAQRYq4fJ8OZ3NVRyaoN9HXeZEf8TknoYyhHe26sI8aTtAghSwq0o8qGP2mt
o506LgZAo8D468aUt95r6PZ6J59IpIK93Ls+36RV5PFtd72tDA3m1SyPiEpX
UEVnVWsEUxqsf55j7vqwjOTbdRonaHQQ8F6HxKsvI7ZO5fkHK3RwG2IVNoUt
oTXjqwYqIgbketUsfX9jETmlOA8rrTFBZKriXVm/gE4PDBjq0lmwzbVEqDI3
j2I0x80cqWyIvpx4cVNpHtmbV9rpCdnwkHtVHOrwFV1xzxAcVOBAarucbUD6
HJoq3zgqyOFAU++jHrOWWaStsHt/wndciNos7Lo3+QUZlg37FzzmgrKwNd3R
dQYRS6LaLIx48C9BoaGj
     "]]}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{-5.438313143124173, -5.480217122370715},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox["\"Intensity [a.u.]\"", HoldForm], TraditionalForm], None}, {
     FormBox[
      TagBox[
      "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) \
[\\!\\(\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], 
      TraditionalForm], None}},
  FrameTicks->{{{{
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox[
        TemplateBox[{"10", "2"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500], -6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 3]], -5.809142990314028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250], -5.521460917862246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200], -5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500, 3]], -5.115995809754082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 7]], -4.961845129926823], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125], -4.8283137373023015`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 9]], -4.710530701645918], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[20], 2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[30], 3.4011973816621555`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[40], 3.6888794541139363`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[50], 3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[60], 4.0943445622221], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[70], 4.248495242049359], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[80], 4.382026634673881], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[90], 4.499809670330265], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[200], 5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[300], 5.703782474656201], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[400], 5.991464547107982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[500], 6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[600], 6.396929655216146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[700], 6.551080335043404], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[800], 6.684611727667927], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[900], 6.802394763324311], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}, {{
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500], -6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 3]], -5.809142990314028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250], -5.521460917862246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200], -5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500, 3]], -5.115995809754082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 7]], -4.961845129926823], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125], -4.8283137373023015`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 9]], -4.710530701645918], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[20], 2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[30], 3.4011973816621555`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[40], 3.6888794541139363`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[50], 3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[60], 4.0943445622221], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[70], 4.248495242049359], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[80], 4.382026634673881], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[90], 4.499809670330265], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[200], 5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[300], 5.703782474656201], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[400], 5.991464547107982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[500], 6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[600], 6.396929655216146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[700], 6.551080335043404], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[800], 6.684611727667927], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[900], 6.802394763324311], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}}, {{{
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500], -6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 3]], -5.809142990314028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250], -5.521460917862246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200], -5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500, 3]], -5.115995809754082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 7]], -4.961845129926823], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125], -4.8283137373023015`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 9]], -4.710530701645918], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}, {{
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500], -6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 3]], -5.809142990314028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250], -5.521460917862246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200], -5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500, 3]], -5.115995809754082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 7]], -4.961845129926823], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125], -4.8283137373023015`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 9]], -4.710530701645918], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  LabelStyle->{FontSize -> 14, 
    GrayLevel[0]},
  Method->{
   "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& )}},
  PlotRange->{{-5.438313143124173, -0.9484045818214244}, {-5.480217122370715, 
   3.6742019754307154`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0], 
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0]}]], "Output",
 CellChangeTimes->{
  3.860121940449121*^9, {3.8601219909814587`*^9, 3.8601219988911247`*^9}, 
   3.8601220305416183`*^9, {3.860122288162386*^9, 3.860122319486766*^9}, {
   3.860122357383444*^9, 3.860122415048162*^9}, 3.8601236448414707`*^9, 
   3.860123678830523*^9, 3.8601409845329585`*^9, 3.8601412163576555`*^9, 
   3.8601413747528563`*^9, 3.86176442550534*^9, 3.861764508178524*^9, 
   3.861764647876793*^9, 3.8617647988763914`*^9, {3.8617650704595146`*^9, 
   3.8617651079871264`*^9}, 3.861765409439147*^9, 3.8617654499851933`*^9, {
   3.861766787669303*^9, 3.8617668184387875`*^9}, {3.861767630673935*^9, 
   3.861767650165983*^9}, 3.861767840576668*^9, {3.8617678717452784`*^9, 
   3.8617678816675997`*^9}, 3.8617680171083403`*^9, {3.8617680479968414`*^9, 
   3.8617680548824015`*^9}, 3.8617682519250493`*^9, 3.861941029901291*^9, 
   3.8619500639728465`*^9, 3.861950323504904*^9, 3.863686272586315*^9, 
   3.8636872317935305`*^9, 3.885975634223706*^9, 3.885976810854197*^9, 
   3.885976922495121*^9, 3.8859771898386564`*^9, 3.885977254405377*^9, 
   3.8859776985071163`*^9, 3.8859777591377735`*^9, 3.8859795032705593`*^9, 
   3.885980141889553*^9, 3.8859804453711944`*^9, 3.8859806226937556`*^9, 
   3.8859807856447215`*^9, {3.8860631041737103`*^9, 3.886063131011697*^9}, {
   3.8860711788656583`*^9, 3.8860711903529096`*^9}, 3.8860714565699263`*^9, {
   3.886152356693725*^9, 3.886152379601023*^9}, 3.888310979615314*^9, 
   3.888311304522476*^9, 3.889002297204956*^9, 3.889060341097105*^9, 
   3.88906457053371*^9, 3.889081915278277*^9, 3.889082751832595*^9, 
   3.8890844816819963`*^9, 3.8895042732162266`*^9, 3.8895154687124505`*^9, 
   3.889668789180977*^9, 3.8896725087091503`*^9, 3.8896746341294947`*^9, {
   3.88967467876441*^9, 3.8896746953717566`*^9}, {3.889674754509908*^9, 
   3.8896747662462883`*^9}, 3.889674833427221*^9, 3.8896749045918837`*^9, {
   3.889676076787506*^9, 3.8896761358772745`*^9}, 3.889676612828989*^9, 
   3.889676756265704*^9, 3.8902038192855253`*^9, {3.890203856897176*^9, 
   3.890203902283286*^9}, 3.8902059339417963`*^9, 3.8902102574150095`*^9, 
   3.8902167504968033`*^9, 3.8902168293738966`*^9, {3.890216870017076*^9, 
   3.890216876660765*^9}, 3.8902172119334965`*^9, 3.8902178180211363`*^9, 
   3.8909817030480986`*^9, 3.8909818035906286`*^9, 3.8909822364544888`*^9, 
   3.890982755046166*^9, 3.891416112682912*^9, 3.891497436223301*^9, 
   3.8914975686949873`*^9, {3.891498532036313*^9, 3.8914985683451767`*^9}, 
   3.891498623092783*^9, 3.891499326018267*^9, 3.891499357538082*^9, 
   3.8914994810548916`*^9, 3.8915004132235947`*^9, 3.89150047307273*^9, {
   3.891501045822155*^9, 3.891501057968319*^9}, 3.8915012850547023`*^9, 
   3.8916963011787567`*^9, 3.891696364294973*^9, 3.8916964128455863`*^9, 
   3.891696468258329*^9},
 CellLabel->
  "Out[2837]=",ExpressionUUID->"a878c058-e575-40f5-9fc8-e78a89f5c966"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\ESRF\\\\Analysis\\\\2022-08_\
new_data\\\\Analysis\\\\Full form factor \
fit\\\\LH-ESRF-C22\\\\DataMergedBinned.pdf\"\>"], "Output",
 CellChangeTimes->{
  3.860121940449121*^9, {3.8601219909814587`*^9, 3.8601219988911247`*^9}, 
   3.8601220305416183`*^9, {3.860122288162386*^9, 3.860122319486766*^9}, {
   3.860122357383444*^9, 3.860122415048162*^9}, 3.8601236448414707`*^9, 
   3.860123678830523*^9, 3.8601409845329585`*^9, 3.8601412163576555`*^9, 
   3.8601413747528563`*^9, 3.86176442550534*^9, 3.861764508178524*^9, 
   3.861764647876793*^9, 3.8617647988763914`*^9, {3.8617650704595146`*^9, 
   3.8617651079871264`*^9}, 3.861765409439147*^9, 3.8617654499851933`*^9, {
   3.861766787669303*^9, 3.8617668184387875`*^9}, {3.861767630673935*^9, 
   3.861767650165983*^9}, 3.861767840576668*^9, {3.8617678717452784`*^9, 
   3.8617678816675997`*^9}, 3.8617680171083403`*^9, {3.8617680479968414`*^9, 
   3.8617680548824015`*^9}, 3.8617682519250493`*^9, 3.861941029901291*^9, 
   3.8619500639728465`*^9, 3.861950323504904*^9, 3.863686272586315*^9, 
   3.8636872317935305`*^9, 3.885975634223706*^9, 3.885976810854197*^9, 
   3.885976922495121*^9, 3.8859771898386564`*^9, 3.885977254405377*^9, 
   3.8859776985071163`*^9, 3.8859777591377735`*^9, 3.8859795032705593`*^9, 
   3.885980141889553*^9, 3.8859804453711944`*^9, 3.8859806226937556`*^9, 
   3.8859807856447215`*^9, {3.8860631041737103`*^9, 3.886063131011697*^9}, {
   3.8860711788656583`*^9, 3.8860711903529096`*^9}, 3.8860714565699263`*^9, {
   3.886152356693725*^9, 3.886152379601023*^9}, 3.888310979615314*^9, 
   3.888311304522476*^9, 3.889002297204956*^9, 3.889060341097105*^9, 
   3.88906457053371*^9, 3.889081915278277*^9, 3.889082751832595*^9, 
   3.8890844816819963`*^9, 3.8895042732162266`*^9, 3.8895154687124505`*^9, 
   3.889668789180977*^9, 3.8896725087091503`*^9, 3.8896746341294947`*^9, {
   3.88967467876441*^9, 3.8896746953717566`*^9}, {3.889674754509908*^9, 
   3.8896747662462883`*^9}, 3.889674833427221*^9, 3.8896749045918837`*^9, {
   3.889676076787506*^9, 3.8896761358772745`*^9}, 3.889676612828989*^9, 
   3.889676756265704*^9, 3.8902038192855253`*^9, {3.890203856897176*^9, 
   3.890203902283286*^9}, 3.8902059339417963`*^9, 3.8902102574150095`*^9, 
   3.8902167504968033`*^9, 3.8902168293738966`*^9, {3.890216870017076*^9, 
   3.890216876660765*^9}, 3.8902172119334965`*^9, 3.8902178180211363`*^9, 
   3.8909817030480986`*^9, 3.8909818035906286`*^9, 3.8909822364544888`*^9, 
   3.890982755046166*^9, 3.891416112682912*^9, 3.891497436223301*^9, 
   3.8914975686949873`*^9, {3.891498532036313*^9, 3.8914985683451767`*^9}, 
   3.891498623092783*^9, 3.891499326018267*^9, 3.891499357538082*^9, 
   3.8914994810548916`*^9, 3.8915004132235947`*^9, 3.89150047307273*^9, {
   3.891501045822155*^9, 3.891501057968319*^9}, 3.8915012850547023`*^9, 
   3.8916963011787567`*^9, 3.891696364294973*^9, 3.8916964128455863`*^9, 
   3.891696469455164*^9},
 CellLabel->
  "Out[2838]=",ExpressionUUID->"05a4f647-0ed4-4393-8115-fcec3a9e33e7"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\ESRF\\\\Analysis\\\\2022-08_\
new_data\\\\Analysis\\\\Full form factor fit\\\\LH-ESRF-C22\\\\Sample \
playground LH-ESRF-C22 NEW SAXS data merged and binned.csv\"\>"], "Output",
 CellChangeTimes->{
  3.860121940449121*^9, {3.8601219909814587`*^9, 3.8601219988911247`*^9}, 
   3.8601220305416183`*^9, {3.860122288162386*^9, 3.860122319486766*^9}, {
   3.860122357383444*^9, 3.860122415048162*^9}, 3.8601236448414707`*^9, 
   3.860123678830523*^9, 3.8601409845329585`*^9, 3.8601412163576555`*^9, 
   3.8601413747528563`*^9, 3.86176442550534*^9, 3.861764508178524*^9, 
   3.861764647876793*^9, 3.8617647988763914`*^9, {3.8617650704595146`*^9, 
   3.8617651079871264`*^9}, 3.861765409439147*^9, 3.8617654499851933`*^9, {
   3.861766787669303*^9, 3.8617668184387875`*^9}, {3.861767630673935*^9, 
   3.861767650165983*^9}, 3.861767840576668*^9, {3.8617678717452784`*^9, 
   3.8617678816675997`*^9}, 3.8617680171083403`*^9, {3.8617680479968414`*^9, 
   3.8617680548824015`*^9}, 3.8617682519250493`*^9, 3.861941029901291*^9, 
   3.8619500639728465`*^9, 3.861950323504904*^9, 3.863686272586315*^9, 
   3.8636872317935305`*^9, 3.885975634223706*^9, 3.885976810854197*^9, 
   3.885976922495121*^9, 3.8859771898386564`*^9, 3.885977254405377*^9, 
   3.8859776985071163`*^9, 3.8859777591377735`*^9, 3.8859795032705593`*^9, 
   3.885980141889553*^9, 3.8859804453711944`*^9, 3.8859806226937556`*^9, 
   3.8859807856447215`*^9, {3.8860631041737103`*^9, 3.886063131011697*^9}, {
   3.8860711788656583`*^9, 3.8860711903529096`*^9}, 3.8860714565699263`*^9, {
   3.886152356693725*^9, 3.886152379601023*^9}, 3.888310979615314*^9, 
   3.888311304522476*^9, 3.889002297204956*^9, 3.889060341097105*^9, 
   3.88906457053371*^9, 3.889081915278277*^9, 3.889082751832595*^9, 
   3.8890844816819963`*^9, 3.8895042732162266`*^9, 3.8895154687124505`*^9, 
   3.889668789180977*^9, 3.8896725087091503`*^9, 3.8896746341294947`*^9, {
   3.88967467876441*^9, 3.8896746953717566`*^9}, {3.889674754509908*^9, 
   3.8896747662462883`*^9}, 3.889674833427221*^9, 3.8896749045918837`*^9, {
   3.889676076787506*^9, 3.8896761358772745`*^9}, 3.889676612828989*^9, 
   3.889676756265704*^9, 3.8902038192855253`*^9, {3.890203856897176*^9, 
   3.890203902283286*^9}, 3.8902059339417963`*^9, 3.8902102574150095`*^9, 
   3.8902167504968033`*^9, 3.8902168293738966`*^9, {3.890216870017076*^9, 
   3.890216876660765*^9}, 3.8902172119334965`*^9, 3.8902178180211363`*^9, 
   3.8909817030480986`*^9, 3.8909818035906286`*^9, 3.8909822364544888`*^9, 
   3.890982755046166*^9, 3.891416112682912*^9, 3.891497436223301*^9, 
   3.8914975686949873`*^9, {3.891498532036313*^9, 3.8914985683451767`*^9}, 
   3.891498623092783*^9, 3.891499326018267*^9, 3.891499357538082*^9, 
   3.8914994810548916`*^9, 3.8915004132235947`*^9, 3.89150047307273*^9, {
   3.891501045822155*^9, 3.891501057968319*^9}, 3.8915012850547023`*^9, 
   3.8916963011787567`*^9, 3.891696364294973*^9, 3.8916964128455863`*^9, 
   3.891696469526894*^9},
 CellLabel->
  "Out[2840]=",ExpressionUUID->"ec3a3661-e06a-44d5-9d42-39c0bc245c33"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Plot", " ", "slopes"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"plotSlopes", "=", " ", 
    RowBox[{"ListLogLinearPlot", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"slope", "[", 
       RowBox[{"datamerged", ",", "0.15"}], "]"}], ",", " ", 
      RowBox[{"(*", " ", 
       RowBox[{"default", ":", " ", "0.15"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"1", " ", 
            RowBox[{"10", "^", 
             RowBox[{"-", "3"}]}]}], ",", " ", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "6"}], ",", "0"}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameTicks", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Automatic", ",", " ", "Automatic"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"PowerTicks", "[", "True", "]"}], "[", 
            RowBox[{
             RowBox[{"10", "^", 
              RowBox[{"-", "2"}]}], ",", " ", 
             RowBox[{"10", "^", "0"}]}], "]"}], ",", 
           RowBox[{
            RowBox[{"PowerTicks", "[", "False", "]"}], "[", 
            RowBox[{
             RowBox[{"10", "^", 
              RowBox[{"-", "2"}]}], ",", " ", 
             RowBox[{"10", "^", "0"}]}], "]"}]}], "}"}]}], "}"}]}], ",", " ", 
      RowBox[{"(*", " ", 
       RowBox[{
       "only", " ", "works", " ", "with", " ", "PowerTicks", " ", "function", 
        " ", "defined", " ", "in", " ", "polydisp", " ", "fitting", " ", 
        "functions", " ", "file"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", " ", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\"\<Slope\>\"", ",", " ", "None"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
        "}"}]}]}], "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
        "\"\<Slopes.pdf\>\""}], "}"}], "]"}], ",", "plotSlopes"}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"slope", "[", 
    RowBox[{"datamerged", ",", "0.15"}], "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Export", " ", "slopes", " ", 
     RowBox[{"(", 
      RowBox[{
      "for", " ", "plotting", " ", "in", " ", "Python", " ", "or", " ", 
       "other", " ", "software"}], ")"}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"exportlist", " ", "=", " ", 
     RowBox[{"exportData", "[", 
      RowBox[{"slope", "[", 
       RowBox[{"datamerged", ",", "0.15"}], "]"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Export", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", "\[IndentingNewLine]", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"FileBaseName", "[", 
          RowBox[{"NotebookFileName", "[", "]"}], "]"}], "<>", 
         "\"\< SAXS slopes.csv\>\""}]}], "\[IndentingNewLine]", "}"}], 
      "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
     "exportlist"}], "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", 
   RowBox[{"NotebookFileName", "[", "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.852797516969694*^9, {3.852797632109549*^9, 3.852797683131383*^9}, {
   3.852797796480151*^9, 3.852797853718195*^9}, {3.8527978838837643`*^9, 
   3.852797901227326*^9}, {3.852797980320817*^9, 3.852798038102087*^9}, 
   3.852798223135673*^9, {3.852798406664549*^9, 3.852798409306513*^9}, {
   3.852798512004775*^9, 3.852798555547234*^9}, {3.85279858828354*^9, 
   3.852798831366269*^9}, {3.852798896028565*^9, 3.852799007753936*^9}, {
   3.852799080350028*^9, 3.852799084748775*^9}, {3.8527992586158037`*^9, 
   3.8527992606884203`*^9}, {3.852801934781908*^9, 3.85280197103442*^9}, {
   3.852802103164875*^9, 3.852802118419861*^9}, {3.852862635200562*^9, 
   3.8528626398081703`*^9}, {3.85286268207966*^9, 3.85286275183375*^9}, {
   3.852862799533414*^9, 3.852862876114451*^9}, {3.8528629338179607`*^9, 
   3.852862985846582*^9}, {3.852863040437448*^9, 3.852863051004711*^9}, {
   3.852868510428824*^9, 3.852868602768145*^9}, {3.852868644287572*^9, 
   3.85286868020261*^9}, {3.852868718724351*^9, 3.85286873785894*^9}, {
   3.852868770378528*^9, 3.8528689132597523`*^9}, {3.852868965432905*^9, 
   3.852868981650947*^9}, 3.852870677134739*^9, {3.8528710993603067`*^9, 
   3.852871145669981*^9}, {3.8528716178560038`*^9, 3.852871618411791*^9}, {
   3.852874052533587*^9, 3.852874070324737*^9}, {3.8533820192129173`*^9, 
   3.853382032526078*^9}, {3.853403584226432*^9, 3.853403584753387*^9}, {
   3.8534051467395353`*^9, 3.853405196243081*^9}, {3.853405235261485*^9, 
   3.8534052353804817`*^9}, {3.853405414194544*^9, 3.85340541704944*^9}, {
   3.854423706814918*^9, 3.854423713174549*^9}, {3.8601401065322495`*^9, 
   3.8601401162752795`*^9}, {3.8617652315248656`*^9, 3.861765245785426*^9}, {
   3.861765486245756*^9, 3.861765500810083*^9}, {3.8617668960181065`*^9, 
   3.861766896503375*^9}, {3.861766959391518*^9, 3.861766970643777*^9}, {
   3.861768170754223*^9, 3.861768171551543*^9}, {3.861768267366991*^9, 
   3.8617682678668547`*^9}, 3.861940907625001*^9, {3.861941874731223*^9, 
   3.8619418752572*^9}, {3.863686273326891*^9, 3.86368627384243*^9}, 
   3.863687238834276*^9, {3.8895154361670246`*^9, 3.889515452084921*^9}, {
   3.889672427830373*^9, 3.8896724458079796`*^9}, {3.8896763888939342`*^9, 
   3.8896765605915513`*^9}, 3.889676629643072*^9, {3.88967679120571*^9, 
   3.88967681543388*^9}, {3.889676858823769*^9, 3.889676888283419*^9}, {
   3.8914993987113857`*^9, 3.89149940896005*^9}, {3.8916963461155796`*^9, 
   3.891696346385415*^9}},
 CellLabel->
  "In[2841]:=",ExpressionUUID->"8edd1d77-e6da-4feb-ad70-9ef9a39ee410"],

Cell[BoxData[
 GraphicsBox[{{{
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-5.1252793563099095`, -0.96477943753508}, \
{-5.1252793563099095`, -0.7391686344009561}}], 
         LineBox[{{-5.1252793563099095`, -0.7391686344009561}, \
{-5.1252793563099095`, -0.5135578312668323}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-4.972895007974446, -0.9535993632839864}, \
{-4.972895007974446, -0.7133739101905257}}], 
         LineBox[{{-4.972895007974446, -0.7133739101905257}, \
{-4.972895007974446, -0.4731484570970649}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-4.8217116543319705`, -1.4920352848705054`}, \
{-4.8217116543319705`, -1.2734305782197923`}}], 
         LineBox[{{-4.8217116543319705`, -1.2734305782197923`}, \
{-4.8217116543319705`, -1.0548258715690793`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-4.673830349076903, -1.3157870376537555`}, \
{-4.673830349076903, -1.1270814075746538`}}], 
         LineBox[{{-4.673830349076903, -1.1270814075746538`}, \
{-4.673830349076903, -0.9383757774955521}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-4.521216293266271, -1.6531108264067091`}, \
{-4.521216293266271, -1.3983615441650237`}}], 
         LineBox[{{-4.521216293266271, -1.3983615441650237`}, \
{-4.521216293266271, -1.1436122619233382`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-4.3682219300566025`, -1.7992520141962367`}, \
{-4.3682219300566025`, -1.465059688428702}}], 
         LineBox[{{-4.3682219300566025`, -1.465059688428702}, \
{-4.3682219300566025`, -1.1308673626611672`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-4.223924574573319, -1.9645624717370351`}, \
{-4.223924574573319, -1.6245590795392313`}}], 
         LineBox[{{-4.223924574573319, -1.6245590795392313`}, \
{-4.223924574573319, -1.2845556873414274`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-4.077721657523017, -2.038209780364534}, \
{-4.077721657523017, -1.7147861404360367`}}], 
         LineBox[{{-4.077721657523017, -1.7147861404360367`}, \
{-4.077721657523017, -1.3913625005075394`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-3.92630264206681, -2.1494508829121255`}, \
{-3.92630264206681, -1.8478089031935414`}}], 
         LineBox[{{-3.92630264206681, -1.8478089031935414`}, \
{-3.92630264206681, -1.546166923474957}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-3.774327986151194, -2.245759723513893}, \
{-3.774327986151194, -1.9383472878026295`}}], 
         LineBox[{{-3.774327986151194, -1.9383472878026295`}, \
{-3.774327986151194, -1.6309348520913662`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-3.6208826994945396`, -2.334711992235891}, \
{-3.6208826994945396`, -2.0395686420545247`}}], 
         LineBox[{{-3.6208826994945396`, -2.0395686420545247`}, \
{-3.6208826994945396`, -1.7444252918731584`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-3.4686602504493296`, -2.399748237667733}, \
{-3.4686602504493296`, -2.1091620931464528`}}], 
         LineBox[{{-3.4686602504493296`, -2.1091620931464528`}, \
{-3.4686602504493296`, -1.8185759486251727`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-3.320632854288721, -2.4784768658854617`}, \
{-3.320632854288721, -2.2038471789535055`}}], 
         LineBox[{{-3.320632854288721, -2.2038471789535055`}, \
{-3.320632854288721, -1.9292174920215492`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-3.169887377457001, -2.4564658324092714`}, \
{-3.169887377457001, -2.2050530434335336`}}], 
         LineBox[{{-3.169887377457001, -2.2050530434335336`}, \
{-3.169887377457001, -1.953640254457796}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-3.01721515252269, -2.345074896394708}, \
{-3.01721515252269, -2.120912908334111}}], 
         LineBox[{{-3.01721515252269, -2.120912908334111}, \
{-3.01721515252269, -1.8967509202735144`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-2.869122979428457, -2.3248215745985488`}, \
{-2.869122979428457, -2.125116138908417}}], 
         LineBox[{{-2.869122979428457, -2.125116138908417}, \
{-2.869122979428457, -1.9254107032182852`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-2.7229707239555854`, -2.4101854065991413`}, \
{-2.7229707239555854`, -2.222581347955065}}], 
         LineBox[{{-2.7229707239555854`, -2.222581347955065}, \
{-2.7229707239555854`, -2.034977289310989}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-2.5674984695241374`, -2.4585576605778705`}, \
{-2.5674984695241374`, -2.1167607486550155`}}], 
         LineBox[{{-2.5674984695241374`, -2.1167607486550155`}, \
{-2.5674984695241374`, -1.7749638367321607`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-2.4167532824388296`, -2.730676061111512}, \
{-2.4167532824388296`, -2.215365091833709}}], 
         LineBox[{{-2.4167532824388296`, -2.215365091833709}, \
{-2.4167532824388296`, -1.7000541225559056`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-2.273683103959538, -2.7151373798005185`}, \
{-2.273683103959538, -2.260552152824246}}], 
         LineBox[{{-2.273683103959538, -2.260552152824246}, \
{-2.273683103959538, -1.8059669258479734`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-2.1225114762089117`, -2.7223200485296535`}, \
{-2.1225114762089117`, -2.3072025595882764`}}], 
         LineBox[{{-2.1225114762089117`, -2.3072025595882764`}, \
{-2.1225114762089117`, -1.8920850706468992`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-1.9688530566493743`, -2.710030614808251}, \
{-1.9688530566493743`, -2.3236366231172294`}}], 
         LineBox[{{-1.9688530566493743`, -2.3236366231172294`}, \
{-1.9688530566493743`, -1.9372426314262075`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-1.8165848867407983`, -2.736987228862975}, \
{-1.8165848867407983`, -2.372330782351529}}], 
         LineBox[{{-1.8165848867407983`, -2.372330782351529}, \
{-1.8165848867407983`, -2.0076743358400835`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-1.6679573417952833`, -2.7655887838744464`}, \
{-1.6679573417952833`, -2.420561808974977}}], 
         LineBox[{{-1.6679573417952833`, -2.420561808974977}, \
{-1.6679573417952833`, -2.0755348340755075`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-1.5211693704213907`, -2.7982903951784612`}, \
{-1.5211693704213907`, -2.4733619472453525`}}], 
         LineBox[{{-1.5211693704213907`, -2.4733619472453525`}, \
{-1.5211693704213907`, -2.148433499312244}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-1.371988295897768, -2.848351894935505}, \
{-1.371988295897768, -2.543378251816936}}], 
         LineBox[{{-1.371988295897768, -2.543378251816936}, \
{-1.371988295897768, -2.238404608698367}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-1.2210917594318125`, -2.9077092438776244`}, \
{-1.2210917594318125`, -2.6181369569061665`}}], 
         LineBox[{{-1.2210917594318125`, -2.6181369569061665`}, \
{-1.2210917594318125`, -2.3285646699347087`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-1.0718189592856806`, -2.942973344943205}, \
{-1.0718189592856806`, -2.6680361941378496`}}], 
         LineBox[{{-1.0718189592856806`, -2.6680361941378496`}, \
{-1.0718189592856806`, -2.3930990433324943`}}]}},
       Antialiasing->False]}}, {
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-5.1252793563099095`, -0.5135578312668323}, 
            Offset[{3, 
             0}, {-5.1252793563099095`, -0.5135578312668323}]}, \
{{-5.1252793563099095`, -0.5135578312668323}, 
            Offset[{-3, 
             0}, {-5.1252793563099095`, -0.5135578312668323}]}, \
{{-5.1252793563099095`, -0.96477943753508}, 
            Offset[{3, 
             0}, {-5.1252793563099095`, -0.96477943753508}]}, \
{{-5.1252793563099095`, -0.96477943753508}, 
            Offset[{-3, 0}, {-5.1252793563099095`, -0.96477943753508}]}}], {{{
          1., 0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-4.972895007974446, -0.4731484570970649}, 
            Offset[{3, 
             0}, {-4.972895007974446, -0.4731484570970649}]}, \
{{-4.972895007974446, -0.4731484570970649}, 
            Offset[{-3, 
             0}, {-4.972895007974446, -0.4731484570970649}]}, \
{{-4.972895007974446, -0.9535993632839864}, 
            Offset[{3, 
             0}, {-4.972895007974446, -0.9535993632839864}]}, \
{{-4.972895007974446, -0.9535993632839864}, 
            Offset[{-3, 0}, {-4.972895007974446, -0.9535993632839864}]}}], {{{
          1., 0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-4.8217116543319705`, -1.0548258715690793`}, 
            Offset[{3, 
             0}, {-4.8217116543319705`, -1.0548258715690793`}]}, \
{{-4.8217116543319705`, -1.0548258715690793`}, 
            Offset[{-3, 
             0}, {-4.8217116543319705`, -1.0548258715690793`}]}, \
{{-4.8217116543319705`, -1.4920352848705054`}, 
            Offset[{3, 
             0}, {-4.8217116543319705`, -1.4920352848705054`}]}, \
{{-4.8217116543319705`, -1.4920352848705054`}, 
            Offset[{-3, 
             0}, {-4.8217116543319705`, -1.4920352848705054`}]}}], {{{1., 
          0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-4.673830349076903, -0.9383757774955521}, 
            Offset[{3, 
             0}, {-4.673830349076903, -0.9383757774955521}]}, \
{{-4.673830349076903, -0.9383757774955521}, 
            Offset[{-3, 
             0}, {-4.673830349076903, -0.9383757774955521}]}, \
{{-4.673830349076903, -1.3157870376537555`}, 
            Offset[{3, 
             0}, {-4.673830349076903, -1.3157870376537555`}]}, \
{{-4.673830349076903, -1.3157870376537555`}, 
            Offset[{-3, 
             0}, {-4.673830349076903, -1.3157870376537555`}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-4.521216293266271, -1.1436122619233382`}, 
            Offset[{3, 
             0}, {-4.521216293266271, -1.1436122619233382`}]}, \
{{-4.521216293266271, -1.1436122619233382`}, 
            Offset[{-3, 
             0}, {-4.521216293266271, -1.1436122619233382`}]}, \
{{-4.521216293266271, -1.6531108264067091`}, 
            Offset[{3, 
             0}, {-4.521216293266271, -1.6531108264067091`}]}, \
{{-4.521216293266271, -1.6531108264067091`}, 
            Offset[{-3, 
             0}, {-4.521216293266271, -1.6531108264067091`}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-4.3682219300566025`, -1.1308673626611672`}, 
            Offset[{3, 
             0}, {-4.3682219300566025`, -1.1308673626611672`}]}, \
{{-4.3682219300566025`, -1.1308673626611672`}, 
            Offset[{-3, 
             0}, {-4.3682219300566025`, -1.1308673626611672`}]}, \
{{-4.3682219300566025`, -1.7992520141962367`}, 
            Offset[{3, 
             0}, {-4.3682219300566025`, -1.7992520141962367`}]}, \
{{-4.3682219300566025`, -1.7992520141962367`}, 
            Offset[{-3, 
             0}, {-4.3682219300566025`, -1.7992520141962367`}]}}], {{{1., 
          0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-4.223924574573319, -1.2845556873414274`}, 
            Offset[{3, 
             0}, {-4.223924574573319, -1.2845556873414274`}]}, \
{{-4.223924574573319, -1.2845556873414274`}, 
            Offset[{-3, 
             0}, {-4.223924574573319, -1.2845556873414274`}]}, \
{{-4.223924574573319, -1.9645624717370351`}, 
            Offset[{3, 
             0}, {-4.223924574573319, -1.9645624717370351`}]}, \
{{-4.223924574573319, -1.9645624717370351`}, 
            Offset[{-3, 
             0}, {-4.223924574573319, -1.9645624717370351`}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-4.077721657523017, -1.3913625005075394`}, 
            Offset[{3, 
             0}, {-4.077721657523017, -1.3913625005075394`}]}, \
{{-4.077721657523017, -1.3913625005075394`}, 
            Offset[{-3, 
             0}, {-4.077721657523017, -1.3913625005075394`}]}, \
{{-4.077721657523017, -2.038209780364534}, 
            Offset[{3, 
             0}, {-4.077721657523017, -2.038209780364534}]}, \
{{-4.077721657523017, -2.038209780364534}, 
            Offset[{-3, 0}, {-4.077721657523017, -2.038209780364534}]}}], {{{
          1., 0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-3.92630264206681, -1.546166923474957}, 
            Offset[{3, 
             0}, {-3.92630264206681, -1.546166923474957}]}, \
{{-3.92630264206681, -1.546166923474957}, 
            Offset[{-3, 
             0}, {-3.92630264206681, -1.546166923474957}]}, \
{{-3.92630264206681, -2.1494508829121255`}, 
            Offset[{3, 
             0}, {-3.92630264206681, -2.1494508829121255`}]}, \
{{-3.92630264206681, -2.1494508829121255`}, 
            Offset[{-3, 0}, {-3.92630264206681, -2.1494508829121255`}]}}], {{{
          1., 0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-3.774327986151194, -1.6309348520913662`}, 
            Offset[{3, 
             0}, {-3.774327986151194, -1.6309348520913662`}]}, \
{{-3.774327986151194, -1.6309348520913662`}, 
            Offset[{-3, 
             0}, {-3.774327986151194, -1.6309348520913662`}]}, \
{{-3.774327986151194, -2.245759723513893}, 
            Offset[{3, 
             0}, {-3.774327986151194, -2.245759723513893}]}, \
{{-3.774327986151194, -2.245759723513893}, 
            Offset[{-3, 0}, {-3.774327986151194, -2.245759723513893}]}}], {{{
          1., 0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-3.6208826994945396`, -1.7444252918731584`}, 
            Offset[{3, 
             0}, {-3.6208826994945396`, -1.7444252918731584`}]}, \
{{-3.6208826994945396`, -1.7444252918731584`}, 
            Offset[{-3, 
             0}, {-3.6208826994945396`, -1.7444252918731584`}]}, \
{{-3.6208826994945396`, -2.334711992235891}, 
            Offset[{3, 
             0}, {-3.6208826994945396`, -2.334711992235891}]}, \
{{-3.6208826994945396`, -2.334711992235891}, 
            Offset[{-3, 
             0}, {-3.6208826994945396`, -2.334711992235891}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-3.4686602504493296`, -1.8185759486251727`}, 
            Offset[{3, 
             0}, {-3.4686602504493296`, -1.8185759486251727`}]}, \
{{-3.4686602504493296`, -1.8185759486251727`}, 
            Offset[{-3, 
             0}, {-3.4686602504493296`, -1.8185759486251727`}]}, \
{{-3.4686602504493296`, -2.399748237667733}, 
            Offset[{3, 
             0}, {-3.4686602504493296`, -2.399748237667733}]}, \
{{-3.4686602504493296`, -2.399748237667733}, 
            Offset[{-3, 
             0}, {-3.4686602504493296`, -2.399748237667733}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-3.320632854288721, -1.9292174920215492`}, 
            Offset[{3, 
             0}, {-3.320632854288721, -1.9292174920215492`}]}, \
{{-3.320632854288721, -1.9292174920215492`}, 
            Offset[{-3, 
             0}, {-3.320632854288721, -1.9292174920215492`}]}, \
{{-3.320632854288721, -2.4784768658854617`}, 
            Offset[{3, 
             0}, {-3.320632854288721, -2.4784768658854617`}]}, \
{{-3.320632854288721, -2.4784768658854617`}, 
            Offset[{-3, 
             0}, {-3.320632854288721, -2.4784768658854617`}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-3.169887377457001, -1.953640254457796}, 
            Offset[{3, 
             0}, {-3.169887377457001, -1.953640254457796}]}, \
{{-3.169887377457001, -1.953640254457796}, 
            Offset[{-3, 
             0}, {-3.169887377457001, -1.953640254457796}]}, \
{{-3.169887377457001, -2.4564658324092714`}, 
            Offset[{3, 
             0}, {-3.169887377457001, -2.4564658324092714`}]}, \
{{-3.169887377457001, -2.4564658324092714`}, 
            Offset[{-3, 
             0}, {-3.169887377457001, -2.4564658324092714`}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-3.01721515252269, -1.8967509202735144`}, 
            Offset[{3, 
             0}, {-3.01721515252269, -1.8967509202735144`}]}, \
{{-3.01721515252269, -1.8967509202735144`}, 
            Offset[{-3, 
             0}, {-3.01721515252269, -1.8967509202735144`}]}, \
{{-3.01721515252269, -2.345074896394708}, 
            Offset[{3, 
             0}, {-3.01721515252269, -2.345074896394708}]}, \
{{-3.01721515252269, -2.345074896394708}, 
            Offset[{-3, 0}, {-3.01721515252269, -2.345074896394708}]}}], {{{
          1., 0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-2.869122979428457, -1.9254107032182852`}, 
            Offset[{3, 
             0}, {-2.869122979428457, -1.9254107032182852`}]}, \
{{-2.869122979428457, -1.9254107032182852`}, 
            Offset[{-3, 
             0}, {-2.869122979428457, -1.9254107032182852`}]}, \
{{-2.869122979428457, -2.3248215745985488`}, 
            Offset[{3, 
             0}, {-2.869122979428457, -2.3248215745985488`}]}, \
{{-2.869122979428457, -2.3248215745985488`}, 
            Offset[{-3, 
             0}, {-2.869122979428457, -2.3248215745985488`}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-2.7229707239555854`, -2.034977289310989}, 
            Offset[{3, 
             0}, {-2.7229707239555854`, -2.034977289310989}]}, \
{{-2.7229707239555854`, -2.034977289310989}, 
            Offset[{-3, 
             0}, {-2.7229707239555854`, -2.034977289310989}]}, \
{{-2.7229707239555854`, -2.4101854065991413`}, 
            Offset[{3, 
             0}, {-2.7229707239555854`, -2.4101854065991413`}]}, \
{{-2.7229707239555854`, -2.4101854065991413`}, 
            Offset[{-3, 
             0}, {-2.7229707239555854`, -2.4101854065991413`}]}}], {{{1., 
          0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-2.5674984695241374`, -1.7749638367321607`}, 
            Offset[{3, 
             0}, {-2.5674984695241374`, -1.7749638367321607`}]}, \
{{-2.5674984695241374`, -1.7749638367321607`}, 
            Offset[{-3, 
             0}, {-2.5674984695241374`, -1.7749638367321607`}]}, \
{{-2.5674984695241374`, -2.4585576605778705`}, 
            Offset[{3, 
             0}, {-2.5674984695241374`, -2.4585576605778705`}]}, \
{{-2.5674984695241374`, -2.4585576605778705`}, 
            Offset[{-3, 
             0}, {-2.5674984695241374`, -2.4585576605778705`}]}}], {{{1., 
          0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-2.4167532824388296`, -1.7000541225559056`}, 
            Offset[{3, 
             0}, {-2.4167532824388296`, -1.7000541225559056`}]}, \
{{-2.4167532824388296`, -1.7000541225559056`}, 
            Offset[{-3, 
             0}, {-2.4167532824388296`, -1.7000541225559056`}]}, \
{{-2.4167532824388296`, -2.730676061111512}, 
            Offset[{3, 
             0}, {-2.4167532824388296`, -2.730676061111512}]}, \
{{-2.4167532824388296`, -2.730676061111512}, 
            Offset[{-3, 
             0}, {-2.4167532824388296`, -2.730676061111512}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-2.273683103959538, -1.8059669258479734`}, 
            Offset[{3, 
             0}, {-2.273683103959538, -1.8059669258479734`}]}, \
{{-2.273683103959538, -1.8059669258479734`}, 
            Offset[{-3, 
             0}, {-2.273683103959538, -1.8059669258479734`}]}, \
{{-2.273683103959538, -2.7151373798005185`}, 
            Offset[{3, 
             0}, {-2.273683103959538, -2.7151373798005185`}]}, \
{{-2.273683103959538, -2.7151373798005185`}, 
            Offset[{-3, 
             0}, {-2.273683103959538, -2.7151373798005185`}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-2.1225114762089117`, -1.8920850706468992`}, 
            Offset[{3, 
             0}, {-2.1225114762089117`, -1.8920850706468992`}]}, \
{{-2.1225114762089117`, -1.8920850706468992`}, 
            Offset[{-3, 
             0}, {-2.1225114762089117`, -1.8920850706468992`}]}, \
{{-2.1225114762089117`, -2.7223200485296535`}, 
            Offset[{3, 
             0}, {-2.1225114762089117`, -2.7223200485296535`}]}, \
{{-2.1225114762089117`, -2.7223200485296535`}, 
            Offset[{-3, 
             0}, {-2.1225114762089117`, -2.7223200485296535`}]}}], {{{1., 
          0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-1.9688530566493743`, -1.9372426314262075`}, 
            Offset[{3, 
             0}, {-1.9688530566493743`, -1.9372426314262075`}]}, \
{{-1.9688530566493743`, -1.9372426314262075`}, 
            Offset[{-3, 
             0}, {-1.9688530566493743`, -1.9372426314262075`}]}, \
{{-1.9688530566493743`, -2.710030614808251}, 
            Offset[{3, 
             0}, {-1.9688530566493743`, -2.710030614808251}]}, \
{{-1.9688530566493743`, -2.710030614808251}, 
            Offset[{-3, 
             0}, {-1.9688530566493743`, -2.710030614808251}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-1.8165848867407983`, -2.0076743358400835`}, 
            Offset[{3, 
             0}, {-1.8165848867407983`, -2.0076743358400835`}]}, \
{{-1.8165848867407983`, -2.0076743358400835`}, 
            Offset[{-3, 
             0}, {-1.8165848867407983`, -2.0076743358400835`}]}, \
{{-1.8165848867407983`, -2.736987228862975}, 
            Offset[{3, 
             0}, {-1.8165848867407983`, -2.736987228862975}]}, \
{{-1.8165848867407983`, -2.736987228862975}, 
            Offset[{-3, 
             0}, {-1.8165848867407983`, -2.736987228862975}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-1.6679573417952833`, -2.0755348340755075`}, 
            Offset[{3, 
             0}, {-1.6679573417952833`, -2.0755348340755075`}]}, \
{{-1.6679573417952833`, -2.0755348340755075`}, 
            Offset[{-3, 
             0}, {-1.6679573417952833`, -2.0755348340755075`}]}, \
{{-1.6679573417952833`, -2.7655887838744464`}, 
            Offset[{3, 
             0}, {-1.6679573417952833`, -2.7655887838744464`}]}, \
{{-1.6679573417952833`, -2.7655887838744464`}, 
            Offset[{-3, 
             0}, {-1.6679573417952833`, -2.7655887838744464`}]}}], {{{1., 
          0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-1.5211693704213907`, -2.148433499312244}, 
            Offset[{3, 
             0}, {-1.5211693704213907`, -2.148433499312244}]}, \
{{-1.5211693704213907`, -2.148433499312244}, 
            Offset[{-3, 
             0}, {-1.5211693704213907`, -2.148433499312244}]}, \
{{-1.5211693704213907`, -2.7982903951784612`}, 
            Offset[{3, 
             0}, {-1.5211693704213907`, -2.7982903951784612`}]}, \
{{-1.5211693704213907`, -2.7982903951784612`}, 
            Offset[{-3, 
             0}, {-1.5211693704213907`, -2.7982903951784612`}]}}], {{{1., 
          0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-1.371988295897768, -2.238404608698367}, 
            Offset[{3, 
             0}, {-1.371988295897768, -2.238404608698367}]}, \
{{-1.371988295897768, -2.238404608698367}, 
            Offset[{-3, 
             0}, {-1.371988295897768, -2.238404608698367}]}, \
{{-1.371988295897768, -2.848351894935505}, 
            Offset[{3, 
             0}, {-1.371988295897768, -2.848351894935505}]}, \
{{-1.371988295897768, -2.848351894935505}, 
            Offset[{-3, 0}, {-1.371988295897768, -2.848351894935505}]}}], {{{
          1., 0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-1.2210917594318125`, -2.3285646699347087`}, 
            Offset[{3, 
             0}, {-1.2210917594318125`, -2.3285646699347087`}]}, \
{{-1.2210917594318125`, -2.3285646699347087`}, 
            Offset[{-3, 
             0}, {-1.2210917594318125`, -2.3285646699347087`}]}, \
{{-1.2210917594318125`, -2.9077092438776244`}, 
            Offset[{3, 
             0}, {-1.2210917594318125`, -2.9077092438776244`}]}, \
{{-1.2210917594318125`, -2.9077092438776244`}, 
            Offset[{-3, 
             0}, {-1.2210917594318125`, -2.9077092438776244`}]}}], {{{1., 
          0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-1.0718189592856806`, -2.3930990433324943`}, 
            Offset[{3, 
             0}, {-1.0718189592856806`, -2.3930990433324943`}]}, \
{{-1.0718189592856806`, -2.3930990433324943`}, 
            Offset[{-3, 
             0}, {-1.0718189592856806`, -2.3930990433324943`}]}, \
{{-1.0718189592856806`, -2.942973344943205}, 
            Offset[{3, 
             0}, {-1.0718189592856806`, -2.942973344943205}]}, \
{{-1.0718189592856806`, -2.942973344943205}, 
            Offset[{-3, 
             0}, {-1.0718189592856806`, -2.942973344943205}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}}}, {{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.012833333333333334`],
      AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJwB0QEu/iFib1JlAgAAABwAAAACAAAAJ9xIO0mAFMARZd/6RKfnv4PExpY+
5BPAetDChfXT5r84ZKjHbkkTwNTi8r34X/S/qllBlQCyEsCRZ5eDhgjyv0ji
Vrm5FRLA8MPCWrBf9r9sDW0rD3kRwN3Th23icPe/okDSe0zlEMBep1CpMf75
v1MCJUSWTxDA0uiMl8Nv+7+0AA9cEWkPwA6VhxGgkP2/5CwH39IxDsAGcRZy
eAP/v5bZR1mR9wzADZI8XQlRAMCa6wTy0L8LwCI3IGCQ3wDAp4s59aeQCsC3
5TeheqEBwL5y0entWwnAOPCb2fKjAcAUpaiyQSMIwI2s1y+h9wDAR8emv/bz
BsDvgebjPAABwGTW+t+kyAXAM1XRutjHAcD8FjmjPIoEwCpwZ0Ig7wDAeJq0
voJVA8CsAVFVEbkBwLjKZ8SAMALAn0L6XZwVAsCcnf1L5/oAwOBulZ0mdQLA
6AQPEGyA/79snEDMzpYCwH5ab1C7EP2/iPOrj4j6AsAxJKIJ9K/6v/jze4JP
XQPAQzCasbVW+L+jtxT9cckDwM4C1v+p8/W/iEpnstZYBMC2y0KDl4nzvzjj
8snx8QTACNYVoysm8b9U7jJcI1gFwKGU7og=
      "]]}}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{-6.907755278982122, 0},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox["\"Slope\"", HoldForm], TraditionalForm], None}, {
     FormBox[
      TagBox[
      "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) \
[\\!\\(\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], 
      TraditionalForm], None}},
  FrameTicks->{{Automatic, Automatic}, {{{
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}, {{
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->{367.456787109375, Automatic},
  LabelStyle->{FontSize -> 14, 
    GrayLevel[0]},
  Method->{
   "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Exp[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Exp[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{-6.907755278982137, 0.}, {-6., 0.}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0], Automatic}]], "Output",
 CellChangeTimes->{
  3.852797345983632*^9, {3.852797675781699*^9, 3.852797695678535*^9}, 
   3.852797816698617*^9, 3.8527979046846867`*^9, {3.852797989212296*^9, 
   3.852798038960855*^9}, 3.852798522749322*^9, {3.852798578042531*^9, 
   3.852798621271277*^9}, 3.8527986774171886`*^9, {3.852798746320681*^9, 
   3.8527987989025307`*^9}, 3.85279883319804*^9, {3.8527988977815037`*^9, 
   3.852798988466496*^9}, {3.852799066571772*^9, 3.852799085595117*^9}, 
   3.852799371236321*^9, {3.852801936937695*^9, 3.852801973543593*^9}, {
   3.852802104655958*^9, 3.852802119561268*^9}, 3.852862500410799*^9, 
   3.852862533883133*^9, {3.852862701607958*^9, 3.852862752832765*^9}, 
   3.852862800589758*^9, {3.852862841572309*^9, 3.85286287853053*^9}, {
   3.852862961040063*^9, 3.852862987162868*^9}, {3.852863041784163*^9, 
   3.852863052517976*^9}, {3.85286851855713*^9, 3.852868563456098*^9}, 
   3.8528686112469378`*^9, {3.852868645635429*^9, 3.852868681292514*^9}, {
   3.852868719950995*^9, 3.852868738834832*^9}, 3.852868916826046*^9, {
   3.852868968202001*^9, 3.85286898265627*^9}, 3.852870678975832*^9, {
   3.8528711007779913`*^9, 3.852871118216545*^9}, 3.85287115355669*^9, 
   3.8528716206367083`*^9, 3.852874084668347*^9, 3.853381370706914*^9, 
   3.853381477907443*^9, 3.853382039594591*^9, 3.85338235753389*^9, 
   3.853402538913465*^9, 3.853403585786399*^9, 3.853405167845274*^9, 
   3.853405199586698*^9, 3.8534052376911182`*^9, 3.853405419430604*^9, {
   3.853409759182901*^9, 3.85340977227461*^9}, 3.8534101965227337`*^9, 
   3.853410249470071*^9, {3.853410575932642*^9, 3.853410598926773*^9}, 
   3.853469099635906*^9, 3.853469309131391*^9, 3.8534962859629583`*^9, 
   3.853499637160716*^9, 3.853817851525353*^9, 3.853818263087407*^9, 
   3.853824688277567*^9, 3.853824875156226*^9, 3.853833080309764*^9, 
   3.8538364568591433`*^9, 3.8538367165690203`*^9, 3.853838543473041*^9, 
   3.854072558698359*^9, 3.854091679143179*^9, 3.854098465796619*^9, 
   3.854420763080948*^9, 3.8544215348281403`*^9, 3.854423713611958*^9, 
   3.860120822653838*^9, 3.860120994984702*^9, 3.860121301461205*^9, 
   3.861765157588767*^9, {3.8617652327352104`*^9, 3.861765246883433*^9}, {
   3.8617654618721933`*^9, 3.861765495117054*^9}, 3.8617669010806527`*^9, {
   3.8617669653893194`*^9, 3.8617669711987777`*^9}, {3.8617681636139946`*^9, 
   3.861768172620324*^9}, {3.8617682638779945`*^9, 3.861768268816891*^9}, 
   3.861941031402981*^9, 3.8619503251086683`*^9, 3.8636862757494583`*^9, 
   3.863687240140381*^9, 3.885975752049604*^9, 3.885976865574806*^9, 
   3.885976952011711*^9, 3.8859772099410114`*^9, 3.8859772799657326`*^9, 
   3.8859777404306726`*^9, 3.885977787111581*^9, 3.8859795103782063`*^9, 
   3.885980164747009*^9, 3.885980479715824*^9, 3.8859806419052787`*^9, 
   3.8859808116886177`*^9, 3.886063156226128*^9, 3.8860712486314845`*^9, 
   3.888310980288575*^9, 3.888311308510944*^9, 3.889060346347356*^9, 
   3.889064571126178*^9, 3.8890819159217157`*^9, 3.889082752421399*^9, 
   3.889084482404039*^9, 3.8895043087134247`*^9, 3.8895154534729757`*^9, 
   3.8896688023607087`*^9, 3.8896724468191605`*^9, {3.889676431056512*^9, 
   3.8896764550519114`*^9}, {3.8896765019285583`*^9, 3.8896765617701*^9}, {
   3.8896766223493395`*^9, 3.889676630450638*^9}, 3.8896767650691853`*^9, 
   3.8896768162718754`*^9, {3.8896768629395857`*^9, 3.8896768889532757`*^9}, 
   3.89020392289333*^9, 3.890205948951085*^9, 3.890210264027658*^9, 
   3.8902168394329166`*^9, 3.8902168818527*^9, 3.8902172179744573`*^9, 
   3.8902178258568845`*^9, 3.8909818360454464`*^9, 3.8909822668066454`*^9, 
   3.890982759573165*^9, 3.891416145956769*^9, 3.891497449054066*^9, 
   3.891497575048091*^9, 3.891498633347803*^9, 3.8914990390695996`*^9, 
   3.891499370242484*^9, {3.891499401039276*^9, 3.8914994098999367`*^9}, 
   3.8914994879861736`*^9, 3.8915004254888115`*^9, 3.8915004803746843`*^9, 
   3.8915010712732925`*^9, 3.8915012948311296`*^9, 3.8916963064792395`*^9, {
   3.8916963479149723`*^9, 3.8916963730750875`*^9}, 3.891696419829344*^9, 
   3.8916964740375233`*^9},
 CellLabel->
  "Out[2841]=",ExpressionUUID->"6ce2721e-9c69-42de-bb89-077463ccc89c"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\ESRF\\\\Analysis\\\\2022-08_\
new_data\\\\Analysis\\\\Full form factor \
fit\\\\LH-ESRF-C22\\\\Slopes.pdf\"\>"], "Output",
 CellChangeTimes->{
  3.852797345983632*^9, {3.852797675781699*^9, 3.852797695678535*^9}, 
   3.852797816698617*^9, 3.8527979046846867`*^9, {3.852797989212296*^9, 
   3.852798038960855*^9}, 3.852798522749322*^9, {3.852798578042531*^9, 
   3.852798621271277*^9}, 3.8527986774171886`*^9, {3.852798746320681*^9, 
   3.8527987989025307`*^9}, 3.85279883319804*^9, {3.8527988977815037`*^9, 
   3.852798988466496*^9}, {3.852799066571772*^9, 3.852799085595117*^9}, 
   3.852799371236321*^9, {3.852801936937695*^9, 3.852801973543593*^9}, {
   3.852802104655958*^9, 3.852802119561268*^9}, 3.852862500410799*^9, 
   3.852862533883133*^9, {3.852862701607958*^9, 3.852862752832765*^9}, 
   3.852862800589758*^9, {3.852862841572309*^9, 3.85286287853053*^9}, {
   3.852862961040063*^9, 3.852862987162868*^9}, {3.852863041784163*^9, 
   3.852863052517976*^9}, {3.85286851855713*^9, 3.852868563456098*^9}, 
   3.8528686112469378`*^9, {3.852868645635429*^9, 3.852868681292514*^9}, {
   3.852868719950995*^9, 3.852868738834832*^9}, 3.852868916826046*^9, {
   3.852868968202001*^9, 3.85286898265627*^9}, 3.852870678975832*^9, {
   3.8528711007779913`*^9, 3.852871118216545*^9}, 3.85287115355669*^9, 
   3.8528716206367083`*^9, 3.852874084668347*^9, 3.853381370706914*^9, 
   3.853381477907443*^9, 3.853382039594591*^9, 3.85338235753389*^9, 
   3.853402538913465*^9, 3.853403585786399*^9, 3.853405167845274*^9, 
   3.853405199586698*^9, 3.8534052376911182`*^9, 3.853405419430604*^9, {
   3.853409759182901*^9, 3.85340977227461*^9}, 3.8534101965227337`*^9, 
   3.853410249470071*^9, {3.853410575932642*^9, 3.853410598926773*^9}, 
   3.853469099635906*^9, 3.853469309131391*^9, 3.8534962859629583`*^9, 
   3.853499637160716*^9, 3.853817851525353*^9, 3.853818263087407*^9, 
   3.853824688277567*^9, 3.853824875156226*^9, 3.853833080309764*^9, 
   3.8538364568591433`*^9, 3.8538367165690203`*^9, 3.853838543473041*^9, 
   3.854072558698359*^9, 3.854091679143179*^9, 3.854098465796619*^9, 
   3.854420763080948*^9, 3.8544215348281403`*^9, 3.854423713611958*^9, 
   3.860120822653838*^9, 3.860120994984702*^9, 3.860121301461205*^9, 
   3.861765157588767*^9, {3.8617652327352104`*^9, 3.861765246883433*^9}, {
   3.8617654618721933`*^9, 3.861765495117054*^9}, 3.8617669010806527`*^9, {
   3.8617669653893194`*^9, 3.8617669711987777`*^9}, {3.8617681636139946`*^9, 
   3.861768172620324*^9}, {3.8617682638779945`*^9, 3.861768268816891*^9}, 
   3.861941031402981*^9, 3.8619503251086683`*^9, 3.8636862757494583`*^9, 
   3.863687240140381*^9, 3.885975752049604*^9, 3.885976865574806*^9, 
   3.885976952011711*^9, 3.8859772099410114`*^9, 3.8859772799657326`*^9, 
   3.8859777404306726`*^9, 3.885977787111581*^9, 3.8859795103782063`*^9, 
   3.885980164747009*^9, 3.885980479715824*^9, 3.8859806419052787`*^9, 
   3.8859808116886177`*^9, 3.886063156226128*^9, 3.8860712486314845`*^9, 
   3.888310980288575*^9, 3.888311308510944*^9, 3.889060346347356*^9, 
   3.889064571126178*^9, 3.8890819159217157`*^9, 3.889082752421399*^9, 
   3.889084482404039*^9, 3.8895043087134247`*^9, 3.8895154534729757`*^9, 
   3.8896688023607087`*^9, 3.8896724468191605`*^9, {3.889676431056512*^9, 
   3.8896764550519114`*^9}, {3.8896765019285583`*^9, 3.8896765617701*^9}, {
   3.8896766223493395`*^9, 3.889676630450638*^9}, 3.8896767650691853`*^9, 
   3.8896768162718754`*^9, {3.8896768629395857`*^9, 3.8896768889532757`*^9}, 
   3.89020392289333*^9, 3.890205948951085*^9, 3.890210264027658*^9, 
   3.8902168394329166`*^9, 3.8902168818527*^9, 3.8902172179744573`*^9, 
   3.8902178258568845`*^9, 3.8909818360454464`*^9, 3.8909822668066454`*^9, 
   3.890982759573165*^9, 3.891416145956769*^9, 3.891497449054066*^9, 
   3.891497575048091*^9, 3.891498633347803*^9, 3.8914990390695996`*^9, 
   3.891499370242484*^9, {3.891499401039276*^9, 3.8914994098999367`*^9}, 
   3.8914994879861736`*^9, 3.8915004254888115`*^9, 3.8915004803746843`*^9, 
   3.8915010712732925`*^9, 3.8915012948311296`*^9, 3.8916963064792395`*^9, {
   3.8916963479149723`*^9, 3.8916963730750875`*^9}, 3.891696419829344*^9, 
   3.891696474801506*^9},
 CellLabel->
  "Out[2842]=",ExpressionUUID->"f6442c5f-dcd2-432c-8ab9-3439197f3a7e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.005944556475133113`", ",", 
     InterpretationBox[
      TemplateBox[{"-0.74", "0.23"},
       "Around"],
      Around[-0.7391686344009561, 0.2256108031341238]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.006923076633269746`", ",", 
     InterpretationBox[
      TemplateBox[{"-0.71", "0.24"},
       "Around"],
      Around[-0.7133739101905257, 0.24022545309346077`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.008052991398086013`", ",", 
     InterpretationBox[
      TemplateBox[{"-1.27", "0.22"},
       "Around"],
      Around[-1.2734305782197923`, 0.21860470665071297`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.009336439128349364`", ",", 
     InterpretationBox[
      TemplateBox[{"-1.13", "0.19"},
       "Around"],
      Around[-1.1270814075746538`, 0.18870563007910168`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.010875787473569305`", ",", 
     InterpretationBox[
      TemplateBox[{"-1.40", "0.25"},
       "Around"],
      Around[-1.3983615441650237`, 0.25474928224168547`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.012673755369119766`", ",", 
     InterpretationBox[
      TemplateBox[{"-1.47", "0.33"},
       "Around"],
      Around[-1.465059688428702, 0.33419232576753466`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.014641071626838408`", ",", 
     InterpretationBox[
      TemplateBox[{"-1.62", "0.34"},
       "Around"],
      Around[-1.6245590795392313`, 0.34000339219780384`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.016946030565237104`", ",", 
     InterpretationBox[
      TemplateBox[{"-1.71", "0.32"},
       "Around"],
      Around[-1.7147861404360367`, 0.3234236399284974]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.019716436676227158`", ",", 
     InterpretationBox[
      TemplateBox[{"-1.85", "0.30"},
       "Around"],
      Around[-1.8478089031935414`, 0.30164197971858425`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.022952509864877024`", ",", 
     InterpretationBox[
      TemplateBox[{"-1.94", "0.31"},
       "Around"],
      Around[-1.9383472878026295`, 0.30741243571126325`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.026759045868540016`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.04", "0.30"},
       "Around"],
      Around[-2.0395686420545247`, 0.29514335018136634`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.031158747627811036`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.11", "0.29"},
       "Around"],
      Around[-2.1091620931464528`, 0.2905861445212802]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.03612995951758131`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.20", "0.27"},
       "Around"],
      Around[-2.2038471789535055`, 0.2746296869319563]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.042008328721849945`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.21", "0.25"},
       "Around"],
      Around[-2.2050530434335336`, 0.25141278897573766`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.048937311723530746`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.12", "0.22"},
       "Around"],
      Around[-2.120912908334111, 0.2241619880605968]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.05674867451663513`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.13", "0.20"},
       "Around"],
      Around[-2.125116138908417, 0.1997054356901318]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.06567934910669987`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.22", "0.19"},
       "Around"],
      Around[-2.222581347955065, 0.18760405864407598`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.07672724108958731`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.12", "0.34"},
       "Around"],
      Around[-2.1167607486550155`, 0.3417969119228548]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.08921079001314548`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.2", "0.5"},
       "Around"],
      Around[-2.215365091833709, 0.5153109692778032]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.10293237045209665`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.3", "0.5"},
       "Around"],
      Around[-2.260552152824246, 0.45458522697627246`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.1197305501659388`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.3", "0.4"},
       "Around"],
      Around[-2.3072025595882764`, 0.415117488941377]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.13961689709035063`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.3", "0.4"},
       "Around"],
      Around[-2.3236366231172294`, 0.38639399169102195`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.1625800331537905`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.4", "0.4"},
       "Around"],
      Around[-2.372330782351529, 0.3646564465114455]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.18863198304539955`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.42", "0.35"},
       "Around"],
      Around[-2.420561808974977, 0.3450269748994693]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.21845628121882524`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.47", "0.32"},
       "Around"],
      Around[-2.4733619472453525`, 0.3249284479331086]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.2536022216779327`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.54", "0.30"},
       "Around"],
      Around[-2.543378251816936, 0.304973643118569]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.29490802248883013`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.62", "0.29"},
       "Around"],
      Around[-2.6181369569061665`, 0.28957228697145765`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.3423851659881858`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.67", "0.27"},
       "Around"],
      Around[-2.6680361941378496`, 0.27493715080535513`]]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.852797345983632*^9, {3.852797675781699*^9, 3.852797695678535*^9}, 
   3.852797816698617*^9, 3.8527979046846867`*^9, {3.852797989212296*^9, 
   3.852798038960855*^9}, 3.852798522749322*^9, {3.852798578042531*^9, 
   3.852798621271277*^9}, 3.8527986774171886`*^9, {3.852798746320681*^9, 
   3.8527987989025307`*^9}, 3.85279883319804*^9, {3.8527988977815037`*^9, 
   3.852798988466496*^9}, {3.852799066571772*^9, 3.852799085595117*^9}, 
   3.852799371236321*^9, {3.852801936937695*^9, 3.852801973543593*^9}, {
   3.852802104655958*^9, 3.852802119561268*^9}, 3.852862500410799*^9, 
   3.852862533883133*^9, {3.852862701607958*^9, 3.852862752832765*^9}, 
   3.852862800589758*^9, {3.852862841572309*^9, 3.85286287853053*^9}, {
   3.852862961040063*^9, 3.852862987162868*^9}, {3.852863041784163*^9, 
   3.852863052517976*^9}, {3.85286851855713*^9, 3.852868563456098*^9}, 
   3.8528686112469378`*^9, {3.852868645635429*^9, 3.852868681292514*^9}, {
   3.852868719950995*^9, 3.852868738834832*^9}, 3.852868916826046*^9, {
   3.852868968202001*^9, 3.85286898265627*^9}, 3.852870678975832*^9, {
   3.8528711007779913`*^9, 3.852871118216545*^9}, 3.85287115355669*^9, 
   3.8528716206367083`*^9, 3.852874084668347*^9, 3.853381370706914*^9, 
   3.853381477907443*^9, 3.853382039594591*^9, 3.85338235753389*^9, 
   3.853402538913465*^9, 3.853403585786399*^9, 3.853405167845274*^9, 
   3.853405199586698*^9, 3.8534052376911182`*^9, 3.853405419430604*^9, {
   3.853409759182901*^9, 3.85340977227461*^9}, 3.8534101965227337`*^9, 
   3.853410249470071*^9, {3.853410575932642*^9, 3.853410598926773*^9}, 
   3.853469099635906*^9, 3.853469309131391*^9, 3.8534962859629583`*^9, 
   3.853499637160716*^9, 3.853817851525353*^9, 3.853818263087407*^9, 
   3.853824688277567*^9, 3.853824875156226*^9, 3.853833080309764*^9, 
   3.8538364568591433`*^9, 3.8538367165690203`*^9, 3.853838543473041*^9, 
   3.854072558698359*^9, 3.854091679143179*^9, 3.854098465796619*^9, 
   3.854420763080948*^9, 3.8544215348281403`*^9, 3.854423713611958*^9, 
   3.860120822653838*^9, 3.860120994984702*^9, 3.860121301461205*^9, 
   3.861765157588767*^9, {3.8617652327352104`*^9, 3.861765246883433*^9}, {
   3.8617654618721933`*^9, 3.861765495117054*^9}, 3.8617669010806527`*^9, {
   3.8617669653893194`*^9, 3.8617669711987777`*^9}, {3.8617681636139946`*^9, 
   3.861768172620324*^9}, {3.8617682638779945`*^9, 3.861768268816891*^9}, 
   3.861941031402981*^9, 3.8619503251086683`*^9, 3.8636862757494583`*^9, 
   3.863687240140381*^9, 3.885975752049604*^9, 3.885976865574806*^9, 
   3.885976952011711*^9, 3.8859772099410114`*^9, 3.8859772799657326`*^9, 
   3.8859777404306726`*^9, 3.885977787111581*^9, 3.8859795103782063`*^9, 
   3.885980164747009*^9, 3.885980479715824*^9, 3.8859806419052787`*^9, 
   3.8859808116886177`*^9, 3.886063156226128*^9, 3.8860712486314845`*^9, 
   3.888310980288575*^9, 3.888311308510944*^9, 3.889060346347356*^9, 
   3.889064571126178*^9, 3.8890819159217157`*^9, 3.889082752421399*^9, 
   3.889084482404039*^9, 3.8895043087134247`*^9, 3.8895154534729757`*^9, 
   3.8896688023607087`*^9, 3.8896724468191605`*^9, {3.889676431056512*^9, 
   3.8896764550519114`*^9}, {3.8896765019285583`*^9, 3.8896765617701*^9}, {
   3.8896766223493395`*^9, 3.889676630450638*^9}, 3.8896767650691853`*^9, 
   3.8896768162718754`*^9, {3.8896768629395857`*^9, 3.8896768889532757`*^9}, 
   3.89020392289333*^9, 3.890205948951085*^9, 3.890210264027658*^9, 
   3.8902168394329166`*^9, 3.8902168818527*^9, 3.8902172179744573`*^9, 
   3.8902178258568845`*^9, 3.8909818360454464`*^9, 3.8909822668066454`*^9, 
   3.890982759573165*^9, 3.891416145956769*^9, 3.891497449054066*^9, 
   3.891497575048091*^9, 3.891498633347803*^9, 3.8914990390695996`*^9, 
   3.891499370242484*^9, {3.891499401039276*^9, 3.8914994098999367`*^9}, 
   3.8914994879861736`*^9, 3.8915004254888115`*^9, 3.8915004803746843`*^9, 
   3.8915010712732925`*^9, 3.8915012948311296`*^9, 3.8916963064792395`*^9, {
   3.8916963479149723`*^9, 3.8916963730750875`*^9}, 3.891696419829344*^9, 
   3.891696474816434*^9},
 CellLabel->
  "Out[2843]=",ExpressionUUID->"3eaf283c-b4ce-4629-a81e-ae3a42d60f00"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\ESRF\\\\Analysis\\\\2022-08_\
new_data\\\\Analysis\\\\Full form factor fit\\\\LH-ESRF-C22\\\\Sample \
playground LH-ESRF-C22 NEW SAXS slopes.csv\"\>"], "Output",
 CellChangeTimes->{
  3.852797345983632*^9, {3.852797675781699*^9, 3.852797695678535*^9}, 
   3.852797816698617*^9, 3.8527979046846867`*^9, {3.852797989212296*^9, 
   3.852798038960855*^9}, 3.852798522749322*^9, {3.852798578042531*^9, 
   3.852798621271277*^9}, 3.8527986774171886`*^9, {3.852798746320681*^9, 
   3.8527987989025307`*^9}, 3.85279883319804*^9, {3.8527988977815037`*^9, 
   3.852798988466496*^9}, {3.852799066571772*^9, 3.852799085595117*^9}, 
   3.852799371236321*^9, {3.852801936937695*^9, 3.852801973543593*^9}, {
   3.852802104655958*^9, 3.852802119561268*^9}, 3.852862500410799*^9, 
   3.852862533883133*^9, {3.852862701607958*^9, 3.852862752832765*^9}, 
   3.852862800589758*^9, {3.852862841572309*^9, 3.85286287853053*^9}, {
   3.852862961040063*^9, 3.852862987162868*^9}, {3.852863041784163*^9, 
   3.852863052517976*^9}, {3.85286851855713*^9, 3.852868563456098*^9}, 
   3.8528686112469378`*^9, {3.852868645635429*^9, 3.852868681292514*^9}, {
   3.852868719950995*^9, 3.852868738834832*^9}, 3.852868916826046*^9, {
   3.852868968202001*^9, 3.85286898265627*^9}, 3.852870678975832*^9, {
   3.8528711007779913`*^9, 3.852871118216545*^9}, 3.85287115355669*^9, 
   3.8528716206367083`*^9, 3.852874084668347*^9, 3.853381370706914*^9, 
   3.853381477907443*^9, 3.853382039594591*^9, 3.85338235753389*^9, 
   3.853402538913465*^9, 3.853403585786399*^9, 3.853405167845274*^9, 
   3.853405199586698*^9, 3.8534052376911182`*^9, 3.853405419430604*^9, {
   3.853409759182901*^9, 3.85340977227461*^9}, 3.8534101965227337`*^9, 
   3.853410249470071*^9, {3.853410575932642*^9, 3.853410598926773*^9}, 
   3.853469099635906*^9, 3.853469309131391*^9, 3.8534962859629583`*^9, 
   3.853499637160716*^9, 3.853817851525353*^9, 3.853818263087407*^9, 
   3.853824688277567*^9, 3.853824875156226*^9, 3.853833080309764*^9, 
   3.8538364568591433`*^9, 3.8538367165690203`*^9, 3.853838543473041*^9, 
   3.854072558698359*^9, 3.854091679143179*^9, 3.854098465796619*^9, 
   3.854420763080948*^9, 3.8544215348281403`*^9, 3.854423713611958*^9, 
   3.860120822653838*^9, 3.860120994984702*^9, 3.860121301461205*^9, 
   3.861765157588767*^9, {3.8617652327352104`*^9, 3.861765246883433*^9}, {
   3.8617654618721933`*^9, 3.861765495117054*^9}, 3.8617669010806527`*^9, {
   3.8617669653893194`*^9, 3.8617669711987777`*^9}, {3.8617681636139946`*^9, 
   3.861768172620324*^9}, {3.8617682638779945`*^9, 3.861768268816891*^9}, 
   3.861941031402981*^9, 3.8619503251086683`*^9, 3.8636862757494583`*^9, 
   3.863687240140381*^9, 3.885975752049604*^9, 3.885976865574806*^9, 
   3.885976952011711*^9, 3.8859772099410114`*^9, 3.8859772799657326`*^9, 
   3.8859777404306726`*^9, 3.885977787111581*^9, 3.8859795103782063`*^9, 
   3.885980164747009*^9, 3.885980479715824*^9, 3.8859806419052787`*^9, 
   3.8859808116886177`*^9, 3.886063156226128*^9, 3.8860712486314845`*^9, 
   3.888310980288575*^9, 3.888311308510944*^9, 3.889060346347356*^9, 
   3.889064571126178*^9, 3.8890819159217157`*^9, 3.889082752421399*^9, 
   3.889084482404039*^9, 3.8895043087134247`*^9, 3.8895154534729757`*^9, 
   3.8896688023607087`*^9, 3.8896724468191605`*^9, {3.889676431056512*^9, 
   3.8896764550519114`*^9}, {3.8896765019285583`*^9, 3.8896765617701*^9}, {
   3.8896766223493395`*^9, 3.889676630450638*^9}, 3.8896767650691853`*^9, 
   3.8896768162718754`*^9, {3.8896768629395857`*^9, 3.8896768889532757`*^9}, 
   3.89020392289333*^9, 3.890205948951085*^9, 3.890210264027658*^9, 
   3.8902168394329166`*^9, 3.8902168818527*^9, 3.8902172179744573`*^9, 
   3.8902178258568845`*^9, 3.8909818360454464`*^9, 3.8909822668066454`*^9, 
   3.890982759573165*^9, 3.891416145956769*^9, 3.891497449054066*^9, 
   3.891497575048091*^9, 3.891498633347803*^9, 3.8914990390695996`*^9, 
   3.891499370242484*^9, {3.891499401039276*^9, 3.8914994098999367`*^9}, 
   3.8914994879861736`*^9, 3.8915004254888115`*^9, 3.8915004803746843`*^9, 
   3.8915010712732925`*^9, 3.8915012948311296`*^9, 3.8916963064792395`*^9, {
   3.8916963479149723`*^9, 3.8916963730750875`*^9}, 3.891696419829344*^9, 
   3.8916964749195786`*^9},
 CellLabel->
  "Out[2845]=",ExpressionUUID->"f9a19f71-8bb9-43da-8a39-3f129f4ceaa5"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\ESRF\\\\Analysis\\\\2022-08_\
new_data\\\\Analysis\\\\Full form factor fit\\\\LH-ESRF-C22\\\\Sample \
playground LH-ESRF-C22 NEW.nb\"\>"], "Output",
 CellChangeTimes->{
  3.852797345983632*^9, {3.852797675781699*^9, 3.852797695678535*^9}, 
   3.852797816698617*^9, 3.8527979046846867`*^9, {3.852797989212296*^9, 
   3.852798038960855*^9}, 3.852798522749322*^9, {3.852798578042531*^9, 
   3.852798621271277*^9}, 3.8527986774171886`*^9, {3.852798746320681*^9, 
   3.8527987989025307`*^9}, 3.85279883319804*^9, {3.8527988977815037`*^9, 
   3.852798988466496*^9}, {3.852799066571772*^9, 3.852799085595117*^9}, 
   3.852799371236321*^9, {3.852801936937695*^9, 3.852801973543593*^9}, {
   3.852802104655958*^9, 3.852802119561268*^9}, 3.852862500410799*^9, 
   3.852862533883133*^9, {3.852862701607958*^9, 3.852862752832765*^9}, 
   3.852862800589758*^9, {3.852862841572309*^9, 3.85286287853053*^9}, {
   3.852862961040063*^9, 3.852862987162868*^9}, {3.852863041784163*^9, 
   3.852863052517976*^9}, {3.85286851855713*^9, 3.852868563456098*^9}, 
   3.8528686112469378`*^9, {3.852868645635429*^9, 3.852868681292514*^9}, {
   3.852868719950995*^9, 3.852868738834832*^9}, 3.852868916826046*^9, {
   3.852868968202001*^9, 3.85286898265627*^9}, 3.852870678975832*^9, {
   3.8528711007779913`*^9, 3.852871118216545*^9}, 3.85287115355669*^9, 
   3.8528716206367083`*^9, 3.852874084668347*^9, 3.853381370706914*^9, 
   3.853381477907443*^9, 3.853382039594591*^9, 3.85338235753389*^9, 
   3.853402538913465*^9, 3.853403585786399*^9, 3.853405167845274*^9, 
   3.853405199586698*^9, 3.8534052376911182`*^9, 3.853405419430604*^9, {
   3.853409759182901*^9, 3.85340977227461*^9}, 3.8534101965227337`*^9, 
   3.853410249470071*^9, {3.853410575932642*^9, 3.853410598926773*^9}, 
   3.853469099635906*^9, 3.853469309131391*^9, 3.8534962859629583`*^9, 
   3.853499637160716*^9, 3.853817851525353*^9, 3.853818263087407*^9, 
   3.853824688277567*^9, 3.853824875156226*^9, 3.853833080309764*^9, 
   3.8538364568591433`*^9, 3.8538367165690203`*^9, 3.853838543473041*^9, 
   3.854072558698359*^9, 3.854091679143179*^9, 3.854098465796619*^9, 
   3.854420763080948*^9, 3.8544215348281403`*^9, 3.854423713611958*^9, 
   3.860120822653838*^9, 3.860120994984702*^9, 3.860121301461205*^9, 
   3.861765157588767*^9, {3.8617652327352104`*^9, 3.861765246883433*^9}, {
   3.8617654618721933`*^9, 3.861765495117054*^9}, 3.8617669010806527`*^9, {
   3.8617669653893194`*^9, 3.8617669711987777`*^9}, {3.8617681636139946`*^9, 
   3.861768172620324*^9}, {3.8617682638779945`*^9, 3.861768268816891*^9}, 
   3.861941031402981*^9, 3.8619503251086683`*^9, 3.8636862757494583`*^9, 
   3.863687240140381*^9, 3.885975752049604*^9, 3.885976865574806*^9, 
   3.885976952011711*^9, 3.8859772099410114`*^9, 3.8859772799657326`*^9, 
   3.8859777404306726`*^9, 3.885977787111581*^9, 3.8859795103782063`*^9, 
   3.885980164747009*^9, 3.885980479715824*^9, 3.8859806419052787`*^9, 
   3.8859808116886177`*^9, 3.886063156226128*^9, 3.8860712486314845`*^9, 
   3.888310980288575*^9, 3.888311308510944*^9, 3.889060346347356*^9, 
   3.889064571126178*^9, 3.8890819159217157`*^9, 3.889082752421399*^9, 
   3.889084482404039*^9, 3.8895043087134247`*^9, 3.8895154534729757`*^9, 
   3.8896688023607087`*^9, 3.8896724468191605`*^9, {3.889676431056512*^9, 
   3.8896764550519114`*^9}, {3.8896765019285583`*^9, 3.8896765617701*^9}, {
   3.8896766223493395`*^9, 3.889676630450638*^9}, 3.8896767650691853`*^9, 
   3.8896768162718754`*^9, {3.8896768629395857`*^9, 3.8896768889532757`*^9}, 
   3.89020392289333*^9, 3.890205948951085*^9, 3.890210264027658*^9, 
   3.8902168394329166`*^9, 3.8902168818527*^9, 3.8902172179744573`*^9, 
   3.8902178258568845`*^9, 3.8909818360454464`*^9, 3.8909822668066454`*^9, 
   3.890982759573165*^9, 3.891416145956769*^9, 3.891497449054066*^9, 
   3.891497575048091*^9, 3.891498633347803*^9, 3.8914990390695996`*^9, 
   3.891499370242484*^9, {3.891499401039276*^9, 3.8914994098999367`*^9}, 
   3.8914994879861736`*^9, 3.8915004254888115`*^9, 3.8915004803746843`*^9, 
   3.8915010712732925`*^9, 3.8915012948311296`*^9, 3.8916963064792395`*^9, {
   3.8916963479149723`*^9, 3.8916963730750875`*^9}, 3.891696419829344*^9, 
   3.8916964749841185`*^9},
 CellLabel->
  "Out[2846]=",ExpressionUUID->"e134f3c5-fb90-4479-bbad-afdc0fd3ff81"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fitting slopes using L + R (thickness + radius)", "Subsubsection",
 CellChangeTimes->{{3.8890831159415197`*^9, 3.889083129907494*^9}, {
  3.8895043397252035`*^9, 
  3.889504346042064*^9}},ExpressionUUID->"c264222d-eedd-4632-bf2a-\
25682c9a5ec9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"fitSlopeLRResult", "=", 
  RowBox[{"fitSlopeLR", "[", 
   RowBox[{
   "datamerged", ",", " ", "2.6", ",", " ", "0.5", ",", " ", "6", ",", " ", 
    "0.5"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8890831508560247`*^9, 3.889083186178582*^9}, {
  3.889083221328817*^9, 3.889083280853166*^9}, {3.890210231443339*^9, 
  3.8902102343651667`*^9}},
 CellLabel->
  "In[2854]:=",ExpressionUUID->"245caa09-fb84-4947-ab47-dd7c0b5b4707"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "2.5052494573989503`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.6791987154840752`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"5.964853188524545`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.5974919472546679`"}],
  SequenceForm[
  "\[Mu]l = ", 2.5052494573989503`, " \[Sigma]l = ", 0.6791987154840752, 
   " \[Mu]r = ", 5.964853188524545 " \[Sigma]r = ", 0.5974919472546679],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8914975996350174`*^9, 3.8914986791906385`*^9, 
  3.8914995306983347`*^9, 3.8915005231069183`*^9, 3.891501364157484*^9, 
  3.8916965159581976`*^9},
 CellLabel->
  "During evaluation of \
In[2854]:=",ExpressionUUID->"97df5ed7-6c8b-4383-aca1-468085e836b7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "2.482242568961419`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.7281991469768736`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"5.973760111772534`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.5598109125206577`"}],
  SequenceForm[
  "\[Mu]l = ", 2.482242568961419, " \[Sigma]l = ", 0.7281991469768736, 
   " \[Mu]r = ", 5.973760111772534 " \[Sigma]r = ", 0.5598109125206577],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8914975996350174`*^9, 3.8914986791906385`*^9, 
  3.8914995306983347`*^9, 3.8915005231069183`*^9, 3.891501364157484*^9, 
  3.8916965216014614`*^9},
 CellLabel->
  "During evaluation of \
In[2854]:=",ExpressionUUID->"49b0fb76-6abc-4f15-b1d3-f6d145edfd13"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "2.475445908229145`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.7578786462009452`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"5.964768548012056`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.5638347394578828`"}],
  SequenceForm[
  "\[Mu]l = ", 2.475445908229145, " \[Sigma]l = ", 0.7578786462009452, 
   " \[Mu]r = ", 5.964768548012056 " \[Sigma]r = ", 0.5638347394578828],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8914975996350174`*^9, 3.8914986791906385`*^9, 
  3.8914995306983347`*^9, 3.8915005231069183`*^9, 3.891501364157484*^9, 
  3.8916965244679704`*^9},
 CellLabel->
  "During evaluation of \
In[2854]:=",ExpressionUUID->"b03be9aa-25e3-4972-af4d-5dea8ce29788"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "2.4826649200001167`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.7598602582969421`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"5.958992128062569`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.5604656474713594`"}],
  SequenceForm[
  "\[Mu]l = ", 2.4826649200001167`, " \[Sigma]l = ", 0.7598602582969421, 
   " \[Mu]r = ", 5.958992128062569 " \[Sigma]r = ", 0.5604656474713594],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8914975996350174`*^9, 3.8914986791906385`*^9, 
  3.8914995306983347`*^9, 3.8915005231069183`*^9, 3.891501364157484*^9, 
  3.891696527311288*^9},
 CellLabel->
  "During evaluation of \
In[2854]:=",ExpressionUUID->"8f6af771-7feb-4f2e-b694-0895c9fc2384"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "2.5944858535366486`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.8015762842933587`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"5.861976980867181`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.5201426972321658`"}],
  SequenceForm[
  "\[Mu]l = ", 2.5944858535366486`, " \[Sigma]l = ", 0.8015762842933587, 
   " \[Mu]r = ", 5.861976980867181 " \[Sigma]r = ", 0.5201426972321658],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8914975996350174`*^9, 3.8914986791906385`*^9, 
  3.8914995306983347`*^9, 3.8915005231069183`*^9, 3.891501364157484*^9, 
  3.891696530160247*^9},
 CellLabel->
  "During evaluation of \
In[2854]:=",ExpressionUUID->"a07f225e-ccf3-4107-863f-be151fc10244"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "2.719467761670229`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.8632725737636803`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"5.749011610214295`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.4814545708985885`"}],
  SequenceForm[
  "\[Mu]l = ", 2.719467761670229, " \[Sigma]l = ", 0.8632725737636803, 
   " \[Mu]r = ", 5.749011610214295 " \[Sigma]r = ", 0.4814545708985885],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8914975996350174`*^9, 3.8914986791906385`*^9, 
  3.8914995306983347`*^9, 3.8915005231069183`*^9, 3.891501364157484*^9, 
  3.8916965330209*^9},
 CellLabel->
  "During evaluation of \
In[2854]:=",ExpressionUUID->"7e13ab7c-b6ba-405b-915f-0dd86793596b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "2.733138741393128`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.8726339129427247`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"5.742822541807497`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.4831846173948668`"}],
  SequenceForm[
  "\[Mu]l = ", 2.733138741393128, " \[Sigma]l = ", 0.8726339129427247, 
   " \[Mu]r = ", 5.742822541807497 " \[Sigma]r = ", 0.4831846173948668],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8914975996350174`*^9, 3.8914986791906385`*^9, 
  3.8914995306983347`*^9, 3.8915005231069183`*^9, 3.891501364157484*^9, 
  3.891696535835063*^9},
 CellLabel->
  "During evaluation of \
In[2854]:=",ExpressionUUID->"de5d20bf-226f-44ce-b419-79984e19d0b9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "2.7432539505782954`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.8821445958974486`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"5.755778248955661`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.49394921380450063`"}],
  SequenceForm[
  "\[Mu]l = ", 2.7432539505782954`, " \[Sigma]l = ", 0.8821445958974486, 
   " \[Mu]r = ", 5.755778248955661 " \[Sigma]r = ", 0.49394921380450063`],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8914975996350174`*^9, 3.8914986791906385`*^9, 
  3.8914995306983347`*^9, 3.8915005231069183`*^9, 3.891501364157484*^9, 
  3.891696538696954*^9},
 CellLabel->
  "During evaluation of \
In[2854]:=",ExpressionUUID->"f13ad79f-25e8-49f4-a0c6-a827bcb417d7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "2.76996402622777`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.8963635743448222`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"5.757594712372038`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.49665706115050995`"}],
  SequenceForm[
  "\[Mu]l = ", 2.76996402622777, " \[Sigma]l = ", 0.8963635743448222, 
   " \[Mu]r = ", 5.757594712372038 " \[Sigma]r = ", 0.49665706115050995`],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8914975996350174`*^9, 3.8914986791906385`*^9, 
  3.8914995306983347`*^9, 3.8915005231069183`*^9, 3.891501364157484*^9, 
  3.891696541581221*^9},
 CellLabel->
  "During evaluation of \
In[2854]:=",ExpressionUUID->"a5b124b8-96ae-4180-91f3-8bbd8553d512"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "2.932523153327365`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.9741270889545063`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"5.777758680208854`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.5100801694324463`"}],
  SequenceForm[
  "\[Mu]l = ", 2.932523153327365, " \[Sigma]l = ", 0.9741270889545063, 
   " \[Mu]r = ", 5.777758680208854 " \[Sigma]r = ", 0.5100801694324463],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8914975996350174`*^9, 3.8914986791906385`*^9, 
  3.8914995306983347`*^9, 3.8915005231069183`*^9, 3.891501364157484*^9, 
  3.891696545009086*^9},
 CellLabel->
  "During evaluation of \
In[2854]:=",ExpressionUUID->"7fe91375-6681-4f71-aeea-967c2260be5c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "3.122957359888376`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "1.0533901561501304`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"5.802485854534389`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.5202591789311285`"}],
  SequenceForm[
  "\[Mu]l = ", 3.122957359888376, " \[Sigma]l = ", 1.0533901561501304`, 
   " \[Mu]r = ", 5.802485854534389 " \[Sigma]r = ", 0.5202591789311285],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8914975996350174`*^9, 3.8914986791906385`*^9, 
  3.8914995306983347`*^9, 3.8915005231069183`*^9, 3.891501364157484*^9, 
  3.891696549750119*^9},
 CellLabel->
  "During evaluation of \
In[2854]:=",ExpressionUUID->"3a668534-b66c-4ef1-b2a6-f165bbfe1d8a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "3.388033914540352`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "1.1447517706477741`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"5.84180043873578`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.5309876502720137`"}],
  SequenceForm[
  "\[Mu]l = ", 3.388033914540352, " \[Sigma]l = ", 1.1447517706477741`, 
   " \[Mu]r = ", 5.84180043873578 " \[Sigma]r = ", 0.5309876502720137],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8914975996350174`*^9, 3.8914986791906385`*^9, 
  3.8914995306983347`*^9, 3.8915005231069183`*^9, 3.891501364157484*^9, 
  3.8916965542756777`*^9},
 CellLabel->
  "During evaluation of \
In[2854]:=",ExpressionUUID->"516521c4-3a22-4048-8687-c887d3c14d4c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "3.524904790575465`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "1.1805747212137159`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"5.860215189942161`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.5341884704198839`"}],
  SequenceForm[
  "\[Mu]l = ", 3.524904790575465, " \[Sigma]l = ", 1.1805747212137159`, 
   " \[Mu]r = ", 5.860215189942161 " \[Sigma]r = ", 0.5341884704198839],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8914975996350174`*^9, 3.8914986791906385`*^9, 
  3.8914995306983347`*^9, 3.8915005231069183`*^9, 3.891501364157484*^9, 
  3.891696559287702*^9},
 CellLabel->
  "During evaluation of \
In[2854]:=",ExpressionUUID->"3e512a8e-b462-42d4-85e7-6034a6c88168"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "3.584337194345304`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "1.2023108254989359`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"5.861792527946377`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.5342315087135507`"}],
  SequenceForm[
  "\[Mu]l = ", 3.584337194345304, " \[Sigma]l = ", 1.2023108254989359`, 
   " \[Mu]r = ", 5.861792527946377 " \[Sigma]r = ", 0.5342315087135507],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8914975996350174`*^9, 3.8914986791906385`*^9, 
  3.8914995306983347`*^9, 3.8915005231069183`*^9, 3.891501364157484*^9, 
  3.89169656362971*^9},
 CellLabel->
  "During evaluation of \
In[2854]:=",ExpressionUUID->"04f7c86b-2dc7-45c3-96d5-b65c9e91bdbc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "3.6014845285135966`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "1.2062585964180803`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"5.8647575004166415`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.5358345873802405`"}],
  SequenceForm[
  "\[Mu]l = ", 3.6014845285135966`, " \[Sigma]l = ", 1.2062585964180803`, 
   " \[Mu]r = ", 5.8647575004166415` " \[Sigma]r = ", 0.5358345873802405],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8914975996350174`*^9, 3.8914986791906385`*^9, 
  3.8914995306983347`*^9, 3.8915005231069183`*^9, 3.891501364157484*^9, 
  3.8916965675514946`*^9},
 CellLabel->
  "During evaluation of \
In[2854]:=",ExpressionUUID->"dc9b63b4-8e92-4e4f-acb1-ebe2f275a754"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "3.606864408925717`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "1.2082325061479284`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"5.864167690526002`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.5358946610911668`"}],
  SequenceForm[
  "\[Mu]l = ", 3.606864408925717, " \[Sigma]l = ", 1.2082325061479284`, 
   " \[Mu]r = ", 5.864167690526002 " \[Sigma]r = ", 0.5358946610911668],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8914975996350174`*^9, 3.8914986791906385`*^9, 
  3.8914995306983347`*^9, 3.8915005231069183`*^9, 3.891501364157484*^9, 
  3.8916965716566267`*^9},
 CellLabel->
  "During evaluation of \
In[2854]:=",ExpressionUUID->"4e4db027-a724-45f3-9424-52cb63011178"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "3.6081019520441724`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "1.2087008875299352`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"5.863678198084414`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.5357890828094317`"}],
  SequenceForm[
  "\[Mu]l = ", 3.6081019520441724`, " \[Sigma]l = ", 1.2087008875299352`, 
   " \[Mu]r = ", 5.863678198084414 " \[Sigma]r = ", 0.5357890828094317],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8914975996350174`*^9, 3.8914986791906385`*^9, 
  3.8914995306983347`*^9, 3.8915005231069183`*^9, 3.891501364157484*^9, 
  3.8916965758698187`*^9},
 CellLabel->
  "During evaluation of \
In[2854]:=",ExpressionUUID->"e23ca904-01bd-4f27-b543-7131ea3c7e78"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "3.608076974210329`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "1.2086895212877269`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"5.863631672400724`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.5357719146777817`"}],
  SequenceForm[
  "\[Mu]l = ", 3.608076974210329, " \[Sigma]l = ", 1.2086895212877269`, 
   " \[Mu]r = ", 5.863631672400724 " \[Sigma]r = ", 0.5357719146777817],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8914975996350174`*^9, 3.8914986791906385`*^9, 
  3.8914995306983347`*^9, 3.8915005231069183`*^9, 3.891501364157484*^9, 
  3.891696580449153*^9},
 CellLabel->
  "During evaluation of \
In[2854]:=",ExpressionUUID->"ab9d257b-a641-49b4-ae32-6dec8ee14d70"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "3.6080663692604333`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "1.2086853192154883`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"5.8636268004110645`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.5357697961010014`"}],
  SequenceForm[
  "\[Mu]l = ", 3.6080663692604333`, " \[Sigma]l = ", 1.2086853192154883`, 
   " \[Mu]r = ", 5.8636268004110645` " \[Sigma]r = ", 0.5357697961010014],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8914975996350174`*^9, 3.8914986791906385`*^9, 
  3.8914995306983347`*^9, 3.8915005231069183`*^9, 3.891501364157484*^9, 
  3.891696584360066*^9},
 CellLabel->
  "During evaluation of \
In[2854]:=",ExpressionUUID->"917f6f03-ef9c-4a98-a802-1bfdb12d06d4"]
}, Open  ]],

Cell[BoxData[
 TemplateBox[{
  "FindMinimum", "lstol", 
   "\"The line search decreased the step size to within the tolerance \
specified by AccuracyGoal and PrecisionGoal but was unable to find a \
sufficient decrease in the function. You may need more than \\!\\(\\*RowBox[{\
\\\"MachinePrecision\\\"}]\\) digits of working precision to meet these \
tolerances.\"", 2, 2854, 305, 18413233985661327353, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.8914172769507356`*^9, 3.891418369238621*^9, 
  3.891497945095332*^9, 3.8914988442705393`*^9, 3.8914997395438075`*^9, 
  3.8915007295980043`*^9, 3.891501571189099*^9, 3.8916966370315676`*^9},
 CellLabel->
  "During evaluation of \
In[2854]:=",ExpressionUUID->"9bfbae9d-5860-419a-bf64-7a845933a786"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\[Mu]l", "\[Rule]", "3.608066369253442`"}], ",", 
   RowBox[{"\[Sigma]l", "\[Rule]", "1.208685319213119`"}], ",", 
   RowBox[{"\[Mu]r", "\[Rule]", "5.863626800410696`"}], ",", 
   RowBox[{"\[Sigma]r", "\[Rule]", "0.5357697961006579`"}], ",", 
   RowBox[{"\[Mu]lx", "\[Rule]", "76.59459169071746`"}], ",", 
   RowBox[{"\[Sigma]lx", "\[Rule]", "139.35003966013832`"}], ",", 
   RowBox[{"\[Mu]rx", "\[Rule]", "406.32423027015903`"}], ",", 
   RowBox[{"\[Sigma]rx", "\[Rule]", "234.29441168759013`"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.8890831915134697`*^9, 3.889083231716405*^9, 
  3.889084522029305*^9, 3.889504478964719*^9, 3.889668839037505*^9, 
  3.8896689977438555`*^9, 3.8902046298151426`*^9, 3.8902062509864902`*^9, 
  3.8902104624878206`*^9, 3.890216989995762*^9, 3.8902173041350584`*^9, 
  3.8902179907784314`*^9, 3.8909820012674875`*^9, 3.8909824058680325`*^9, 
  3.890982955030755*^9, 3.8909840701831517`*^9, 3.8909841450834846`*^9, 
  3.8909843770126934`*^9, 3.8909844264654613`*^9, 3.890984470131813*^9, 
  3.8914172771083*^9, 3.8914183694354115`*^9, 3.891497945190528*^9, 
  3.891498844312603*^9, 3.891499739625004*^9, 3.8915007296431637`*^9, 
  3.8915015713154106`*^9, 3.8916966370696754`*^9},
 CellLabel->
  "Out[2854]=",ExpressionUUID->"792c53db-ea47-4a77-b0d5-fced415c8769"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"ColorData", "[", 
    RowBox[{"\"\<SunsetColors\>\"", ",", "\"\<Image\>\""}], "]"}], "*)"}], 
  " ", 
  RowBox[{"(*", " ", 
   RowBox[{"Visualize", " ", "a", " ", "color", " ", "scheme"}], "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"plotIntensityFitPlatelets", " ", "=", " ", 
    RowBox[{"ListLogLogPlot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"datamerged", "[", 
         RowBox[{"[", 
          RowBox[{"1", ";;", 
           RowBox[{"-", "1"}]}], "]"}], "]"}], ",", 
        RowBox[{
         RowBox[{"calculateIntensitiesLR", "[", 
          RowBox[{
          "\[Mu]l", ",", "\[Sigma]l", ",", "\[Mu]r", ",", "\[Sigma]r"}], 
          "]"}], "/.", "fitSlopeLRResult"}]}], "}"}], ",", " ", 
      RowBox[{"(*", 
       RowBox[{"Optional", ":", " ", 
        RowBox[{
        "Plot", " ", "every", " ", "2", "nd", " ", "point", " ", "only", " ", 
         "for", " ", "readibility"}], ":", " ", 
        RowBox[{"datamerged", "[", 
         RowBox[{"[", 
          RowBox[{"1", ";;", 
           RowBox[{"-", "1"}], ";;", "2"}], "]"}], "]"}]}], "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"5", " ", 
            RowBox[{"10", "^", 
             RowBox[{"-", "3"}]}]}], ",", " ", 
           RowBox[{"10", "^", "0"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"10", "^", 
            RowBox[{"-", "6"}]}], ",", " ", 
           RowBox[{"10", "^", "2"}]}], "}"}]}], "}"}]}], ",", " ", 
      "\[IndentingNewLine]", 
      RowBox[{"Joined", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"False", ",", "True"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameTicks", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",",
       "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", " ", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\"\<Intensity [a.u.]\>\"", ",", " ", "None"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<\!\(\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotStyle", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "1", "]"}], ",", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"Black", ",", " ", 
           RowBox[{"PointSize", "[", "0.04", "]"}], ",", " ", 
           RowBox[{"Thickness", "[", "0.004", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           
           TemplateBox[<|
            "color" -> RGBColor[
              0.6745098039215687, 0.07450980392156863, 0.043137254901960784`]|>,
            "RGBColorSwatchTemplate"], ",", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}]}], "}"}]}], ",", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{
        "third", " ", "color", " ", "not", " ", "currently", " ", "used"}], 
        ",", " ", 
        RowBox[{
        "but", " ", "left", " ", "here", " ", "for", " ", "reference", " ", 
         "as", " ", "it", " ", "has", " ", "a", " ", "pretty", " ", "decent", 
         " ", "contrast", " ", "with", " ", "the", " ", "first", " ", 
         "color"}]}], " ", "*)"}], 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"ColorData", "[", "9", "]"}], "[", "i", "]"}], ",", 
            RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
            RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}], ",", " ", 
          RowBox[{"{", 
           RowBox[{"i", ",", 
            RowBox[{"Length", "[", "datamerged", "]"}]}], "}"}]}], "]"}], 
        ","}], "*)"}], 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Automatic", ",", "Automatic"}], "}"}], ","}], "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
        "}"}]}]}], "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
        "\"\<PlateletsIntensityFit.pdf\>\""}], "}"}], "]"}], ",", 
     "plotIntensityFitPlatelets"}], "]"}], "\[IndentingNewLine]", "\n", 
   RowBox[{"plotPlateletsFit", " ", "=", " ", 
    RowBox[{"ListLogLinearPlot", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"slope", "[", 
         RowBox[{"datamerged", ",", "0.15"}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"slope", "[", 
         RowBox[{
          RowBox[{"calculateIntensitiesLR", "[", 
           RowBox[{
           "\[Mu]l", ",", "\[Sigma]l", ",", "\[Mu]r", ",", "\[Sigma]r"}], 
           "]"}], "/.", "fitSlopeLRResult"}], "]"}]}], "\[IndentingNewLine]", 
       "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameTicks", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Automatic", ",", " ", "Automatic"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",",
       "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", " ", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\"\<Slope\>\"", ",", " ", "None"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotLegends", "->", 
       RowBox[{"{", 
        RowBox[{
        "\"\<Binned data\>\"", ",", " ", 
         "\"\<Platelets form factor fit\>\""}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotStyle", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "1", "]"}], ",", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           
           TemplateBox[<|
            "color" -> RGBColor[
              0.6745098039215687, 0.07450980392156863, 0.043137254901960784`]|>,
            "RGBColorSwatchTemplate"], ",", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"Black", ",", " ", 
           RowBox[{"PointSize", "[", "0.04", "]"}], ",", " ", 
           RowBox[{"Thickness", "[", "0.004", "]"}], ",", " ", "Dashed"}], 
          "}"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameStyle", "\[Rule]", "Black"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Joined", "->", 
       RowBox[{"{", 
        RowBox[{"False", ",", "True"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotMarkers", "->", 
       RowBox[{"{", 
        RowBox[{"Automatic", ",", "\"\<\>\"", ",", "\"\<\>\""}], "}"}]}]}], 
     "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
        "\"\<PlateletsSlopeFit.pdf\>\""}], "}"}], "]"}], ",", 
     "plotPlateletsFit"}], "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"plot3Dprobability", " ", "=", " ", 
    RowBox[{"ListPlot3D", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Flatten", "[", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"l", ",", "r", ",", 
            RowBox[{
             RowBox[{"probfunc", "[", 
              RowBox[{
              "\[Mu]l", ",", "\[Sigma]l", ",", "\[Mu]r", ",", "\[Sigma]r", 
               ",", "l", ",", "r"}], "]"}], "/.", "fitSlopeLRResult"}]}], 
           "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"r", ",", "radii"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"l", ",", "lengths"}], "}"}]}], "]"}], ",", "1"}], "]"}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", "All"}], ",", "\[IndentingNewLine]", 
      RowBox[{"ScalingFunctions", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<Log\>\"", ",", "\"\<Log\>\"", ",", "None"}], "}"}]}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"Ticks", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
         RowBox[{"PowerTicks", "[", "True", "]"}], ",", "Automatic"}], 
        "}"}]}], ",", " ", "\[IndentingNewLine]", 
      RowBox[{"AxesLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
        "\"\<Length (nm)\>\"", ",", "\"\<Radius (nm)\>\"", ",", 
         "\"\<Probability\>\""}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "12"}], ",", " ", "Black"}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"LabelStyle", "\[Rule]", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
          "}"}]}], ","}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"ColorFunction", "->", 
         RowBox[{"(", 
          RowBox[{"ColorData", "[", "9", "]"}], ")"}]}], ","}], "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"PlotStyle", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"ColorData", "[", "9", "]"}], "[", "1", "]"}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"BoxStyle", "\[Rule]", "Black"}]}], "\[IndentingNewLine]", 
     "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
        "\"\<PlateletsFit3Dprobability.pdf\>\""}], "}"}], "]"}], ",", " ", 
     "plot3Dprobability"}], "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"plot2Ddensity", " ", "=", " ", 
    RowBox[{"ListDensityPlot", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Flatten", "[", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"l", ",", "r", ",", 
            RowBox[{
             RowBox[{"probfunc", "[", 
              RowBox[{
              "\[Mu]l", ",", "\[Sigma]l", ",", "\[Mu]r", ",", "\[Sigma]r", 
               ",", "l", ",", "r"}], "]"}], "/.", "fitSlopeLRResult"}]}], 
           "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"r", ",", "radii"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"l", ",", "lengths"}], "}"}]}], "]"}], ",", "1"}], "]"}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", "All"}], ",", "\[IndentingNewLine]", 
      RowBox[{"ScalingFunctions", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<Log\>\"", ",", "\"\<Log\>\"", ",", "None"}], "}"}]}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<Length (nm)\>\"", ",", "\"\<Radius (nm)\>\""}], "}"}]}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"FrameTicks", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",",
       "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameStyle", "\[Rule]", "Black"}], ",", "\[IndentingNewLine]", 
      RowBox[{"ColorFunction", "->", "\"\<SunsetColors\>\""}], ",", " ", 
      RowBox[{"(*", 
       RowBox[{"\"\<CherryTones\>\"", ",", " ", 
        RowBox[{"\"\<SunsetColors\>\"", " ", 
         RowBox[{"(", 
          RowBox[{"one", " ", "directionally", " ", 
           RowBox[{"continuous", "/", "best"}]}], ")"}]}], ",", " ", 
        "\"\<LightTemperatureMap\>\"", ",", " ", 
        "\"\<ThermometerColors\>\""}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{"PlotLegends", "->", " ", "Automatic"}], ",", " ", 
      RowBox[{"(*", " ", 
       RowBox[{"PlotLegends", "->", " ", 
        RowBox[{"BarLegend", "[", "\"\<SunsetColors\>\"", "]"}]}], " ", 
       "*)"}], "\[IndentingNewLine]", 
      RowBox[{"AspectRatio", "->", "Automatic"}]}], "\[IndentingNewLine]", 
     "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
        "\"\<PlateletsFit2Ddensity.pdf\>\""}], "}"}], "]"}], ",", 
     "plot2Ddensity"}], "]"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"plotPlateletDistributions", " ", "=", " ", 
    RowBox[{"ListLogLinearPlot", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{"lengths", ",", 
           RowBox[{
            RowBox[{
             RowBox[{"#", "/", 
              RowBox[{"Max", "[", "#", "]"}]}], "&"}], "@", 
            RowBox[{"PDF", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"LogNormalDistribution", "[", 
                RowBox[{"\[Mu]l", ",", "\[Sigma]l"}], "]"}], "/.", 
               "fitSlopeLRResult"}], ",", "lengths"}], "]"}]}]}], "}"}], 
         "\[Transpose]"}], ",", " ", 
        RowBox[{"(*", " ", 
         RowBox[{
         "Probability", " ", "normalized", " ", "by", " ", "the", " ", 
          "maximum", " ", "probability"}], "*)"}], "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"radii", ",", 
           RowBox[{
            RowBox[{
             RowBox[{"#", "/", 
              RowBox[{"Max", "[", "#", "]"}]}], "&"}], "@", 
            RowBox[{"PDF", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"LogNormalDistribution", "[", 
                RowBox[{"\[Mu]r", ",", "\[Sigma]r"}], "]"}], "/.", 
               "fitSlopeLRResult"}], ",", "radii"}], "]"}]}]}], "}"}], 
         "\[Transpose]"}]}], "\[IndentingNewLine]", "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Frame", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "->", "All"}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<Size (nm)\>\"", ",", "\"\<Normalized probability\>\""}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameTicks", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Automatic", ",", " ", "Automatic"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",",
       "\[IndentingNewLine]", 
      RowBox[{"PlotLegends", "->", 
       RowBox[{"{", 
        RowBox[{
        "\"\<Platelets thickness fit distribution\>\"", ",", " ", 
         "\"\<Platelets radii fit distribution\>\""}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Joined", "->", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotStyle", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "1", "]"}], ",", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           
           TemplateBox[<|
            "color" -> RGBColor[
              0.6745098039215687, 0.07450980392156863, 0.043137254901960784`]|>,
            "RGBColorSwatchTemplate"], ",", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"Black", ",", " ", 
           RowBox[{"PointSize", "[", "0.04", "]"}], ",", " ", 
           RowBox[{"Thickness", "[", "0.004", "]"}], ",", " ", "Dashed"}], 
          "}"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameStyle", "\[Rule]", "Black"}]}], "\[IndentingNewLine]", 
     "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
        "\"\<PlateletFitDistributions.pdf\>\""}], "}"}], "]"}], ",", 
     "plotPlateletDistributions"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.889083294305049*^9, 3.889083315851309*^9}, {
   3.8890833883662243`*^9, 3.8890834456873417`*^9}, {3.889083486103497*^9, 
   3.8890835217014627`*^9}, {3.889083563050894*^9, 3.8890835639046907`*^9}, {
   3.88908424900935*^9, 3.889084266338831*^9}, {3.8895047640723577`*^9, 
   3.8895048132399473`*^9}, {3.889504846884196*^9, 3.8895048547452297`*^9}, {
   3.8895049269182625`*^9, 3.8895050026520877`*^9}, {3.8895050961729617`*^9, 
   3.889505131901743*^9}, {3.8895051665115204`*^9, 3.88950517791572*^9}, {
   3.889514960971097*^9, 3.889515036411804*^9}, {3.8895151686784644`*^9, 
   3.8895152527812395`*^9}, {3.889515322726761*^9, 3.889515322942603*^9}, {
   3.889515414799749*^9, 3.889515415134011*^9}, {3.889515802135846*^9, 
   3.8895158072956295`*^9}, {3.88951762311401*^9, 3.8895176529460897`*^9}, {
   3.8895177805499964`*^9, 3.8895178521346097`*^9}, {3.8895178958654327`*^9, 
   3.889517895992517*^9}, {3.8895179853740325`*^9, 3.8895179941825094`*^9}, {
   3.889518050385213*^9, 3.8895180651462665`*^9}, {3.889518110111107*^9, 
   3.8895181537599416`*^9}, {3.8895181952428894`*^9, 3.889518231543586*^9}, {
   3.8895182640986247`*^9, 3.889518360154647*^9}, {3.889518402957049*^9, 
   3.8895184404208817`*^9}, {3.889518524888457*^9, 3.8895185272255807`*^9}, {
   3.8895889126133003`*^9, 3.889588935610735*^9}, {3.889589038336623*^9, 
   3.889589077704085*^9}, {3.889592078032647*^9, 3.8895920808209195`*^9}, {
   3.889592118364094*^9, 3.8895924083479843`*^9}, {3.8895925522801237`*^9, 
   3.8895925725829153`*^9}, {3.8895927385856147`*^9, 3.889592740371332*^9}, {
   3.8895928489211516`*^9, 3.8895928588784356`*^9}, {3.8895928981345015`*^9, 
   3.889592939760598*^9}, {3.889592994486616*^9, 3.889593006731392*^9}, {
   3.8896690677438173`*^9, 3.8896690861177497`*^9}, {3.8896691662237344`*^9, 
   3.8896691680709915`*^9}, {3.8896692820528316`*^9, 
   3.8896693106620665`*^9}, {3.889669383022016*^9, 3.8896694349828773`*^9}, {
   3.8896699958407335`*^9, 3.8896699966198225`*^9}, {3.8896701115288887`*^9, 
   3.8896701256913085`*^9}, {3.8896701570270524`*^9, 3.889670157394929*^9}, {
   3.8896712449546976`*^9, 3.889671273339734*^9}, {3.8896722465178547`*^9, 
   3.8896723216246796`*^9}, {3.889677150823584*^9, 3.889677160683831*^9}, {
   3.8896771908757315`*^9, 3.889677195202493*^9}, 3.8896773421424313`*^9, {
   3.889677378283571*^9, 3.8896773887669315`*^9}, {3.88967742719445*^9, 
   3.889677430963851*^9}, {3.889677480339917*^9, 3.889677480743126*^9}, {
   3.889677596624218*^9, 3.8896775968970366`*^9}, {3.889680706734044*^9, 
   3.8896807216712313`*^9}, {3.889680801340059*^9, 3.8896808079046683`*^9}, 
   3.8896849744898243`*^9, {3.889685151140499*^9, 3.8896851850751715`*^9}, {
   3.905230066978773*^9, 
   3.905230073266673*^9}},ExpressionUUID->"53db37f2-ab19-4a4d-8175-\
4749ca30cef4"],

Cell[BoxData[
 GraphicsBox[{{}, {{{}, {}, {}, 
     {GrayLevel[0], PointSize[0.04], Thickness[0.004], LineBox[CompressedData["
1:eJw1VQk0VXsXv4lrvIY7T+7g3mtueElpvJoHNEq9hwwfGuR70fCeXgNFiTSZ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       "]]}}, {
     {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
      PointSize[0.01], Thickness[0.005], PointBox[CompressedData["
1:eJwVl2k41H8bxccw+wxjxpL+lhZLCCXZ9fsRpZSdlCW0CklEi5QWiihK2UIo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       "]]}, {}}}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{-5.298317366548025, -13.815510557964243`},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox["\"Intensity [a.u.]\"", HoldForm], TraditionalForm], None}, {
     FormBox[
      TagBox[
      "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) \
[\\!\\(\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], 
      TraditionalForm], None}},
  FrameTicks->{{{{
       NCache[-Log[1000000], -13.815510557964274`], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "6"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[100000], -11.512925464970229`], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "5"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[10000], -9.210340371976184], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "4"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox[
        TemplateBox[{"10", "2"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[-Log[1000000], -13.815510557964274`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500000], -13.122363377404328`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000000, 3]], -12.716898269296165`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250000], -12.429216196844383`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200000], -12.206072645530174`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500000, 3]], -12.02375108873622], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000000, 7]], -11.86960040890896], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125000], -11.736069016284437`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000000, 9]], -11.618285980628055`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100000], -11.512925464970229`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50000], -10.819778284410283`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100000, 3]], -10.41431317630212], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25000], -10.126631103850338`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20000], -9.903487552536127], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50000, 3]], -9.721165995742174], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100000, 7]], -9.567015315914915], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[12500], -9.433483923290392], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100000, 9]], -9.315700887634009], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10000], -9.210340371976184], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5000], -8.517193191416238], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10000, 3]], -8.111728083308073], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2500], -7.824046010856292], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2000], -7.600902459542082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5000, 3]], -7.418580902748128], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10000, 7]], -7.264430222920869], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[1250], -7.1308988302963465`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10000, 9]], -7.013115794639964], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500], -6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 3]], -5.809142990314028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250], -5.521460917862246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200], -5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500, 3]], -5.115995809754082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 7]], -4.961845129926823], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125], -4.8283137373023015`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 9]], -4.710530701645918], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[20], 2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[30], 3.4011973816621555`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[40], 3.6888794541139363`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[50], 3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[60], 4.0943445622221], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[70], 4.248495242049359], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[80], 4.382026634673881], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[90], 4.499809670330265], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[200], 5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[300], 5.703782474656201], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[400], 5.991464547107982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[500], 6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[600], 6.396929655216146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[700], 6.551080335043404], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[800], 6.684611727667927], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[900], 6.802394763324311], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}, {{
       NCache[-Log[1000000], -13.815510557964274`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[100000], -11.512925464970229`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[10000], -9.210340371976184], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[1000000], -13.815510557964274`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500000], -13.122363377404328`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000000, 3]], -12.716898269296165`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250000], -12.429216196844383`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200000], -12.206072645530174`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500000, 3]], -12.02375108873622], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000000, 7]], -11.86960040890896], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125000], -11.736069016284437`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000000, 9]], -11.618285980628055`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100000], -11.512925464970229`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50000], -10.819778284410283`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100000, 3]], -10.41431317630212], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25000], -10.126631103850338`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20000], -9.903487552536127], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50000, 3]], -9.721165995742174], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100000, 7]], -9.567015315914915], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[12500], -9.433483923290392], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100000, 9]], -9.315700887634009], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10000], -9.210340371976184], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5000], -8.517193191416238], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10000, 3]], -8.111728083308073], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2500], -7.824046010856292], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2000], -7.600902459542082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5000, 3]], -7.418580902748128], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10000, 7]], -7.264430222920869], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[1250], -7.1308988302963465`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10000, 9]], -7.013115794639964], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500], -6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 3]], -5.809142990314028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250], -5.521460917862246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200], -5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500, 3]], -5.115995809754082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 7]], -4.961845129926823], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125], -4.8283137373023015`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 9]], -4.710530701645918], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[20], 2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[30], 3.4011973816621555`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[40], 3.6888794541139363`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[50], 3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[60], 4.0943445622221], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[70], 4.248495242049359], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[80], 4.382026634673881], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[90], 4.499809670330265], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[200], 5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[300], 5.703782474656201], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[400], 5.991464547107982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[500], 6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[600], 6.396929655216146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[700], 6.551080335043404], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[800], 6.684611727667927], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[900], 6.802394763324311], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}}, {{{
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500], -6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 3]], -5.809142990314028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250], -5.521460917862246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200], -5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500, 3]], -5.115995809754082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 7]], -4.961845129926823], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125], -4.8283137373023015`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 9]], -4.710530701645918], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}, {{
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500], -6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 3]], -5.809142990314028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250], -5.521460917862246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200], -5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500, 3]], -5.115995809754082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 7]], -4.961845129926823], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125], -4.8283137373023015`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 9]], -4.710530701645918], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  LabelStyle->{FontSize -> 14, 
    GrayLevel[0]},
  Method->{
   "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& )}},
  PlotRange->{{-5.298317366548036, 0.}, {-13.815510557964274`, 
   4.605170185988092}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0], 
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0]}]], "Output",
 CellChangeTimes->{
  3.8895182869567413`*^9, {3.8895183343905697`*^9, 3.8895183620551634`*^9}, {
   3.8895184150560637`*^9, 3.8895184418507495`*^9}, 3.8895185281220536`*^9, 
   3.8895889404320927`*^9, {3.8895890406246934`*^9, 3.8895890784682913`*^9}, 
   3.889592148098647*^9, 3.889592411520773*^9, 3.8895925734732924`*^9, 
   3.889592742450922*^9, 3.889592859727005*^9, 3.889592922507035*^9, 
   3.8895930087831736`*^9, 3.889668998234763*^9, 3.8896690890570593`*^9, 
   3.889669169286552*^9, 3.8896693168938737`*^9, 3.8896711091569824`*^9, 
   3.889671276253702*^9, 3.8896723301246977`*^9, 3.889677442821598*^9, 
   3.889677598100257*^9, 3.889684978194605*^9, 3.889685185804984*^9, 
   3.890204642630407*^9, 3.8902063323023443`*^9, 3.8902104829738626`*^9, 
   3.8902169904530506`*^9, 3.890217304571312*^9, 3.8902182374475017`*^9, 
   3.8909820692101192`*^9, 3.8909824066539817`*^9, 3.8909829558379273`*^9, 
   3.8914172809480352`*^9, 3.89141922718013*^9, 3.8914979473215375`*^9, 
   3.891498845326952*^9, 3.891499741577324*^9, 3.8915007310934925`*^9, 
   3.891501572647173*^9, 3.891696638378026*^9},
 CellLabel->
  "Out[2855]=",ExpressionUUID->"e5724759-be44-47ae-a51b-f4401f7ca86f"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\ESRF\\\\Analysis\\\\2022-08_\
new_data\\\\Analysis\\\\Full form factor \
fit\\\\LH-ESRF-C22\\\\PlateletsIntensityFit.pdf\"\>"], "Output",
 CellChangeTimes->{
  3.8895182869567413`*^9, {3.8895183343905697`*^9, 3.8895183620551634`*^9}, {
   3.8895184150560637`*^9, 3.8895184418507495`*^9}, 3.8895185281220536`*^9, 
   3.8895889404320927`*^9, {3.8895890406246934`*^9, 3.8895890784682913`*^9}, 
   3.889592148098647*^9, 3.889592411520773*^9, 3.8895925734732924`*^9, 
   3.889592742450922*^9, 3.889592859727005*^9, 3.889592922507035*^9, 
   3.8895930087831736`*^9, 3.889668998234763*^9, 3.8896690890570593`*^9, 
   3.889669169286552*^9, 3.8896693168938737`*^9, 3.8896711091569824`*^9, 
   3.889671276253702*^9, 3.8896723301246977`*^9, 3.889677442821598*^9, 
   3.889677598100257*^9, 3.889684978194605*^9, 3.889685185804984*^9, 
   3.890204642630407*^9, 3.8902063323023443`*^9, 3.8902104829738626`*^9, 
   3.8902169904530506`*^9, 3.890217304571312*^9, 3.8902182374475017`*^9, 
   3.8909820692101192`*^9, 3.8909824066539817`*^9, 3.8909829558379273`*^9, 
   3.8914172809480352`*^9, 3.89141922718013*^9, 3.8914979473215375`*^9, 
   3.891498845326952*^9, 3.891499741577324*^9, 3.8915007310934925`*^9, 
   3.891501572647173*^9, 3.8916966409788055`*^9},
 CellLabel->
  "Out[2856]=",ExpressionUUID->"17a3653f-49f4-45e6-a9aa-5fd5d096c2b3"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{{{{Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-5.1252793563099095`, -0.96477943753508}, \
{-5.1252793563099095`, -0.7391686344009561}}], 
          
          LineBox[{{-5.1252793563099095`, -0.7391686344009561}, \
{-5.1252793563099095`, -0.5135578312668323}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.972895007974446, -0.9535993632839864}, \
{-4.972895007974446, -0.7133739101905257}}], 
          
          LineBox[{{-4.972895007974446, -0.7133739101905257}, \
{-4.972895007974446, -0.4731484570970649}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.8217116543319705`, -1.4920352848705054`}, \
{-4.8217116543319705`, -1.2734305782197923`}}], 
          
          LineBox[{{-4.8217116543319705`, -1.2734305782197923`}, \
{-4.8217116543319705`, -1.0548258715690793`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.673830349076903, -1.3157870376537555`}, \
{-4.673830349076903, -1.1270814075746538`}}], 
          
          LineBox[{{-4.673830349076903, -1.1270814075746538`}, \
{-4.673830349076903, -0.9383757774955521}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.521216293266271, -1.6531108264067091`}, \
{-4.521216293266271, -1.3983615441650237`}}], 
          
          LineBox[{{-4.521216293266271, -1.3983615441650237`}, \
{-4.521216293266271, -1.1436122619233382`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.3682219300566025`, -1.7992520141962367`}, \
{-4.3682219300566025`, -1.465059688428702}}], 
          
          LineBox[{{-4.3682219300566025`, -1.465059688428702}, \
{-4.3682219300566025`, -1.1308673626611672`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.223924574573319, -1.9645624717370351`}, \
{-4.223924574573319, -1.6245590795392313`}}], 
          
          LineBox[{{-4.223924574573319, -1.6245590795392313`}, \
{-4.223924574573319, -1.2845556873414274`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.077721657523017, -2.038209780364534}, \
{-4.077721657523017, -1.7147861404360367`}}], 
          
          LineBox[{{-4.077721657523017, -1.7147861404360367`}, \
{-4.077721657523017, -1.3913625005075394`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.92630264206681, -2.1494508829121255`}, \
{-3.92630264206681, -1.8478089031935414`}}], 
          
          LineBox[{{-3.92630264206681, -1.8478089031935414`}, \
{-3.92630264206681, -1.546166923474957}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.774327986151194, -2.245759723513893}, \
{-3.774327986151194, -1.9383472878026295`}}], 
          
          LineBox[{{-3.774327986151194, -1.9383472878026295`}, \
{-3.774327986151194, -1.6309348520913662`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.6208826994945396`, -2.334711992235891}, \
{-3.6208826994945396`, -2.0395686420545247`}}], 
          
          LineBox[{{-3.6208826994945396`, -2.0395686420545247`}, \
{-3.6208826994945396`, -1.7444252918731584`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.4686602504493296`, -2.399748237667733}, \
{-3.4686602504493296`, -2.1091620931464528`}}], 
          
          LineBox[{{-3.4686602504493296`, -2.1091620931464528`}, \
{-3.4686602504493296`, -1.8185759486251727`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.320632854288721, -2.4784768658854617`}, \
{-3.320632854288721, -2.2038471789535055`}}], 
          
          LineBox[{{-3.320632854288721, -2.2038471789535055`}, \
{-3.320632854288721, -1.9292174920215492`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.169887377457001, -2.4564658324092714`}, \
{-3.169887377457001, -2.2050530434335336`}}], 
          
          LineBox[{{-3.169887377457001, -2.2050530434335336`}, \
{-3.169887377457001, -1.953640254457796}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.01721515252269, -2.345074896394708}, \
{-3.01721515252269, -2.120912908334111}}], 
          
          LineBox[{{-3.01721515252269, -2.120912908334111}, \
{-3.01721515252269, -1.8967509202735144`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.869122979428457, -2.3248215745985488`}, \
{-2.869122979428457, -2.125116138908417}}], 
          
          LineBox[{{-2.869122979428457, -2.125116138908417}, \
{-2.869122979428457, -1.9254107032182852`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.7229707239555854`, -2.4101854065991413`}, \
{-2.7229707239555854`, -2.222581347955065}}], 
          
          LineBox[{{-2.7229707239555854`, -2.222581347955065}, \
{-2.7229707239555854`, -2.034977289310989}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.5674984695241374`, -2.4585576605778705`}, \
{-2.5674984695241374`, -2.1167607486550155`}}], 
          
          LineBox[{{-2.5674984695241374`, -2.1167607486550155`}, \
{-2.5674984695241374`, -1.7749638367321607`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.4167532824388296`, -2.730676061111512}, \
{-2.4167532824388296`, -2.215365091833709}}], 
          
          LineBox[{{-2.4167532824388296`, -2.215365091833709}, \
{-2.4167532824388296`, -1.7000541225559056`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.273683103959538, -2.7151373798005185`}, \
{-2.273683103959538, -2.260552152824246}}], 
          
          LineBox[{{-2.273683103959538, -2.260552152824246}, \
{-2.273683103959538, -1.8059669258479734`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.1225114762089117`, -2.7223200485296535`}, \
{-2.1225114762089117`, -2.3072025595882764`}}], 
          
          LineBox[{{-2.1225114762089117`, -2.3072025595882764`}, \
{-2.1225114762089117`, -1.8920850706468992`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.9688530566493743`, -2.710030614808251}, \
{-1.9688530566493743`, -2.3236366231172294`}}], 
          
          LineBox[{{-1.9688530566493743`, -2.3236366231172294`}, \
{-1.9688530566493743`, -1.9372426314262075`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.8165848867407983`, -2.736987228862975}, \
{-1.8165848867407983`, -2.372330782351529}}], 
          
          LineBox[{{-1.8165848867407983`, -2.372330782351529}, \
{-1.8165848867407983`, -2.0076743358400835`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.6679573417952833`, -2.7655887838744464`}, \
{-1.6679573417952833`, -2.420561808974977}}], 
          
          LineBox[{{-1.6679573417952833`, -2.420561808974977}, \
{-1.6679573417952833`, -2.0755348340755075`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.5211693704213907`, -2.7982903951784612`}, \
{-1.5211693704213907`, -2.4733619472453525`}}], 
          
          LineBox[{{-1.5211693704213907`, -2.4733619472453525`}, \
{-1.5211693704213907`, -2.148433499312244}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.371988295897768, -2.848351894935505}, \
{-1.371988295897768, -2.543378251816936}}], 
          
          LineBox[{{-1.371988295897768, -2.543378251816936}, \
{-1.371988295897768, -2.238404608698367}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.2210917594318125`, -2.9077092438776244`}, \
{-1.2210917594318125`, -2.6181369569061665`}}], 
          
          LineBox[{{-1.2210917594318125`, -2.6181369569061665`}, \
{-1.2210917594318125`, -2.3285646699347087`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.0718189592856806`, -2.942973344943205}, \
{-1.0718189592856806`, -2.6680361941378496`}}], 
          
          LineBox[{{-1.0718189592856806`, -2.6680361941378496`}, \
{-1.0718189592856806`, -2.3930990433324943`}}]}}}}}, {{{}, {}, {}, {
        Hue[0.9060679774997897, 0.6, 0.6], 
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[
         0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
         PointSize[0.01], 
         Thickness[0.005]], 
        LineBox[CompressedData["
1:eJw1lnk4lN0bx2fGzGDM2NchspUXk7ciWzyk3oo2e1FEElHavFSWRKtQipBk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         "]]}}, {{
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
         PointSize[0.01], 
         Thickness[0.005]], 
        GeometricTransformationBox[
         InsetBox[
          BoxData[
           FormBox[
            StyleBox[
             GraphicsBox[{
               EdgeForm[], 
               DiskBox[{0, 0}]}], 
             GraphicsBoxOptions -> {DefaultBaseStyle -> Directive[
                 AbsoluteThickness[1.6], 
                 RGBColor[
                 0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
                 PointSize[0.01], 
                 Thickness[0.005]]}, StripOnInput -> False], 
            TraditionalForm]], {0., 0.}, Automatic, 
          Offset[6.272]], CompressedData["
1:eJwB1QEq/iFib1JlAwAAABwAAAABAAAAAgAAACfcSDtJgBTAEWXf+kSn57+D
xMaWPuQTwHrQwoX10+a/OGSox25JE8DU4vK9+F/0v6pZQZUAshLAkWeXg4YI
8r9I4la5uRUSwPDDwlqwX/a/bA1tKw95EcDd04dt4nD3v6JA0ntM5RDAXqdQ
qTH++b9TAiVElk8QwNLojJfDb/u/tAAPXBFpD8AOlYcRoJD9v+QsB9/SMQ7A
BnEWcngD/7+W2UdZkfcMwA2SPF0JUQDAmusE8tC/C8AiNyBgkN8AwKeLOfWn
kArAt+U3oXqhAcC+ctHp7VsJwDjwm9nyowHAFKWoskEjCMCNrNcvofcAwEfH
pr/28wbA74Hm4zwAAcBk1vrfpMgFwDNV0brYxwHA/BY5ozyKBMAqcGdCIO8A
wHiatL6CVQPArAFRVRG5AcC4ymfEgDACwJ9C+l2cFQLAnJ39S+f6AMDgbpWd
JnUCwOgEDxBsgP+/bJxAzM6WAsB+Wm9QuxD9v4jzq4+I+gLAMSSiCfSv+r/4
83uCT10DwEMwmrG1Vvi/o7cU/XHJA8DOAtb/qfP1v4hKZ7LWWATAtstCg5eJ
87844/LJ8fEEwAjWFaMrJvG/VO4yXCNYBcCsTO6K
         "]]}, {
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[
         0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
         PointSize[0.01], 
         Thickness[0.005]], 
        GeometricTransformationBox[
         TagBox[
          InsetBox["", {0., 0.}], "InsetString"], CompressedData["
1:eJw1lnk4lN0bx2fGzGDM2NchspUXk7ciW3pIvRVt9qKIJKK0+VFZEq1CKUKS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         "]]}}}, {{}, {}}}, {
    DisplayFunction -> Identity, GridLines -> {None, None}, DisplayFunction -> 
     Identity, DisplayFunction -> Identity, DisplayFunction -> Identity, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, AxesOrigin -> {-7.2705523451534315`, 0}, 
     DisplayFunction :> Identity, Frame -> {{True, True}, {True, True}}, 
     FrameLabel -> {{
        FormBox[
         TagBox["\"Slope\"", HoldForm], TraditionalForm], None}, {
        FormBox[
         TagBox[
         "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) [\\!\\(\
\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], TraditionalForm], 
        None}}, FrameStyle -> GrayLevel[0], 
     FrameTicks -> {{Automatic, Automatic}, {{{
          NCache[-Log[10000], -9.210340371976184], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "4"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {0, 
          FormBox[
           
           TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           
           TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           
           TemplateBox[{"10", "2"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10000], -9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5000], -8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 3]], -8.111728083308073], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2500], -7.824046010856292], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2000], -7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5000, 3]], -7.418580902748128], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 7]], -7.264430222920869], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1250], -7.1308988302963465`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 9]], -7.013115794639964], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200], 5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300], 5.703782474656201], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400], 5.991464547107982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500], 6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600], 6.396929655216146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700], 6.551080335043404], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800], 6.684611727667927], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900], 6.802394763324311], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}, {{
          NCache[-Log[10000], -9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10000], -9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5000], -8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 3]], -8.111728083308073], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2500], -7.824046010856292], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2000], -7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5000, 3]], -7.418580902748128], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 7]], -7.264430222920869], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1250], -7.1308988302963465`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 9]], -7.013115794639964], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200], 5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300], 5.703782474656201], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400], 5.991464547107982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500], 6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600], 6.396929655216146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700], 6.551080335043404], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800], 6.684611727667927], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900], 6.802394763324311], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}}}, GridLines -> {None, None}, GridLinesStyle -> 
     Directive[
       GrayLevel[0.5, 0.4]], LabelStyle -> {FontSize -> 14, 
       GrayLevel[0]}, 
     Method -> {
      "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
       "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           Exp[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           Exp[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{-7.2705523451534315`, 
       2.2795592420641055`}, {-3.9594979122239065`, 0}}, PlotRangeClipping -> 
     True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.05], 
        Scaled[0.02]}}, Ticks -> {
       Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
        15.954589770191003`, RotateLabel -> 0], Automatic}}], 
   FormBox[
    FormBox[
     TemplateBox[{"\"Binned data\"", "\"Platelets form factor fit\""}, 
      "PointLegend", DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.9372549019607843, 0.6470588235294118, 
                    0.6431372549019608], 
                    PointSize[0.5], 
                    Thickness[0.09]], {
                    InsetBox[
                    GraphicsBox[{
                    EdgeForm[], 
                    DiskBox[{0, 0}]}, {DefaultBaseStyle -> {"Graphics", {
                    AbsolutePointSize[6]}, 
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.9372549019607843, 0.6470588235294118, 
                    0.6431372549019608], 
                    PointSize[0.5], 
                    Thickness[0.09]]}}], 
                    NCache[
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}], 
                    Scaled[{0.5, 0.5}]], Automatic, 
                    Scaled[1]]}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 6.272}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.28196428571428567`] -> 
                    Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09]], {
                    InsetBox[
                    FormBox[
                    StyleBox["\"\"", 
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09]], FontSize -> 10, Plain, StripOnInput -> 
                    False], TraditionalForm], 
                    NCache[
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}], 
                    Scaled[{0.5, 0.5}]]]}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #2}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontSize -> 14, 
          GrayLevel[0], FontFamily -> "Arial"}, Background -> Automatic, 
         StripOnInput -> False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"PointLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.9372549019607843, 0.6470588235294118, 
                    0.6431372549019608]|>, "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"PointSize", "[", "0.01`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.005`", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`]|>, "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"PointSize", "[", "0.01`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.005`", "]"}]}], "]"}]}], 
             "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{
                    GraphicsBox[{
                    EdgeForm[], 
                    DiskBox[{0, 0}]}], ",", 
                    RowBox[{"Offset", "[", "6.272`", "]"}]}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"\"\"", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"False", ",", "True"}], "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"FontSize", "\[Rule]", "14"}], ",", 
                 
                 TemplateBox[<|"color" -> GrayLevel[0]|>, 
                  "GrayLevelColorSwatchTemplate"]}], "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{
  3.8895182869567413`*^9, {3.8895183343905697`*^9, 3.8895183620551634`*^9}, {
   3.8895184150560637`*^9, 3.8895184418507495`*^9}, 3.8895185281220536`*^9, 
   3.8895889404320927`*^9, {3.8895890406246934`*^9, 3.8895890784682913`*^9}, 
   3.889592148098647*^9, 3.889592411520773*^9, 3.8895925734732924`*^9, 
   3.889592742450922*^9, 3.889592859727005*^9, 3.889592922507035*^9, 
   3.8895930087831736`*^9, 3.889668998234763*^9, 3.8896690890570593`*^9, 
   3.889669169286552*^9, 3.8896693168938737`*^9, 3.8896711091569824`*^9, 
   3.889671276253702*^9, 3.8896723301246977`*^9, 3.889677442821598*^9, 
   3.889677598100257*^9, 3.889684978194605*^9, 3.889685185804984*^9, 
   3.890204642630407*^9, 3.8902063323023443`*^9, 3.8902104829738626`*^9, 
   3.8902169904530506`*^9, 3.890217304571312*^9, 3.8902182374475017`*^9, 
   3.8909820692101192`*^9, 3.8909824066539817`*^9, 3.8909829558379273`*^9, 
   3.8914172809480352`*^9, 3.89141922718013*^9, 3.8914979473215375`*^9, 
   3.891498845326952*^9, 3.891499741577324*^9, 3.8915007310934925`*^9, 
   3.891501572647173*^9, 3.891696641789034*^9},
 CellLabel->
  "Out[2857]=",ExpressionUUID->"3d8be69c-371e-47fa-b84e-5b15cebfe9e7"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\ESRF\\\\Analysis\\\\2022-08_\
new_data\\\\Analysis\\\\Full form factor \
fit\\\\LH-ESRF-C22\\\\PlateletsSlopeFit.pdf\"\>"], "Output",
 CellChangeTimes->{
  3.8895182869567413`*^9, {3.8895183343905697`*^9, 3.8895183620551634`*^9}, {
   3.8895184150560637`*^9, 3.8895184418507495`*^9}, 3.8895185281220536`*^9, 
   3.8895889404320927`*^9, {3.8895890406246934`*^9, 3.8895890784682913`*^9}, 
   3.889592148098647*^9, 3.889592411520773*^9, 3.8895925734732924`*^9, 
   3.889592742450922*^9, 3.889592859727005*^9, 3.889592922507035*^9, 
   3.8895930087831736`*^9, 3.889668998234763*^9, 3.8896690890570593`*^9, 
   3.889669169286552*^9, 3.8896693168938737`*^9, 3.8896711091569824`*^9, 
   3.889671276253702*^9, 3.8896723301246977`*^9, 3.889677442821598*^9, 
   3.889677598100257*^9, 3.889684978194605*^9, 3.889685185804984*^9, 
   3.890204642630407*^9, 3.8902063323023443`*^9, 3.8902104829738626`*^9, 
   3.8902169904530506`*^9, 3.890217304571312*^9, 3.8902182374475017`*^9, 
   3.8909820692101192`*^9, 3.8909824066539817`*^9, 3.8909829558379273`*^9, 
   3.8914172809480352`*^9, 3.89141922718013*^9, 3.8914979473215375`*^9, 
   3.891498845326952*^9, 3.891499741577324*^9, 3.8915007310934925`*^9, 
   3.891501572647173*^9, 3.8916966437893467`*^9},
 CellLabel->
  "Out[2858]=",ExpressionUUID->"dd448697-79af-42a8-90f9-4d49be300773"],

Cell[BoxData[
 Graphics3DBox[{GraphicsComplex3DBox[CompressedData["
1:eJxM3Hc81u3//3EVQnTRQFR2ZpKU0XmWSJIUsrJXFFmRLTOzspIRQsoolTRp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